package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSchema invokes the baas.UpdateSchema API synchronously
// api document: https://help.aliyun.com/api/baas/updateschema.html
func (client *Client) UpdateSchema(request *UpdateSchemaRequest) (response *UpdateSchemaResponse, err error) {
	response = CreateUpdateSchemaResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSchemaWithChan invokes the baas.UpdateSchema API asynchronously
// api document: https://help.aliyun.com/api/baas/updateschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateSchemaWithChan(request *UpdateSchemaRequest) (<-chan *UpdateSchemaResponse, <-chan error) {
	responseChan := make(chan *UpdateSchemaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSchema(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSchemaWithCallback invokes the baas.UpdateSchema API asynchronously
// api document: https://help.aliyun.com/api/baas/updateschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateSchemaWithCallback(request *UpdateSchemaRequest, callback func(response *UpdateSchemaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSchemaResponse
		var err error
		defer close(result)
		response, err = client.UpdateSchema(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSchemaRequest is the request struct for api UpdateSchema
type UpdateSchemaRequest struct {
	*requests.RpcRequest
	SchemaName      string           `position:"Body" name:"SchemaName"`
	SchemaId        requests.Integer `position:"Body" name:"SchemaId"`
	Bizid           string           `position:"Body" name:"Bizid"`
	Description     string           `position:"Body" name:"Description"`
	CategoryConfigs string           `position:"Body" name:"CategoryConfigs"`
}

// UpdateSchemaResponse is the response struct for api UpdateSchema
type UpdateSchemaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateUpdateSchemaRequest creates a request to invoke UpdateSchema API
func CreateUpdateSchemaRequest() (request *UpdateSchemaRequest) {
	request = &UpdateSchemaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "UpdateSchema", "", "")
	return
}

// CreateUpdateSchemaResponse creates a response to parse from UpdateSchema response
func CreateUpdateSchemaResponse() (response *UpdateSchemaResponse) {
	response = &UpdateSchemaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
