package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMetricRuleTemplate invokes the cms.ModifyMetricRuleTemplate API synchronously
// api document: https://help.aliyun.com/api/cms/modifymetricruletemplate.html
func (client *Client) ModifyMetricRuleTemplate(request *ModifyMetricRuleTemplateRequest) (response *ModifyMetricRuleTemplateResponse, err error) {
	response = CreateModifyMetricRuleTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMetricRuleTemplateWithChan invokes the cms.ModifyMetricRuleTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/modifymetricruletemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyMetricRuleTemplateWithChan(request *ModifyMetricRuleTemplateRequest) (<-chan *ModifyMetricRuleTemplateResponse, <-chan error) {
	responseChan := make(chan *ModifyMetricRuleTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMetricRuleTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMetricRuleTemplateWithCallback invokes the cms.ModifyMetricRuleTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/modifymetricruletemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyMetricRuleTemplateWithCallback(request *ModifyMetricRuleTemplateRequest, callback func(response *ModifyMetricRuleTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMetricRuleTemplateResponse
		var err error
		defer close(result)
		response, err = client.ModifyMetricRuleTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMetricRuleTemplateRequest is the request struct for api ModifyMetricRuleTemplate
type ModifyMetricRuleTemplateRequest struct {
	*requests.RpcRequest
	Name           string                                    `position:"Query" name:"Name"`
	RestVersion    requests.Integer                          `position:"Query" name:"RestVersion"`
	Description    string                                    `position:"Query" name:"Description"`
	AlertTemplates *[]ModifyMetricRuleTemplateAlertTemplates `position:"Query" name:"AlertTemplates"  type:"Repeated"`
	TemplateId     requests.Integer                          `position:"Query" name:"TemplateId"`
}

// ModifyMetricRuleTemplateAlertTemplates is a repeated param struct in ModifyMetricRuleTemplateRequest
type ModifyMetricRuleTemplateAlertTemplates struct {
	Period                                string `name:"Period"`
	EscalationsWarnThreshold              string `name:"Escalations.Warn.Threshold"`
	EscalationsWarnComparisonOperator     string `name:"Escalations.Warn.ComparisonOperator"`
	EscalationsCriticalStatistics         string `name:"Escalations.Critical.Statistics"`
	EscalationsInfoTimes                  string `name:"Escalations.Info.Times"`
	RuleName                              string `name:"RuleName"`
	EscalationsInfoStatistics             string `name:"Escalations.Info.Statistics"`
	EscalationsCriticalTimes              string `name:"Escalations.Critical.Times"`
	EscalationsInfoComparisonOperator     string `name:"Escalations.Info.ComparisonOperator"`
	EscalationsWarnStatistics             string `name:"Escalations.Warn.Statistics"`
	EscalationsInfoThreshold              string `name:"Escalations.Info.Threshold"`
	Namespace                             string `name:"Namespace"`
	Selector                              string `name:"Selector"`
	MetricName                            string `name:"MetricName"`
	Category                              string `name:"Category"`
	EscalationsCriticalComparisonOperator string `name:"Escalations.Critical.ComparisonOperator"`
	EscalationsWarnTimes                  string `name:"Escalations.Warn.Times"`
	EscalationsCriticalThreshold          string `name:"Escalations.Critical.Threshold"`
}

// ModifyMetricRuleTemplateResponse is the response struct for api ModifyMetricRuleTemplate
type ModifyMetricRuleTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateModifyMetricRuleTemplateRequest creates a request to invoke ModifyMetricRuleTemplate API
func CreateModifyMetricRuleTemplateRequest() (request *ModifyMetricRuleTemplateRequest) {
	request = &ModifyMetricRuleTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "ModifyMetricRuleTemplate", "cms", "openAPI")
	return
}

// CreateModifyMetricRuleTemplateResponse creates a response to parse from ModifyMetricRuleTemplate response
func CreateModifyMetricRuleTemplateResponse() (response *ModifyMetricRuleTemplateResponse) {
	response = &ModifyMetricRuleTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
