//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSynchronizationJobStatus invokes the dts.DescribeSynchronizationJobStatus API synchronously
// api document: https://help.aliyun.com/api/dts/describesynchronizationjobstatus.html
func (client *Client) DescribeSynchronizationJobStatus(request *DescribeSynchronizationJobStatusRequest) (response *DescribeSynchronizationJobStatusResponse, err error) {
	response = CreateDescribeSynchronizationJobStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSynchronizationJobStatusWithChan invokes the dts.DescribeSynchronizationJobStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describesynchronizationjobstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSynchronizationJobStatusWithChan(request *DescribeSynchronizationJobStatusRequest) (<-chan *DescribeSynchronizationJobStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeSynchronizationJobStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSynchronizationJobStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSynchronizationJobStatusWithCallback invokes the dts.DescribeSynchronizationJobStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describesynchronizationjobstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSynchronizationJobStatusWithCallback(request *DescribeSynchronizationJobStatusRequest, callback func(response *DescribeSynchronizationJobStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSynchronizationJobStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeSynchronizationJobStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSynchronizationJobStatusRequest is the request struct for api DescribeSynchronizationJobStatus
type DescribeSynchronizationJobStatusRequest struct {
	*requests.RpcRequest
	SynchronizationJobId     string `position:"Query" name:"SynchronizationJobId"`
	SynchronizationDirection string `position:"Query" name:"SynchronizationDirection"`
	ClientToken              string `position:"Query" name:"ClientToken"`
	OwnerId                  string `position:"Query" name:"OwnerId"`
}

// DescribeSynchronizationJobStatusResponse is the response struct for api DescribeSynchronizationJobStatus
type DescribeSynchronizationJobStatusResponse struct {
	*responses.BaseResponse
	RequestId                     string                                                         `json:"RequestId" xml:"RequestId"`
	SynchronizationJobId          string                                                         `json:"SynchronizationJobId" xml:"SynchronizationJobId"`
	SynchronizationJobName        string                                                         `json:"SynchronizationJobName" xml:"SynchronizationJobName"`
	SynchronizationDirection      string                                                         `json:"SynchronizationDirection" xml:"SynchronizationDirection"`
	SynchronizationJobClass       string                                                         `json:"SynchronizationJobClass" xml:"SynchronizationJobClass"`
	PayType                       string                                                         `json:"PayType" xml:"PayType"`
	ExpireTime                    string                                                         `json:"ExpireTime" xml:"ExpireTime"`
	StructureInitialization       string                                                         `json:"StructureInitialization" xml:"StructureInitialization"`
	DataInitialization            string                                                         `json:"DataInitialization" xml:"DataInitialization"`
	Status                        string                                                         `json:"Status" xml:"Status"`
	ErrorMessage                  string                                                         `json:"ErrorMessage" xml:"ErrorMessage"`
	Delay                         string                                                         `json:"Delay" xml:"Delay"`
	Checkpoint                    string                                                         `json:"Checkpoint" xml:"Checkpoint"`
	SynchronizationObjects        DescribeSynchronizationJobStatusSynchronizationObjects0        `json:"SynchronizationObjects" xml:"SynchronizationObjects"`
	SourceEndpoint                DescribeSynchronizationJobStatusSourceEndpoint0                `json:"SourceEndpoint" xml:"SourceEndpoint"`
	DestinationEndpoint           DescribeSynchronizationJobStatusDestinationEndpoint0           `json:"DestinationEndpoint" xml:"DestinationEndpoint"`
	PrecheckStatus                DescribeSynchronizationJobStatusPrecheckStatus0                `json:"PrecheckStatus" xml:"PrecheckStatus"`
	StructureInitializationStatus DescribeSynchronizationJobStatusStructureInitializationStatus0 `json:"StructureInitializationStatus" xml:"StructureInitializationStatus"`
	DataInitializationStatus      DescribeSynchronizationJobStatusDataInitializationStatus0      `json:"DataInitializationStatus" xml:"DataInitializationStatus"`
	DataSynchronizationStatus     DescribeSynchronizationJobStatusDataSynchronizationStatus0     `json:"DataSynchronizationStatus" xml:"DataSynchronizationStatus"`
	Performance                   DescribeSynchronizationJobStatusPerformance0                   `json:"Performance" xml:"Performance"`
}

type DescribeSynchronizationJobStatusSynchronizationObjects0 struct {
	SynchronizationObject []DescribeSynchronizationJobStatusSynchronizationObject1 `json:"SynchronizationObject" xml:"SynchronizationObject"`
}

type DescribeSynchronizationJobStatusSynchronizationObject1 struct {
	SchemaName    string                                           `json:"SchemaName" xml:"SchemaName"`
	NewSchemaName string                                           `json:"NewSchemaName" xml:"NewSchemaName"`
	TableIncludes []DescribeSynchronizationJobStatusTableIncludes1 `json:"TableIncludes" xml:"TableIncludes"`
	TableExcludes []DescribeSynchronizationJobStatusTableExcludes1 `json:"TableExcludes" xml:"TableExcludes"`
}

type DescribeSynchronizationJobStatusSourceEndpoint0 struct {
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
	InstanceId   string `json:"InstanceId" xml:"InstanceId"`
	EngineName   string `json:"EngineName" xml:"EngineName"`
	IP           string `json:"IP" xml:"IP"`
	Port         string `json:"Port" xml:"Port"`
	UserName     string `json:"UserName" xml:"UserName"`
}

type DescribeSynchronizationJobStatusDestinationEndpoint0 struct {
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
	InstanceId   string `json:"InstanceId" xml:"InstanceId"`
	EngineName   string `json:"EngineName" xml:"EngineName"`
	IP           string `json:"IP" xml:"IP"`
	Port         string `json:"Port" xml:"Port"`
	UserName     string `json:"UserName" xml:"UserName"`
}

type DescribeSynchronizationJobStatusPrecheckStatus0 struct {
	Status  string                                    `json:"Status" xml:"Status"`
	Percent string                                    `json:"Percent" xml:"Percent"`
	Detail  []DescribeSynchronizationJobStatusDetail1 `json:"Detail" xml:"Detail"`
}

type DescribeSynchronizationJobStatusStructureInitializationStatus0 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Progress     string `json:"Progress" xml:"Progress"`
}

type DescribeSynchronizationJobStatusDataInitializationStatus0 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Progress     string `json:"Progress" xml:"Progress"`
}

type DescribeSynchronizationJobStatusDataSynchronizationStatus0 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Delay        string `json:"Delay" xml:"Delay"`
	Checkpoint   string `json:"Checkpoint" xml:"Checkpoint"`
}

type DescribeSynchronizationJobStatusPerformance0 struct {
	RPS  string `json:"RPS" xml:"RPS"`
	FLOW string `json:"FLOW" xml:"FLOW"`
}

type DescribeSynchronizationJobStatusTableIncludes1 struct {
	TableInclude []DescribeSynchronizationJobStatusTableInclude2 `json:"TableInclude" xml:"TableInclude"`
}

type DescribeSynchronizationJobStatusTableInclude2 struct {
	TableName string `json:"TableName" xml:"TableName"`
}

type DescribeSynchronizationJobStatusTableExcludes1 struct {
	TableExclude []DescribeSynchronizationJobStatusTableExclude2 `json:"TableExclude" xml:"TableExclude"`
}

type DescribeSynchronizationJobStatusTableExclude2 struct {
	TableName string `json:"TableName" xml:"TableName"`
}

type DescribeSynchronizationJobStatusDetail1 struct {
	CheckItem []DescribeSynchronizationJobStatusCheckItem2 `json:"CheckItem" xml:"CheckItem"`
}

type DescribeSynchronizationJobStatusCheckItem2 struct {
	ItemName     string `json:"ItemName" xml:"ItemName"`
	CheckStatus  string `json:"CheckStatus" xml:"CheckStatus"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RepairMethod string `json:"RepairMethod" xml:"RepairMethod"`
}

// CreateDescribeSynchronizationJobStatusRequest creates a request to invoke DescribeSynchronizationJobStatus API
func CreateDescribeSynchronizationJobStatusRequest() (request *DescribeSynchronizationJobStatusRequest) {
	request = &DescribeSynchronizationJobStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeSynchronizationJobStatus", "dts", "openAPI")
	return
}

// CreateDescribeSynchronizationJobStatusResponse creates a response to parse from DescribeSynchronizationJobStatus response
func CreateDescribeSynchronizationJobStatusResponse() (response *DescribeSynchronizationJobStatusResponse) {
	response = &DescribeSynchronizationJobStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
