package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateScalingTaskGroup invokes the emr.CreateScalingTaskGroup API synchronously
// api document: https://help.aliyun.com/api/emr/createscalingtaskgroup.html
func (client *Client) CreateScalingTaskGroup(request *CreateScalingTaskGroupRequest) (response *CreateScalingTaskGroupResponse, err error) {
	response = CreateCreateScalingTaskGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateScalingTaskGroupWithChan invokes the emr.CreateScalingTaskGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/createscalingtaskgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateScalingTaskGroupWithChan(request *CreateScalingTaskGroupRequest) (<-chan *CreateScalingTaskGroupResponse, <-chan error) {
	responseChan := make(chan *CreateScalingTaskGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateScalingTaskGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateScalingTaskGroupWithCallback invokes the emr.CreateScalingTaskGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/createscalingtaskgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateScalingTaskGroupWithCallback(request *CreateScalingTaskGroupRequest, callback func(response *CreateScalingTaskGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateScalingTaskGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateScalingTaskGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateScalingTaskGroupRequest is the request struct for api CreateScalingTaskGroup
type CreateScalingTaskGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId    requests.Integer                         `position:"Query" name:"ResourceOwnerId"`
	DataDiskCategory   string                                   `position:"Query" name:"DataDiskCategory"`
	ClusterId          string                                   `position:"Query" name:"ClusterId"`
	MinSize            requests.Integer                         `position:"Query" name:"MinSize"`
	SpotStrategy       string                                   `position:"Query" name:"SpotStrategy"`
	DataDiskSize       requests.Integer                         `position:"Query" name:"DataDiskSize"`
	SpotPriceLimits    *[]CreateScalingTaskGroupSpotPriceLimits `position:"Query" name:"SpotPriceLimits"  type:"Repeated"`
	ScalingRule        *[]CreateScalingTaskGroupScalingRule     `position:"Query" name:"ScalingRule"  type:"Repeated"`
	ActiveRuleCategory string                                   `position:"Query" name:"ActiveRuleCategory"`
	MaxSize            requests.Integer                         `position:"Query" name:"MaxSize"`
	DataDiskCount      requests.Integer                         `position:"Query" name:"DataDiskCount"`
	DefaultCooldown    requests.Integer                         `position:"Query" name:"DefaultCooldown"`
	PayType            string                                   `position:"Query" name:"PayType"`
	InstanceTypeList   *[]string                                `position:"Query" name:"InstanceTypeList"  type:"Repeated"`
}

// CreateScalingTaskGroupSpotPriceLimits is a repeated param struct in CreateScalingTaskGroupRequest
type CreateScalingTaskGroupSpotPriceLimits struct {
	InstanceType string `name:"InstanceType"`
	PriceLimit   string `name:"PriceLimit"`
}

// CreateScalingTaskGroupScalingRule is a repeated param struct in CreateScalingTaskGroupRequest
type CreateScalingTaskGroupScalingRule struct {
	LaunchTime           string    `name:"LaunchTime"`
	RuleCategory         string    `name:"RuleCategory"`
	AdjustmentValue      string    `name:"AdjustmentValue"`
	SchedulerTrigger     *[]string `name:"SchedulerTrigger" type:"Repeated"`
	AdjustmentType       string    `name:"AdjustmentType"`
	Cooldown             string    `name:"Cooldown"`
	RuleName             string    `name:"RuleName"`
	LaunchExpirationTime string    `name:"LaunchExpirationTime"`
	RecurrenceValue      string    `name:"RecurrenceValue"`
	RecurrenceEndTime    string    `name:"RecurrenceEndTime"`
	CloudWatchTrigger    *[]string `name:"CloudWatchTrigger" type:"Repeated"`
	RecurrenceType       string    `name:"RecurrenceType"`
}

// CreateScalingTaskGroupResponse is the response struct for api CreateScalingTaskGroup
type CreateScalingTaskGroupResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	HostGroupId string `json:"HostGroupId" xml:"HostGroupId"`
}

// CreateCreateScalingTaskGroupRequest creates a request to invoke CreateScalingTaskGroup API
func CreateCreateScalingTaskGroupRequest() (request *CreateScalingTaskGroupRequest) {
	request = &CreateScalingTaskGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateScalingTaskGroup", "emr", "openAPI")
	return
}

// CreateCreateScalingTaskGroupResponse creates a response to parse from CreateScalingTaskGroup response
func CreateCreateScalingTaskGroupResponse() (response *CreateScalingTaskGroupResponse) {
	response = &CreateScalingTaskGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
