package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListServiceLog invokes the emr.ListServiceLog API synchronously
// api document: https://help.aliyun.com/api/emr/listservicelog.html
func (client *Client) ListServiceLog(request *ListServiceLogRequest) (response *ListServiceLogResponse, err error) {
	response = CreateListServiceLogResponse()
	err = client.DoAction(request, response)
	return
}

// ListServiceLogWithChan invokes the emr.ListServiceLog API asynchronously
// api document: https://help.aliyun.com/api/emr/listservicelog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListServiceLogWithChan(request *ListServiceLogRequest) (<-chan *ListServiceLogResponse, <-chan error) {
	responseChan := make(chan *ListServiceLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListServiceLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListServiceLogWithCallback invokes the emr.ListServiceLog API asynchronously
// api document: https://help.aliyun.com/api/emr/listservicelog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListServiceLogWithCallback(request *ListServiceLogRequest, callback func(response *ListServiceLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListServiceLogResponse
		var err error
		defer close(result)
		response, err = client.ListServiceLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListServiceLogRequest is the request struct for api ListServiceLog
type ListServiceLogRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostName        string           `position:"Query" name:"HostName"`
	MaxKeys         requests.Integer `position:"Query" name:"MaxKeys"`
	LogstoreName    string           `position:"Query" name:"LogstoreName"`
	Marker          string           `position:"Query" name:"Marker"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// ListServiceLogResponse is the response struct for api ListServiceLog
type ListServiceLogResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	LogFileList LogFileList `json:"LogFileList" xml:"LogFileList"`
}

// CreateListServiceLogRequest creates a request to invoke ListServiceLog API
func CreateListServiceLogRequest() (request *ListServiceLogRequest) {
	request = &ListServiceLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListServiceLog", "emr", "openAPI")
	return
}

// CreateListServiceLogResponse creates a response to parse from ListServiceLog response
func CreateListServiceLogResponse() (response *ListServiceLogResponse) {
	response = &ListServiceLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
