package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreDescribeTask invokes the emr.MetastoreDescribeTask API synchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribetask.html
func (client *Client) MetastoreDescribeTask(request *MetastoreDescribeTaskRequest) (response *MetastoreDescribeTaskResponse, err error) {
	response = CreateMetastoreDescribeTaskResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreDescribeTaskWithChan invokes the emr.MetastoreDescribeTask API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeTaskWithChan(request *MetastoreDescribeTaskRequest) (<-chan *MetastoreDescribeTaskResponse, <-chan error) {
	responseChan := make(chan *MetastoreDescribeTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreDescribeTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreDescribeTaskWithCallback invokes the emr.MetastoreDescribeTask API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeTaskWithCallback(request *MetastoreDescribeTaskRequest, callback func(response *MetastoreDescribeTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreDescribeTaskResponse
		var err error
		defer close(result)
		response, err = client.MetastoreDescribeTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreDescribeTaskRequest is the request struct for api MetastoreDescribeTask
type MetastoreDescribeTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskId          string           `position:"Query" name:"TaskId"`
}

// MetastoreDescribeTaskResponse is the response struct for api MetastoreDescribeTask
type MetastoreDescribeTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Task      Task   `json:"Task" xml:"Task"`
}

// CreateMetastoreDescribeTaskRequest creates a request to invoke MetastoreDescribeTask API
func CreateMetastoreDescribeTaskRequest() (request *MetastoreDescribeTaskRequest) {
	request = &MetastoreDescribeTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreDescribeTask", "emr", "openAPI")
	return
}

// CreateMetastoreDescribeTaskResponse creates a response to parse from MetastoreDescribeTask response
func CreateMetastoreDescribeTaskResponse() (response *MetastoreDescribeTaskResponse) {
	response = &MetastoreDescribeTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
