package industry_brain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateEquipment invokes the industry_brain.OperateEquipment API synchronously
// api document: https://help.aliyun.com/api/industry-brain/operateequipment.html
func (client *Client) OperateEquipment(request *OperateEquipmentRequest) (response *OperateEquipmentResponse, err error) {
	response = CreateOperateEquipmentResponse()
	err = client.DoAction(request, response)
	return
}

// OperateEquipmentWithChan invokes the industry_brain.OperateEquipment API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/operateequipment.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateEquipmentWithChan(request *OperateEquipmentRequest) (<-chan *OperateEquipmentResponse, <-chan error) {
	responseChan := make(chan *OperateEquipmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateEquipment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateEquipmentWithCallback invokes the industry_brain.OperateEquipment API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/operateequipment.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateEquipmentWithCallback(request *OperateEquipmentRequest, callback func(response *OperateEquipmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateEquipmentResponse
		var err error
		defer close(result)
		response, err = client.OperateEquipment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateEquipmentRequest is the request struct for api OperateEquipment
type OperateEquipmentRequest struct {
	*requests.RpcRequest
	Operation   string `position:"Body" name:"Operation"`
	ProjectId   string `position:"Body" name:"ProjectId"`
	RequestData string `position:"Body" name:"RequestData"`
}

// OperateEquipmentResponse is the response struct for api OperateEquipment
type OperateEquipmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateOperateEquipmentRequest creates a request to invoke OperateEquipment API
func CreateOperateEquipmentRequest() (request *OperateEquipmentRequest) {
	request = &OperateEquipmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("industry-brain", "2018-07-12", "OperateEquipment", "", "")
	return
}

// CreateOperateEquipmentResponse creates a response to parse from OperateEquipment response
func CreateOperateEquipmentResponse() (response *OperateEquipmentResponse) {
	response = &OperateEquipmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
