package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTrainDatasFromPrediction invokes the ivision.CreateTrainDatasFromPrediction API synchronously
// api document: https://help.aliyun.com/api/ivision/createtraindatasfromprediction.html
func (client *Client) CreateTrainDatasFromPrediction(request *CreateTrainDatasFromPredictionRequest) (response *CreateTrainDatasFromPredictionResponse, err error) {
	response = CreateCreateTrainDatasFromPredictionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTrainDatasFromPredictionWithChan invokes the ivision.CreateTrainDatasFromPrediction API asynchronously
// api document: https://help.aliyun.com/api/ivision/createtraindatasfromprediction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTrainDatasFromPredictionWithChan(request *CreateTrainDatasFromPredictionRequest) (<-chan *CreateTrainDatasFromPredictionResponse, <-chan error) {
	responseChan := make(chan *CreateTrainDatasFromPredictionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTrainDatasFromPrediction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTrainDatasFromPredictionWithCallback invokes the ivision.CreateTrainDatasFromPrediction API asynchronously
// api document: https://help.aliyun.com/api/ivision/createtraindatasfromprediction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTrainDatasFromPredictionWithCallback(request *CreateTrainDatasFromPredictionRequest, callback func(response *CreateTrainDatasFromPredictionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTrainDatasFromPredictionResponse
		var err error
		defer close(result)
		response, err = client.CreateTrainDatasFromPrediction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTrainDatasFromPredictionRequest is the request struct for api CreateTrainDatasFromPrediction
type CreateTrainDatasFromPredictionRequest struct {
	*requests.RpcRequest
	DataIds     string           `position:"Query" name:"DataIds"`
	ProjectId   string           `position:"Query" name:"ProjectId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	TagId       string           `position:"Query" name:"TagId"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	IterationId string           `position:"Query" name:"IterationId"`
}

// CreateTrainDatasFromPredictionResponse is the response struct for api CreateTrainDatasFromPrediction
type CreateTrainDatasFromPredictionResponse struct {
	*responses.BaseResponse
	RequestId  string                                     `json:"RequestId" xml:"RequestId"`
	TrainDatas TrainDatasInCreateTrainDatasFromPrediction `json:"TrainDatas" xml:"TrainDatas"`
}

// CreateCreateTrainDatasFromPredictionRequest creates a request to invoke CreateTrainDatasFromPrediction API
func CreateCreateTrainDatasFromPredictionRequest() (request *CreateTrainDatasFromPredictionRequest) {
	request = &CreateTrainDatasFromPredictionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "CreateTrainDatasFromPrediction", "ivision", "openAPI")
	return
}

// CreateCreateTrainDatasFromPredictionResponse creates a response to parse from CreateTrainDatasFromPrediction response
func CreateCreateTrainDatasFromPredictionResponse() (response *CreateTrainDatasFromPredictionResponse) {
	response = &CreateTrainDatasFromPredictionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
