package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTrainDatasFromUrls invokes the ivision.CreateTrainDatasFromUrls API synchronously
// api document: https://help.aliyun.com/api/ivision/createtraindatasfromurls.html
func (client *Client) CreateTrainDatasFromUrls(request *CreateTrainDatasFromUrlsRequest) (response *CreateTrainDatasFromUrlsResponse, err error) {
	response = CreateCreateTrainDatasFromUrlsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTrainDatasFromUrlsWithChan invokes the ivision.CreateTrainDatasFromUrls API asynchronously
// api document: https://help.aliyun.com/api/ivision/createtraindatasfromurls.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTrainDatasFromUrlsWithChan(request *CreateTrainDatasFromUrlsRequest) (<-chan *CreateTrainDatasFromUrlsResponse, <-chan error) {
	responseChan := make(chan *CreateTrainDatasFromUrlsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTrainDatasFromUrls(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTrainDatasFromUrlsWithCallback invokes the ivision.CreateTrainDatasFromUrls API asynchronously
// api document: https://help.aliyun.com/api/ivision/createtraindatasfromurls.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTrainDatasFromUrlsWithCallback(request *CreateTrainDatasFromUrlsRequest, callback func(response *CreateTrainDatasFromUrlsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTrainDatasFromUrlsResponse
		var err error
		defer close(result)
		response, err = client.CreateTrainDatasFromUrls(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTrainDatasFromUrlsRequest is the request struct for api CreateTrainDatasFromUrls
type CreateTrainDatasFromUrlsRequest struct {
	*requests.RpcRequest
	Urls      string           `position:"Query" name:"Urls"`
	ProjectId string           `position:"Query" name:"ProjectId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	TagId     string           `position:"Query" name:"TagId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateTrainDatasFromUrlsResponse is the response struct for api CreateTrainDatasFromUrls
type CreateTrainDatasFromUrlsResponse struct {
	*responses.BaseResponse
	RequestId  string                               `json:"RequestId" xml:"RequestId"`
	TrainDatas TrainDatasInCreateTrainDatasFromUrls `json:"TrainDatas" xml:"TrainDatas"`
}

// CreateCreateTrainDatasFromUrlsRequest creates a request to invoke CreateTrainDatasFromUrls API
func CreateCreateTrainDatasFromUrlsRequest() (request *CreateTrainDatasFromUrlsRequest) {
	request = &CreateTrainDatasFromUrlsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "CreateTrainDatasFromUrls", "ivision", "openAPI")
	return
}

// CreateCreateTrainDatasFromUrlsResponse creates a response to parse from CreateTrainDatasFromUrls response
func CreateCreateTrainDatasFromUrlsResponse() (response *CreateTrainDatasFromUrlsResponse) {
	response = &CreateTrainDatasFromUrlsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
