package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainTranscodeData invokes the live.DescribeLiveDomainTranscodeData API synchronously
// api document: https://help.aliyun.com/api/live/describelivedomaintranscodedata.html
func (client *Client) DescribeLiveDomainTranscodeData(request *DescribeLiveDomainTranscodeDataRequest) (response *DescribeLiveDomainTranscodeDataResponse, err error) {
	response = CreateDescribeLiveDomainTranscodeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainTranscodeDataWithChan invokes the live.DescribeLiveDomainTranscodeData API asynchronously
// api document: https://help.aliyun.com/api/live/describelivedomaintranscodedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveDomainTranscodeDataWithChan(request *DescribeLiveDomainTranscodeDataRequest) (<-chan *DescribeLiveDomainTranscodeDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainTranscodeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainTranscodeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainTranscodeDataWithCallback invokes the live.DescribeLiveDomainTranscodeData API asynchronously
// api document: https://help.aliyun.com/api/live/describelivedomaintranscodedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveDomainTranscodeDataWithCallback(request *DescribeLiveDomainTranscodeDataRequest, callback func(response *DescribeLiveDomainTranscodeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainTranscodeDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainTranscodeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainTranscodeDataRequest is the request struct for api DescribeLiveDomainTranscodeData
type DescribeLiveDomainTranscodeDataRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	StartTime  string           `position:"Query" name:"StartTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveDomainTranscodeDataResponse is the response struct for api DescribeLiveDomainTranscodeData
type DescribeLiveDomainTranscodeDataResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	TranscodeDataInfos TranscodeDataInfos `json:"TranscodeDataInfos" xml:"TranscodeDataInfos"`
}

// CreateDescribeLiveDomainTranscodeDataRequest creates a request to invoke DescribeLiveDomainTranscodeData API
func CreateDescribeLiveDomainTranscodeDataRequest() (request *DescribeLiveDomainTranscodeDataRequest) {
	request = &DescribeLiveDomainTranscodeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainTranscodeData", "live", "openAPI")
	return
}

// CreateDescribeLiveDomainTranscodeDataResponse creates a response to parse from DescribeLiveDomainTranscodeData response
func CreateDescribeLiveDomainTranscodeDataResponse() (response *DescribeLiveDomainTranscodeDataResponse) {
	response = &DescribeLiveDomainTranscodeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
