//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package nas

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccessGroups invokes the nas.DescribeAccessGroups API synchronously
// api document: https://help.aliyun.com/api/nas/describeaccessgroups.html
func (client *Client) DescribeAccessGroups(request *DescribeAccessGroupsRequest) (response *DescribeAccessGroupsResponse, err error) {
	response = CreateDescribeAccessGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccessGroupsWithChan invokes the nas.DescribeAccessGroups API asynchronously
// api document: https://help.aliyun.com/api/nas/describeaccessgroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccessGroupsWithChan(request *DescribeAccessGroupsRequest) (<-chan *DescribeAccessGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeAccessGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccessGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccessGroupsWithCallback invokes the nas.DescribeAccessGroups API asynchronously
// api document: https://help.aliyun.com/api/nas/describeaccessgroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccessGroupsWithCallback(request *DescribeAccessGroupsRequest, callback func(response *DescribeAccessGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccessGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccessGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccessGroupsRequest is the request struct for api DescribeAccessGroups
type DescribeAccessGroupsRequest struct {
	*requests.RpcRequest
	AccessGroupName string           `position:"Query" name:"AccessGroupName"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeAccessGroupsResponse is the response struct for api DescribeAccessGroups
type DescribeAccessGroupsResponse struct {
	*responses.BaseResponse
	RequestId    string                            `json:"RequestId" xml:"RequestId"`
	TotalCount   int                               `json:"TotalCount" xml:"TotalCount"`
	PageSize     int                               `json:"PageSize" xml:"PageSize"`
	PageNumber   int                               `json:"PageNumber" xml:"PageNumber"`
	AccessGroups DescribeAccessGroupsAccessGroups0 `json:"AccessGroups" xml:"AccessGroups"`
}

type DescribeAccessGroupsAccessGroups0 struct {
	AccessGroup []DescribeAccessGroupsAccessGroup1 `json:"AccessGroup" xml:"AccessGroup"`
}

type DescribeAccessGroupsAccessGroup1 struct {
	AccessGroupName  string `json:"AccessGroupName" xml:"AccessGroupName"`
	AccessGroupType  string `json:"AccessGroupType" xml:"AccessGroupType"`
	RuleCount        int    `json:"RuleCount" xml:"RuleCount"`
	MountTargetCount int    `json:"MountTargetCount" xml:"MountTargetCount"`
	Description      string `json:"Description" xml:"Description"`
}

// CreateDescribeAccessGroupsRequest creates a request to invoke DescribeAccessGroups API
func CreateDescribeAccessGroupsRequest() (request *DescribeAccessGroupsRequest) {
	request = &DescribeAccessGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DescribeAccessGroups", "nas", "openAPI")
	return
}

// CreateDescribeAccessGroupsResponse creates a response to parse from DescribeAccessGroups response
func CreateDescribeAccessGroupsResponse() (response *DescribeAccessGroupsResponse) {
	response = &DescribeAccessGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
