//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package nas

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTieringJob invokes the nas.ModifyTieringJob API synchronously
// api document: https://help.aliyun.com/api/nas/modifytieringjob.html
func (client *Client) ModifyTieringJob(request *ModifyTieringJobRequest) (response *ModifyTieringJobResponse, err error) {
	response = CreateModifyTieringJobResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTieringJobWithChan invokes the nas.ModifyTieringJob API asynchronously
// api document: https://help.aliyun.com/api/nas/modifytieringjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTieringJobWithChan(request *ModifyTieringJobRequest) (<-chan *ModifyTieringJobResponse, <-chan error) {
	responseChan := make(chan *ModifyTieringJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTieringJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTieringJobWithCallback invokes the nas.ModifyTieringJob API asynchronously
// api document: https://help.aliyun.com/api/nas/modifytieringjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTieringJobWithCallback(request *ModifyTieringJobRequest, callback func(response *ModifyTieringJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTieringJobResponse
		var err error
		defer close(result)
		response, err = client.ModifyTieringJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTieringJobRequest is the request struct for api ModifyTieringJob
type ModifyTieringJobRequest struct {
	*requests.RpcRequest
	Volume    string           `position:"Query" name:"Volume"`
	Name      string           `position:"Query" name:"Name"`
	Type      string           `position:"Query" name:"Type"`
	Path      string           `position:"Query" name:"Path"`
	Recursive requests.Boolean `position:"Query" name:"Recursive"`
	Policy    string           `position:"Query" name:"Policy"`
	Weekday   requests.Integer `position:"Query" name:"Weekday"`
	Hour      requests.Integer `position:"Query" name:"Hour"`
	Enabled   requests.Boolean `position:"Query" name:"Enabled"`
}

// ModifyTieringJobResponse is the response struct for api ModifyTieringJob
type ModifyTieringJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyTieringJobRequest creates a request to invoke ModifyTieringJob API
func CreateModifyTieringJobRequest() (request *ModifyTieringJobRequest) {
	request = &ModifyTieringJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "ModifyTieringJob", "nas", "openAPI")
	return
}

// CreateModifyTieringJobResponse creates a response to parse from ModifyTieringJob response
func CreateModifyTieringJobResponse() (response *ModifyTieringJobResponse) {
	response = &ModifyTieringJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
