//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package nas

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTieringPolicy invokes the nas.ModifyTieringPolicy API synchronously
// api document: https://help.aliyun.com/api/nas/modifytieringpolicy.html
func (client *Client) ModifyTieringPolicy(request *ModifyTieringPolicyRequest) (response *ModifyTieringPolicyResponse, err error) {
	response = CreateModifyTieringPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTieringPolicyWithChan invokes the nas.ModifyTieringPolicy API asynchronously
// api document: https://help.aliyun.com/api/nas/modifytieringpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTieringPolicyWithChan(request *ModifyTieringPolicyRequest) (<-chan *ModifyTieringPolicyResponse, <-chan error) {
	responseChan := make(chan *ModifyTieringPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTieringPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTieringPolicyWithCallback invokes the nas.ModifyTieringPolicy API asynchronously
// api document: https://help.aliyun.com/api/nas/modifytieringpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTieringPolicyWithCallback(request *ModifyTieringPolicyRequest, callback func(response *ModifyTieringPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTieringPolicyResponse
		var err error
		defer close(result)
		response, err = client.ModifyTieringPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTieringPolicyRequest is the request struct for api ModifyTieringPolicy
type ModifyTieringPolicyRequest struct {
	*requests.RpcRequest
	Name        string           `position:"Query" name:"Name"`
	Description string           `position:"Query" name:"Description"`
	Mtime       requests.Integer `position:"Query" name:"Mtime"`
	Atime       requests.Integer `position:"Query" name:"Atime"`
	Ctime       requests.Integer `position:"Query" name:"Ctime"`
	Size        requests.Integer `position:"Query" name:"Size"`
	FileName    string           `position:"Query" name:"FileName"`
	RecallTime  requests.Integer `position:"Query" name:"RecallTime"`
}

// ModifyTieringPolicyResponse is the response struct for api ModifyTieringPolicy
type ModifyTieringPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyTieringPolicyRequest creates a request to invoke ModifyTieringPolicy API
func CreateModifyTieringPolicyRequest() (request *ModifyTieringPolicyRequest) {
	request = &ModifyTieringPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "ModifyTieringPolicy", "nas", "openAPI")
	return
}

// CreateModifyTieringPolicyResponse creates a response to parse from ModifyTieringPolicy response
func CreateModifyTieringPolicyResponse() (response *ModifyTieringPolicyResponse) {
	response = &ModifyTieringPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
