//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package rtc

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopMPUTask invokes the rtc.StopMPUTask API synchronously
// api document: https://help.aliyun.com/api/rtc/stopmputask.html
func (client *Client) StopMPUTask(request *StopMPUTaskRequest) (response *StopMPUTaskResponse, err error) {
	response = CreateStopMPUTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StopMPUTaskWithChan invokes the rtc.StopMPUTask API asynchronously
// api document: https://help.aliyun.com/api/rtc/stopmputask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StopMPUTaskWithChan(request *StopMPUTaskRequest) (<-chan *StopMPUTaskResponse, <-chan error) {
	responseChan := make(chan *StopMPUTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopMPUTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopMPUTaskWithCallback invokes the rtc.StopMPUTask API asynchronously
// api document: https://help.aliyun.com/api/rtc/stopmputask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StopMPUTaskWithCallback(request *StopMPUTaskRequest, callback func(response *StopMPUTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopMPUTaskResponse
		var err error
		defer close(result)
		response, err = client.StopMPUTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopMPUTaskRequest is the request struct for api StopMPUTask
type StopMPUTaskRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	AppId   string           `position:"Query" name:"AppId"`
	TaskId  string           `position:"Query" name:"TaskId"`
}

// StopMPUTaskResponse is the response struct for api StopMPUTask
type StopMPUTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopMPUTaskRequest creates a request to invoke StopMPUTask API
func CreateStopMPUTaskRequest() (request *StopMPUTaskRequest) {
	request = &StopMPUTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "StopMPUTask", "rtc", "openAPI")
	return
}

// CreateStopMPUTaskResponse creates a response to parse from StopMPUTask response
func CreateStopMPUTaskResponse() (response *StopMPUTaskResponse) {
	response = &StopMPUTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
