package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDedicatedLineBackup invokes the smartag.CreateDedicatedLineBackup API synchronously
// api document: https://help.aliyun.com/api/smartag/creatededicatedlinebackup.html
func (client *Client) CreateDedicatedLineBackup(request *CreateDedicatedLineBackupRequest) (response *CreateDedicatedLineBackupResponse, err error) {
	response = CreateCreateDedicatedLineBackupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDedicatedLineBackupWithChan invokes the smartag.CreateDedicatedLineBackup API asynchronously
// api document: https://help.aliyun.com/api/smartag/creatededicatedlinebackup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDedicatedLineBackupWithChan(request *CreateDedicatedLineBackupRequest) (<-chan *CreateDedicatedLineBackupResponse, <-chan error) {
	responseChan := make(chan *CreateDedicatedLineBackupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDedicatedLineBackup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDedicatedLineBackupWithCallback invokes the smartag.CreateDedicatedLineBackup API asynchronously
// api document: https://help.aliyun.com/api/smartag/creatededicatedlinebackup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDedicatedLineBackupWithCallback(request *CreateDedicatedLineBackupRequest, callback func(response *CreateDedicatedLineBackupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDedicatedLineBackupResponse
		var err error
		defer close(result)
		response, err = client.CreateDedicatedLineBackup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDedicatedLineBackupRequest is the request struct for api CreateDedicatedLineBackup
type CreateDedicatedLineBackupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VbrId                string           `position:"Query" name:"VbrId"`
	VbrRegionId          string           `position:"Query" name:"VbrRegionId"`
}

// CreateDedicatedLineBackupResponse is the response struct for api CreateDedicatedLineBackup
type CreateDedicatedLineBackupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDedicatedLineBackupRequest creates a request to invoke CreateDedicatedLineBackup API
func CreateCreateDedicatedLineBackupRequest() (request *CreateDedicatedLineBackupRequest) {
	request = &CreateDedicatedLineBackupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "CreateDedicatedLineBackup", "smartag", "openAPI")
	return
}

// CreateCreateDedicatedLineBackupResponse creates a response to parse from CreateDedicatedLineBackup response
func CreateCreateDedicatedLineBackupResponse() (response *CreateDedicatedLineBackupResponse) {
	response = &CreateDedicatedLineBackupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
