package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSAGLinkLevelHa invokes the smartag.CreateSAGLinkLevelHa API synchronously
// api document: https://help.aliyun.com/api/smartag/createsaglinklevelha.html
func (client *Client) CreateSAGLinkLevelHa(request *CreateSAGLinkLevelHaRequest) (response *CreateSAGLinkLevelHaResponse, err error) {
	response = CreateCreateSAGLinkLevelHaResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSAGLinkLevelHaWithChan invokes the smartag.CreateSAGLinkLevelHa API asynchronously
// api document: https://help.aliyun.com/api/smartag/createsaglinklevelha.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSAGLinkLevelHaWithChan(request *CreateSAGLinkLevelHaRequest) (<-chan *CreateSAGLinkLevelHaResponse, <-chan error) {
	responseChan := make(chan *CreateSAGLinkLevelHaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSAGLinkLevelHa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSAGLinkLevelHaWithCallback invokes the smartag.CreateSAGLinkLevelHa API asynchronously
// api document: https://help.aliyun.com/api/smartag/createsaglinklevelha.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSAGLinkLevelHaWithCallback(request *CreateSAGLinkLevelHaRequest, callback func(response *CreateSAGLinkLevelHaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSAGLinkLevelHaResponse
		var err error
		defer close(result)
		response, err = client.CreateSAGLinkLevelHa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSAGLinkLevelHaRequest is the request struct for api CreateSAGLinkLevelHa
type CreateSAGLinkLevelHaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BackupLinkId         string           `position:"Query" name:"BackupLinkId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	HaType               string           `position:"Query" name:"HaType"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	MainLinkRegionId     string           `position:"Query" name:"MainLinkRegionId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	MainLinkId           string           `position:"Query" name:"MainLinkId"`
	BackupLinkRegionId   string           `position:"Query" name:"BackupLinkRegionId"`
}

// CreateSAGLinkLevelHaResponse is the response struct for api CreateSAGLinkLevelHa
type CreateSAGLinkLevelHaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateSAGLinkLevelHaRequest creates a request to invoke CreateSAGLinkLevelHa API
func CreateCreateSAGLinkLevelHaRequest() (request *CreateSAGLinkLevelHaRequest) {
	request = &CreateSAGLinkLevelHaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "CreateSAGLinkLevelHa", "smartag", "openAPI")
	return
}

// CreateCreateSAGLinkLevelHaResponse creates a response to parse from CreateSAGLinkLevelHa response
func CreateCreateSAGLinkLevelHaResponse() (response *CreateSAGLinkLevelHaResponse) {
	response = &CreateSAGLinkLevelHaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
