package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySerialNumber invokes the smartag.ModifySerialNumber API synchronously
// api document: https://help.aliyun.com/api/smartag/modifyserialnumber.html
func (client *Client) ModifySerialNumber(request *ModifySerialNumberRequest) (response *ModifySerialNumberResponse, err error) {
	response = CreateModifySerialNumberResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySerialNumberWithChan invokes the smartag.ModifySerialNumber API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifyserialnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySerialNumberWithChan(request *ModifySerialNumberRequest) (<-chan *ModifySerialNumberResponse, <-chan error) {
	responseChan := make(chan *ModifySerialNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySerialNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySerialNumberWithCallback invokes the smartag.ModifySerialNumber API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifyserialnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySerialNumberWithCallback(request *ModifySerialNumberRequest, callback func(response *ModifySerialNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySerialNumberResponse
		var err error
		defer close(result)
		response, err = client.ModifySerialNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySerialNumberRequest is the request struct for api ModifySerialNumber
type ModifySerialNumberRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SerialNumber         string           `position:"Query" name:"SerialNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifySerialNumberResponse is the response struct for api ModifySerialNumber
type ModifySerialNumberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySerialNumberRequest creates a request to invoke ModifySerialNumber API
func CreateModifySerialNumberRequest() (request *ModifySerialNumberRequest) {
	request = &ModifySerialNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySerialNumber", "smartag", "openAPI")
	return
}

// CreateModifySerialNumberResponse creates a response to parse from ModifySerialNumber response
func CreateModifySerialNumberResponse() (response *ModifySerialNumberResponse) {
	response = &ModifySerialNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
