package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetSmartAccessGatewayClientUserPassword invokes the smartag.ResetSmartAccessGatewayClientUserPassword API synchronously
// api document: https://help.aliyun.com/api/smartag/resetsmartaccessgatewayclientuserpassword.html
func (client *Client) ResetSmartAccessGatewayClientUserPassword(request *ResetSmartAccessGatewayClientUserPasswordRequest) (response *ResetSmartAccessGatewayClientUserPasswordResponse, err error) {
	response = CreateResetSmartAccessGatewayClientUserPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ResetSmartAccessGatewayClientUserPasswordWithChan invokes the smartag.ResetSmartAccessGatewayClientUserPassword API asynchronously
// api document: https://help.aliyun.com/api/smartag/resetsmartaccessgatewayclientuserpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetSmartAccessGatewayClientUserPasswordWithChan(request *ResetSmartAccessGatewayClientUserPasswordRequest) (<-chan *ResetSmartAccessGatewayClientUserPasswordResponse, <-chan error) {
	responseChan := make(chan *ResetSmartAccessGatewayClientUserPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetSmartAccessGatewayClientUserPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetSmartAccessGatewayClientUserPasswordWithCallback invokes the smartag.ResetSmartAccessGatewayClientUserPassword API asynchronously
// api document: https://help.aliyun.com/api/smartag/resetsmartaccessgatewayclientuserpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetSmartAccessGatewayClientUserPasswordWithCallback(request *ResetSmartAccessGatewayClientUserPasswordRequest, callback func(response *ResetSmartAccessGatewayClientUserPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetSmartAccessGatewayClientUserPasswordResponse
		var err error
		defer close(result)
		response, err = client.ResetSmartAccessGatewayClientUserPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetSmartAccessGatewayClientUserPasswordRequest is the request struct for api ResetSmartAccessGatewayClientUserPassword
type ResetSmartAccessGatewayClientUserPasswordRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	UserName             string           `position:"Query" name:"UserName"`
}

// ResetSmartAccessGatewayClientUserPasswordResponse is the response struct for api ResetSmartAccessGatewayClientUserPassword
type ResetSmartAccessGatewayClientUserPasswordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetSmartAccessGatewayClientUserPasswordRequest creates a request to invoke ResetSmartAccessGatewayClientUserPassword API
func CreateResetSmartAccessGatewayClientUserPasswordRequest() (request *ResetSmartAccessGatewayClientUserPasswordRequest) {
	request = &ResetSmartAccessGatewayClientUserPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ResetSmartAccessGatewayClientUserPassword", "smartag", "openAPI")
	return
}

// CreateResetSmartAccessGatewayClientUserPasswordResponse creates a response to parse from ResetSmartAccessGatewayClientUserPassword response
func CreateResetSmartAccessGatewayClientUserPasswordResponse() (response *ResetSmartAccessGatewayClientUserPasswordResponse) {
	response = &ResetSmartAccessGatewayClientUserPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
