// Copyright (c) 2016, 2018, 2019, Oracle and/or its affiliates. All rights reserved.
// Code generated. DO NOT EDIT.

// Events API
//
// API for the Events Service. Use this API to manage rules and actions that create automation
// in your tenancy. For more information, see Overview of Events (https://docs.cloud.oracle.com/iaas/Content/Events/Concepts/eventsoverview.htm).
//

package events

import (
	"encoding/json"
	"github.com/oracle/oci-go-sdk/common"
)

// StreamingServiceAction An action that delivers to an Oracle Stream Service stream.
type StreamingServiceAction struct {

	// The OCID (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the action.
	Id *string `mandatory:"true" json:"id"`

	// A message generated by the Events service about the current state of this rule.
	LifecycleMessage *string `mandatory:"true" json:"lifecycleMessage"`

	// A string that describes the details of the action. It does not have to be unique, and you can change it. Avoid entering
	// confidential information.
	Description *string `mandatory:"false" json:"description"`

	// The OCID (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream to which messages are delivered.
	StreamId *string `mandatory:"false" json:"streamId"`

	// The current state of the rule.
	LifecycleState ActionLifecycleStateEnum `mandatory:"true" json:"lifecycleState"`
}

//GetId returns Id
func (m StreamingServiceAction) GetId() *string {
	return m.Id
}

//GetLifecycleMessage returns LifecycleMessage
func (m StreamingServiceAction) GetLifecycleMessage() *string {
	return m.LifecycleMessage
}

//GetLifecycleState returns LifecycleState
func (m StreamingServiceAction) GetLifecycleState() ActionLifecycleStateEnum {
	return m.LifecycleState
}

//GetDescription returns Description
func (m StreamingServiceAction) GetDescription() *string {
	return m.Description
}

func (m StreamingServiceAction) String() string {
	return common.PointerString(m)
}

// MarshalJSON marshals to json representation
func (m StreamingServiceAction) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeStreamingServiceAction StreamingServiceAction
	s := struct {
		DiscriminatorParam string `json:"actionType"`
		MarshalTypeStreamingServiceAction
	}{
		"OSS",
		(MarshalTypeStreamingServiceAction)(m),
	}

	return json.Marshal(&s)
}
