---
layout: "registry"
page_title: "Terraform Registry - Verified Modules"
sidebar_current: "docs-registry-verified"
description: |-
  Verified modules are reviewed by HashiCorp and actively maintained by contributors to stay up-to-date and compatible with both Terraform and their respective providers.
---

# Verified Modules

Verified modules are reviewed by HashiCorp and actively maintained by
contributors to stay up-to-date and compatible with both Terraform and
their respective providers.

The blue verification badge appears next to modules that are verified.

![Verified module listing](/assets/images/docs/registry-verified.png)

Verified modules are expected to be actively maintained by the Cloud providers.
The verified badge isn’t indicative of flexibility or feature support; very
simple modules can be verified just because they're great examples of modules.
Likewise, an unverified module could be extremely high quality and actively
maintained. An unverified module shouldn't be assumed to be poor quality, it
only means it hasn't been created by a HashiCorp partner.

Module verification is currently a manual process restricted to a small group
of trusted HashiCorp partners. In the coming months, we'll be expanding
verification to enable the broader community to verify their modules.

When [using registry modules](/docs/registry/modules/use.html), there is no
difference between a verified and unverified module; they are used the same
way.
