// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot1clickdevicesservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opClaimDevicesByClaimCode = "ClaimDevicesByClaimCode"

// ClaimDevicesByClaimCodeRequest generates a "aws/request.Request" representing the
// client's request for the ClaimDevicesByClaimCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ClaimDevicesByClaimCode for more information on using the ClaimDevicesByClaimCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ClaimDevicesByClaimCodeRequest method.
//    req, resp := client.ClaimDevicesByClaimCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ClaimDevicesByClaimCode
func (c *IoT1ClickDevicesService) ClaimDevicesByClaimCodeRequest(input *ClaimDevicesByClaimCodeInput) (req *request.Request, output *ClaimDevicesByClaimCodeOutput) {
	op := &request.Operation{
		Name:       opClaimDevicesByClaimCode,
		HTTPMethod: "PUT",
		HTTPPath:   "/claims/{claimCode}",
	}

	if input == nil {
		input = &ClaimDevicesByClaimCodeInput{}
	}

	output = &ClaimDevicesByClaimCodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ClaimDevicesByClaimCode API operation for AWS IoT 1-Click Devices Service.
//
// Adds device(s) to your account (i.e., claim one or more devices) if and only
// if you received a claim code with the device(s).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation ClaimDevicesByClaimCode for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//
//   * InternalFailureException
//
//   * ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ClaimDevicesByClaimCode
func (c *IoT1ClickDevicesService) ClaimDevicesByClaimCode(input *ClaimDevicesByClaimCodeInput) (*ClaimDevicesByClaimCodeOutput, error) {
	req, out := c.ClaimDevicesByClaimCodeRequest(input)
	return out, req.Send()
}

// ClaimDevicesByClaimCodeWithContext is the same as ClaimDevicesByClaimCode with the addition of
// the ability to pass a context and additional request options.
//
// See ClaimDevicesByClaimCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) ClaimDevicesByClaimCodeWithContext(ctx aws.Context, input *ClaimDevicesByClaimCodeInput, opts ...request.Option) (*ClaimDevicesByClaimCodeOutput, error) {
	req, out := c.ClaimDevicesByClaimCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDevice = "DescribeDevice"

// DescribeDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDevice for more information on using the DescribeDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeviceRequest method.
//    req, resp := client.DescribeDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/DescribeDevice
func (c *IoT1ClickDevicesService) DescribeDeviceRequest(input *DescribeDeviceInput) (req *request.Request, output *DescribeDeviceOutput) {
	op := &request.Operation{
		Name:       opDescribeDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/devices/{deviceId}",
	}

	if input == nil {
		input = &DescribeDeviceInput{}
	}

	output = &DescribeDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDevice API operation for AWS IoT 1-Click Devices Service.
//
// Given a device ID, returns a DescribeDeviceResponse object describing the
// details of the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation DescribeDevice for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/DescribeDevice
func (c *IoT1ClickDevicesService) DescribeDevice(input *DescribeDeviceInput) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	return out, req.Send()
}

// DescribeDeviceWithContext is the same as DescribeDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) DescribeDeviceWithContext(ctx aws.Context, input *DescribeDeviceInput, opts ...request.Option) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opFinalizeDeviceClaim = "FinalizeDeviceClaim"

// FinalizeDeviceClaimRequest generates a "aws/request.Request" representing the
// client's request for the FinalizeDeviceClaim operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FinalizeDeviceClaim for more information on using the FinalizeDeviceClaim
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FinalizeDeviceClaimRequest method.
//    req, resp := client.FinalizeDeviceClaimRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/FinalizeDeviceClaim
func (c *IoT1ClickDevicesService) FinalizeDeviceClaimRequest(input *FinalizeDeviceClaimInput) (req *request.Request, output *FinalizeDeviceClaimOutput) {
	op := &request.Operation{
		Name:       opFinalizeDeviceClaim,
		HTTPMethod: "PUT",
		HTTPPath:   "/devices/{deviceId}/finalize-claim",
	}

	if input == nil {
		input = &FinalizeDeviceClaimInput{}
	}

	output = &FinalizeDeviceClaimOutput{}
	req = c.newRequest(op, input, output)
	return
}

// FinalizeDeviceClaim API operation for AWS IoT 1-Click Devices Service.
//
// Given a device ID, finalizes the claim request for the associated device.
//
// Claiming a device consists of initiating a claim, then publishing a device
// event, and finalizing the claim. For a device of type button, a device event
// can be published by simply clicking the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation FinalizeDeviceClaim for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
//   * PreconditionFailedException
//
//   * ResourceConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/FinalizeDeviceClaim
func (c *IoT1ClickDevicesService) FinalizeDeviceClaim(input *FinalizeDeviceClaimInput) (*FinalizeDeviceClaimOutput, error) {
	req, out := c.FinalizeDeviceClaimRequest(input)
	return out, req.Send()
}

// FinalizeDeviceClaimWithContext is the same as FinalizeDeviceClaim with the addition of
// the ability to pass a context and additional request options.
//
// See FinalizeDeviceClaim for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) FinalizeDeviceClaimWithContext(ctx aws.Context, input *FinalizeDeviceClaimInput, opts ...request.Option) (*FinalizeDeviceClaimOutput, error) {
	req, out := c.FinalizeDeviceClaimRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceMethods = "GetDeviceMethods"

// GetDeviceMethodsRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceMethods operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceMethods for more information on using the GetDeviceMethods
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceMethodsRequest method.
//    req, resp := client.GetDeviceMethodsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/GetDeviceMethods
func (c *IoT1ClickDevicesService) GetDeviceMethodsRequest(input *GetDeviceMethodsInput) (req *request.Request, output *GetDeviceMethodsOutput) {
	op := &request.Operation{
		Name:       opGetDeviceMethods,
		HTTPMethod: "GET",
		HTTPPath:   "/devices/{deviceId}/methods",
	}

	if input == nil {
		input = &GetDeviceMethodsInput{}
	}

	output = &GetDeviceMethodsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceMethods API operation for AWS IoT 1-Click Devices Service.
//
// Given a device ID, returns the invokable methods associated with the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation GetDeviceMethods for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/GetDeviceMethods
func (c *IoT1ClickDevicesService) GetDeviceMethods(input *GetDeviceMethodsInput) (*GetDeviceMethodsOutput, error) {
	req, out := c.GetDeviceMethodsRequest(input)
	return out, req.Send()
}

// GetDeviceMethodsWithContext is the same as GetDeviceMethods with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceMethods for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) GetDeviceMethodsWithContext(ctx aws.Context, input *GetDeviceMethodsInput, opts ...request.Option) (*GetDeviceMethodsOutput, error) {
	req, out := c.GetDeviceMethodsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitiateDeviceClaim = "InitiateDeviceClaim"

// InitiateDeviceClaimRequest generates a "aws/request.Request" representing the
// client's request for the InitiateDeviceClaim operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitiateDeviceClaim for more information on using the InitiateDeviceClaim
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InitiateDeviceClaimRequest method.
//    req, resp := client.InitiateDeviceClaimRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InitiateDeviceClaim
func (c *IoT1ClickDevicesService) InitiateDeviceClaimRequest(input *InitiateDeviceClaimInput) (req *request.Request, output *InitiateDeviceClaimOutput) {
	op := &request.Operation{
		Name:       opInitiateDeviceClaim,
		HTTPMethod: "PUT",
		HTTPPath:   "/devices/{deviceId}/initiate-claim",
	}

	if input == nil {
		input = &InitiateDeviceClaimInput{}
	}

	output = &InitiateDeviceClaimOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InitiateDeviceClaim API operation for AWS IoT 1-Click Devices Service.
//
// Given a device ID, initiates a claim request for the associated device.
//
// Claiming a device consists of initiating a claim, then publishing a device
// event, and finalizing the claim. For a device of type button, a device event
// can be published by simply clicking the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation InitiateDeviceClaim for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
//   * ResourceConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InitiateDeviceClaim
func (c *IoT1ClickDevicesService) InitiateDeviceClaim(input *InitiateDeviceClaimInput) (*InitiateDeviceClaimOutput, error) {
	req, out := c.InitiateDeviceClaimRequest(input)
	return out, req.Send()
}

// InitiateDeviceClaimWithContext is the same as InitiateDeviceClaim with the addition of
// the ability to pass a context and additional request options.
//
// See InitiateDeviceClaim for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) InitiateDeviceClaimWithContext(ctx aws.Context, input *InitiateDeviceClaimInput, opts ...request.Option) (*InitiateDeviceClaimOutput, error) {
	req, out := c.InitiateDeviceClaimRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInvokeDeviceMethod = "InvokeDeviceMethod"

// InvokeDeviceMethodRequest generates a "aws/request.Request" representing the
// client's request for the InvokeDeviceMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvokeDeviceMethod for more information on using the InvokeDeviceMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InvokeDeviceMethodRequest method.
//    req, resp := client.InvokeDeviceMethodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InvokeDeviceMethod
func (c *IoT1ClickDevicesService) InvokeDeviceMethodRequest(input *InvokeDeviceMethodInput) (req *request.Request, output *InvokeDeviceMethodOutput) {
	op := &request.Operation{
		Name:       opInvokeDeviceMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/devices/{deviceId}/methods",
	}

	if input == nil {
		input = &InvokeDeviceMethodInput{}
	}

	output = &InvokeDeviceMethodOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InvokeDeviceMethod API operation for AWS IoT 1-Click Devices Service.
//
// Given a device ID, issues a request to invoke a named device method (with
// possible parameters). See the "Example POST" code snippet below.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation InvokeDeviceMethod for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//
//   * PreconditionFailedException
//
//   * InternalFailureException
//
//   * ResourceNotFoundException
//
//   * RangeNotSatisfiableException
//
//   * ResourceConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InvokeDeviceMethod
func (c *IoT1ClickDevicesService) InvokeDeviceMethod(input *InvokeDeviceMethodInput) (*InvokeDeviceMethodOutput, error) {
	req, out := c.InvokeDeviceMethodRequest(input)
	return out, req.Send()
}

// InvokeDeviceMethodWithContext is the same as InvokeDeviceMethod with the addition of
// the ability to pass a context and additional request options.
//
// See InvokeDeviceMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) InvokeDeviceMethodWithContext(ctx aws.Context, input *InvokeDeviceMethodInput, opts ...request.Option) (*InvokeDeviceMethodOutput, error) {
	req, out := c.InvokeDeviceMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeviceEvents = "ListDeviceEvents"

// ListDeviceEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceEvents for more information on using the ListDeviceEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeviceEventsRequest method.
//    req, resp := client.ListDeviceEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDeviceEvents
func (c *IoT1ClickDevicesService) ListDeviceEventsRequest(input *ListDeviceEventsInput) (req *request.Request, output *ListDeviceEventsOutput) {
	op := &request.Operation{
		Name:       opListDeviceEvents,
		HTTPMethod: "GET",
		HTTPPath:   "/devices/{deviceId}/events",
	}

	if input == nil {
		input = &ListDeviceEventsInput{}
	}

	output = &ListDeviceEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceEvents API operation for AWS IoT 1-Click Devices Service.
//
// Using a device ID, returns a DeviceEventsResponse object containing an array
// of events for the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation ListDeviceEvents for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * RangeNotSatisfiableException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDeviceEvents
func (c *IoT1ClickDevicesService) ListDeviceEvents(input *ListDeviceEventsInput) (*ListDeviceEventsOutput, error) {
	req, out := c.ListDeviceEventsRequest(input)
	return out, req.Send()
}

// ListDeviceEventsWithContext is the same as ListDeviceEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) ListDeviceEventsWithContext(ctx aws.Context, input *ListDeviceEventsInput, opts ...request.Option) (*ListDeviceEventsOutput, error) {
	req, out := c.ListDeviceEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevices for more information on using the ListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDevicesRequest method.
//    req, resp := client.ListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDevices
func (c *IoT1ClickDevicesService) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "GET",
		HTTPPath:   "/devices",
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevices API operation for AWS IoT 1-Click Devices Service.
//
// Lists the 1-Click compatible devices associated with your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation ListDevices for usage and error information.
//
// Returned Error Types:
//   * RangeNotSatisfiableException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDevices
func (c *IoT1ClickDevicesService) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	return out, req.Send()
}

// ListDevicesWithContext is the same as ListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) ListDevicesWithContext(ctx aws.Context, input *ListDevicesInput, opts ...request.Option) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListTagsForResource
func (c *IoT1ClickDevicesService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT 1-Click Devices Service.
//
// Lists the tags associated with the specified resource ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * InternalFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListTagsForResource
func (c *IoT1ClickDevicesService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/TagResource
func (c *IoT1ClickDevicesService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT 1-Click Devices Service.
//
// Adds or updates the tags associated with the resource ARN. See AWS IoT 1-Click
// Service Limits (https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits)
// for the maximum number of tags allowed per resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/TagResource
func (c *IoT1ClickDevicesService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnclaimDevice = "UnclaimDevice"

// UnclaimDeviceRequest generates a "aws/request.Request" representing the
// client's request for the UnclaimDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnclaimDevice for more information on using the UnclaimDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnclaimDeviceRequest method.
//    req, resp := client.UnclaimDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UnclaimDevice
func (c *IoT1ClickDevicesService) UnclaimDeviceRequest(input *UnclaimDeviceInput) (req *request.Request, output *UnclaimDeviceOutput) {
	op := &request.Operation{
		Name:       opUnclaimDevice,
		HTTPMethod: "PUT",
		HTTPPath:   "/devices/{deviceId}/unclaim",
	}

	if input == nil {
		input = &UnclaimDeviceInput{}
	}

	output = &UnclaimDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnclaimDevice API operation for AWS IoT 1-Click Devices Service.
//
// Disassociates a device from your AWS account using its device ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation UnclaimDevice for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UnclaimDevice
func (c *IoT1ClickDevicesService) UnclaimDevice(input *UnclaimDeviceInput) (*UnclaimDeviceOutput, error) {
	req, out := c.UnclaimDeviceRequest(input)
	return out, req.Send()
}

// UnclaimDeviceWithContext is the same as UnclaimDevice with the addition of
// the ability to pass a context and additional request options.
//
// See UnclaimDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) UnclaimDeviceWithContext(ctx aws.Context, input *UnclaimDeviceInput, opts ...request.Option) (*UnclaimDeviceOutput, error) {
	req, out := c.UnclaimDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UntagResource
func (c *IoT1ClickDevicesService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT 1-Click Devices Service.
//
// Using tag keys, deletes the tags (key/value pairs) associated with the specified
// resource ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UntagResource
func (c *IoT1ClickDevicesService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeviceState = "UpdateDeviceState"

// UpdateDeviceStateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeviceState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeviceState for more information on using the UpdateDeviceState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeviceStateRequest method.
//    req, resp := client.UpdateDeviceStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UpdateDeviceState
func (c *IoT1ClickDevicesService) UpdateDeviceStateRequest(input *UpdateDeviceStateInput) (req *request.Request, output *UpdateDeviceStateOutput) {
	op := &request.Operation{
		Name:       opUpdateDeviceState,
		HTTPMethod: "PUT",
		HTTPPath:   "/devices/{deviceId}/state",
	}

	if input == nil {
		input = &UpdateDeviceStateInput{}
	}

	output = &UpdateDeviceStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDeviceState API operation for AWS IoT 1-Click Devices Service.
//
// Using a Boolean value (true or false), this operation enables or disables
// the device given a device ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Devices Service's
// API operation UpdateDeviceState for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * InvalidRequestException
//
//   * InternalFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UpdateDeviceState
func (c *IoT1ClickDevicesService) UpdateDeviceState(input *UpdateDeviceStateInput) (*UpdateDeviceStateOutput, error) {
	req, out := c.UpdateDeviceStateRequest(input)
	return out, req.Send()
}

// UpdateDeviceStateWithContext is the same as UpdateDeviceState with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeviceState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickDevicesService) UpdateDeviceStateWithContext(ctx aws.Context, input *UpdateDeviceStateInput, opts ...request.Option) (*UpdateDeviceStateOutput, error) {
	req, out := c.UpdateDeviceStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type Attributes struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Attributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attributes) GoString() string {
	return s.String()
}

type ClaimDevicesByClaimCodeInput struct {
	_ struct{} `type:"structure"`

	// ClaimCode is a required field
	ClaimCode *string `location:"uri" locationName:"claimCode" type:"string" required:"true"`
}

// String returns the string representation
func (s ClaimDevicesByClaimCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClaimDevicesByClaimCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClaimDevicesByClaimCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClaimDevicesByClaimCodeInput"}
	if s.ClaimCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ClaimCode"))
	}
	if s.ClaimCode != nil && len(*s.ClaimCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClaimCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClaimCode sets the ClaimCode field's value.
func (s *ClaimDevicesByClaimCodeInput) SetClaimCode(v string) *ClaimDevicesByClaimCodeInput {
	s.ClaimCode = &v
	return s
}

type ClaimDevicesByClaimCodeOutput struct {
	_ struct{} `type:"structure"`

	// The claim code provided by the device manufacturer.
	ClaimCode *string `locationName:"claimCode" min:"12" type:"string"`

	// The total number of devices associated with the claim code that has been
	// processed in the claim request.
	Total *int64 `locationName:"total" type:"integer"`
}

// String returns the string representation
func (s ClaimDevicesByClaimCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClaimDevicesByClaimCodeOutput) GoString() string {
	return s.String()
}

// SetClaimCode sets the ClaimCode field's value.
func (s *ClaimDevicesByClaimCodeOutput) SetClaimCode(v string) *ClaimDevicesByClaimCodeOutput {
	s.ClaimCode = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ClaimDevicesByClaimCodeOutput) SetTotal(v int64) *ClaimDevicesByClaimCodeOutput {
	s.Total = &v
	return s
}

type DescribeDeviceInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeviceInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *DescribeDeviceInput) SetDeviceId(v string) *DescribeDeviceInput {
	s.DeviceId = &v
	return s
}

type DescribeDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Device details.
	DeviceDescription *DeviceDescription `locationName:"deviceDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeviceOutput) GoString() string {
	return s.String()
}

// SetDeviceDescription sets the DeviceDescription field's value.
func (s *DescribeDeviceOutput) SetDeviceDescription(v *DeviceDescription) *DescribeDeviceOutput {
	s.DeviceDescription = v
	return s
}

type Device struct {
	_ struct{} `type:"structure"`

	// The user specified attributes associated with the device for an event.
	Attributes *Attributes `locationName:"attributes" type:"structure"`

	// The unique identifier of the device.
	DeviceId *string `locationName:"deviceId" type:"string"`

	// The device type, such as "button".
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Device) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *Device) SetAttributes(v *Attributes) *Device {
	s.Attributes = v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *Device) SetDeviceId(v string) *Device {
	s.DeviceId = &v
	return s
}

// SetType sets the Type field's value.
func (s *Device) SetType(v string) *Device {
	s.Type = &v
	return s
}

type DeviceDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the device.
	Arn *string `locationName:"arn" type:"string"`

	// An array of zero or more elements of DeviceAttribute objects providing user
	// specified device attributes.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The unique identifier of the device.
	DeviceId *string `locationName:"deviceId" type:"string"`

	// A Boolean value indicating whether or not the device is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// A value between 0 and 1 inclusive, representing the fraction of life remaining
	// for the device.
	RemainingLife *float64 `locationName:"remainingLife" type:"double"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of the device, such as "button".
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s DeviceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceDescription) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeviceDescription) SetArn(v string) *DeviceDescription {
	s.Arn = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *DeviceDescription) SetAttributes(v map[string]*string) *DeviceDescription {
	s.Attributes = v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *DeviceDescription) SetDeviceId(v string) *DeviceDescription {
	s.DeviceId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *DeviceDescription) SetEnabled(v bool) *DeviceDescription {
	s.Enabled = &v
	return s
}

// SetRemainingLife sets the RemainingLife field's value.
func (s *DeviceDescription) SetRemainingLife(v float64) *DeviceDescription {
	s.RemainingLife = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeviceDescription) SetTags(v map[string]*string) *DeviceDescription {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *DeviceDescription) SetType(v string) *DeviceDescription {
	s.Type = &v
	return s
}

type DeviceEvent struct {
	_ struct{} `type:"structure"`

	// An object representing the device associated with the event.
	Device *Device `locationName:"device" type:"structure"`

	// A serialized JSON object representing the device-type specific event.
	StdEvent *string `locationName:"stdEvent" type:"string"`
}

// String returns the string representation
func (s DeviceEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceEvent) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *DeviceEvent) SetDevice(v *Device) *DeviceEvent {
	s.Device = v
	return s
}

// SetStdEvent sets the StdEvent field's value.
func (s *DeviceEvent) SetStdEvent(v string) *DeviceEvent {
	s.StdEvent = &v
	return s
}

type DeviceMethod struct {
	_ struct{} `type:"structure"`

	// The type of the device, such as "button".
	DeviceType *string `locationName:"deviceType" type:"string"`

	// The name of the method applicable to the deviceType.
	MethodName *string `locationName:"methodName" type:"string"`
}

// String returns the string representation
func (s DeviceMethod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceMethod) GoString() string {
	return s.String()
}

// SetDeviceType sets the DeviceType field's value.
func (s *DeviceMethod) SetDeviceType(v string) *DeviceMethod {
	s.DeviceType = &v
	return s
}

// SetMethodName sets the MethodName field's value.
func (s *DeviceMethod) SetMethodName(v string) *DeviceMethod {
	s.MethodName = &v
	return s
}

type FinalizeDeviceClaimInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s FinalizeDeviceClaimInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FinalizeDeviceClaimInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FinalizeDeviceClaimInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FinalizeDeviceClaimInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *FinalizeDeviceClaimInput) SetDeviceId(v string) *FinalizeDeviceClaimInput {
	s.DeviceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *FinalizeDeviceClaimInput) SetTags(v map[string]*string) *FinalizeDeviceClaimInput {
	s.Tags = v
	return s
}

type FinalizeDeviceClaimOutput struct {
	_ struct{} `type:"structure"`

	State *string `locationName:"state" type:"string"`
}

// String returns the string representation
func (s FinalizeDeviceClaimOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FinalizeDeviceClaimOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *FinalizeDeviceClaimOutput) SetState(v string) *FinalizeDeviceClaimOutput {
	s.State = &v
	return s
}

type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 403
	Code_ *string `locationName:"code" type:"string"`

	// The 403 error message returned by the web server.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetDeviceMethodsInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceMethodsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceMethodsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceMethodsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceMethodsInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *GetDeviceMethodsInput) SetDeviceId(v string) *GetDeviceMethodsInput {
	s.DeviceId = &v
	return s
}

type GetDeviceMethodsOutput struct {
	_ struct{} `type:"structure"`

	// List of available device APIs.
	DeviceMethods []*DeviceMethod `locationName:"deviceMethods" type:"list"`
}

// String returns the string representation
func (s GetDeviceMethodsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceMethodsOutput) GoString() string {
	return s.String()
}

// SetDeviceMethods sets the DeviceMethods field's value.
func (s *GetDeviceMethodsOutput) SetDeviceMethods(v []*DeviceMethod) *GetDeviceMethodsOutput {
	s.DeviceMethods = v
	return s
}

type InitiateDeviceClaimInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateDeviceClaimInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateDeviceClaimInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateDeviceClaimInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateDeviceClaimInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *InitiateDeviceClaimInput) SetDeviceId(v string) *InitiateDeviceClaimInput {
	s.DeviceId = &v
	return s
}

type InitiateDeviceClaimOutput struct {
	_ struct{} `type:"structure"`

	State *string `locationName:"state" type:"string"`
}

// String returns the string representation
func (s InitiateDeviceClaimOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateDeviceClaimOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *InitiateDeviceClaimOutput) SetState(v string) *InitiateDeviceClaimOutput {
	s.State = &v
	return s
}

type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 500
	Code_ *string `locationName:"code" type:"string"`

	// The 500 error message returned by the web server.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 400
	Code_ *string `locationName:"code" type:"string"`

	// The 400 error message returned by the web server.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvokeDeviceMethodInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`

	// The device method to invoke.
	DeviceMethod *DeviceMethod `locationName:"deviceMethod" type:"structure"`

	// A JSON encoded string containing the device method request parameters.
	DeviceMethodParameters *string `locationName:"deviceMethodParameters" type:"string"`
}

// String returns the string representation
func (s InvokeDeviceMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeDeviceMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeDeviceMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeDeviceMethodInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *InvokeDeviceMethodInput) SetDeviceId(v string) *InvokeDeviceMethodInput {
	s.DeviceId = &v
	return s
}

// SetDeviceMethod sets the DeviceMethod field's value.
func (s *InvokeDeviceMethodInput) SetDeviceMethod(v *DeviceMethod) *InvokeDeviceMethodInput {
	s.DeviceMethod = v
	return s
}

// SetDeviceMethodParameters sets the DeviceMethodParameters field's value.
func (s *InvokeDeviceMethodInput) SetDeviceMethodParameters(v string) *InvokeDeviceMethodInput {
	s.DeviceMethodParameters = &v
	return s
}

type InvokeDeviceMethodOutput struct {
	_ struct{} `type:"structure"`

	// A JSON encoded string containing the device method response.
	DeviceMethodResponse *string `locationName:"deviceMethodResponse" type:"string"`
}

// String returns the string representation
func (s InvokeDeviceMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeDeviceMethodOutput) GoString() string {
	return s.String()
}

// SetDeviceMethodResponse sets the DeviceMethodResponse field's value.
func (s *InvokeDeviceMethodOutput) SetDeviceMethodResponse(v string) *InvokeDeviceMethodOutput {
	s.DeviceMethodResponse = &v
	return s
}

type ListDeviceEventsInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`

	// FromTimeStamp is a required field
	FromTimeStamp *time.Time `location:"querystring" locationName:"fromTimeStamp" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// ToTimeStamp is a required field
	ToTimeStamp *time.Time `location:"querystring" locationName:"toTimeStamp" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ListDeviceEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeviceEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeviceEventsInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.FromTimeStamp == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTimeStamp"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ToTimeStamp == nil {
		invalidParams.Add(request.NewErrParamRequired("ToTimeStamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *ListDeviceEventsInput) SetDeviceId(v string) *ListDeviceEventsInput {
	s.DeviceId = &v
	return s
}

// SetFromTimeStamp sets the FromTimeStamp field's value.
func (s *ListDeviceEventsInput) SetFromTimeStamp(v time.Time) *ListDeviceEventsInput {
	s.FromTimeStamp = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceEventsInput) SetMaxResults(v int64) *ListDeviceEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceEventsInput) SetNextToken(v string) *ListDeviceEventsInput {
	s.NextToken = &v
	return s
}

// SetToTimeStamp sets the ToTimeStamp field's value.
func (s *ListDeviceEventsInput) SetToTimeStamp(v time.Time) *ListDeviceEventsInput {
	s.ToTimeStamp = &v
	return s
}

type ListDeviceEventsOutput struct {
	_ struct{} `type:"structure"`

	Events []*DeviceEvent `locationName:"events" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeviceEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ListDeviceEventsOutput) SetEvents(v []*DeviceEvent) *ListDeviceEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceEventsOutput) SetNextToken(v string) *ListDeviceEventsOutput {
	s.NextToken = &v
	return s
}

type ListDevicesInput struct {
	_ struct{} `type:"structure"`

	DeviceType *string `location:"querystring" locationName:"deviceType" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceType sets the DeviceType field's value.
func (s *ListDevicesInput) SetDeviceType(v string) *ListDevicesInput {
	s.DeviceType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDevicesInput) SetMaxResults(v int64) *ListDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesInput) SetNextToken(v string) *ListDevicesInput {
	s.NextToken = &v
	return s
}

type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// A list of devices.
	Devices []*DeviceDescription `locationName:"devices" type:"list"`

	// The token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *ListDevicesOutput) SetDevices(v []*DeviceDescription) *ListDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesOutput) SetNextToken(v string) *ListDevicesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PreconditionFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 412
	Code_ *string `locationName:"code" type:"string"`

	// An error message explaining the error or its remedy.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s PreconditionFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PreconditionFailedException) GoString() string {
	return s.String()
}

func newErrorPreconditionFailedException(v protocol.ResponseMetadata) error {
	return &PreconditionFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PreconditionFailedException) Code() string {
	return "PreconditionFailedException"
}

// Message returns the exception's message.
func (s *PreconditionFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PreconditionFailedException) OrigErr() error {
	return nil
}

func (s *PreconditionFailedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PreconditionFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PreconditionFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RangeNotSatisfiableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 416
	Code_ *string `locationName:"code" type:"string"`

	// The requested number of results specified by nextToken cannot be satisfied.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s RangeNotSatisfiableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RangeNotSatisfiableException) GoString() string {
	return s.String()
}

func newErrorRangeNotSatisfiableException(v protocol.ResponseMetadata) error {
	return &RangeNotSatisfiableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RangeNotSatisfiableException) Code() string {
	return "RangeNotSatisfiableException"
}

// Message returns the exception's message.
func (s *RangeNotSatisfiableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RangeNotSatisfiableException) OrigErr() error {
	return nil
}

func (s *RangeNotSatisfiableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RangeNotSatisfiableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RangeNotSatisfiableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 409
	Code_ *string `locationName:"code" type:"string"`

	// An error message explaining the error or its remedy.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConflictException) GoString() string {
	return s.String()
}

func newErrorResourceConflictException(v protocol.ResponseMetadata) error {
	return &ResourceConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceConflictException) Code() string {
	return "ResourceConflictException"
}

// Message returns the exception's message.
func (s *ResourceConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceConflictException) OrigErr() error {
	return nil
}

func (s *ResourceConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 404
	Code_ *string `locationName:"code" type:"string"`

	// The requested device could not be found.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UnclaimDeviceInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s UnclaimDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnclaimDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnclaimDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnclaimDeviceInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *UnclaimDeviceInput) SetDeviceId(v string) *UnclaimDeviceInput {
	s.DeviceId = &v
	return s
}

type UnclaimDeviceOutput struct {
	_ struct{} `type:"structure"`

	State *string `locationName:"state" type:"string"`
}

// String returns the string representation
func (s UnclaimDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnclaimDeviceOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *UnclaimDeviceOutput) SetState(v string) *UnclaimDeviceOutput {
	s.State = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDeviceStateInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`

	// If true, the device is enabled. If false, the device is disabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation
func (s UpdateDeviceStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceStateInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *UpdateDeviceStateInput) SetDeviceId(v string) *UpdateDeviceStateInput {
	s.DeviceId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateDeviceStateInput) SetEnabled(v bool) *UpdateDeviceStateInput {
	s.Enabled = &v
	return s
}

type UpdateDeviceStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceStateOutput) GoString() string {
	return s.String()
}
