// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/ads/googleads/v1/services/campaign_experiment_service.proto

package services

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for [CampaignExperimentService.GetCampaignExperiment][google.ads.googleads.v1.services.CampaignExperimentService.GetCampaignExperiment].
type GetCampaignExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the campaign experiment to fetch.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *GetCampaignExperimentRequest) Reset() {
	*x = GetCampaignExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCampaignExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCampaignExperimentRequest) ProtoMessage() {}

func (x *GetCampaignExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCampaignExperimentRequest.ProtoReflect.Descriptor instead.
func (*GetCampaignExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetCampaignExperimentRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [CampaignExperimentService.MutateCampaignExperiments][google.ads.googleads.v1.services.CampaignExperimentService.MutateCampaignExperiments].
type MutateCampaignExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer whose campaign experiments are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual campaign experiments.
	Operations []*CampaignExperimentOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *MutateCampaignExperimentsRequest) Reset() {
	*x = MutateCampaignExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateCampaignExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateCampaignExperimentsRequest) ProtoMessage() {}

func (x *MutateCampaignExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateCampaignExperimentsRequest.ProtoReflect.Descriptor instead.
func (*MutateCampaignExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{1}
}

func (x *MutateCampaignExperimentsRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *MutateCampaignExperimentsRequest) GetOperations() []*CampaignExperimentOperation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *MutateCampaignExperimentsRequest) GetPartialFailure() bool {
	if x != nil {
		return x.PartialFailure
	}
	return false
}

func (x *MutateCampaignExperimentsRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// A single update operation on a campaign experiment.
type CampaignExperimentOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are assignable to Operation:
	//	*CampaignExperimentOperation_Update
	//	*CampaignExperimentOperation_Remove
	Operation isCampaignExperimentOperation_Operation `protobuf_oneof:"operation"`
}

func (x *CampaignExperimentOperation) Reset() {
	*x = CampaignExperimentOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CampaignExperimentOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CampaignExperimentOperation) ProtoMessage() {}

func (x *CampaignExperimentOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CampaignExperimentOperation.ProtoReflect.Descriptor instead.
func (*CampaignExperimentOperation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{2}
}

func (x *CampaignExperimentOperation) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (m *CampaignExperimentOperation) GetOperation() isCampaignExperimentOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *CampaignExperimentOperation) GetUpdate() *resources.CampaignExperiment {
	if x, ok := x.GetOperation().(*CampaignExperimentOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (x *CampaignExperimentOperation) GetRemove() string {
	if x, ok := x.GetOperation().(*CampaignExperimentOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

type isCampaignExperimentOperation_Operation interface {
	isCampaignExperimentOperation_Operation()
}

type CampaignExperimentOperation_Update struct {
	// Update operation: The campaign experiment is expected to have a valid
	// resource name.
	Update *resources.CampaignExperiment `protobuf:"bytes,1,opt,name=update,proto3,oneof"`
}

type CampaignExperimentOperation_Remove struct {
	// Remove operation: The campaign experiment is expected to have a valid
	// resource name, in this format:
	//
	// `customers/{customer_id}/campaignExperiments/{campaign_experiment_id}`
	Remove string `protobuf:"bytes,2,opt,name=remove,proto3,oneof"`
}

func (*CampaignExperimentOperation_Update) isCampaignExperimentOperation_Operation() {}

func (*CampaignExperimentOperation_Remove) isCampaignExperimentOperation_Operation() {}

// Response message for campaign experiment mutate.
type MutateCampaignExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results []*MutateCampaignExperimentResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *MutateCampaignExperimentsResponse) Reset() {
	*x = MutateCampaignExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateCampaignExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateCampaignExperimentsResponse) ProtoMessage() {}

func (x *MutateCampaignExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateCampaignExperimentsResponse.ProtoReflect.Descriptor instead.
func (*MutateCampaignExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{3}
}

func (x *MutateCampaignExperimentsResponse) GetPartialFailureError() *status.Status {
	if x != nil {
		return x.PartialFailureError
	}
	return nil
}

func (x *MutateCampaignExperimentsResponse) GetResults() []*MutateCampaignExperimentResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// The result for the campaign experiment mutate.
type MutateCampaignExperimentResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned for successful operations.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *MutateCampaignExperimentResult) Reset() {
	*x = MutateCampaignExperimentResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateCampaignExperimentResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateCampaignExperimentResult) ProtoMessage() {}

func (x *MutateCampaignExperimentResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateCampaignExperimentResult.ProtoReflect.Descriptor instead.
func (*MutateCampaignExperimentResult) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{4}
}

func (x *MutateCampaignExperimentResult) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [CampaignExperimentService.CreateCampaignExperiment][google.ads.googleads.v1.services.CampaignExperimentService.CreateCampaignExperiment].
type CreateCampaignExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer whose campaign experiment is being created.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The campaign experiment to be created.
	CampaignExperiment *resources.CampaignExperiment `protobuf:"bytes,2,opt,name=campaign_experiment,json=campaignExperiment,proto3" json:"campaign_experiment,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateCampaignExperimentRequest) Reset() {
	*x = CreateCampaignExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCampaignExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCampaignExperimentRequest) ProtoMessage() {}

func (x *CreateCampaignExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCampaignExperimentRequest.ProtoReflect.Descriptor instead.
func (*CreateCampaignExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateCampaignExperimentRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *CreateCampaignExperimentRequest) GetCampaignExperiment() *resources.CampaignExperiment {
	if x != nil {
		return x.CampaignExperiment
	}
	return nil
}

func (x *CreateCampaignExperimentRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message used as metadata returned in Long Running Operations for
// CreateCampaignExperimentRequest
type CreateCampaignExperimentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of campaign experiment created.
	CampaignExperiment string `protobuf:"bytes,1,opt,name=campaign_experiment,json=campaignExperiment,proto3" json:"campaign_experiment,omitempty"`
}

func (x *CreateCampaignExperimentMetadata) Reset() {
	*x = CreateCampaignExperimentMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCampaignExperimentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCampaignExperimentMetadata) ProtoMessage() {}

func (x *CreateCampaignExperimentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCampaignExperimentMetadata.ProtoReflect.Descriptor instead.
func (*CreateCampaignExperimentMetadata) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateCampaignExperimentMetadata) GetCampaignExperiment() string {
	if x != nil {
		return x.CampaignExperiment
	}
	return ""
}

// Request message for [CampaignExperimentService.GraduateCampaignExperiment][google.ads.googleads.v1.services.CampaignExperimentService.GraduateCampaignExperiment].
type GraduateCampaignExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the campaign experiment to graduate.
	CampaignExperiment string `protobuf:"bytes,1,opt,name=campaign_experiment,json=campaignExperiment,proto3" json:"campaign_experiment,omitempty"`
	// Required. Resource name of the budget to attach to the campaign graduated from the
	// experiment.
	CampaignBudget string `protobuf:"bytes,2,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
}

func (x *GraduateCampaignExperimentRequest) Reset() {
	*x = GraduateCampaignExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GraduateCampaignExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GraduateCampaignExperimentRequest) ProtoMessage() {}

func (x *GraduateCampaignExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GraduateCampaignExperimentRequest.ProtoReflect.Descriptor instead.
func (*GraduateCampaignExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{7}
}

func (x *GraduateCampaignExperimentRequest) GetCampaignExperiment() string {
	if x != nil {
		return x.CampaignExperiment
	}
	return ""
}

func (x *GraduateCampaignExperimentRequest) GetCampaignBudget() string {
	if x != nil {
		return x.CampaignBudget
	}
	return ""
}

// Response message for campaign experiment graduate.
type GraduateCampaignExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the campaign from the graduated experiment.
	// This campaign is the same one as CampaignExperiment.experiment_campaign.
	GraduatedCampaign string `protobuf:"bytes,1,opt,name=graduated_campaign,json=graduatedCampaign,proto3" json:"graduated_campaign,omitempty"`
}

func (x *GraduateCampaignExperimentResponse) Reset() {
	*x = GraduateCampaignExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GraduateCampaignExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GraduateCampaignExperimentResponse) ProtoMessage() {}

func (x *GraduateCampaignExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GraduateCampaignExperimentResponse.ProtoReflect.Descriptor instead.
func (*GraduateCampaignExperimentResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{8}
}

func (x *GraduateCampaignExperimentResponse) GetGraduatedCampaign() string {
	if x != nil {
		return x.GraduatedCampaign
	}
	return ""
}

// Request message for [CampaignExperimentService.PromoteCampaignExperiment][google.ads.googleads.v1.services.CampaignExperimentService.PromoteCampaignExperiment].
type PromoteCampaignExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the campaign experiment to promote.
	CampaignExperiment string `protobuf:"bytes,1,opt,name=campaign_experiment,json=campaignExperiment,proto3" json:"campaign_experiment,omitempty"`
}

func (x *PromoteCampaignExperimentRequest) Reset() {
	*x = PromoteCampaignExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PromoteCampaignExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromoteCampaignExperimentRequest) ProtoMessage() {}

func (x *PromoteCampaignExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromoteCampaignExperimentRequest.ProtoReflect.Descriptor instead.
func (*PromoteCampaignExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{9}
}

func (x *PromoteCampaignExperimentRequest) GetCampaignExperiment() string {
	if x != nil {
		return x.CampaignExperiment
	}
	return ""
}

// Request message for [CampaignExperimentService.EndCampaignExperiment][google.ads.googleads.v1.services.CampaignExperimentService.EndCampaignExperiment].
type EndCampaignExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the campaign experiment to end.
	CampaignExperiment string `protobuf:"bytes,1,opt,name=campaign_experiment,json=campaignExperiment,proto3" json:"campaign_experiment,omitempty"`
}

func (x *EndCampaignExperimentRequest) Reset() {
	*x = EndCampaignExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndCampaignExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndCampaignExperimentRequest) ProtoMessage() {}

func (x *EndCampaignExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndCampaignExperimentRequest.ProtoReflect.Descriptor instead.
func (*EndCampaignExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{10}
}

func (x *EndCampaignExperimentRequest) GetCampaignExperiment() string {
	if x != nil {
		return x.CampaignExperiment
	}
	return ""
}

// Request message for
// [CampaignExperimentService.ListCampaignExperimentAsyncErrors][google.ads.googleads.v1.services.CampaignExperimentService.ListCampaignExperimentAsyncErrors].
type ListCampaignExperimentAsyncErrorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the campaign experiment from which to retrieve the async
	// errors.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request
	// the next page of results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When a page request is too large, the server may decide to
	// further limit the number of returned resources.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListCampaignExperimentAsyncErrorsRequest) Reset() {
	*x = ListCampaignExperimentAsyncErrorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCampaignExperimentAsyncErrorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCampaignExperimentAsyncErrorsRequest) ProtoMessage() {}

func (x *ListCampaignExperimentAsyncErrorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCampaignExperimentAsyncErrorsRequest.ProtoReflect.Descriptor instead.
func (*ListCampaignExperimentAsyncErrorsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListCampaignExperimentAsyncErrorsRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *ListCampaignExperimentAsyncErrorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCampaignExperimentAsyncErrorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for
// [CampaignExperimentService.ListCampaignExperimentAsyncErrors][google.ads.googleads.v1.services.CampaignExperimentService.ListCampaignExperimentAsyncErrors].
type ListCampaignExperimentAsyncErrorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the errors when performing the asynchronous operation.
	Errors []*status.Status `protobuf:"bytes,1,rep,name=errors,proto3" json:"errors,omitempty"`
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCampaignExperimentAsyncErrorsResponse) Reset() {
	*x = ListCampaignExperimentAsyncErrorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCampaignExperimentAsyncErrorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCampaignExperimentAsyncErrorsResponse) ProtoMessage() {}

func (x *ListCampaignExperimentAsyncErrorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCampaignExperimentAsyncErrorsResponse.ProtoReflect.Descriptor instead.
func (*ListCampaignExperimentAsyncErrorsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListCampaignExperimentAsyncErrorsResponse) GetErrors() []*status.Status {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *ListCampaignExperimentAsyncErrorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_ads_googleads_v1_services_campaign_experiment_service_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDesc = []byte{
	0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x78, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xfa, 0x01,
	0x0a, 0x20, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x62, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xd2, 0x01, 0x0a, 0x1b, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4f, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xc7, 0x01, 0x0a, 0x21, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x15, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x13, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61,
	0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x5a, 0x0a,
	0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x45, 0x0a, 0x1e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0xd9, 0x01, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x6b, 0x0a, 0x13, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x12, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x53, 0x0a, 0x20,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x2f, 0x0a, 0x13, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x87, 0x01, 0x0a, 0x21, 0x47, 0x72, 0x61, 0x64, 0x75, 0x61, 0x74, 0x65, 0x43, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x13, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a,
	0x0f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x63, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x22, 0x53, 0x0a, 0x22, 0x47,
	0x72, 0x61, 0x64, 0x75, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2d, 0x0a, 0x12, 0x67, 0x72, 0x61, 0x64, 0x75, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x67,
	0x72, 0x61, 0x64, 0x75, 0x61, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x22, 0x58, 0x0a, 0x20, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x13, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x54, 0x0a, 0x1c, 0x45, 0x6e,
	0x64, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x13, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0xc0, 0x01, 0x0a, 0x28, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x79, 0x6e, 0x63,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x22, 0x7f, 0x0a, 0x29, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x79,
	0x6e, 0x63, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2a, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x8d, 0x0f, 0x0a, 0x19, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xdd, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xc1, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xc2, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0xca, 0x41, 0x5a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x82, 0x02, 0x0a, 0x19, 0x4d, 0x75, 0x74, 0x61, 0x74,
	0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5c, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x3d, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x16, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x2c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x9e, 0x02, 0x0a, 0x1a,
	0x47, 0x72, 0x61, 0x64, 0x75, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x72,
	0x61, 0x64, 0x75, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x47, 0x72, 0x61, 0x64, 0x75, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x75, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x22, 0x44, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x72, 0x61, 0x64, 0x75,
	0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x23, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x96, 0x02, 0x0a,
	0x19, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x50, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x95, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x13, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0xca, 0x41, 0x2e, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0xd1, 0x01, 0x0a, 0x15, 0x45, 0x6e, 0x64, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x45, 0x6e, 0x64, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x22,
	0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x6e, 0x64,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x13, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x9b, 0x02, 0x0a, 0x21, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47,
	0x12, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x79, 0x6e,
	0x63, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0xda, 0x41, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x1b, 0xca, 0x41, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x85, 0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x42, 0x1e, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa,
	0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x31, 0x5c, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a,
	0x56, 0x31, 0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescData = file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDesc
)

func file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescData)
	})
	return file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDescData
}

var file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_ads_googleads_v1_services_campaign_experiment_service_proto_goTypes = []interface{}{
	(*GetCampaignExperimentRequest)(nil),              // 0: google.ads.googleads.v1.services.GetCampaignExperimentRequest
	(*MutateCampaignExperimentsRequest)(nil),          // 1: google.ads.googleads.v1.services.MutateCampaignExperimentsRequest
	(*CampaignExperimentOperation)(nil),               // 2: google.ads.googleads.v1.services.CampaignExperimentOperation
	(*MutateCampaignExperimentsResponse)(nil),         // 3: google.ads.googleads.v1.services.MutateCampaignExperimentsResponse
	(*MutateCampaignExperimentResult)(nil),            // 4: google.ads.googleads.v1.services.MutateCampaignExperimentResult
	(*CreateCampaignExperimentRequest)(nil),           // 5: google.ads.googleads.v1.services.CreateCampaignExperimentRequest
	(*CreateCampaignExperimentMetadata)(nil),          // 6: google.ads.googleads.v1.services.CreateCampaignExperimentMetadata
	(*GraduateCampaignExperimentRequest)(nil),         // 7: google.ads.googleads.v1.services.GraduateCampaignExperimentRequest
	(*GraduateCampaignExperimentResponse)(nil),        // 8: google.ads.googleads.v1.services.GraduateCampaignExperimentResponse
	(*PromoteCampaignExperimentRequest)(nil),          // 9: google.ads.googleads.v1.services.PromoteCampaignExperimentRequest
	(*EndCampaignExperimentRequest)(nil),              // 10: google.ads.googleads.v1.services.EndCampaignExperimentRequest
	(*ListCampaignExperimentAsyncErrorsRequest)(nil),  // 11: google.ads.googleads.v1.services.ListCampaignExperimentAsyncErrorsRequest
	(*ListCampaignExperimentAsyncErrorsResponse)(nil), // 12: google.ads.googleads.v1.services.ListCampaignExperimentAsyncErrorsResponse
	(*field_mask.FieldMask)(nil),                      // 13: google.protobuf.FieldMask
	(*resources.CampaignExperiment)(nil),              // 14: google.ads.googleads.v1.resources.CampaignExperiment
	(*status.Status)(nil),                             // 15: google.rpc.Status
	(*longrunning.Operation)(nil),                     // 16: google.longrunning.Operation
	(*empty.Empty)(nil),                               // 17: google.protobuf.Empty
}
var file_google_ads_googleads_v1_services_campaign_experiment_service_proto_depIdxs = []int32{
	2,  // 0: google.ads.googleads.v1.services.MutateCampaignExperimentsRequest.operations:type_name -> google.ads.googleads.v1.services.CampaignExperimentOperation
	13, // 1: google.ads.googleads.v1.services.CampaignExperimentOperation.update_mask:type_name -> google.protobuf.FieldMask
	14, // 2: google.ads.googleads.v1.services.CampaignExperimentOperation.update:type_name -> google.ads.googleads.v1.resources.CampaignExperiment
	15, // 3: google.ads.googleads.v1.services.MutateCampaignExperimentsResponse.partial_failure_error:type_name -> google.rpc.Status
	4,  // 4: google.ads.googleads.v1.services.MutateCampaignExperimentsResponse.results:type_name -> google.ads.googleads.v1.services.MutateCampaignExperimentResult
	14, // 5: google.ads.googleads.v1.services.CreateCampaignExperimentRequest.campaign_experiment:type_name -> google.ads.googleads.v1.resources.CampaignExperiment
	15, // 6: google.ads.googleads.v1.services.ListCampaignExperimentAsyncErrorsResponse.errors:type_name -> google.rpc.Status
	0,  // 7: google.ads.googleads.v1.services.CampaignExperimentService.GetCampaignExperiment:input_type -> google.ads.googleads.v1.services.GetCampaignExperimentRequest
	5,  // 8: google.ads.googleads.v1.services.CampaignExperimentService.CreateCampaignExperiment:input_type -> google.ads.googleads.v1.services.CreateCampaignExperimentRequest
	1,  // 9: google.ads.googleads.v1.services.CampaignExperimentService.MutateCampaignExperiments:input_type -> google.ads.googleads.v1.services.MutateCampaignExperimentsRequest
	7,  // 10: google.ads.googleads.v1.services.CampaignExperimentService.GraduateCampaignExperiment:input_type -> google.ads.googleads.v1.services.GraduateCampaignExperimentRequest
	9,  // 11: google.ads.googleads.v1.services.CampaignExperimentService.PromoteCampaignExperiment:input_type -> google.ads.googleads.v1.services.PromoteCampaignExperimentRequest
	10, // 12: google.ads.googleads.v1.services.CampaignExperimentService.EndCampaignExperiment:input_type -> google.ads.googleads.v1.services.EndCampaignExperimentRequest
	11, // 13: google.ads.googleads.v1.services.CampaignExperimentService.ListCampaignExperimentAsyncErrors:input_type -> google.ads.googleads.v1.services.ListCampaignExperimentAsyncErrorsRequest
	14, // 14: google.ads.googleads.v1.services.CampaignExperimentService.GetCampaignExperiment:output_type -> google.ads.googleads.v1.resources.CampaignExperiment
	16, // 15: google.ads.googleads.v1.services.CampaignExperimentService.CreateCampaignExperiment:output_type -> google.longrunning.Operation
	3,  // 16: google.ads.googleads.v1.services.CampaignExperimentService.MutateCampaignExperiments:output_type -> google.ads.googleads.v1.services.MutateCampaignExperimentsResponse
	8,  // 17: google.ads.googleads.v1.services.CampaignExperimentService.GraduateCampaignExperiment:output_type -> google.ads.googleads.v1.services.GraduateCampaignExperimentResponse
	16, // 18: google.ads.googleads.v1.services.CampaignExperimentService.PromoteCampaignExperiment:output_type -> google.longrunning.Operation
	17, // 19: google.ads.googleads.v1.services.CampaignExperimentService.EndCampaignExperiment:output_type -> google.protobuf.Empty
	12, // 20: google.ads.googleads.v1.services.CampaignExperimentService.ListCampaignExperimentAsyncErrors:output_type -> google.ads.googleads.v1.services.ListCampaignExperimentAsyncErrorsResponse
	14, // [14:21] is the sub-list for method output_type
	7,  // [7:14] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v1_services_campaign_experiment_service_proto_init() }
func file_google_ads_googleads_v1_services_campaign_experiment_service_proto_init() {
	if File_google_ads_googleads_v1_services_campaign_experiment_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCampaignExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateCampaignExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CampaignExperimentOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateCampaignExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateCampaignExperimentResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCampaignExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCampaignExperimentMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GraduateCampaignExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GraduateCampaignExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PromoteCampaignExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndCampaignExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCampaignExperimentAsyncErrorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCampaignExperimentAsyncErrorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*CampaignExperimentOperation_Update)(nil),
		(*CampaignExperimentOperation_Remove)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ads_googleads_v1_services_campaign_experiment_service_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v1_services_campaign_experiment_service_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v1_services_campaign_experiment_service_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v1_services_campaign_experiment_service_proto = out.File
	file_google_ads_googleads_v1_services_campaign_experiment_service_proto_rawDesc = nil
	file_google_ads_googleads_v1_services_campaign_experiment_service_proto_goTypes = nil
	file_google_ads_googleads_v1_services_campaign_experiment_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CampaignExperimentServiceClient is the client API for CampaignExperimentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CampaignExperimentServiceClient interface {
	// Returns the requested campaign experiment in full detail.
	GetCampaignExperiment(ctx context.Context, in *GetCampaignExperimentRequest, opts ...grpc.CallOption) (*resources.CampaignExperiment, error)
	// Creates a campaign experiment based on a campaign draft. The draft campaign
	// will be forked into a real campaign (called the experiment campaign) that
	// will begin serving ads if successfully created.
	//
	// The campaign experiment is created immediately with status INITIALIZING.
	// This method return a long running operation that tracks the forking of the
	// draft campaign. If the forking fails, a list of errors can be retrieved
	// using the ListCampaignExperimentAsyncErrors method. The operation's
	// metadata will be a StringValue containing the resource name of the created
	// campaign experiment.
	CreateCampaignExperiment(ctx context.Context, in *CreateCampaignExperimentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates campaign experiments. Operation statuses are returned.
	MutateCampaignExperiments(ctx context.Context, in *MutateCampaignExperimentsRequest, opts ...grpc.CallOption) (*MutateCampaignExperimentsResponse, error)
	// Graduates a campaign experiment to a full campaign. The base and experiment
	// campaigns will start running independently with their own budgets.
	GraduateCampaignExperiment(ctx context.Context, in *GraduateCampaignExperimentRequest, opts ...grpc.CallOption) (*GraduateCampaignExperimentResponse, error)
	// Promotes the changes in a experiment campaign back to the base campaign.
	//
	// The campaign experiment is updated immediately with status PROMOTING.
	// This method return a long running operation that tracks the promoting of
	// the experiment campaign. If the promoting fails, a list of errors can be
	// retrieved using the ListCampaignExperimentAsyncErrors method.
	PromoteCampaignExperiment(ctx context.Context, in *PromoteCampaignExperimentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Immediately ends a campaign experiment, changing the experiment's scheduled
	// end date and without waiting for end of day. End date is updated to be the
	// time of the request.
	EndCampaignExperiment(ctx context.Context, in *EndCampaignExperimentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns all errors that occurred during CampaignExperiment create or
	// promote (whichever occurred last).
	// Supports standard list paging.
	ListCampaignExperimentAsyncErrors(ctx context.Context, in *ListCampaignExperimentAsyncErrorsRequest, opts ...grpc.CallOption) (*ListCampaignExperimentAsyncErrorsResponse, error)
}

type campaignExperimentServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCampaignExperimentServiceClient(cc grpc.ClientConnInterface) CampaignExperimentServiceClient {
	return &campaignExperimentServiceClient{cc}
}

func (c *campaignExperimentServiceClient) GetCampaignExperiment(ctx context.Context, in *GetCampaignExperimentRequest, opts ...grpc.CallOption) (*resources.CampaignExperiment, error) {
	out := new(resources.CampaignExperiment)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CampaignExperimentService/GetCampaignExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *campaignExperimentServiceClient) CreateCampaignExperiment(ctx context.Context, in *CreateCampaignExperimentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CampaignExperimentService/CreateCampaignExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *campaignExperimentServiceClient) MutateCampaignExperiments(ctx context.Context, in *MutateCampaignExperimentsRequest, opts ...grpc.CallOption) (*MutateCampaignExperimentsResponse, error) {
	out := new(MutateCampaignExperimentsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CampaignExperimentService/MutateCampaignExperiments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *campaignExperimentServiceClient) GraduateCampaignExperiment(ctx context.Context, in *GraduateCampaignExperimentRequest, opts ...grpc.CallOption) (*GraduateCampaignExperimentResponse, error) {
	out := new(GraduateCampaignExperimentResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CampaignExperimentService/GraduateCampaignExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *campaignExperimentServiceClient) PromoteCampaignExperiment(ctx context.Context, in *PromoteCampaignExperimentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CampaignExperimentService/PromoteCampaignExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *campaignExperimentServiceClient) EndCampaignExperiment(ctx context.Context, in *EndCampaignExperimentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CampaignExperimentService/EndCampaignExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *campaignExperimentServiceClient) ListCampaignExperimentAsyncErrors(ctx context.Context, in *ListCampaignExperimentAsyncErrorsRequest, opts ...grpc.CallOption) (*ListCampaignExperimentAsyncErrorsResponse, error) {
	out := new(ListCampaignExperimentAsyncErrorsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CampaignExperimentService/ListCampaignExperimentAsyncErrors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CampaignExperimentServiceServer is the server API for CampaignExperimentService service.
type CampaignExperimentServiceServer interface {
	// Returns the requested campaign experiment in full detail.
	GetCampaignExperiment(context.Context, *GetCampaignExperimentRequest) (*resources.CampaignExperiment, error)
	// Creates a campaign experiment based on a campaign draft. The draft campaign
	// will be forked into a real campaign (called the experiment campaign) that
	// will begin serving ads if successfully created.
	//
	// The campaign experiment is created immediately with status INITIALIZING.
	// This method return a long running operation that tracks the forking of the
	// draft campaign. If the forking fails, a list of errors can be retrieved
	// using the ListCampaignExperimentAsyncErrors method. The operation's
	// metadata will be a StringValue containing the resource name of the created
	// campaign experiment.
	CreateCampaignExperiment(context.Context, *CreateCampaignExperimentRequest) (*longrunning.Operation, error)
	// Updates campaign experiments. Operation statuses are returned.
	MutateCampaignExperiments(context.Context, *MutateCampaignExperimentsRequest) (*MutateCampaignExperimentsResponse, error)
	// Graduates a campaign experiment to a full campaign. The base and experiment
	// campaigns will start running independently with their own budgets.
	GraduateCampaignExperiment(context.Context, *GraduateCampaignExperimentRequest) (*GraduateCampaignExperimentResponse, error)
	// Promotes the changes in a experiment campaign back to the base campaign.
	//
	// The campaign experiment is updated immediately with status PROMOTING.
	// This method return a long running operation that tracks the promoting of
	// the experiment campaign. If the promoting fails, a list of errors can be
	// retrieved using the ListCampaignExperimentAsyncErrors method.
	PromoteCampaignExperiment(context.Context, *PromoteCampaignExperimentRequest) (*longrunning.Operation, error)
	// Immediately ends a campaign experiment, changing the experiment's scheduled
	// end date and without waiting for end of day. End date is updated to be the
	// time of the request.
	EndCampaignExperiment(context.Context, *EndCampaignExperimentRequest) (*empty.Empty, error)
	// Returns all errors that occurred during CampaignExperiment create or
	// promote (whichever occurred last).
	// Supports standard list paging.
	ListCampaignExperimentAsyncErrors(context.Context, *ListCampaignExperimentAsyncErrorsRequest) (*ListCampaignExperimentAsyncErrorsResponse, error)
}

// UnimplementedCampaignExperimentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCampaignExperimentServiceServer struct {
}

func (*UnimplementedCampaignExperimentServiceServer) GetCampaignExperiment(context.Context, *GetCampaignExperimentRequest) (*resources.CampaignExperiment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCampaignExperiment not implemented")
}
func (*UnimplementedCampaignExperimentServiceServer) CreateCampaignExperiment(context.Context, *CreateCampaignExperimentRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCampaignExperiment not implemented")
}
func (*UnimplementedCampaignExperimentServiceServer) MutateCampaignExperiments(context.Context, *MutateCampaignExperimentsRequest) (*MutateCampaignExperimentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateCampaignExperiments not implemented")
}
func (*UnimplementedCampaignExperimentServiceServer) GraduateCampaignExperiment(context.Context, *GraduateCampaignExperimentRequest) (*GraduateCampaignExperimentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GraduateCampaignExperiment not implemented")
}
func (*UnimplementedCampaignExperimentServiceServer) PromoteCampaignExperiment(context.Context, *PromoteCampaignExperimentRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PromoteCampaignExperiment not implemented")
}
func (*UnimplementedCampaignExperimentServiceServer) EndCampaignExperiment(context.Context, *EndCampaignExperimentRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method EndCampaignExperiment not implemented")
}
func (*UnimplementedCampaignExperimentServiceServer) ListCampaignExperimentAsyncErrors(context.Context, *ListCampaignExperimentAsyncErrorsRequest) (*ListCampaignExperimentAsyncErrorsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCampaignExperimentAsyncErrors not implemented")
}

func RegisterCampaignExperimentServiceServer(s *grpc.Server, srv CampaignExperimentServiceServer) {
	s.RegisterService(&_CampaignExperimentService_serviceDesc, srv)
}

func _CampaignExperimentService_GetCampaignExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCampaignExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CampaignExperimentServiceServer).GetCampaignExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CampaignExperimentService/GetCampaignExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CampaignExperimentServiceServer).GetCampaignExperiment(ctx, req.(*GetCampaignExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CampaignExperimentService_CreateCampaignExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCampaignExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CampaignExperimentServiceServer).CreateCampaignExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CampaignExperimentService/CreateCampaignExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CampaignExperimentServiceServer).CreateCampaignExperiment(ctx, req.(*CreateCampaignExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CampaignExperimentService_MutateCampaignExperiments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCampaignExperimentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CampaignExperimentServiceServer).MutateCampaignExperiments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CampaignExperimentService/MutateCampaignExperiments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CampaignExperimentServiceServer).MutateCampaignExperiments(ctx, req.(*MutateCampaignExperimentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CampaignExperimentService_GraduateCampaignExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GraduateCampaignExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CampaignExperimentServiceServer).GraduateCampaignExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CampaignExperimentService/GraduateCampaignExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CampaignExperimentServiceServer).GraduateCampaignExperiment(ctx, req.(*GraduateCampaignExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CampaignExperimentService_PromoteCampaignExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PromoteCampaignExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CampaignExperimentServiceServer).PromoteCampaignExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CampaignExperimentService/PromoteCampaignExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CampaignExperimentServiceServer).PromoteCampaignExperiment(ctx, req.(*PromoteCampaignExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CampaignExperimentService_EndCampaignExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EndCampaignExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CampaignExperimentServiceServer).EndCampaignExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CampaignExperimentService/EndCampaignExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CampaignExperimentServiceServer).EndCampaignExperiment(ctx, req.(*EndCampaignExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CampaignExperimentService_ListCampaignExperimentAsyncErrors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCampaignExperimentAsyncErrorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CampaignExperimentServiceServer).ListCampaignExperimentAsyncErrors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CampaignExperimentService/ListCampaignExperimentAsyncErrors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CampaignExperimentServiceServer).ListCampaignExperimentAsyncErrors(ctx, req.(*ListCampaignExperimentAsyncErrorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CampaignExperimentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.CampaignExperimentService",
	HandlerType: (*CampaignExperimentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCampaignExperiment",
			Handler:    _CampaignExperimentService_GetCampaignExperiment_Handler,
		},
		{
			MethodName: "CreateCampaignExperiment",
			Handler:    _CampaignExperimentService_CreateCampaignExperiment_Handler,
		},
		{
			MethodName: "MutateCampaignExperiments",
			Handler:    _CampaignExperimentService_MutateCampaignExperiments_Handler,
		},
		{
			MethodName: "GraduateCampaignExperiment",
			Handler:    _CampaignExperimentService_GraduateCampaignExperiment_Handler,
		},
		{
			MethodName: "PromoteCampaignExperiment",
			Handler:    _CampaignExperimentService_PromoteCampaignExperiment_Handler,
		},
		{
			MethodName: "EndCampaignExperiment",
			Handler:    _CampaignExperimentService_EndCampaignExperiment_Handler,
		},
		{
			MethodName: "ListCampaignExperimentAsyncErrors",
			Handler:    _CampaignExperimentService_ListCampaignExperimentAsyncErrors_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/campaign_experiment_service.proto",
}
