// Code generated by main. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	scheme "github.com/openshift/hive/pkg/client/clientset-generated/clientset/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SyncSetInstancesGetter has a method to return a SyncSetInstanceInterface.
// A group's client should implement this interface.
type SyncSetInstancesGetter interface {
	SyncSetInstances(namespace string) SyncSetInstanceInterface
}

// SyncSetInstanceInterface has methods to work with SyncSetInstance resources.
type SyncSetInstanceInterface interface {
	Create(*v1.SyncSetInstance) (*v1.SyncSetInstance, error)
	Update(*v1.SyncSetInstance) (*v1.SyncSetInstance, error)
	UpdateStatus(*v1.SyncSetInstance) (*v1.SyncSetInstance, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.SyncSetInstance, error)
	List(opts metav1.ListOptions) (*v1.SyncSetInstanceList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SyncSetInstance, err error)
	SyncSetInstanceExpansion
}

// syncSetInstances implements SyncSetInstanceInterface
type syncSetInstances struct {
	client rest.Interface
	ns     string
}

// newSyncSetInstances returns a SyncSetInstances
func newSyncSetInstances(c *HiveV1Client, namespace string) *syncSetInstances {
	return &syncSetInstances{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the syncSetInstance, and returns the corresponding syncSetInstance object, and an error if there is any.
func (c *syncSetInstances) Get(name string, options metav1.GetOptions) (result *v1.SyncSetInstance, err error) {
	result = &v1.SyncSetInstance{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("syncsetinstances").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SyncSetInstances that match those selectors.
func (c *syncSetInstances) List(opts metav1.ListOptions) (result *v1.SyncSetInstanceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SyncSetInstanceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("syncsetinstances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested syncSetInstances.
func (c *syncSetInstances) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("syncsetinstances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a syncSetInstance and creates it.  Returns the server's representation of the syncSetInstance, and an error, if there is any.
func (c *syncSetInstances) Create(syncSetInstance *v1.SyncSetInstance) (result *v1.SyncSetInstance, err error) {
	result = &v1.SyncSetInstance{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("syncsetinstances").
		Body(syncSetInstance).
		Do().
		Into(result)
	return
}

// Update takes the representation of a syncSetInstance and updates it. Returns the server's representation of the syncSetInstance, and an error, if there is any.
func (c *syncSetInstances) Update(syncSetInstance *v1.SyncSetInstance) (result *v1.SyncSetInstance, err error) {
	result = &v1.SyncSetInstance{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("syncsetinstances").
		Name(syncSetInstance.Name).
		Body(syncSetInstance).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *syncSetInstances) UpdateStatus(syncSetInstance *v1.SyncSetInstance) (result *v1.SyncSetInstance, err error) {
	result = &v1.SyncSetInstance{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("syncsetinstances").
		Name(syncSetInstance.Name).
		SubResource("status").
		Body(syncSetInstance).
		Do().
		Into(result)
	return
}

// Delete takes name of the syncSetInstance and deletes it. Returns an error if one occurs.
func (c *syncSetInstances) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("syncsetinstances").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *syncSetInstances) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("syncsetinstances").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched syncSetInstance.
func (c *syncSetInstances) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SyncSetInstance, err error) {
	result = &v1.SyncSetInstance{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("syncsetinstances").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
