## helm search

Search for a keyword in charts

### Synopsis


Search reads through all of the repositories configured on the system, and
looks for matches.

It will display the latest stable versions of the charts found. If you
specify the --devel flag, the output will include pre-release versions.
If you want to search using a version constraint, use --version.

Examples:

    # Search for stable release versions matching the keyword "nginx"
    helm search nginx

    # Search for release versions matching the keyword "nginx", including pre-release versions
    helm search nginx --devel

    # Search for the latest stable release for nginx-ingress with a major version of 1
    helm search nginx-ingress --version ^1.0.0

Repositories are managed with 'helm repo' commands.

To look for charts with a particular name (such as stable/mysql), try
searching using vertical tabs (\v). Vertical tabs are used as the delimiter
between search fields. For example:

    helm search --regexp '\vstable/mysql\v'

To search for charts using common keywords (such as "database" or
"key-value store"), use

    helm search database

or

    helm search key-value store


```
helm search [keyword] [flags]
```

### Options

```
      --col-width uint   Specifies the max column width of output (default 60)
      --devel            use development versions (alpha, beta, and release candidate releases), too. Equivalent to version '>0.0.0-0'. If --version is set, this is ignored
  -h, --help             help for search
  -o, --output string    Prints the output in the specified format. Allowed values: table, json, yaml (default "table")
  -r, --regexp           Use regular expressions for searching
  -v, --version string   Search using semantic versioning constraints
  -l, --versions         Show the long listing, with each version of each chart on its own line
```

### Options inherited from parent commands

```
      --debug                           Enable verbose output
      --home string                     Location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     Address of Tiller. Overrides $HELM_HOST
      --kube-context string             Name of the kubeconfig context to use
      --kubeconfig string               Absolute path of the kubeconfig file to be used
      --tiller-connection-timeout int   The duration (in seconds) Helm will wait to establish a connection to Tiller (default 300)
      --tiller-namespace string         Namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.

###### Auto generated by spf13/cobra on 30-Oct-2019
