// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1alpha1"
	scheme "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/clientset_generated/clientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ResourceViewsGetter has a method to return a ResourceViewInterface.
// A group's client should implement this interface.
type ResourceViewsGetter interface {
	ResourceViews(namespace string) ResourceViewInterface
}

// ResourceViewInterface has methods to work with ResourceView resources.
type ResourceViewInterface interface {
	Create(*v1alpha1.ResourceView) (*v1alpha1.ResourceView, error)
	Update(*v1alpha1.ResourceView) (*v1alpha1.ResourceView, error)
	UpdateStatus(*v1alpha1.ResourceView) (*v1alpha1.ResourceView, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.ResourceView, error)
	List(opts v1.ListOptions) (*v1alpha1.ResourceViewList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ResourceView, err error)
	ResourceViewExpansion
}

// resourceViews implements ResourceViewInterface
type resourceViews struct {
	client rest.Interface
	ns     string
}

// newResourceViews returns a ResourceViews
func newResourceViews(c *McmV1alpha1Client, namespace string) *resourceViews {
	return &resourceViews{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the resourceView, and returns the corresponding resourceView object, and an error if there is any.
func (c *resourceViews) Get(name string, options v1.GetOptions) (result *v1alpha1.ResourceView, err error) {
	result = &v1alpha1.ResourceView{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("resourceviews").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ResourceViews that match those selectors.
func (c *resourceViews) List(opts v1.ListOptions) (result *v1alpha1.ResourceViewList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ResourceViewList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("resourceviews").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested resourceViews.
func (c *resourceViews) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("resourceviews").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a resourceView and creates it.  Returns the server's representation of the resourceView, and an error, if there is any.
func (c *resourceViews) Create(resourceView *v1alpha1.ResourceView) (result *v1alpha1.ResourceView, err error) {
	result = &v1alpha1.ResourceView{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("resourceviews").
		Body(resourceView).
		Do().
		Into(result)
	return
}

// Update takes the representation of a resourceView and updates it. Returns the server's representation of the resourceView, and an error, if there is any.
func (c *resourceViews) Update(resourceView *v1alpha1.ResourceView) (result *v1alpha1.ResourceView, err error) {
	result = &v1alpha1.ResourceView{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("resourceviews").
		Name(resourceView.Name).
		Body(resourceView).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *resourceViews) UpdateStatus(resourceView *v1alpha1.ResourceView) (result *v1alpha1.ResourceView, err error) {
	result = &v1alpha1.ResourceView{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("resourceviews").
		Name(resourceView.Name).
		SubResource("status").
		Body(resourceView).
		Do().
		Into(result)
	return
}

// Delete takes name of the resourceView and deletes it. Returns an error if one occurs.
func (c *resourceViews) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("resourceviews").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *resourceViews) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("resourceviews").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched resourceView.
func (c *resourceViews) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ResourceView, err error) {
	result = &v1alpha1.ResourceView{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("resourceviews").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
