// +build !ignore_autogenerated

/*
Copyright 2016 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by deepcopy-gen. Do not edit it manually!

package conversion

import (
	forked_reflect "k8s.io/kubernetes/third_party/forked/reflect"
	reflect "reflect"
)

func DeepCopy_conversion_Cloner(in Cloner, out *Cloner, c *Cloner) error {
	if in.deepCopyFuncs != nil {
		in, out := in.deepCopyFuncs, &out.deepCopyFuncs
		*out = make(map[reflect.Type]reflect.Value)
		for range in {
			// FIXME: Copying unassignable keys unsupported reflect.Type
		}
	} else {
		out.deepCopyFuncs = nil
	}
	if in.generatedDeepCopyFuncs != nil {
		in, out := in.generatedDeepCopyFuncs, &out.generatedDeepCopyFuncs
		*out = make(map[reflect.Type]reflect.Value)
		for range in {
			// FIXME: Copying unassignable keys unsupported reflect.Type
		}
	} else {
		out.generatedDeepCopyFuncs = nil
	}
	return nil
}

func DeepCopy_conversion_ConversionFuncs(in ConversionFuncs, out *ConversionFuncs, c *Cloner) error {
	if in.fns != nil {
		in, out := in.fns, &out.fns
		*out = make(map[typePair]reflect.Value)
		for range in {
			// FIXME: Copying unassignable keys unsupported typePair
		}
	} else {
		out.fns = nil
	}
	return nil
}

func DeepCopy_conversion_Converter(in Converter, out *Converter, c *Cloner) error {
	if err := DeepCopy_conversion_ConversionFuncs(in.conversionFuncs, &out.conversionFuncs, c); err != nil {
		return err
	}
	if err := DeepCopy_conversion_ConversionFuncs(in.generatedConversionFuncs, &out.generatedConversionFuncs, c); err != nil {
		return err
	}
	if in.ignoredConversions != nil {
		in, out := in.ignoredConversions, &out.ignoredConversions
		*out = make(map[typePair]struct{})
		for range in {
			// FIXME: Copying unassignable keys unsupported typePair
		}
	} else {
		out.ignoredConversions = nil
	}
	if in.structFieldDests != nil {
		in, out := in.structFieldDests, &out.structFieldDests
		*out = make(map[typeNamePair][]typeNamePair)
		for range in {
			// FIXME: Copying unassignable keys unsupported typeNamePair
		}
	} else {
		out.structFieldDests = nil
	}
	if in.structFieldSources != nil {
		in, out := in.structFieldSources, &out.structFieldSources
		*out = make(map[typeNamePair][]typeNamePair)
		for range in {
			// FIXME: Copying unassignable keys unsupported typeNamePair
		}
	} else {
		out.structFieldSources = nil
	}
	if in.defaultingFuncs != nil {
		in, out := in.defaultingFuncs, &out.defaultingFuncs
		*out = make(map[reflect.Type]reflect.Value)
		for range in {
			// FIXME: Copying unassignable keys unsupported reflect.Type
		}
	} else {
		out.defaultingFuncs = nil
	}
	if in.defaultingInterfaces != nil {
		in, out := in.defaultingInterfaces, &out.defaultingInterfaces
		*out = make(map[reflect.Type]interface{})
		for range in {
			// FIXME: Copying unassignable keys unsupported reflect.Type
		}
	} else {
		out.defaultingInterfaces = nil
	}
	if in.inputFieldMappingFuncs != nil {
		in, out := in.inputFieldMappingFuncs, &out.inputFieldMappingFuncs
		*out = make(map[reflect.Type]FieldMappingFunc)
		for range in {
			// FIXME: Copying unassignable keys unsupported reflect.Type
		}
	} else {
		out.inputFieldMappingFuncs = nil
	}
	if in.inputDefaultFlags != nil {
		in, out := in.inputDefaultFlags, &out.inputDefaultFlags
		*out = make(map[reflect.Type]FieldMatchingFlags)
		for range in {
			// FIXME: Copying unassignable keys unsupported reflect.Type
		}
	} else {
		out.inputDefaultFlags = nil
	}
	if in.Debug == nil {
		out.Debug = nil
	} else if newVal, err := c.DeepCopy(in.Debug); err != nil {
		return err
	} else {
		out.Debug = newVal.(DebugLogger)
	}
	if in.nameFunc == nil {
		out.nameFunc = nil
	} else if newVal, err := c.DeepCopy(in.nameFunc); err != nil {
		return err
	} else {
		out.nameFunc = newVal.(func(reflect.Type) string)
	}
	return nil
}

func DeepCopy_conversion_Equalities(in Equalities, out *Equalities, c *Cloner) error {
	if in.Equalities != nil {
		in, out := in.Equalities, &out.Equalities
		*out = make(forked_reflect.Equalities)
		for range in {
			// FIXME: Copying unassignable keys unsupported reflect.Type
		}
	} else {
		out.Equalities = nil
	}
	return nil
}

func DeepCopy_conversion_Meta(in Meta, out *Meta, c *Cloner) error {
	out.SrcVersion = in.SrcVersion
	out.DestVersion = in.DestVersion
	if in.KeyNameMapping == nil {
		out.KeyNameMapping = nil
	} else if newVal, err := c.DeepCopy(in.KeyNameMapping); err != nil {
		return err
	} else {
		out.KeyNameMapping = newVal.(FieldMappingFunc)
	}
	return nil
}
