// Code generated by main. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	scheme "github.com/openshift/hive/pkg/client/clientset-generated/clientset/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterDeprovisionsGetter has a method to return a ClusterDeprovisionInterface.
// A group's client should implement this interface.
type ClusterDeprovisionsGetter interface {
	ClusterDeprovisions(namespace string) ClusterDeprovisionInterface
}

// ClusterDeprovisionInterface has methods to work with ClusterDeprovision resources.
type ClusterDeprovisionInterface interface {
	Create(*v1.ClusterDeprovision) (*v1.ClusterDeprovision, error)
	Update(*v1.ClusterDeprovision) (*v1.ClusterDeprovision, error)
	UpdateStatus(*v1.ClusterDeprovision) (*v1.ClusterDeprovision, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ClusterDeprovision, error)
	List(opts metav1.ListOptions) (*v1.ClusterDeprovisionList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ClusterDeprovision, err error)
	ClusterDeprovisionExpansion
}

// clusterDeprovisions implements ClusterDeprovisionInterface
type clusterDeprovisions struct {
	client rest.Interface
	ns     string
}

// newClusterDeprovisions returns a ClusterDeprovisions
func newClusterDeprovisions(c *HiveV1Client, namespace string) *clusterDeprovisions {
	return &clusterDeprovisions{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the clusterDeprovision, and returns the corresponding clusterDeprovision object, and an error if there is any.
func (c *clusterDeprovisions) Get(name string, options metav1.GetOptions) (result *v1.ClusterDeprovision, err error) {
	result = &v1.ClusterDeprovision{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("clusterdeprovisions").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterDeprovisions that match those selectors.
func (c *clusterDeprovisions) List(opts metav1.ListOptions) (result *v1.ClusterDeprovisionList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ClusterDeprovisionList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("clusterdeprovisions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterDeprovisions.
func (c *clusterDeprovisions) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("clusterdeprovisions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a clusterDeprovision and creates it.  Returns the server's representation of the clusterDeprovision, and an error, if there is any.
func (c *clusterDeprovisions) Create(clusterDeprovision *v1.ClusterDeprovision) (result *v1.ClusterDeprovision, err error) {
	result = &v1.ClusterDeprovision{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("clusterdeprovisions").
		Body(clusterDeprovision).
		Do().
		Into(result)
	return
}

// Update takes the representation of a clusterDeprovision and updates it. Returns the server's representation of the clusterDeprovision, and an error, if there is any.
func (c *clusterDeprovisions) Update(clusterDeprovision *v1.ClusterDeprovision) (result *v1.ClusterDeprovision, err error) {
	result = &v1.ClusterDeprovision{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("clusterdeprovisions").
		Name(clusterDeprovision.Name).
		Body(clusterDeprovision).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *clusterDeprovisions) UpdateStatus(clusterDeprovision *v1.ClusterDeprovision) (result *v1.ClusterDeprovision, err error) {
	result = &v1.ClusterDeprovision{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("clusterdeprovisions").
		Name(clusterDeprovision.Name).
		SubResource("status").
		Body(clusterDeprovision).
		Do().
		Into(result)
	return
}

// Delete takes name of the clusterDeprovision and deletes it. Returns an error if one occurs.
func (c *clusterDeprovisions) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("clusterdeprovisions").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterDeprovisions) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("clusterdeprovisions").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched clusterDeprovision.
func (c *clusterDeprovisions) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ClusterDeprovision, err error) {
	result = &v1.ClusterDeprovision{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("clusterdeprovisions").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
