// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	mcmv1alpha1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1alpha1"
	clientset "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/clientset_generated/clientset"
	internalinterfaces "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/informers_generated/externalversions/internalinterfaces"
	v1alpha1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/listers_generated/mcm/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// ClusterJoinRequestInformer provides access to a shared informer and lister for
// ClusterJoinRequests.
type ClusterJoinRequestInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.ClusterJoinRequestLister
}

type clusterJoinRequestInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// NewClusterJoinRequestInformer constructs a new informer for ClusterJoinRequest type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewClusterJoinRequestInformer(client clientset.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredClusterJoinRequestInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredClusterJoinRequestInformer constructs a new informer for ClusterJoinRequest type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredClusterJoinRequestInformer(client clientset.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.McmV1alpha1().ClusterJoinRequests().List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.McmV1alpha1().ClusterJoinRequests().Watch(options)
			},
		},
		&mcmv1alpha1.ClusterJoinRequest{},
		resyncPeriod,
		indexers,
	)
}

func (f *clusterJoinRequestInformer) defaultInformer(client clientset.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredClusterJoinRequestInformer(client, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *clusterJoinRequestInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&mcmv1alpha1.ClusterJoinRequest{}, f.defaultInformer)
}

func (f *clusterJoinRequestInformer) Lister() v1alpha1.ClusterJoinRequestLister {
	return v1alpha1.NewClusterJoinRequestLister(f.Informer().GetIndexer())
}
