// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by informer-gen. DO NOT EDIT.

package internalversion

import (
	time "time"

	mcm "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm"
	internalclientset "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/clientset_generated/internalclientset"
	internalinterfaces "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/informers_generated/internalversion/internalinterfaces"
	internalversion "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/listers_generated/mcm/internalversion"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// WorkSetInformer provides access to a shared informer and lister for
// WorkSets.
type WorkSetInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() internalversion.WorkSetLister
}

type workSetInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewWorkSetInformer constructs a new informer for WorkSet type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewWorkSetInformer(client internalclientset.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredWorkSetInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredWorkSetInformer constructs a new informer for WorkSet type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredWorkSetInformer(client internalclientset.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.Mcm().WorkSets(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.Mcm().WorkSets(namespace).Watch(options)
			},
		},
		&mcm.WorkSet{},
		resyncPeriod,
		indexers,
	)
}

func (f *workSetInformer) defaultInformer(client internalclientset.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredWorkSetInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *workSetInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&mcm.WorkSet{}, f.defaultInformer)
}

func (f *workSetInformer) Lister() internalversion.WorkSetLister {
	return internalversion.NewWorkSetLister(f.Informer().GetIndexer())
}
