// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// WorkLister helps list Works.
type WorkLister interface {
	// List lists all Works in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.Work, err error)
	// Works returns an object that can list and get Works.
	Works(namespace string) WorkNamespaceLister
	WorkListerExpansion
}

// workLister implements the WorkLister interface.
type workLister struct {
	indexer cache.Indexer
}

// NewWorkLister returns a new WorkLister.
func NewWorkLister(indexer cache.Indexer) WorkLister {
	return &workLister{indexer: indexer}
}

// List lists all Works in the indexer.
func (s *workLister) List(selector labels.Selector) (ret []*v1alpha1.Work, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Work))
	})
	return ret, err
}

// Works returns an object that can list and get Works.
func (s *workLister) Works(namespace string) WorkNamespaceLister {
	return workNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// WorkNamespaceLister helps list and get Works.
type WorkNamespaceLister interface {
	// List lists all Works in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.Work, err error)
	// Get retrieves the Work from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.Work, error)
	WorkNamespaceListerExpansion
}

// workNamespaceLister implements the WorkNamespaceLister
// interface.
type workNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Works in the indexer for a given namespace.
func (s workNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Work, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Work))
	})
	return ret, err
}

// Get retrieves the Work from the indexer for a given namespace and name.
func (s workNamespaceLister) Get(name string) (*v1alpha1.Work, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("work"), name)
	}
	return obj.(*v1alpha1.Work), nil
}
