// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterJoinRequestLister helps list ClusterJoinRequests.
type ClusterJoinRequestLister interface {
	// List lists all ClusterJoinRequests in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.ClusterJoinRequest, err error)
	// Get retrieves the ClusterJoinRequest from the index for a given name.
	Get(name string) (*v1beta1.ClusterJoinRequest, error)
	ClusterJoinRequestListerExpansion
}

// clusterJoinRequestLister implements the ClusterJoinRequestLister interface.
type clusterJoinRequestLister struct {
	indexer cache.Indexer
}

// NewClusterJoinRequestLister returns a new ClusterJoinRequestLister.
func NewClusterJoinRequestLister(indexer cache.Indexer) ClusterJoinRequestLister {
	return &clusterJoinRequestLister{indexer: indexer}
}

// List lists all ClusterJoinRequests in the indexer.
func (s *clusterJoinRequestLister) List(selector labels.Selector) (ret []*v1beta1.ClusterJoinRequest, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.ClusterJoinRequest))
	})
	return ret, err
}

// Get retrieves the ClusterJoinRequest from the index for a given name.
func (s *clusterJoinRequestLister) Get(name string) (*v1beta1.ClusterJoinRequest, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("clusterjoinrequest"), name)
	}
	return obj.(*v1beta1.ClusterJoinRequest), nil
}
