// Code generated by main. DO NOT EDIT.

package fake

import (
	hivev1 "github.com/openshift/hive/pkg/apis/hive/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCheckpoints implements CheckpointInterface
type FakeCheckpoints struct {
	Fake *FakeHiveV1
	ns   string
}

var checkpointsResource = schema.GroupVersionResource{Group: "hive.openshift.io", Version: "v1", Resource: "checkpoints"}

var checkpointsKind = schema.GroupVersionKind{Group: "hive.openshift.io", Version: "v1", Kind: "Checkpoint"}

// Get takes name of the checkpoint, and returns the corresponding checkpoint object, and an error if there is any.
func (c *FakeCheckpoints) Get(name string, options v1.GetOptions) (result *hivev1.Checkpoint, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(checkpointsResource, c.ns, name), &hivev1.Checkpoint{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.Checkpoint), err
}

// List takes label and field selectors, and returns the list of Checkpoints that match those selectors.
func (c *FakeCheckpoints) List(opts v1.ListOptions) (result *hivev1.CheckpointList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(checkpointsResource, checkpointsKind, c.ns, opts), &hivev1.CheckpointList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &hivev1.CheckpointList{ListMeta: obj.(*hivev1.CheckpointList).ListMeta}
	for _, item := range obj.(*hivev1.CheckpointList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested checkpoints.
func (c *FakeCheckpoints) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(checkpointsResource, c.ns, opts))

}

// Create takes the representation of a checkpoint and creates it.  Returns the server's representation of the checkpoint, and an error, if there is any.
func (c *FakeCheckpoints) Create(checkpoint *hivev1.Checkpoint) (result *hivev1.Checkpoint, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(checkpointsResource, c.ns, checkpoint), &hivev1.Checkpoint{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.Checkpoint), err
}

// Update takes the representation of a checkpoint and updates it. Returns the server's representation of the checkpoint, and an error, if there is any.
func (c *FakeCheckpoints) Update(checkpoint *hivev1.Checkpoint) (result *hivev1.Checkpoint, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(checkpointsResource, c.ns, checkpoint), &hivev1.Checkpoint{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.Checkpoint), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeCheckpoints) UpdateStatus(checkpoint *hivev1.Checkpoint) (*hivev1.Checkpoint, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(checkpointsResource, "status", c.ns, checkpoint), &hivev1.Checkpoint{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.Checkpoint), err
}

// Delete takes name of the checkpoint and deletes it. Returns an error if one occurs.
func (c *FakeCheckpoints) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(checkpointsResource, c.ns, name), &hivev1.Checkpoint{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCheckpoints) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(checkpointsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &hivev1.CheckpointList{})
	return err
}

// Patch applies the patch and returns the patched checkpoint.
func (c *FakeCheckpoints) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *hivev1.Checkpoint, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(checkpointsResource, c.ns, name, pt, data, subresources...), &hivev1.Checkpoint{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.Checkpoint), err
}
