// +build !ignore_autogenerated

// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by conversion-gen. DO NOT EDIT.

package v1beta1

import (
	unsafe "unsafe"

	mcm "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*ClusterJoinRequest)(nil), (*mcm.ClusterJoinRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterJoinRequest_To_mcm_ClusterJoinRequest(a.(*ClusterJoinRequest), b.(*mcm.ClusterJoinRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterJoinRequest)(nil), (*ClusterJoinRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterJoinRequest_To_v1beta1_ClusterJoinRequest(a.(*mcm.ClusterJoinRequest), b.(*ClusterJoinRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterJoinRequestList)(nil), (*mcm.ClusterJoinRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList(a.(*ClusterJoinRequestList), b.(*mcm.ClusterJoinRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterJoinRequestList)(nil), (*ClusterJoinRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterJoinRequestList_To_v1beta1_ClusterJoinRequestList(a.(*mcm.ClusterJoinRequestList), b.(*ClusterJoinRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterJoinRequestSpec)(nil), (*mcm.ClusterJoinRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(a.(*ClusterJoinRequestSpec), b.(*mcm.ClusterJoinRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterJoinRequestSpec)(nil), (*ClusterJoinRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterJoinRequestSpec_To_v1beta1_ClusterJoinRequestSpec(a.(*mcm.ClusterJoinRequestSpec), b.(*ClusterJoinRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterJoinStatus)(nil), (*mcm.ClusterJoinStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(a.(*ClusterJoinStatus), b.(*mcm.ClusterJoinStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterJoinStatus)(nil), (*ClusterJoinStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterJoinStatus_To_v1beta1_ClusterJoinStatus(a.(*mcm.ClusterJoinStatus), b.(*ClusterJoinStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterRestOptions)(nil), (*mcm.ClusterRestOptions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterRestOptions_To_mcm_ClusterRestOptions(a.(*ClusterRestOptions), b.(*mcm.ClusterRestOptions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterRestOptions)(nil), (*ClusterRestOptions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterRestOptions_To_v1beta1_ClusterRestOptions(a.(*mcm.ClusterRestOptions), b.(*ClusterRestOptions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterStatus)(nil), (*mcm.ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterStatus_To_mcm_ClusterStatus(a.(*ClusterStatus), b.(*mcm.ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterStatus)(nil), (*ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterStatus_To_v1beta1_ClusterStatus(a.(*mcm.ClusterStatus), b.(*ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterStatusList)(nil), (*mcm.ClusterStatusList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterStatusList_To_mcm_ClusterStatusList(a.(*ClusterStatusList), b.(*mcm.ClusterStatusList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterStatusList)(nil), (*ClusterStatusList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterStatusList_To_v1beta1_ClusterStatusList(a.(*mcm.ClusterStatusList), b.(*ClusterStatusList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterStatusSpec)(nil), (*mcm.ClusterStatusSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(a.(*ClusterStatusSpec), b.(*mcm.ClusterStatusSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterStatusSpec)(nil), (*ClusterStatusSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterStatusSpec_To_v1beta1_ClusterStatusSpec(a.(*mcm.ClusterStatusSpec), b.(*ClusterStatusSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeWorkSpec)(nil), (*mcm.KubeWorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_KubeWorkSpec_To_mcm_KubeWorkSpec(a.(*KubeWorkSpec), b.(*mcm.KubeWorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.KubeWorkSpec)(nil), (*KubeWorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_KubeWorkSpec_To_v1beta1_KubeWorkSpec(a.(*mcm.KubeWorkSpec), b.(*KubeWorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceFilter)(nil), (*mcm.ResourceFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ResourceFilter_To_mcm_ResourceFilter(a.(*ResourceFilter), b.(*mcm.ResourceFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceFilter)(nil), (*ResourceFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceFilter_To_v1beta1_ResourceFilter(a.(*mcm.ResourceFilter), b.(*ResourceFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceView)(nil), (*mcm.ResourceView)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ResourceView_To_mcm_ResourceView(a.(*ResourceView), b.(*mcm.ResourceView), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceView)(nil), (*ResourceView)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceView_To_v1beta1_ResourceView(a.(*mcm.ResourceView), b.(*ResourceView), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewList)(nil), (*mcm.ResourceViewList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ResourceViewList_To_mcm_ResourceViewList(a.(*ResourceViewList), b.(*mcm.ResourceViewList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewList)(nil), (*ResourceViewList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewList_To_v1beta1_ResourceViewList(a.(*mcm.ResourceViewList), b.(*ResourceViewList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewResult)(nil), (*mcm.ResourceViewResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ResourceViewResult_To_mcm_ResourceViewResult(a.(*ResourceViewResult), b.(*mcm.ResourceViewResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewResult)(nil), (*ResourceViewResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewResult_To_v1beta1_ResourceViewResult(a.(*mcm.ResourceViewResult), b.(*ResourceViewResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewResultList)(nil), (*mcm.ResourceViewResultList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ResourceViewResultList_To_mcm_ResourceViewResultList(a.(*ResourceViewResultList), b.(*mcm.ResourceViewResultList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewResultList)(nil), (*ResourceViewResultList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewResultList_To_v1beta1_ResourceViewResultList(a.(*mcm.ResourceViewResultList), b.(*ResourceViewResultList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewSpec)(nil), (*mcm.ResourceViewSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ResourceViewSpec_To_mcm_ResourceViewSpec(a.(*ResourceViewSpec), b.(*mcm.ResourceViewSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewSpec)(nil), (*ResourceViewSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewSpec_To_v1beta1_ResourceViewSpec(a.(*mcm.ResourceViewSpec), b.(*ResourceViewSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewStatus)(nil), (*mcm.ResourceViewStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ResourceViewStatus_To_mcm_ResourceViewStatus(a.(*ResourceViewStatus), b.(*mcm.ResourceViewStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewStatus)(nil), (*ResourceViewStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewStatus_To_v1beta1_ResourceViewStatus(a.(*mcm.ResourceViewStatus), b.(*ResourceViewStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ViewCondition)(nil), (*mcm.ViewCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ViewCondition_To_mcm_ViewCondition(a.(*ViewCondition), b.(*mcm.ViewCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ViewCondition)(nil), (*ViewCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ViewCondition_To_v1beta1_ViewCondition(a.(*mcm.ViewCondition), b.(*ViewCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ViewFilter)(nil), (*mcm.ViewFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ViewFilter_To_mcm_ViewFilter(a.(*ViewFilter), b.(*mcm.ViewFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ViewFilter)(nil), (*ViewFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ViewFilter_To_v1beta1_ViewFilter(a.(*mcm.ViewFilter), b.(*ViewFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Work)(nil), (*mcm.Work)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Work_To_mcm_Work(a.(*Work), b.(*mcm.Work), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.Work)(nil), (*Work)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_Work_To_v1beta1_Work(a.(*mcm.Work), b.(*Work), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkList)(nil), (*mcm.WorkList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkList_To_mcm_WorkList(a.(*WorkList), b.(*mcm.WorkList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkList)(nil), (*WorkList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkList_To_v1beta1_WorkList(a.(*mcm.WorkList), b.(*WorkList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSet)(nil), (*mcm.WorkSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkSet_To_mcm_WorkSet(a.(*WorkSet), b.(*mcm.WorkSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSet)(nil), (*WorkSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSet_To_v1beta1_WorkSet(a.(*mcm.WorkSet), b.(*WorkSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSetList)(nil), (*mcm.WorkSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkSetList_To_mcm_WorkSetList(a.(*WorkSetList), b.(*mcm.WorkSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSetList)(nil), (*WorkSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSetList_To_v1beta1_WorkSetList(a.(*mcm.WorkSetList), b.(*WorkSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSetSpec)(nil), (*mcm.WorkSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkSetSpec_To_mcm_WorkSetSpec(a.(*WorkSetSpec), b.(*mcm.WorkSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSetSpec)(nil), (*WorkSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSetSpec_To_v1beta1_WorkSetSpec(a.(*mcm.WorkSetSpec), b.(*WorkSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSetStatus)(nil), (*mcm.WorkSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkSetStatus_To_mcm_WorkSetStatus(a.(*WorkSetStatus), b.(*mcm.WorkSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSetStatus)(nil), (*WorkSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSetStatus_To_v1beta1_WorkSetStatus(a.(*mcm.WorkSetStatus), b.(*WorkSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSpec)(nil), (*mcm.WorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkSpec_To_mcm_WorkSpec(a.(*WorkSpec), b.(*mcm.WorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSpec)(nil), (*WorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSpec_To_v1beta1_WorkSpec(a.(*mcm.WorkSpec), b.(*WorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkStatus)(nil), (*mcm.WorkStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkStatus_To_mcm_WorkStatus(a.(*WorkStatus), b.(*mcm.WorkStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkStatus)(nil), (*WorkStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkStatus_To_v1beta1_WorkStatus(a.(*mcm.WorkStatus), b.(*WorkStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkTemplateSpec)(nil), (*mcm.WorkTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(a.(*WorkTemplateSpec), b.(*mcm.WorkTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkTemplateSpec)(nil), (*WorkTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkTemplateSpec_To_v1beta1_WorkTemplateSpec(a.(*mcm.WorkTemplateSpec), b.(*WorkTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*mcm.WorkSpec)(nil), (*WorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSpec_To_v1beta1_WorkSpec(a.(*mcm.WorkSpec), b.(*WorkSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1beta1_ClusterJoinRequest_To_mcm_ClusterJoinRequest(in *ClusterJoinRequest, out *mcm.ClusterJoinRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_ClusterJoinRequest_To_mcm_ClusterJoinRequest is an autogenerated conversion function.
func Convert_v1beta1_ClusterJoinRequest_To_mcm_ClusterJoinRequest(in *ClusterJoinRequest, out *mcm.ClusterJoinRequest, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterJoinRequest_To_mcm_ClusterJoinRequest(in, out, s)
}

func autoConvert_mcm_ClusterJoinRequest_To_v1beta1_ClusterJoinRequest(in *mcm.ClusterJoinRequest, out *ClusterJoinRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_ClusterJoinRequestSpec_To_v1beta1_ClusterJoinRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_ClusterJoinStatus_To_v1beta1_ClusterJoinStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_ClusterJoinRequest_To_v1beta1_ClusterJoinRequest is an autogenerated conversion function.
func Convert_mcm_ClusterJoinRequest_To_v1beta1_ClusterJoinRequest(in *mcm.ClusterJoinRequest, out *ClusterJoinRequest, s conversion.Scope) error {
	return autoConvert_mcm_ClusterJoinRequest_To_v1beta1_ClusterJoinRequest(in, out, s)
}

func autoConvert_v1beta1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList(in *ClusterJoinRequestList, out *mcm.ClusterJoinRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.ClusterJoinRequest)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList is an autogenerated conversion function.
func Convert_v1beta1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList(in *ClusterJoinRequestList, out *mcm.ClusterJoinRequestList, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList(in, out, s)
}

func autoConvert_mcm_ClusterJoinRequestList_To_v1beta1_ClusterJoinRequestList(in *mcm.ClusterJoinRequestList, out *ClusterJoinRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ClusterJoinRequest)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_ClusterJoinRequestList_To_v1beta1_ClusterJoinRequestList is an autogenerated conversion function.
func Convert_mcm_ClusterJoinRequestList_To_v1beta1_ClusterJoinRequestList(in *mcm.ClusterJoinRequestList, out *ClusterJoinRequestList, s conversion.Scope) error {
	return autoConvert_mcm_ClusterJoinRequestList_To_v1beta1_ClusterJoinRequestList(in, out, s)
}

func autoConvert_v1beta1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(in *ClusterJoinRequestSpec, out *mcm.ClusterJoinRequestSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.ClusterNamespace = in.ClusterNamespace
	out.CSR = in.CSR
	return nil
}

// Convert_v1beta1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec is an autogenerated conversion function.
func Convert_v1beta1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(in *ClusterJoinRequestSpec, out *mcm.ClusterJoinRequestSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(in, out, s)
}

func autoConvert_mcm_ClusterJoinRequestSpec_To_v1beta1_ClusterJoinRequestSpec(in *mcm.ClusterJoinRequestSpec, out *ClusterJoinRequestSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.ClusterNamespace = in.ClusterNamespace
	out.CSR = in.CSR
	return nil
}

// Convert_mcm_ClusterJoinRequestSpec_To_v1beta1_ClusterJoinRequestSpec is an autogenerated conversion function.
func Convert_mcm_ClusterJoinRequestSpec_To_v1beta1_ClusterJoinRequestSpec(in *mcm.ClusterJoinRequestSpec, out *ClusterJoinRequestSpec, s conversion.Scope) error {
	return autoConvert_mcm_ClusterJoinRequestSpec_To_v1beta1_ClusterJoinRequestSpec(in, out, s)
}

func autoConvert_v1beta1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(in *ClusterJoinStatus, out *mcm.ClusterJoinStatus, s conversion.Scope) error {
	out.Phase = mcm.JoinRequestPhase(in.Phase)
	out.CSRStatus = in.CSRStatus
	return nil
}

// Convert_v1beta1_ClusterJoinStatus_To_mcm_ClusterJoinStatus is an autogenerated conversion function.
func Convert_v1beta1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(in *ClusterJoinStatus, out *mcm.ClusterJoinStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(in, out, s)
}

func autoConvert_mcm_ClusterJoinStatus_To_v1beta1_ClusterJoinStatus(in *mcm.ClusterJoinStatus, out *ClusterJoinStatus, s conversion.Scope) error {
	out.Phase = JoinRequestPhase(in.Phase)
	out.CSRStatus = in.CSRStatus
	return nil
}

// Convert_mcm_ClusterJoinStatus_To_v1beta1_ClusterJoinStatus is an autogenerated conversion function.
func Convert_mcm_ClusterJoinStatus_To_v1beta1_ClusterJoinStatus(in *mcm.ClusterJoinStatus, out *ClusterJoinStatus, s conversion.Scope) error {
	return autoConvert_mcm_ClusterJoinStatus_To_v1beta1_ClusterJoinStatus(in, out, s)
}

func autoConvert_v1beta1_ClusterRestOptions_To_mcm_ClusterRestOptions(in *ClusterRestOptions, out *mcm.ClusterRestOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_v1beta1_ClusterRestOptions_To_mcm_ClusterRestOptions is an autogenerated conversion function.
func Convert_v1beta1_ClusterRestOptions_To_mcm_ClusterRestOptions(in *ClusterRestOptions, out *mcm.ClusterRestOptions, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterRestOptions_To_mcm_ClusterRestOptions(in, out, s)
}

func autoConvert_mcm_ClusterRestOptions_To_v1beta1_ClusterRestOptions(in *mcm.ClusterRestOptions, out *ClusterRestOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_mcm_ClusterRestOptions_To_v1beta1_ClusterRestOptions is an autogenerated conversion function.
func Convert_mcm_ClusterRestOptions_To_v1beta1_ClusterRestOptions(in *mcm.ClusterRestOptions, out *ClusterRestOptions, s conversion.Scope) error {
	return autoConvert_mcm_ClusterRestOptions_To_v1beta1_ClusterRestOptions(in, out, s)
}

func autoConvert_v1beta1_ClusterStatus_To_mcm_ClusterStatus(in *ClusterStatus, out *mcm.ClusterStatus, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_ClusterStatus_To_mcm_ClusterStatus is an autogenerated conversion function.
func Convert_v1beta1_ClusterStatus_To_mcm_ClusterStatus(in *ClusterStatus, out *mcm.ClusterStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterStatus_To_mcm_ClusterStatus(in, out, s)
}

func autoConvert_mcm_ClusterStatus_To_v1beta1_ClusterStatus(in *mcm.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_ClusterStatusSpec_To_v1beta1_ClusterStatusSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_ClusterStatus_To_v1beta1_ClusterStatus is an autogenerated conversion function.
func Convert_mcm_ClusterStatus_To_v1beta1_ClusterStatus(in *mcm.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	return autoConvert_mcm_ClusterStatus_To_v1beta1_ClusterStatus(in, out, s)
}

func autoConvert_v1beta1_ClusterStatusList_To_mcm_ClusterStatusList(in *ClusterStatusList, out *mcm.ClusterStatusList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]mcm.ClusterStatus, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_ClusterStatus_To_mcm_ClusterStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_ClusterStatusList_To_mcm_ClusterStatusList is an autogenerated conversion function.
func Convert_v1beta1_ClusterStatusList_To_mcm_ClusterStatusList(in *ClusterStatusList, out *mcm.ClusterStatusList, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterStatusList_To_mcm_ClusterStatusList(in, out, s)
}

func autoConvert_mcm_ClusterStatusList_To_v1beta1_ClusterStatusList(in *mcm.ClusterStatusList, out *ClusterStatusList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterStatus, len(*in))
		for i := range *in {
			if err := Convert_mcm_ClusterStatus_To_v1beta1_ClusterStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_mcm_ClusterStatusList_To_v1beta1_ClusterStatusList is an autogenerated conversion function.
func Convert_mcm_ClusterStatusList_To_v1beta1_ClusterStatusList(in *mcm.ClusterStatusList, out *ClusterStatusList, s conversion.Scope) error {
	return autoConvert_mcm_ClusterStatusList_To_v1beta1_ClusterStatusList(in, out, s)
}

func autoConvert_v1beta1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(in *ClusterStatusSpec, out *mcm.ClusterStatusSpec, s conversion.Scope) error {
	out.MasterAddresses = *(*[]v1.EndpointAddress)(unsafe.Pointer(&in.MasterAddresses))
	out.ConsoleURL = in.ConsoleURL
	out.Capacity = *(*v1.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Usage = *(*v1.ResourceList)(unsafe.Pointer(&in.Usage))
	out.KlusterletEndpoint = in.KlusterletEndpoint
	out.KlusterletPort = in.KlusterletPort
	out.MonitoringScrapeTarget = in.MonitoringScrapeTarget
	out.KlusterletVersion = in.KlusterletVersion
	out.Version = in.Version
	out.KlusterletCA = *(*[]byte)(unsafe.Pointer(&in.KlusterletCA))
	out.EndpointVersion = in.EndpointVersion
	out.EndpointOperatorVersion = in.EndpointOperatorVersion
	return nil
}

// Convert_v1beta1_ClusterStatusSpec_To_mcm_ClusterStatusSpec is an autogenerated conversion function.
func Convert_v1beta1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(in *ClusterStatusSpec, out *mcm.ClusterStatusSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(in, out, s)
}

func autoConvert_mcm_ClusterStatusSpec_To_v1beta1_ClusterStatusSpec(in *mcm.ClusterStatusSpec, out *ClusterStatusSpec, s conversion.Scope) error {
	out.MasterAddresses = *(*[]v1.EndpointAddress)(unsafe.Pointer(&in.MasterAddresses))
	out.ConsoleURL = in.ConsoleURL
	out.Capacity = *(*v1.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Usage = *(*v1.ResourceList)(unsafe.Pointer(&in.Usage))
	out.KlusterletEndpoint = in.KlusterletEndpoint
	out.KlusterletPort = in.KlusterletPort
	out.KlusterletVersion = in.KlusterletVersion
	out.KlusterletCA = *(*[]byte)(unsafe.Pointer(&in.KlusterletCA))
	out.MonitoringScrapeTarget = in.MonitoringScrapeTarget
	out.Version = in.Version
	out.EndpointVersion = in.EndpointVersion
	out.EndpointOperatorVersion = in.EndpointOperatorVersion
	return nil
}

// Convert_mcm_ClusterStatusSpec_To_v1beta1_ClusterStatusSpec is an autogenerated conversion function.
func Convert_mcm_ClusterStatusSpec_To_v1beta1_ClusterStatusSpec(in *mcm.ClusterStatusSpec, out *ClusterStatusSpec, s conversion.Scope) error {
	return autoConvert_mcm_ClusterStatusSpec_To_v1beta1_ClusterStatusSpec(in, out, s)
}

func autoConvert_v1beta1_KubeWorkSpec_To_mcm_KubeWorkSpec(in *KubeWorkSpec, out *mcm.KubeWorkSpec, s conversion.Scope) error {
	out.Resource = in.Resource
	out.Name = in.Name
	out.Namespace = in.Namespace
	out.ObjectTemplate = in.ObjectTemplate
	return nil
}

// Convert_v1beta1_KubeWorkSpec_To_mcm_KubeWorkSpec is an autogenerated conversion function.
func Convert_v1beta1_KubeWorkSpec_To_mcm_KubeWorkSpec(in *KubeWorkSpec, out *mcm.KubeWorkSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_KubeWorkSpec_To_mcm_KubeWorkSpec(in, out, s)
}

func autoConvert_mcm_KubeWorkSpec_To_v1beta1_KubeWorkSpec(in *mcm.KubeWorkSpec, out *KubeWorkSpec, s conversion.Scope) error {
	out.Resource = in.Resource
	out.Name = in.Name
	out.Namespace = in.Namespace
	out.ObjectTemplate = in.ObjectTemplate
	return nil
}

// Convert_mcm_KubeWorkSpec_To_v1beta1_KubeWorkSpec is an autogenerated conversion function.
func Convert_mcm_KubeWorkSpec_To_v1beta1_KubeWorkSpec(in *mcm.KubeWorkSpec, out *KubeWorkSpec, s conversion.Scope) error {
	return autoConvert_mcm_KubeWorkSpec_To_v1beta1_KubeWorkSpec(in, out, s)
}

func autoConvert_v1beta1_ResourceFilter_To_mcm_ResourceFilter(in *ResourceFilter, out *mcm.ResourceFilter, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.FieldSelector = in.FieldSelector
	out.APIGroup = in.APIGroup
	out.ResourceType = in.ResourceType
	out.Name = in.Name
	out.NameSpace = in.NameSpace
	out.Version = in.Version
	out.ServerPrint = in.ServerPrint
	out.Mode = mcm.ResourceFilterMode(in.Mode)
	out.UpdateIntervalSeconds = in.UpdateIntervalSeconds
	return nil
}

// Convert_v1beta1_ResourceFilter_To_mcm_ResourceFilter is an autogenerated conversion function.
func Convert_v1beta1_ResourceFilter_To_mcm_ResourceFilter(in *ResourceFilter, out *mcm.ResourceFilter, s conversion.Scope) error {
	return autoConvert_v1beta1_ResourceFilter_To_mcm_ResourceFilter(in, out, s)
}

func autoConvert_mcm_ResourceFilter_To_v1beta1_ResourceFilter(in *mcm.ResourceFilter, out *ResourceFilter, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.FieldSelector = in.FieldSelector
	out.APIGroup = in.APIGroup
	out.ResourceType = in.ResourceType
	out.Name = in.Name
	out.NameSpace = in.NameSpace
	out.Version = in.Version
	out.ServerPrint = in.ServerPrint
	out.Mode = ResourceFilterMode(in.Mode)
	out.UpdateIntervalSeconds = in.UpdateIntervalSeconds
	return nil
}

// Convert_mcm_ResourceFilter_To_v1beta1_ResourceFilter is an autogenerated conversion function.
func Convert_mcm_ResourceFilter_To_v1beta1_ResourceFilter(in *mcm.ResourceFilter, out *ResourceFilter, s conversion.Scope) error {
	return autoConvert_mcm_ResourceFilter_To_v1beta1_ResourceFilter(in, out, s)
}

func autoConvert_v1beta1_ResourceView_To_mcm_ResourceView(in *ResourceView, out *mcm.ResourceView, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_ResourceViewSpec_To_mcm_ResourceViewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ResourceViewStatus_To_mcm_ResourceViewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_ResourceView_To_mcm_ResourceView is an autogenerated conversion function.
func Convert_v1beta1_ResourceView_To_mcm_ResourceView(in *ResourceView, out *mcm.ResourceView, s conversion.Scope) error {
	return autoConvert_v1beta1_ResourceView_To_mcm_ResourceView(in, out, s)
}

func autoConvert_mcm_ResourceView_To_v1beta1_ResourceView(in *mcm.ResourceView, out *ResourceView, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_ResourceViewSpec_To_v1beta1_ResourceViewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_ResourceViewStatus_To_v1beta1_ResourceViewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_ResourceView_To_v1beta1_ResourceView is an autogenerated conversion function.
func Convert_mcm_ResourceView_To_v1beta1_ResourceView(in *mcm.ResourceView, out *ResourceView, s conversion.Scope) error {
	return autoConvert_mcm_ResourceView_To_v1beta1_ResourceView(in, out, s)
}

func autoConvert_v1beta1_ResourceViewList_To_mcm_ResourceViewList(in *ResourceViewList, out *mcm.ResourceViewList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.ResourceView)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_ResourceViewList_To_mcm_ResourceViewList is an autogenerated conversion function.
func Convert_v1beta1_ResourceViewList_To_mcm_ResourceViewList(in *ResourceViewList, out *mcm.ResourceViewList, s conversion.Scope) error {
	return autoConvert_v1beta1_ResourceViewList_To_mcm_ResourceViewList(in, out, s)
}

func autoConvert_mcm_ResourceViewList_To_v1beta1_ResourceViewList(in *mcm.ResourceViewList, out *ResourceViewList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ResourceView)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_ResourceViewList_To_v1beta1_ResourceViewList is an autogenerated conversion function.
func Convert_mcm_ResourceViewList_To_v1beta1_ResourceViewList(in *mcm.ResourceViewList, out *ResourceViewList, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewList_To_v1beta1_ResourceViewList(in, out, s)
}

func autoConvert_v1beta1_ResourceViewResult_To_mcm_ResourceViewResult(in *ResourceViewResult, out *mcm.ResourceViewResult, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = *(*[]byte)(unsafe.Pointer(&in.Data))
	return nil
}

// Convert_v1beta1_ResourceViewResult_To_mcm_ResourceViewResult is an autogenerated conversion function.
func Convert_v1beta1_ResourceViewResult_To_mcm_ResourceViewResult(in *ResourceViewResult, out *mcm.ResourceViewResult, s conversion.Scope) error {
	return autoConvert_v1beta1_ResourceViewResult_To_mcm_ResourceViewResult(in, out, s)
}

func autoConvert_mcm_ResourceViewResult_To_v1beta1_ResourceViewResult(in *mcm.ResourceViewResult, out *ResourceViewResult, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = *(*[]byte)(unsafe.Pointer(&in.Data))
	return nil
}

// Convert_mcm_ResourceViewResult_To_v1beta1_ResourceViewResult is an autogenerated conversion function.
func Convert_mcm_ResourceViewResult_To_v1beta1_ResourceViewResult(in *mcm.ResourceViewResult, out *ResourceViewResult, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewResult_To_v1beta1_ResourceViewResult(in, out, s)
}

func autoConvert_v1beta1_ResourceViewResultList_To_mcm_ResourceViewResultList(in *ResourceViewResultList, out *mcm.ResourceViewResultList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.ResourceViewResult)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_ResourceViewResultList_To_mcm_ResourceViewResultList is an autogenerated conversion function.
func Convert_v1beta1_ResourceViewResultList_To_mcm_ResourceViewResultList(in *ResourceViewResultList, out *mcm.ResourceViewResultList, s conversion.Scope) error {
	return autoConvert_v1beta1_ResourceViewResultList_To_mcm_ResourceViewResultList(in, out, s)
}

func autoConvert_mcm_ResourceViewResultList_To_v1beta1_ResourceViewResultList(in *mcm.ResourceViewResultList, out *ResourceViewResultList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ResourceViewResult)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_ResourceViewResultList_To_v1beta1_ResourceViewResultList is an autogenerated conversion function.
func Convert_mcm_ResourceViewResultList_To_v1beta1_ResourceViewResultList(in *mcm.ResourceViewResultList, out *ResourceViewResultList, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewResultList_To_v1beta1_ResourceViewResultList(in, out, s)
}

func autoConvert_v1beta1_ResourceViewSpec_To_mcm_ResourceViewSpec(in *ResourceViewSpec, out *mcm.ResourceViewSpec, s conversion.Scope) error {
	out.ClusterSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterSelector))
	if err := Convert_v1beta1_ViewFilter_To_mcm_ViewFilter(&in.Scope, &out.Scope, s); err != nil {
		return err
	}
	out.SummaryOnly = in.SummaryOnly
	out.Mode = mcm.ResourceFilterMode(in.Mode)
	out.UpdateIntervalSeconds = in.UpdateIntervalSeconds
	return nil
}

// Convert_v1beta1_ResourceViewSpec_To_mcm_ResourceViewSpec is an autogenerated conversion function.
func Convert_v1beta1_ResourceViewSpec_To_mcm_ResourceViewSpec(in *ResourceViewSpec, out *mcm.ResourceViewSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_ResourceViewSpec_To_mcm_ResourceViewSpec(in, out, s)
}

func autoConvert_mcm_ResourceViewSpec_To_v1beta1_ResourceViewSpec(in *mcm.ResourceViewSpec, out *ResourceViewSpec, s conversion.Scope) error {
	out.ClusterSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterSelector))
	if err := Convert_mcm_ViewFilter_To_v1beta1_ViewFilter(&in.Scope, &out.Scope, s); err != nil {
		return err
	}
	out.SummaryOnly = in.SummaryOnly
	out.Mode = ResourceFilterMode(in.Mode)
	out.UpdateIntervalSeconds = in.UpdateIntervalSeconds
	return nil
}

// Convert_mcm_ResourceViewSpec_To_v1beta1_ResourceViewSpec is an autogenerated conversion function.
func Convert_mcm_ResourceViewSpec_To_v1beta1_ResourceViewSpec(in *mcm.ResourceViewSpec, out *ResourceViewSpec, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewSpec_To_v1beta1_ResourceViewSpec(in, out, s)
}

func autoConvert_v1beta1_ResourceViewStatus_To_mcm_ResourceViewStatus(in *ResourceViewStatus, out *mcm.ResourceViewStatus, s conversion.Scope) error {
	out.Conditions = *(*[]mcm.ViewCondition)(unsafe.Pointer(&in.Conditions))
	out.Results = *(*map[string]runtime.RawExtension)(unsafe.Pointer(&in.Results))
	return nil
}

// Convert_v1beta1_ResourceViewStatus_To_mcm_ResourceViewStatus is an autogenerated conversion function.
func Convert_v1beta1_ResourceViewStatus_To_mcm_ResourceViewStatus(in *ResourceViewStatus, out *mcm.ResourceViewStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_ResourceViewStatus_To_mcm_ResourceViewStatus(in, out, s)
}

func autoConvert_mcm_ResourceViewStatus_To_v1beta1_ResourceViewStatus(in *mcm.ResourceViewStatus, out *ResourceViewStatus, s conversion.Scope) error {
	out.Conditions = *(*[]ViewCondition)(unsafe.Pointer(&in.Conditions))
	out.Results = *(*map[string]runtime.RawExtension)(unsafe.Pointer(&in.Results))
	return nil
}

// Convert_mcm_ResourceViewStatus_To_v1beta1_ResourceViewStatus is an autogenerated conversion function.
func Convert_mcm_ResourceViewStatus_To_v1beta1_ResourceViewStatus(in *mcm.ResourceViewStatus, out *ResourceViewStatus, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewStatus_To_v1beta1_ResourceViewStatus(in, out, s)
}

func autoConvert_v1beta1_ViewCondition_To_mcm_ViewCondition(in *ViewCondition, out *mcm.ViewCondition, s conversion.Scope) error {
	out.Type = mcm.WorkStatusType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.Reason = in.Reason
	return nil
}

// Convert_v1beta1_ViewCondition_To_mcm_ViewCondition is an autogenerated conversion function.
func Convert_v1beta1_ViewCondition_To_mcm_ViewCondition(in *ViewCondition, out *mcm.ViewCondition, s conversion.Scope) error {
	return autoConvert_v1beta1_ViewCondition_To_mcm_ViewCondition(in, out, s)
}

func autoConvert_mcm_ViewCondition_To_v1beta1_ViewCondition(in *mcm.ViewCondition, out *ViewCondition, s conversion.Scope) error {
	out.Type = WorkStatusType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.Reason = in.Reason
	return nil
}

// Convert_mcm_ViewCondition_To_v1beta1_ViewCondition is an autogenerated conversion function.
func Convert_mcm_ViewCondition_To_v1beta1_ViewCondition(in *mcm.ViewCondition, out *ViewCondition, s conversion.Scope) error {
	return autoConvert_mcm_ViewCondition_To_v1beta1_ViewCondition(in, out, s)
}

func autoConvert_v1beta1_ViewFilter_To_mcm_ViewFilter(in *ViewFilter, out *mcm.ViewFilter, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.FieldSelector = in.FieldSelector
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.ResourceName = in.ResourceName
	out.NameSpace = in.NameSpace
	return nil
}

// Convert_v1beta1_ViewFilter_To_mcm_ViewFilter is an autogenerated conversion function.
func Convert_v1beta1_ViewFilter_To_mcm_ViewFilter(in *ViewFilter, out *mcm.ViewFilter, s conversion.Scope) error {
	return autoConvert_v1beta1_ViewFilter_To_mcm_ViewFilter(in, out, s)
}

func autoConvert_mcm_ViewFilter_To_v1beta1_ViewFilter(in *mcm.ViewFilter, out *ViewFilter, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.FieldSelector = in.FieldSelector
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.ResourceName = in.ResourceName
	out.NameSpace = in.NameSpace
	return nil
}

// Convert_mcm_ViewFilter_To_v1beta1_ViewFilter is an autogenerated conversion function.
func Convert_mcm_ViewFilter_To_v1beta1_ViewFilter(in *mcm.ViewFilter, out *ViewFilter, s conversion.Scope) error {
	return autoConvert_mcm_ViewFilter_To_v1beta1_ViewFilter(in, out, s)
}

func autoConvert_v1beta1_Work_To_mcm_Work(in *Work, out *mcm.Work, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_WorkSpec_To_mcm_WorkSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_WorkStatus_To_mcm_WorkStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_Work_To_mcm_Work is an autogenerated conversion function.
func Convert_v1beta1_Work_To_mcm_Work(in *Work, out *mcm.Work, s conversion.Scope) error {
	return autoConvert_v1beta1_Work_To_mcm_Work(in, out, s)
}

func autoConvert_mcm_Work_To_v1beta1_Work(in *mcm.Work, out *Work, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_WorkSpec_To_v1beta1_WorkSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_WorkStatus_To_v1beta1_WorkStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_Work_To_v1beta1_Work is an autogenerated conversion function.
func Convert_mcm_Work_To_v1beta1_Work(in *mcm.Work, out *Work, s conversion.Scope) error {
	return autoConvert_mcm_Work_To_v1beta1_Work(in, out, s)
}

func autoConvert_v1beta1_WorkList_To_mcm_WorkList(in *WorkList, out *mcm.WorkList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]mcm.Work, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_Work_To_mcm_Work(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_WorkList_To_mcm_WorkList is an autogenerated conversion function.
func Convert_v1beta1_WorkList_To_mcm_WorkList(in *WorkList, out *mcm.WorkList, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkList_To_mcm_WorkList(in, out, s)
}

func autoConvert_mcm_WorkList_To_v1beta1_WorkList(in *mcm.WorkList, out *WorkList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Work, len(*in))
		for i := range *in {
			if err := Convert_mcm_Work_To_v1beta1_Work(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_mcm_WorkList_To_v1beta1_WorkList is an autogenerated conversion function.
func Convert_mcm_WorkList_To_v1beta1_WorkList(in *mcm.WorkList, out *WorkList, s conversion.Scope) error {
	return autoConvert_mcm_WorkList_To_v1beta1_WorkList(in, out, s)
}

func autoConvert_v1beta1_WorkSet_To_mcm_WorkSet(in *WorkSet, out *mcm.WorkSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_WorkSetSpec_To_mcm_WorkSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_WorkSetStatus_To_mcm_WorkSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_WorkSet_To_mcm_WorkSet is an autogenerated conversion function.
func Convert_v1beta1_WorkSet_To_mcm_WorkSet(in *WorkSet, out *mcm.WorkSet, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkSet_To_mcm_WorkSet(in, out, s)
}

func autoConvert_mcm_WorkSet_To_v1beta1_WorkSet(in *mcm.WorkSet, out *WorkSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_WorkSetSpec_To_v1beta1_WorkSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_WorkSetStatus_To_v1beta1_WorkSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_WorkSet_To_v1beta1_WorkSet is an autogenerated conversion function.
func Convert_mcm_WorkSet_To_v1beta1_WorkSet(in *mcm.WorkSet, out *WorkSet, s conversion.Scope) error {
	return autoConvert_mcm_WorkSet_To_v1beta1_WorkSet(in, out, s)
}

func autoConvert_v1beta1_WorkSetList_To_mcm_WorkSetList(in *WorkSetList, out *mcm.WorkSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]mcm.WorkSet, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_WorkSet_To_mcm_WorkSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_WorkSetList_To_mcm_WorkSetList is an autogenerated conversion function.
func Convert_v1beta1_WorkSetList_To_mcm_WorkSetList(in *WorkSetList, out *mcm.WorkSetList, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkSetList_To_mcm_WorkSetList(in, out, s)
}

func autoConvert_mcm_WorkSetList_To_v1beta1_WorkSetList(in *mcm.WorkSetList, out *WorkSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]WorkSet, len(*in))
		for i := range *in {
			if err := Convert_mcm_WorkSet_To_v1beta1_WorkSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_mcm_WorkSetList_To_v1beta1_WorkSetList is an autogenerated conversion function.
func Convert_mcm_WorkSetList_To_v1beta1_WorkSetList(in *mcm.WorkSetList, out *WorkSetList, s conversion.Scope) error {
	return autoConvert_mcm_WorkSetList_To_v1beta1_WorkSetList(in, out, s)
}

func autoConvert_v1beta1_WorkSetSpec_To_mcm_WorkSetSpec(in *WorkSetSpec, out *mcm.WorkSetSpec, s conversion.Scope) error {
	out.ClusterSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterSelector))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := Convert_v1beta1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_WorkSetSpec_To_mcm_WorkSetSpec is an autogenerated conversion function.
func Convert_v1beta1_WorkSetSpec_To_mcm_WorkSetSpec(in *WorkSetSpec, out *mcm.WorkSetSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkSetSpec_To_mcm_WorkSetSpec(in, out, s)
}

func autoConvert_mcm_WorkSetSpec_To_v1beta1_WorkSetSpec(in *mcm.WorkSetSpec, out *WorkSetSpec, s conversion.Scope) error {
	out.ClusterSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterSelector))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := Convert_mcm_WorkTemplateSpec_To_v1beta1_WorkTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_WorkSetSpec_To_v1beta1_WorkSetSpec is an autogenerated conversion function.
func Convert_mcm_WorkSetSpec_To_v1beta1_WorkSetSpec(in *mcm.WorkSetSpec, out *WorkSetSpec, s conversion.Scope) error {
	return autoConvert_mcm_WorkSetSpec_To_v1beta1_WorkSetSpec(in, out, s)
}

func autoConvert_v1beta1_WorkSetStatus_To_mcm_WorkSetStatus(in *WorkSetStatus, out *mcm.WorkSetStatus, s conversion.Scope) error {
	out.Status = mcm.WorkStatusType(in.Status)
	out.Reason = in.Reason
	return nil
}

// Convert_v1beta1_WorkSetStatus_To_mcm_WorkSetStatus is an autogenerated conversion function.
func Convert_v1beta1_WorkSetStatus_To_mcm_WorkSetStatus(in *WorkSetStatus, out *mcm.WorkSetStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkSetStatus_To_mcm_WorkSetStatus(in, out, s)
}

func autoConvert_mcm_WorkSetStatus_To_v1beta1_WorkSetStatus(in *mcm.WorkSetStatus, out *WorkSetStatus, s conversion.Scope) error {
	out.Status = WorkStatusType(in.Status)
	out.Reason = in.Reason
	return nil
}

// Convert_mcm_WorkSetStatus_To_v1beta1_WorkSetStatus is an autogenerated conversion function.
func Convert_mcm_WorkSetStatus_To_v1beta1_WorkSetStatus(in *mcm.WorkSetStatus, out *WorkSetStatus, s conversion.Scope) error {
	return autoConvert_mcm_WorkSetStatus_To_v1beta1_WorkSetStatus(in, out, s)
}

func autoConvert_v1beta1_WorkSpec_To_mcm_WorkSpec(in *WorkSpec, out *mcm.WorkSpec, s conversion.Scope) error {
	out.Cluster = in.Cluster
	out.Type = mcm.WorkType(in.Type)
	if err := Convert_v1beta1_ResourceFilter_To_mcm_ResourceFilter(&in.Scope, &out.Scope, s); err != nil {
		return err
	}
	out.ActionType = mcm.ActionType(in.ActionType)
	out.KubeWork = (*mcm.KubeWorkSpec)(unsafe.Pointer(in.KubeWork))
	return nil
}

// Convert_v1beta1_WorkSpec_To_mcm_WorkSpec is an autogenerated conversion function.
func Convert_v1beta1_WorkSpec_To_mcm_WorkSpec(in *WorkSpec, out *mcm.WorkSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkSpec_To_mcm_WorkSpec(in, out, s)
}

func autoConvert_mcm_WorkSpec_To_v1beta1_WorkSpec(in *mcm.WorkSpec, out *WorkSpec, s conversion.Scope) error {
	out.Cluster = in.Cluster
	out.Type = WorkType(in.Type)
	if err := Convert_mcm_ResourceFilter_To_v1beta1_ResourceFilter(&in.Scope, &out.Scope, s); err != nil {
		return err
	}
	out.ActionType = ActionType(in.ActionType)
	// WARNING: in.HelmWork requires manual conversion: does not exist in peer-type
	out.KubeWork = (*KubeWorkSpec)(unsafe.Pointer(in.KubeWork))
	return nil
}

func autoConvert_v1beta1_WorkStatus_To_mcm_WorkStatus(in *WorkStatus, out *mcm.WorkStatus, s conversion.Scope) error {
	out.Type = mcm.WorkStatusType(in.Type)
	out.Reason = in.Reason
	out.Result = in.Result
	out.LastUpdateTime = in.LastUpdateTime
	return nil
}

// Convert_v1beta1_WorkStatus_To_mcm_WorkStatus is an autogenerated conversion function.
func Convert_v1beta1_WorkStatus_To_mcm_WorkStatus(in *WorkStatus, out *mcm.WorkStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkStatus_To_mcm_WorkStatus(in, out, s)
}

func autoConvert_mcm_WorkStatus_To_v1beta1_WorkStatus(in *mcm.WorkStatus, out *WorkStatus, s conversion.Scope) error {
	out.Type = WorkStatusType(in.Type)
	out.Reason = in.Reason
	out.Result = in.Result
	out.LastUpdateTime = in.LastUpdateTime
	return nil
}

// Convert_mcm_WorkStatus_To_v1beta1_WorkStatus is an autogenerated conversion function.
func Convert_mcm_WorkStatus_To_v1beta1_WorkStatus(in *mcm.WorkStatus, out *WorkStatus, s conversion.Scope) error {
	return autoConvert_mcm_WorkStatus_To_v1beta1_WorkStatus(in, out, s)
}

func autoConvert_v1beta1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(in *WorkTemplateSpec, out *mcm.WorkTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_WorkSpec_To_mcm_WorkSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_WorkTemplateSpec_To_mcm_WorkTemplateSpec is an autogenerated conversion function.
func Convert_v1beta1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(in *WorkTemplateSpec, out *mcm.WorkTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(in, out, s)
}

func autoConvert_mcm_WorkTemplateSpec_To_v1beta1_WorkTemplateSpec(in *mcm.WorkTemplateSpec, out *WorkTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_WorkSpec_To_v1beta1_WorkSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_WorkTemplateSpec_To_v1beta1_WorkTemplateSpec is an autogenerated conversion function.
func Convert_mcm_WorkTemplateSpec_To_v1beta1_WorkTemplateSpec(in *mcm.WorkTemplateSpec, out *WorkTemplateSpec, s conversion.Scope) error {
	return autoConvert_mcm_WorkTemplateSpec_To_v1beta1_WorkTemplateSpec(in, out, s)
}
