// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	mcm "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeLeaderVotes implements LeaderVoteInterface
type FakeLeaderVotes struct {
	Fake *FakeMcm
}

var leadervotesResource = schema.GroupVersionResource{Group: "mcm.ibm.com", Version: "", Resource: "leadervotes"}

var leadervotesKind = schema.GroupVersionKind{Group: "mcm.ibm.com", Version: "", Kind: "LeaderVote"}

// Get takes name of the leaderVote, and returns the corresponding leaderVote object, and an error if there is any.
func (c *FakeLeaderVotes) Get(name string, options v1.GetOptions) (result *mcm.LeaderVote, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(leadervotesResource, name), &mcm.LeaderVote{})
	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.LeaderVote), err
}

// List takes label and field selectors, and returns the list of LeaderVotes that match those selectors.
func (c *FakeLeaderVotes) List(opts v1.ListOptions) (result *mcm.LeaderVoteList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(leadervotesResource, leadervotesKind, opts), &mcm.LeaderVoteList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &mcm.LeaderVoteList{ListMeta: obj.(*mcm.LeaderVoteList).ListMeta}
	for _, item := range obj.(*mcm.LeaderVoteList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested leaderVotes.
func (c *FakeLeaderVotes) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(leadervotesResource, opts))
}

// Create takes the representation of a leaderVote and creates it.  Returns the server's representation of the leaderVote, and an error, if there is any.
func (c *FakeLeaderVotes) Create(leaderVote *mcm.LeaderVote) (result *mcm.LeaderVote, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(leadervotesResource, leaderVote), &mcm.LeaderVote{})
	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.LeaderVote), err
}

// Update takes the representation of a leaderVote and updates it. Returns the server's representation of the leaderVote, and an error, if there is any.
func (c *FakeLeaderVotes) Update(leaderVote *mcm.LeaderVote) (result *mcm.LeaderVote, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(leadervotesResource, leaderVote), &mcm.LeaderVote{})
	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.LeaderVote), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeLeaderVotes) UpdateStatus(leaderVote *mcm.LeaderVote) (*mcm.LeaderVote, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(leadervotesResource, "status", leaderVote), &mcm.LeaderVote{})
	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.LeaderVote), err
}

// Delete takes name of the leaderVote and deletes it. Returns an error if one occurs.
func (c *FakeLeaderVotes) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(leadervotesResource, name), &mcm.LeaderVote{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeLeaderVotes) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(leadervotesResource, listOptions)

	_, err := c.Fake.Invokes(action, &mcm.LeaderVoteList{})
	return err
}

// Patch applies the patch and returns the patched leaderVote.
func (c *FakeLeaderVotes) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *mcm.LeaderVote, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(leadervotesResource, name, pt, data, subresources...), &mcm.LeaderVote{})
	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.LeaderVote), err
}
