// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by client-gen. DO NOT EDIT.

package internalversion

import (
	"time"

	mcm "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm"
	scheme "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/clientset_generated/internalclientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// LeaderVotesGetter has a method to return a LeaderVoteInterface.
// A group's client should implement this interface.
type LeaderVotesGetter interface {
	LeaderVotes() LeaderVoteInterface
}

// LeaderVoteInterface has methods to work with LeaderVote resources.
type LeaderVoteInterface interface {
	Create(*mcm.LeaderVote) (*mcm.LeaderVote, error)
	Update(*mcm.LeaderVote) (*mcm.LeaderVote, error)
	UpdateStatus(*mcm.LeaderVote) (*mcm.LeaderVote, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*mcm.LeaderVote, error)
	List(opts v1.ListOptions) (*mcm.LeaderVoteList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *mcm.LeaderVote, err error)
	LeaderVoteExpansion
}

// leaderVotes implements LeaderVoteInterface
type leaderVotes struct {
	client rest.Interface
}

// newLeaderVotes returns a LeaderVotes
func newLeaderVotes(c *McmClient) *leaderVotes {
	return &leaderVotes{
		client: c.RESTClient(),
	}
}

// Get takes name of the leaderVote, and returns the corresponding leaderVote object, and an error if there is any.
func (c *leaderVotes) Get(name string, options v1.GetOptions) (result *mcm.LeaderVote, err error) {
	result = &mcm.LeaderVote{}
	err = c.client.Get().
		Resource("leadervotes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of LeaderVotes that match those selectors.
func (c *leaderVotes) List(opts v1.ListOptions) (result *mcm.LeaderVoteList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &mcm.LeaderVoteList{}
	err = c.client.Get().
		Resource("leadervotes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested leaderVotes.
func (c *leaderVotes) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("leadervotes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a leaderVote and creates it.  Returns the server's representation of the leaderVote, and an error, if there is any.
func (c *leaderVotes) Create(leaderVote *mcm.LeaderVote) (result *mcm.LeaderVote, err error) {
	result = &mcm.LeaderVote{}
	err = c.client.Post().
		Resource("leadervotes").
		Body(leaderVote).
		Do().
		Into(result)
	return
}

// Update takes the representation of a leaderVote and updates it. Returns the server's representation of the leaderVote, and an error, if there is any.
func (c *leaderVotes) Update(leaderVote *mcm.LeaderVote) (result *mcm.LeaderVote, err error) {
	result = &mcm.LeaderVote{}
	err = c.client.Put().
		Resource("leadervotes").
		Name(leaderVote.Name).
		Body(leaderVote).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *leaderVotes) UpdateStatus(leaderVote *mcm.LeaderVote) (result *mcm.LeaderVote, err error) {
	result = &mcm.LeaderVote{}
	err = c.client.Put().
		Resource("leadervotes").
		Name(leaderVote.Name).
		SubResource("status").
		Body(leaderVote).
		Do().
		Into(result)
	return
}

// Delete takes name of the leaderVote and deletes it. Returns an error if one occurs.
func (c *leaderVotes) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("leadervotes").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *leaderVotes) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("leadervotes").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched leaderVote.
func (c *leaderVotes) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *mcm.LeaderVote, err error) {
	result = &mcm.LeaderVote{}
	err = c.client.Patch(pt).
		Resource("leadervotes").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
