// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by informer-gen. DO NOT EDIT.

package externalversions

import (
	"fmt"

	v1alpha1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1alpha1"
	v1beta1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1beta1"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=mcm.ibm.com, Version=v1alpha1
	case v1alpha1.SchemeGroupVersion.WithResource("clusterjoinrequests"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1alpha1().ClusterJoinRequests().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("clusterstatuses"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1alpha1().ClusterStatuses().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("leadervotes"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1alpha1().LeaderVotes().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("placementbindings"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1alpha1().PlacementBindings().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("placementpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1alpha1().PlacementPolicies().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("resourceviews"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1alpha1().ResourceViews().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("works"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1alpha1().Works().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("worksets"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1alpha1().WorkSets().Informer()}, nil

		// Group=mcm.ibm.com, Version=v1beta1
	case v1beta1.SchemeGroupVersion.WithResource("clusterjoinrequests"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1beta1().ClusterJoinRequests().Informer()}, nil
	case v1beta1.SchemeGroupVersion.WithResource("clusterstatuses"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1beta1().ClusterStatuses().Informer()}, nil
	case v1beta1.SchemeGroupVersion.WithResource("resourceviews"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1beta1().ResourceViews().Informer()}, nil
	case v1beta1.SchemeGroupVersion.WithResource("works"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1beta1().Works().Informer()}, nil
	case v1beta1.SchemeGroupVersion.WithResource("worksets"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().V1beta1().WorkSets().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
