// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by gapic-generator. DO NOT EDIT.

package cloudbuild

import (
	"context"
	"flag"
	"fmt"
	"io"
	"log"
	"net"
	"os"
	"strings"
	"testing"

	"github.com/golang/protobuf/proto"
	"github.com/golang/protobuf/ptypes"
	emptypb "github.com/golang/protobuf/ptypes/empty"
	"google.golang.org/api/option"
	cloudbuildpb "google.golang.org/genproto/googleapis/devtools/cloudbuild/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"

	status "google.golang.org/genproto/googleapis/rpc/status"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"

	gstatus "google.golang.org/grpc/status"
)

var _ = io.EOF
var _ = ptypes.MarshalAny
var _ status.Status

type mockCloudBuildServer struct {
	// Embed for forward compatibility.
	// Tests will keep working if more methods are added
	// in the future.
	cloudbuildpb.CloudBuildServer

	reqs []proto.Message

	// If set, all calls return this error.
	err error

	// responses to return if err == nil
	resps []proto.Message
}

func (s *mockCloudBuildServer) CreateBuild(ctx context.Context, req *cloudbuildpb.CreateBuildRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockCloudBuildServer) GetBuild(ctx context.Context, req *cloudbuildpb.GetBuildRequest) (*cloudbuildpb.Build, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*cloudbuildpb.Build), nil
}

func (s *mockCloudBuildServer) ListBuilds(ctx context.Context, req *cloudbuildpb.ListBuildsRequest) (*cloudbuildpb.ListBuildsResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*cloudbuildpb.ListBuildsResponse), nil
}

func (s *mockCloudBuildServer) CancelBuild(ctx context.Context, req *cloudbuildpb.CancelBuildRequest) (*cloudbuildpb.Build, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*cloudbuildpb.Build), nil
}

func (s *mockCloudBuildServer) RetryBuild(ctx context.Context, req *cloudbuildpb.RetryBuildRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockCloudBuildServer) CreateBuildTrigger(ctx context.Context, req *cloudbuildpb.CreateBuildTriggerRequest) (*cloudbuildpb.BuildTrigger, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*cloudbuildpb.BuildTrigger), nil
}

func (s *mockCloudBuildServer) GetBuildTrigger(ctx context.Context, req *cloudbuildpb.GetBuildTriggerRequest) (*cloudbuildpb.BuildTrigger, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*cloudbuildpb.BuildTrigger), nil
}

func (s *mockCloudBuildServer) ListBuildTriggers(ctx context.Context, req *cloudbuildpb.ListBuildTriggersRequest) (*cloudbuildpb.ListBuildTriggersResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*cloudbuildpb.ListBuildTriggersResponse), nil
}

func (s *mockCloudBuildServer) DeleteBuildTrigger(ctx context.Context, req *cloudbuildpb.DeleteBuildTriggerRequest) (*emptypb.Empty, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*emptypb.Empty), nil
}

func (s *mockCloudBuildServer) UpdateBuildTrigger(ctx context.Context, req *cloudbuildpb.UpdateBuildTriggerRequest) (*cloudbuildpb.BuildTrigger, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*cloudbuildpb.BuildTrigger), nil
}

func (s *mockCloudBuildServer) RunBuildTrigger(ctx context.Context, req *cloudbuildpb.RunBuildTriggerRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

// clientOpt is the option tests should use to connect to the test server.
// It is initialized by TestMain.
var clientOpt option.ClientOption

var (
	mockCloudBuild mockCloudBuildServer
)

func TestMain(m *testing.M) {
	flag.Parse()

	serv := grpc.NewServer()
	cloudbuildpb.RegisterCloudBuildServer(serv, &mockCloudBuild)

	lis, err := net.Listen("tcp", "localhost:0")
	if err != nil {
		log.Fatal(err)
	}
	go serv.Serve(lis)

	conn, err := grpc.Dial(lis.Addr().String(), grpc.WithInsecure())
	if err != nil {
		log.Fatal(err)
	}
	clientOpt = option.WithGRPCConn(conn)

	os.Exit(m.Run())
}

func TestCloudBuildCreateBuild(t *testing.T) {
	var name string = "name3373707"
	var done bool = true
	var expectedResponse = &longrunningpb.Operation{
		Name: name,
		Done: done,
	}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var build *cloudbuildpb.Build = &cloudbuildpb.Build{}
	var request = &cloudbuildpb.CreateBuildRequest{
		ProjectId: projectId,
		Build:     build,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateBuild(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildCreateBuildError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var build *cloudbuildpb.Build = &cloudbuildpb.Build{}
	var request = &cloudbuildpb.CreateBuildRequest{
		ProjectId: projectId,
		Build:     build,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateBuild(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestCloudBuildGetBuild(t *testing.T) {
	var id2 string = "id23227150"
	var projectId2 string = "projectId2939242356"
	var statusDetail string = "statusDetail2089931070"
	var logsBucket string = "logsBucket1565363834"
	var buildTriggerId string = "buildTriggerId1105559411"
	var logUrl string = "logUrl342054388"
	var expectedResponse = &cloudbuildpb.Build{
		Id:             id2,
		ProjectId:      projectId2,
		StatusDetail:   statusDetail,
		LogsBucket:     logsBucket,
		BuildTriggerId: buildTriggerId,
		LogUrl:         logUrl,
	}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var id string = "id3355"
	var request = &cloudbuildpb.GetBuildRequest{
		ProjectId: projectId,
		Id:        id,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetBuild(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildGetBuildError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var id string = "id3355"
	var request = &cloudbuildpb.GetBuildRequest{
		ProjectId: projectId,
		Id:        id,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetBuild(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestCloudBuildListBuilds(t *testing.T) {
	var nextPageToken string = ""
	var buildsElement *cloudbuildpb.Build = &cloudbuildpb.Build{}
	var builds = []*cloudbuildpb.Build{buildsElement}
	var expectedResponse = &cloudbuildpb.ListBuildsResponse{
		NextPageToken: nextPageToken,
		Builds:        builds,
	}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var request = &cloudbuildpb.ListBuildsRequest{
		ProjectId: projectId,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListBuilds(context.Background(), request).Next()

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	want := (interface{})(expectedResponse.Builds[0])
	got := (interface{})(resp)
	var ok bool

	switch want := (want).(type) {
	case proto.Message:
		ok = proto.Equal(want, got.(proto.Message))
	default:
		ok = want == got
	}
	if !ok {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildListBuildsError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var request = &cloudbuildpb.ListBuildsRequest{
		ProjectId: projectId,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListBuilds(context.Background(), request).Next()

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestCloudBuildCancelBuild(t *testing.T) {
	var id2 string = "id23227150"
	var projectId2 string = "projectId2939242356"
	var statusDetail string = "statusDetail2089931070"
	var logsBucket string = "logsBucket1565363834"
	var buildTriggerId string = "buildTriggerId1105559411"
	var logUrl string = "logUrl342054388"
	var expectedResponse = &cloudbuildpb.Build{
		Id:             id2,
		ProjectId:      projectId2,
		StatusDetail:   statusDetail,
		LogsBucket:     logsBucket,
		BuildTriggerId: buildTriggerId,
		LogUrl:         logUrl,
	}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var id string = "id3355"
	var request = &cloudbuildpb.CancelBuildRequest{
		ProjectId: projectId,
		Id:        id,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CancelBuild(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildCancelBuildError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var id string = "id3355"
	var request = &cloudbuildpb.CancelBuildRequest{
		ProjectId: projectId,
		Id:        id,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CancelBuild(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestCloudBuildCreateBuildTrigger(t *testing.T) {
	var id string = "id3355"
	var description string = "description-1724546052"
	var filename string = "filename-734768633"
	var disabled bool = true
	var expectedResponse = &cloudbuildpb.BuildTrigger{
		Id:          id,
		Description: description,
		BuildTemplate: &cloudbuildpb.BuildTrigger_Filename{
			Filename: filename,
		},
		Disabled: disabled,
	}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var trigger *cloudbuildpb.BuildTrigger = &cloudbuildpb.BuildTrigger{}
	var request = &cloudbuildpb.CreateBuildTriggerRequest{
		ProjectId: projectId,
		Trigger:   trigger,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateBuildTrigger(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildCreateBuildTriggerError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var trigger *cloudbuildpb.BuildTrigger = &cloudbuildpb.BuildTrigger{}
	var request = &cloudbuildpb.CreateBuildTriggerRequest{
		ProjectId: projectId,
		Trigger:   trigger,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateBuildTrigger(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestCloudBuildGetBuildTrigger(t *testing.T) {
	var id string = "id3355"
	var description string = "description-1724546052"
	var filename string = "filename-734768633"
	var disabled bool = true
	var expectedResponse = &cloudbuildpb.BuildTrigger{
		Id:          id,
		Description: description,
		BuildTemplate: &cloudbuildpb.BuildTrigger_Filename{
			Filename: filename,
		},
		Disabled: disabled,
	}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var triggerId string = "triggerId1363517698"
	var request = &cloudbuildpb.GetBuildTriggerRequest{
		ProjectId: projectId,
		TriggerId: triggerId,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetBuildTrigger(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildGetBuildTriggerError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var triggerId string = "triggerId1363517698"
	var request = &cloudbuildpb.GetBuildTriggerRequest{
		ProjectId: projectId,
		TriggerId: triggerId,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetBuildTrigger(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestCloudBuildListBuildTriggers(t *testing.T) {
	var expectedResponse *cloudbuildpb.ListBuildTriggersResponse = &cloudbuildpb.ListBuildTriggersResponse{}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var request = &cloudbuildpb.ListBuildTriggersRequest{
		ProjectId: projectId,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListBuildTriggers(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildListBuildTriggersError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var request = &cloudbuildpb.ListBuildTriggersRequest{
		ProjectId: projectId,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListBuildTriggers(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestCloudBuildDeleteBuildTrigger(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var triggerId string = "triggerId1363517698"
	var request = &cloudbuildpb.DeleteBuildTriggerRequest{
		ProjectId: projectId,
		TriggerId: triggerId,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	err = c.DeleteBuildTrigger(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestCloudBuildDeleteBuildTriggerError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var triggerId string = "triggerId1363517698"
	var request = &cloudbuildpb.DeleteBuildTriggerRequest{
		ProjectId: projectId,
		TriggerId: triggerId,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	err = c.DeleteBuildTrigger(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
func TestCloudBuildUpdateBuildTrigger(t *testing.T) {
	var id string = "id3355"
	var description string = "description-1724546052"
	var filename string = "filename-734768633"
	var disabled bool = true
	var expectedResponse = &cloudbuildpb.BuildTrigger{
		Id:          id,
		Description: description,
		BuildTemplate: &cloudbuildpb.BuildTrigger_Filename{
			Filename: filename,
		},
		Disabled: disabled,
	}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var triggerId string = "triggerId1363517698"
	var trigger *cloudbuildpb.BuildTrigger = &cloudbuildpb.BuildTrigger{}
	var request = &cloudbuildpb.UpdateBuildTriggerRequest{
		ProjectId: projectId,
		TriggerId: triggerId,
		Trigger:   trigger,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateBuildTrigger(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildUpdateBuildTriggerError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var triggerId string = "triggerId1363517698"
	var trigger *cloudbuildpb.BuildTrigger = &cloudbuildpb.BuildTrigger{}
	var request = &cloudbuildpb.UpdateBuildTriggerRequest{
		ProjectId: projectId,
		TriggerId: triggerId,
		Trigger:   trigger,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateBuildTrigger(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestCloudBuildRunBuildTrigger(t *testing.T) {
	var name string = "name3373707"
	var done bool = true
	var expectedResponse = &longrunningpb.Operation{
		Name: name,
		Done: done,
	}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var triggerId string = "triggerId1363517698"
	var source *cloudbuildpb.RepoSource = &cloudbuildpb.RepoSource{}
	var request = &cloudbuildpb.RunBuildTriggerRequest{
		ProjectId: projectId,
		TriggerId: triggerId,
		Source:    source,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.RunBuildTrigger(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildRunBuildTriggerError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var triggerId string = "triggerId1363517698"
	var source *cloudbuildpb.RepoSource = &cloudbuildpb.RepoSource{}
	var request = &cloudbuildpb.RunBuildTriggerRequest{
		ProjectId: projectId,
		TriggerId: triggerId,
		Source:    source,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.RunBuildTrigger(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestCloudBuildRetryBuild(t *testing.T) {
	var name string = "name3373707"
	var done bool = true
	var expectedResponse = &longrunningpb.Operation{
		Name: name,
		Done: done,
	}

	mockCloudBuild.err = nil
	mockCloudBuild.reqs = nil

	mockCloudBuild.resps = append(mockCloudBuild.resps[:0], expectedResponse)

	var projectId string = "projectId-1969970175"
	var id string = "id3355"
	var request = &cloudbuildpb.RetryBuildRequest{
		ProjectId: projectId,
		Id:        id,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.RetryBuild(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockCloudBuild.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestCloudBuildRetryBuildError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockCloudBuild.err = gstatus.Error(errCode, "test error")

	var projectId string = "projectId-1969970175"
	var id string = "id3355"
	var request = &cloudbuildpb.RetryBuildRequest{
		ProjectId: projectId,
		Id:        id,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.RetryBuild(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
