package v1

// This file contains methods that can be used by the go-restful package to generate Swagger
// documentation for the object types found in 'types.go' This file is automatically generated
// by hack/update-generated-swagger-descriptions.sh and should be run after a full build of OpenShift.
// ==== DO NOT EDIT THIS FILE MANUALLY ====

var map_OAuthAccessToken = map[string]string{
	"":               "OAuthAccessToken describes an OAuth access token",
	"metadata":       "Standard object's metadata.",
	"clientName":     "ClientName references the client that created this token.",
	"expiresIn":      "ExpiresIn is the seconds from CreationTime before this token expires.",
	"scopes":         "Scopes is an array of the requested scopes.",
	"redirectURI":    "RedirectURI is the redirection associated with the token.",
	"userName":       "UserName is the user name associated with this token",
	"userUID":        "UserUID is the unique UID associated with this token",
	"authorizeToken": "AuthorizeToken contains the token that authorized this token",
	"refreshToken":   "RefreshToken is the value by which this token can be renewed. Can be blank.",
}

func (OAuthAccessToken) SwaggerDoc() map[string]string {
	return map_OAuthAccessToken
}

var map_OAuthAccessTokenList = map[string]string{
	"":         "OAuthAccessTokenList is a collection of OAuth access tokens",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of OAuth access tokens",
}

func (OAuthAccessTokenList) SwaggerDoc() map[string]string {
	return map_OAuthAccessTokenList
}

var map_OAuthAuthorizeToken = map[string]string{
	"":            "OAuthAuthorizeToken describes an OAuth authorization token",
	"metadata":    "Standard object's metadata.",
	"clientName":  "ClientName references the client that created this token.",
	"expiresIn":   "ExpiresIn is the seconds from CreationTime before this token expires.",
	"scopes":      "Scopes is an array of the requested scopes.",
	"redirectURI": "RedirectURI is the redirection associated with the token.",
	"state":       "State data from request",
	"userName":    "UserName is the user name associated with this token",
	"userUID":     "UserUID is the unique UID associated with this token. UserUID and UserName must both match for this token to be valid.",
}

func (OAuthAuthorizeToken) SwaggerDoc() map[string]string {
	return map_OAuthAuthorizeToken
}

var map_OAuthAuthorizeTokenList = map[string]string{
	"":         "OAuthAuthorizeTokenList is a collection of OAuth authorization tokens",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of OAuth authorization tokens",
}

func (OAuthAuthorizeTokenList) SwaggerDoc() map[string]string {
	return map_OAuthAuthorizeTokenList
}

var map_OAuthClient = map[string]string{
	"":                      "OAuthClient describes an OAuth client",
	"metadata":              "Standard object's metadata.",
	"secret":                "Secret is the unique secret associated with a client",
	"respondWithChallenges": "RespondWithChallenges indicates whether the client wants authentication needed responses made in the form of challenges instead of redirects",
	"redirectURIs":          "RedirectURIs is the valid redirection URIs associated with a client",
}

func (OAuthClient) SwaggerDoc() map[string]string {
	return map_OAuthClient
}

var map_OAuthClientAuthorization = map[string]string{
	"":           "OAuthClientAuthorization describes an authorization created by an OAuth client",
	"metadata":   "Standard object's metadata.",
	"clientName": "ClientName references the client that created this authorization",
	"userName":   "UserName is the user name that authorized this client",
	"userUID":    "UserUID is the unique UID associated with this authorization. UserUID and UserName must both match for this authorization to be valid.",
	"scopes":     "Scopes is an array of the granted scopes.",
}

func (OAuthClientAuthorization) SwaggerDoc() map[string]string {
	return map_OAuthClientAuthorization
}

var map_OAuthClientAuthorizationList = map[string]string{
	"":         "OAuthClientAuthorizationList is a collection of OAuth client authorizations",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of OAuth client authorizations",
}

func (OAuthClientAuthorizationList) SwaggerDoc() map[string]string {
	return map_OAuthClientAuthorizationList
}

var map_OAuthClientList = map[string]string{
	"":         "OAuthClientList is a collection of OAuth clients",
	"metadata": "Standard object's metadata.",
	"items":    "Items is the list of OAuth clients",
}

func (OAuthClientList) SwaggerDoc() map[string]string {
	return map_OAuthClientList
}
