// Code generated by main. DO NOT EDIT.

package fake

import (
	hivev1 "github.com/openshift/hive/pkg/apis/hive/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSelectorSyncSets implements SelectorSyncSetInterface
type FakeSelectorSyncSets struct {
	Fake *FakeHiveV1
}

var selectorsyncsetsResource = schema.GroupVersionResource{Group: "hive.openshift.io", Version: "v1", Resource: "selectorsyncsets"}

var selectorsyncsetsKind = schema.GroupVersionKind{Group: "hive.openshift.io", Version: "v1", Kind: "SelectorSyncSet"}

// Get takes name of the selectorSyncSet, and returns the corresponding selectorSyncSet object, and an error if there is any.
func (c *FakeSelectorSyncSets) Get(name string, options v1.GetOptions) (result *hivev1.SelectorSyncSet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(selectorsyncsetsResource, name), &hivev1.SelectorSyncSet{})
	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SelectorSyncSet), err
}

// List takes label and field selectors, and returns the list of SelectorSyncSets that match those selectors.
func (c *FakeSelectorSyncSets) List(opts v1.ListOptions) (result *hivev1.SelectorSyncSetList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(selectorsyncsetsResource, selectorsyncsetsKind, opts), &hivev1.SelectorSyncSetList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &hivev1.SelectorSyncSetList{ListMeta: obj.(*hivev1.SelectorSyncSetList).ListMeta}
	for _, item := range obj.(*hivev1.SelectorSyncSetList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested selectorSyncSets.
func (c *FakeSelectorSyncSets) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(selectorsyncsetsResource, opts))
}

// Create takes the representation of a selectorSyncSet and creates it.  Returns the server's representation of the selectorSyncSet, and an error, if there is any.
func (c *FakeSelectorSyncSets) Create(selectorSyncSet *hivev1.SelectorSyncSet) (result *hivev1.SelectorSyncSet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(selectorsyncsetsResource, selectorSyncSet), &hivev1.SelectorSyncSet{})
	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SelectorSyncSet), err
}

// Update takes the representation of a selectorSyncSet and updates it. Returns the server's representation of the selectorSyncSet, and an error, if there is any.
func (c *FakeSelectorSyncSets) Update(selectorSyncSet *hivev1.SelectorSyncSet) (result *hivev1.SelectorSyncSet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(selectorsyncsetsResource, selectorSyncSet), &hivev1.SelectorSyncSet{})
	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SelectorSyncSet), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSelectorSyncSets) UpdateStatus(selectorSyncSet *hivev1.SelectorSyncSet) (*hivev1.SelectorSyncSet, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(selectorsyncsetsResource, "status", selectorSyncSet), &hivev1.SelectorSyncSet{})
	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SelectorSyncSet), err
}

// Delete takes name of the selectorSyncSet and deletes it. Returns an error if one occurs.
func (c *FakeSelectorSyncSets) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(selectorsyncsetsResource, name), &hivev1.SelectorSyncSet{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSelectorSyncSets) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(selectorsyncsetsResource, listOptions)

	_, err := c.Fake.Invokes(action, &hivev1.SelectorSyncSetList{})
	return err
}

// Patch applies the patch and returns the patched selectorSyncSet.
func (c *FakeSelectorSyncSets) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *hivev1.SelectorSyncSet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(selectorsyncsetsResource, name, pt, data, subresources...), &hivev1.SelectorSyncSet{})
	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SelectorSyncSet), err
}
