// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationautoscaling

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDeleteScalingPolicy = "DeleteScalingPolicy"

// DeleteScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScalingPolicy for more information on using the DeleteScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScalingPolicyRequest method.
//    req, resp := client.DeleteScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScalingPolicy
func (c *ApplicationAutoScaling) DeleteScalingPolicyRequest(input *DeleteScalingPolicyInput) (req *request.Request, output *DeleteScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPolicyInput{}
	}

	output = &DeleteScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScalingPolicy API operation for Application Auto Scaling.
//
// Deletes the specified Application Auto Scaling scaling policy.
//
// Deleting a policy deletes the underlying alarm action, but does not delete
// the CloudWatch alarm associated with the scaling policy, even if it no longer
// has an associated action.
//
// To create a scaling policy or update an existing one, see PutScalingPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DeleteScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeObjectNotFoundException "ObjectNotFoundException"
//   The specified object could not be found. For any operation that depends on
//   the existence of a scalable target, this exception is thrown if the scalable
//   target with the specified service namespace, resource ID, and scalable dimension
//   does not exist. For any operation that deletes or deregisters a resource,
//   this exception is thrown if the resource cannot be found.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScalingPolicy
func (c *ApplicationAutoScaling) DeleteScalingPolicy(input *DeleteScalingPolicyInput) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	return out, req.Send()
}

// DeleteScalingPolicyWithContext is the same as DeleteScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DeleteScalingPolicyWithContext(ctx aws.Context, input *DeleteScalingPolicyInput, opts ...request.Option) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScheduledAction = "DeleteScheduledAction"

// DeleteScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScheduledAction for more information on using the DeleteScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScheduledActionRequest method.
//    req, resp := client.DeleteScheduledActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScheduledAction
func (c *ApplicationAutoScaling) DeleteScheduledActionRequest(input *DeleteScheduledActionInput) (req *request.Request, output *DeleteScheduledActionOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScheduledActionInput{}
	}

	output = &DeleteScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScheduledAction API operation for Application Auto Scaling.
//
// Deletes the specified Application Auto Scaling scheduled action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DeleteScheduledAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeObjectNotFoundException "ObjectNotFoundException"
//   The specified object could not be found. For any operation that depends on
//   the existence of a scalable target, this exception is thrown if the scalable
//   target with the specified service namespace, resource ID, and scalable dimension
//   does not exist. For any operation that deletes or deregisters a resource,
//   this exception is thrown if the resource cannot be found.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScheduledAction
func (c *ApplicationAutoScaling) DeleteScheduledAction(input *DeleteScheduledActionInput) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	return out, req.Send()
}

// DeleteScheduledActionWithContext is the same as DeleteScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DeleteScheduledActionWithContext(ctx aws.Context, input *DeleteScheduledActionInput, opts ...request.Option) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterScalableTarget = "DeregisterScalableTarget"

// DeregisterScalableTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterScalableTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterScalableTarget for more information on using the DeregisterScalableTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterScalableTargetRequest method.
//    req, resp := client.DeregisterScalableTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeregisterScalableTarget
func (c *ApplicationAutoScaling) DeregisterScalableTargetRequest(input *DeregisterScalableTargetInput) (req *request.Request, output *DeregisterScalableTargetOutput) {
	op := &request.Operation{
		Name:       opDeregisterScalableTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterScalableTargetInput{}
	}

	output = &DeregisterScalableTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterScalableTarget API operation for Application Auto Scaling.
//
// Deregisters a scalable target.
//
// Deregistering a scalable target deletes the scaling policies that are associated
// with it.
//
// To create a scalable target or update an existing one, see RegisterScalableTarget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DeregisterScalableTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeObjectNotFoundException "ObjectNotFoundException"
//   The specified object could not be found. For any operation that depends on
//   the existence of a scalable target, this exception is thrown if the scalable
//   target with the specified service namespace, resource ID, and scalable dimension
//   does not exist. For any operation that deletes or deregisters a resource,
//   this exception is thrown if the resource cannot be found.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeregisterScalableTarget
func (c *ApplicationAutoScaling) DeregisterScalableTarget(input *DeregisterScalableTargetInput) (*DeregisterScalableTargetOutput, error) {
	req, out := c.DeregisterScalableTargetRequest(input)
	return out, req.Send()
}

// DeregisterScalableTargetWithContext is the same as DeregisterScalableTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterScalableTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DeregisterScalableTargetWithContext(ctx aws.Context, input *DeregisterScalableTargetInput, opts ...request.Option) (*DeregisterScalableTargetOutput, error) {
	req, out := c.DeregisterScalableTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScalableTargets = "DescribeScalableTargets"

// DescribeScalableTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalableTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalableTargets for more information on using the DescribeScalableTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalableTargetsRequest method.
//    req, resp := client.DescribeScalableTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalableTargets
func (c *ApplicationAutoScaling) DescribeScalableTargetsRequest(input *DescribeScalableTargetsInput) (req *request.Request, output *DescribeScalableTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeScalableTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalableTargetsInput{}
	}

	output = &DescribeScalableTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalableTargets API operation for Application Auto Scaling.
//
// Gets information about the scalable targets in the specified namespace.
//
// You can filter the results using the ResourceIds and ScalableDimension parameters.
//
// To create a scalable target or update an existing one, see RegisterScalableTarget.
// If you are no longer using a scalable target, you can deregister it using
// DeregisterScalableTarget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScalableTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token supplied was invalid.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalableTargets
func (c *ApplicationAutoScaling) DescribeScalableTargets(input *DescribeScalableTargetsInput) (*DescribeScalableTargetsOutput, error) {
	req, out := c.DescribeScalableTargetsRequest(input)
	return out, req.Send()
}

// DescribeScalableTargetsWithContext is the same as DescribeScalableTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalableTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalableTargetsWithContext(ctx aws.Context, input *DescribeScalableTargetsInput, opts ...request.Option) (*DescribeScalableTargetsOutput, error) {
	req, out := c.DescribeScalableTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScalableTargetsPages iterates over the pages of a DescribeScalableTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalableTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScalableTargets operation.
//    pageNum := 0
//    err := client.DescribeScalableTargetsPages(params,
//        func(page *DescribeScalableTargetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationAutoScaling) DescribeScalableTargetsPages(input *DescribeScalableTargetsInput, fn func(*DescribeScalableTargetsOutput, bool) bool) error {
	return c.DescribeScalableTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScalableTargetsPagesWithContext same as DescribeScalableTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalableTargetsPagesWithContext(ctx aws.Context, input *DescribeScalableTargetsInput, fn func(*DescribeScalableTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScalableTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScalableTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeScalableTargetsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeScalingActivities = "DescribeScalingActivities"

// DescribeScalingActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingActivities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingActivities for more information on using the DescribeScalingActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingActivitiesRequest method.
//    req, resp := client.DescribeScalingActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingActivities
func (c *ApplicationAutoScaling) DescribeScalingActivitiesRequest(input *DescribeScalingActivitiesInput) (req *request.Request, output *DescribeScalingActivitiesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingActivities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingActivitiesInput{}
	}

	output = &DescribeScalingActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingActivities API operation for Application Auto Scaling.
//
// Provides descriptive information about the scaling activities in the specified
// namespace from the previous six weeks.
//
// You can filter the results using the ResourceId and ScalableDimension parameters.
//
// Scaling activities are triggered by CloudWatch alarms that are associated
// with scaling policies. To view the scaling policies for a service namespace,
// see DescribeScalingPolicies. To create a scaling policy or update an existing
// one, see PutScalingPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScalingActivities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token supplied was invalid.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingActivities
func (c *ApplicationAutoScaling) DescribeScalingActivities(input *DescribeScalingActivitiesInput) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	return out, req.Send()
}

// DescribeScalingActivitiesWithContext is the same as DescribeScalingActivities with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalingActivitiesWithContext(ctx aws.Context, input *DescribeScalingActivitiesInput, opts ...request.Option) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScalingActivitiesPages iterates over the pages of a DescribeScalingActivities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalingActivities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScalingActivities operation.
//    pageNum := 0
//    err := client.DescribeScalingActivitiesPages(params,
//        func(page *DescribeScalingActivitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationAutoScaling) DescribeScalingActivitiesPages(input *DescribeScalingActivitiesInput, fn func(*DescribeScalingActivitiesOutput, bool) bool) error {
	return c.DescribeScalingActivitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScalingActivitiesPagesWithContext same as DescribeScalingActivitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalingActivitiesPagesWithContext(ctx aws.Context, input *DescribeScalingActivitiesInput, fn func(*DescribeScalingActivitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScalingActivitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScalingActivitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeScalingActivitiesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeScalingPolicies = "DescribeScalingPolicies"

// DescribeScalingPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingPolicies for more information on using the DescribeScalingPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingPoliciesRequest method.
//    req, resp := client.DescribeScalingPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingPolicies
func (c *ApplicationAutoScaling) DescribeScalingPoliciesRequest(input *DescribeScalingPoliciesInput) (req *request.Request, output *DescribeScalingPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingPoliciesInput{}
	}

	output = &DescribeScalingPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingPolicies API operation for Application Auto Scaling.
//
// Describes the scaling policies for the specified service namespace.
//
// You can filter the results using the ResourceId, ScalableDimension, and PolicyNames
// parameters.
//
// To create a scaling policy or update an existing one, see PutScalingPolicy.
// If you are no longer using a scaling policy, you can delete it using DeleteScalingPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScalingPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeFailedResourceAccessException "FailedResourceAccessException"
//   Failed access to resources caused an exception. This exception is thrown
//   when Application Auto Scaling is unable to retrieve the alarms associated
//   with a scaling policy due to a client error, for example, if the role ARN
//   specified for a scalable target does not have permission to call the CloudWatch
//   DescribeAlarms (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)
//   on your behalf.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token supplied was invalid.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingPolicies
func (c *ApplicationAutoScaling) DescribeScalingPolicies(input *DescribeScalingPoliciesInput) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	return out, req.Send()
}

// DescribeScalingPoliciesWithContext is the same as DescribeScalingPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalingPoliciesWithContext(ctx aws.Context, input *DescribeScalingPoliciesInput, opts ...request.Option) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScalingPoliciesPages iterates over the pages of a DescribeScalingPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalingPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScalingPolicies operation.
//    pageNum := 0
//    err := client.DescribeScalingPoliciesPages(params,
//        func(page *DescribeScalingPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationAutoScaling) DescribeScalingPoliciesPages(input *DescribeScalingPoliciesInput, fn func(*DescribeScalingPoliciesOutput, bool) bool) error {
	return c.DescribeScalingPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScalingPoliciesPagesWithContext same as DescribeScalingPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalingPoliciesPagesWithContext(ctx aws.Context, input *DescribeScalingPoliciesInput, fn func(*DescribeScalingPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScalingPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScalingPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeScalingPoliciesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeScheduledActions = "DescribeScheduledActions"

// DescribeScheduledActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScheduledActions for more information on using the DescribeScheduledActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduledActionsRequest method.
//    req, resp := client.DescribeScheduledActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScheduledActions
func (c *ApplicationAutoScaling) DescribeScheduledActionsRequest(input *DescribeScheduledActionsInput) (req *request.Request, output *DescribeScheduledActionsOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScheduledActionsInput{}
	}

	output = &DescribeScheduledActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledActions API operation for Application Auto Scaling.
//
// Describes the scheduled actions for the specified service namespace.
//
// You can filter the results using the ResourceId, ScalableDimension, and ScheduledActionNames
// parameters.
//
// To create a scheduled action or update an existing one, see PutScheduledAction.
// If you are no longer using a scheduled action, you can delete it using DeleteScheduledAction.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScheduledActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token supplied was invalid.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScheduledActions
func (c *ApplicationAutoScaling) DescribeScheduledActions(input *DescribeScheduledActionsInput) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	return out, req.Send()
}

// DescribeScheduledActionsWithContext is the same as DescribeScheduledActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScheduledActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScheduledActionsWithContext(ctx aws.Context, input *DescribeScheduledActionsInput, opts ...request.Option) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutScalingPolicy for more information on using the PutScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutScalingPolicyRequest method.
//    req, resp := client.PutScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScalingPolicy
func (c *ApplicationAutoScaling) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	output = &PutScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutScalingPolicy API operation for Application Auto Scaling.
//
// Creates or updates a policy for an Application Auto Scaling scalable target.
//
// Each scalable target is identified by a service namespace, resource ID, and
// scalable dimension. A scaling policy applies to the scalable target identified
// by those three attributes. You cannot create a scaling policy until you have
// registered the resource as a scalable target using RegisterScalableTarget.
//
// To update a policy, specify its policy name and the parameters that you want
// to change. Any parameters that you don't specify are not changed by this
// update request.
//
// You can view the scaling policies for a service namespace using DescribeScalingPolicies.
// If you are no longer using a scaling policy, you can delete it using DeleteScalingPolicy.
//
// Multiple scaling policies can be in force at the same time for the same scalable
// target. You can have one or more target tracking scaling policies, one or
// more step scaling policies, or both. However, there is a chance that multiple
// policies could conflict, instructing the scalable target to scale out or
// in at the same time. Application Auto Scaling gives precedence to the policy
// that provides the largest capacity for both scale in and scale out. For example,
// if one policy increases capacity by 3, another policy increases capacity
// by 200 percent, and the current capacity is 10, Application Auto Scaling
// uses the policy with the highest calculated capacity (200% of 10 = 20) and
// scales out to 30.
//
// Learn more about how to work with scaling policies in the Application Auto
// Scaling User Guide (https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation PutScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A per-account resource limit is exceeded. For more information, see Application
//   Auto Scaling Limits (https://docs.aws.amazon.com/ApplicationAutoScaling/latest/userguide/application-auto-scaling-limits.html).
//
//   * ErrCodeObjectNotFoundException "ObjectNotFoundException"
//   The specified object could not be found. For any operation that depends on
//   the existence of a scalable target, this exception is thrown if the scalable
//   target with the specified service namespace, resource ID, and scalable dimension
//   does not exist. For any operation that deletes or deregisters a resource,
//   this exception is thrown if the resource cannot be found.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeFailedResourceAccessException "FailedResourceAccessException"
//   Failed access to resources caused an exception. This exception is thrown
//   when Application Auto Scaling is unable to retrieve the alarms associated
//   with a scaling policy due to a client error, for example, if the role ARN
//   specified for a scalable target does not have permission to call the CloudWatch
//   DescribeAlarms (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)
//   on your behalf.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScalingPolicy
func (c *ApplicationAutoScaling) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	return out, req.Send()
}

// PutScalingPolicyWithContext is the same as PutScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) PutScalingPolicyWithContext(ctx aws.Context, input *PutScalingPolicyInput, opts ...request.Option) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutScheduledAction = "PutScheduledAction"

// PutScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the PutScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutScheduledAction for more information on using the PutScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutScheduledActionRequest method.
//    req, resp := client.PutScheduledActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScheduledAction
func (c *ApplicationAutoScaling) PutScheduledActionRequest(input *PutScheduledActionInput) (req *request.Request, output *PutScheduledActionOutput) {
	op := &request.Operation{
		Name:       opPutScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScheduledActionInput{}
	}

	output = &PutScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutScheduledAction API operation for Application Auto Scaling.
//
// Creates or updates a scheduled action for an Application Auto Scaling scalable
// target.
//
// Each scalable target is identified by a service namespace, resource ID, and
// scalable dimension. A scheduled action applies to the scalable target identified
// by those three attributes. You cannot create a scheduled action until you
// have registered the resource as a scalable target using RegisterScalableTarget.
//
// To update an action, specify its name and the parameters that you want to
// change. If you don't specify start and end times, the old values are deleted.
// Any other parameters that you don't specify are not changed by this update
// request.
//
// You can view the scheduled actions using DescribeScheduledActions. If you
// are no longer using a scheduled action, you can delete it using DeleteScheduledAction.
//
// Learn more about how to work with scheduled actions in the Application Auto
// Scaling User Guide (https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation PutScheduledAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A per-account resource limit is exceeded. For more information, see Application
//   Auto Scaling Limits (https://docs.aws.amazon.com/ApplicationAutoScaling/latest/userguide/application-auto-scaling-limits.html).
//
//   * ErrCodeObjectNotFoundException "ObjectNotFoundException"
//   The specified object could not be found. For any operation that depends on
//   the existence of a scalable target, this exception is thrown if the scalable
//   target with the specified service namespace, resource ID, and scalable dimension
//   does not exist. For any operation that deletes or deregisters a resource,
//   this exception is thrown if the resource cannot be found.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScheduledAction
func (c *ApplicationAutoScaling) PutScheduledAction(input *PutScheduledActionInput) (*PutScheduledActionOutput, error) {
	req, out := c.PutScheduledActionRequest(input)
	return out, req.Send()
}

// PutScheduledActionWithContext is the same as PutScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See PutScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) PutScheduledActionWithContext(ctx aws.Context, input *PutScheduledActionInput, opts ...request.Option) (*PutScheduledActionOutput, error) {
	req, out := c.PutScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterScalableTarget = "RegisterScalableTarget"

// RegisterScalableTargetRequest generates a "aws/request.Request" representing the
// client's request for the RegisterScalableTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterScalableTarget for more information on using the RegisterScalableTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterScalableTargetRequest method.
//    req, resp := client.RegisterScalableTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/RegisterScalableTarget
func (c *ApplicationAutoScaling) RegisterScalableTargetRequest(input *RegisterScalableTargetInput) (req *request.Request, output *RegisterScalableTargetOutput) {
	op := &request.Operation{
		Name:       opRegisterScalableTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterScalableTargetInput{}
	}

	output = &RegisterScalableTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterScalableTarget API operation for Application Auto Scaling.
//
// Registers or updates a scalable target. A scalable target is a resource that
// Application Auto Scaling can scale out and scale in. Each scalable target
// has a resource ID, scalable dimension, and namespace, as well as values for
// minimum and maximum capacity.
//
// After you register a scalable target, you do not need to register it again
// to use other Application Auto Scaling operations. To see which resources
// have been registered, use DescribeScalableTargets. You can also view the
// scaling policies for a service namespace using DescribeScalableTargets.
//
// If you no longer need a scalable target, you can deregister it using DeregisterScalableTarget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation RegisterScalableTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A per-account resource limit is exceeded. For more information, see Application
//   Auto Scaling Limits (https://docs.aws.amazon.com/ApplicationAutoScaling/latest/userguide/application-auto-scaling-limits.html).
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/RegisterScalableTarget
func (c *ApplicationAutoScaling) RegisterScalableTarget(input *RegisterScalableTargetInput) (*RegisterScalableTargetOutput, error) {
	req, out := c.RegisterScalableTargetRequest(input)
	return out, req.Send()
}

// RegisterScalableTargetWithContext is the same as RegisterScalableTarget with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterScalableTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) RegisterScalableTargetWithContext(ctx aws.Context, input *RegisterScalableTargetInput, opts ...request.Option) (*RegisterScalableTargetOutput, error) {
	req, out := c.RegisterScalableTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents a CloudWatch alarm associated with a scaling policy.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alarm.
	//
	// AlarmARN is a required field
	AlarmARN *string `type:"string" required:"true"`

	// The name of the alarm.
	//
	// AlarmName is a required field
	AlarmName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alarm) GoString() string {
	return s.String()
}

// SetAlarmARN sets the AlarmARN field's value.
func (s *Alarm) SetAlarmARN(v string) *Alarm {
	s.AlarmARN = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *Alarm) SetAlarmName(v string) *Alarm {
	s.AlarmName = &v
	return s
}

// Represents a CloudWatch metric of your choosing for a target tracking scaling
// policy to use with Application Auto Scaling.
//
// To create your customized metric specification:
//
//    * Add values for each required parameter from CloudWatch. You can use
//    an existing metric, or a new metric that you create. To use your own metric,
//    you must first publish the metric to CloudWatch. For more information,
//    see Publish Custom Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
//    in the Amazon CloudWatch User Guide.
//
//    * Choose a metric that changes proportionally with capacity. The value
//    of the metric should increase or decrease in inverse proportion to the
//    number of capacity units. That is, the value of the metric should decrease
//    when capacity increases.
//
// For more information about CloudWatch, see Amazon CloudWatch Concepts (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html).
type CustomizedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The dimensions of the metric.
	//
	// Conditional: If you published your metric with dimensions, you must specify
	// the same dimensions in your scaling policy.
	Dimensions []*MetricDimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// The statistic of the metric.
	//
	// Statistic is a required field
	Statistic *string `type:"string" required:"true" enum:"MetricStatistic"`

	// The unit of the metric.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s CustomizedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizedMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomizedMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomizedMetricSpecification"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *CustomizedMetricSpecification) SetDimensions(v []*MetricDimension) *CustomizedMetricSpecification {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CustomizedMetricSpecification) SetMetricName(v string) *CustomizedMetricSpecification {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CustomizedMetricSpecification) SetNamespace(v string) *CustomizedMetricSpecification {
	s.Namespace = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CustomizedMetricSpecification) SetStatistic(v string) *CustomizedMetricSpecification {
	s.Statistic = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CustomizedMetricSpecification) SetUnit(v string) *CustomizedMetricSpecification {
	s.Unit = &v
	return s
}

type DeleteScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The identifier of the resource associated with the scalable target. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DeleteScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScalingPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeleteScalingPolicyInput) SetPolicyName(v string) *DeleteScalingPolicyInput {
	s.PolicyName = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteScalingPolicyInput) SetResourceId(v string) *DeleteScalingPolicyInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DeleteScalingPolicyInput) SetScalableDimension(v string) *DeleteScalingPolicyInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DeleteScalingPolicyInput) SetServiceNamespace(v string) *DeleteScalingPolicyInput {
	s.ServiceNamespace = &v
	return s
}

type DeleteScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyOutput) GoString() string {
	return s.String()
}

type DeleteScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the resource associated with the scheduled action. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DeleteScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduledActionInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteScheduledActionInput) SetResourceId(v string) *DeleteScheduledActionInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DeleteScheduledActionInput) SetScalableDimension(v string) *DeleteScheduledActionInput {
	s.ScalableDimension = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *DeleteScheduledActionInput) SetScheduledActionName(v string) *DeleteScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DeleteScheduledActionInput) SetServiceNamespace(v string) *DeleteScheduledActionInput {
	s.ServiceNamespace = &v
	return s
}

type DeleteScheduledActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledActionOutput) GoString() string {
	return s.String()
}

type DeregisterScalableTargetInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the resource associated with the scalable target. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the scalable target. This string consists
	// of the service namespace, resource type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DeregisterScalableTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterScalableTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterScalableTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterScalableTargetInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeregisterScalableTargetInput) SetResourceId(v string) *DeregisterScalableTargetInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DeregisterScalableTargetInput) SetScalableDimension(v string) *DeregisterScalableTargetInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DeregisterScalableTargetInput) SetServiceNamespace(v string) *DeregisterScalableTargetInput {
	s.ServiceNamespace = &v
	return s
}

type DeregisterScalableTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterScalableTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterScalableTargetOutput) GoString() string {
	return s.String()
}

type DescribeScalableTargetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scalable targets. This value can be between 1 and 50.
	// The default value is 50.
	//
	// If this parameter is used, the operation returns up to MaxResults results
	// at a time, along with a NextToken value. To get the next set of results,
	// include the NextToken value in a subsequent call. If this parameter is not
	// used, the operation returns up to 50 results and a NextToken value, if applicable.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The identifier of the resource associated with the scalable target. This
	// string consists of the resource type and unique identifier. If you specify
	// a scalable dimension, you must also specify a resource ID.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	ResourceIds []*string `type:"list"`

	// The scalable dimension associated with the scalable target. This string consists
	// of the service namespace, resource type, and scaling property. If you specify
	// a scalable dimension, you must also specify a resource ID.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DescribeScalableTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalableTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalableTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalableTargetsInput"}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalableTargetsInput) SetMaxResults(v int64) *DescribeScalableTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalableTargetsInput) SetNextToken(v string) *DescribeScalableTargetsInput {
	s.NextToken = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *DescribeScalableTargetsInput) SetResourceIds(v []*string) *DescribeScalableTargetsInput {
	s.ResourceIds = v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DescribeScalableTargetsInput) SetScalableDimension(v string) *DescribeScalableTargetsInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DescribeScalableTargetsInput) SetServiceNamespace(v string) *DescribeScalableTargetsInput {
	s.ServiceNamespace = &v
	return s
}

type DescribeScalableTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// The scalable targets that match the request parameters.
	ScalableTargets []*ScalableTarget `type:"list"`
}

// String returns the string representation
func (s DescribeScalableTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalableTargetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalableTargetsOutput) SetNextToken(v string) *DescribeScalableTargetsOutput {
	s.NextToken = &v
	return s
}

// SetScalableTargets sets the ScalableTargets field's value.
func (s *DescribeScalableTargetsOutput) SetScalableTargets(v []*ScalableTarget) *DescribeScalableTargetsOutput {
	s.ScalableTargets = v
	return s
}

type DescribeScalingActivitiesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scalable targets. This value can be between 1 and 50.
	// The default value is 50.
	//
	// If this parameter is used, the operation returns up to MaxResults results
	// at a time, along with a NextToken value. To get the next set of results,
	// include the NextToken value in a subsequent call. If this parameter is not
	// used, the operation returns up to 50 results and a NextToken value, if applicable.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The identifier of the resource associated with the scaling activity. This
	// string consists of the resource type and unique identifier. If you specify
	// a scalable dimension, you must also specify a resource ID.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	ResourceId *string `min:"1" type:"string"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property. If you specify a scalable dimension, you must
	// also specify a resource ID.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DescribeScalingActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingActivitiesInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalingActivitiesInput) SetMaxResults(v int64) *DescribeScalingActivitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingActivitiesInput) SetNextToken(v string) *DescribeScalingActivitiesInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeScalingActivitiesInput) SetResourceId(v string) *DescribeScalingActivitiesInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DescribeScalingActivitiesInput) SetScalableDimension(v string) *DescribeScalingActivitiesInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DescribeScalingActivitiesInput) SetServiceNamespace(v string) *DescribeScalingActivitiesInput {
	s.ServiceNamespace = &v
	return s
}

type DescribeScalingActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// A list of scaling activity objects.
	ScalingActivities []*ScalingActivity `type:"list"`
}

// String returns the string representation
func (s DescribeScalingActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingActivitiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingActivitiesOutput) SetNextToken(v string) *DescribeScalingActivitiesOutput {
	s.NextToken = &v
	return s
}

// SetScalingActivities sets the ScalingActivities field's value.
func (s *DescribeScalingActivitiesOutput) SetScalingActivities(v []*ScalingActivity) *DescribeScalingActivitiesOutput {
	s.ScalingActivities = v
	return s
}

type DescribeScalingPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scalable targets. This value can be between 1 and 50.
	// The default value is 50.
	//
	// If this parameter is used, the operation returns up to MaxResults results
	// at a time, along with a NextToken value. To get the next set of results,
	// include the NextToken value in a subsequent call. If this parameter is not
	// used, the operation returns up to 50 results and a NextToken value, if applicable.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The names of the scaling policies to describe.
	PolicyNames []*string `type:"list"`

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier. If you specify a scalable
	// dimension, you must also specify a resource ID.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	ResourceId *string `min:"1" type:"string"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property. If you specify a scalable dimension, you must
	// also specify a resource ID.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DescribeScalingPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPoliciesInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalingPoliciesInput) SetMaxResults(v int64) *DescribeScalingPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesInput) SetNextToken(v string) *DescribeScalingPoliciesInput {
	s.NextToken = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *DescribeScalingPoliciesInput) SetPolicyNames(v []*string) *DescribeScalingPoliciesInput {
	s.PolicyNames = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeScalingPoliciesInput) SetResourceId(v string) *DescribeScalingPoliciesInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DescribeScalingPoliciesInput) SetScalableDimension(v string) *DescribeScalingPoliciesInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DescribeScalingPoliciesInput) SetServiceNamespace(v string) *DescribeScalingPoliciesInput {
	s.ServiceNamespace = &v
	return s
}

type DescribeScalingPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the scaling policies.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesOutput) SetNextToken(v string) *DescribeScalingPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetScalingPolicies sets the ScalingPolicies field's value.
func (s *DescribeScalingPoliciesOutput) SetScalingPolicies(v []*ScalingPolicy) *DescribeScalingPoliciesOutput {
	s.ScalingPolicies = v
	return s
}

type DescribeScheduledActionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scheduled action results. This value can be between
	// 1 and 50. The default value is 50.
	//
	// If this parameter is used, the operation returns up to MaxResults results
	// at a time, along with a NextToken value. To get the next set of results,
	// include the NextToken value in a subsequent call. If this parameter is not
	// used, the operation returns up to 50 results and a NextToken value, if applicable.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The identifier of the resource associated with the scheduled action. This
	// string consists of the resource type and unique identifier. If you specify
	// a scalable dimension, you must also specify a resource ID.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	ResourceId *string `min:"1" type:"string"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property. If you specify a scalable dimension, you must
	// also specify a resource ID.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The names of the scheduled actions to describe.
	ScheduledActionNames []*string `type:"list"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DescribeScheduledActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduledActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduledActionsInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScheduledActionsInput) SetMaxResults(v int64) *DescribeScheduledActionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduledActionsInput) SetNextToken(v string) *DescribeScheduledActionsInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeScheduledActionsInput) SetResourceId(v string) *DescribeScheduledActionsInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DescribeScheduledActionsInput) SetScalableDimension(v string) *DescribeScheduledActionsInput {
	s.ScalableDimension = &v
	return s
}

// SetScheduledActionNames sets the ScheduledActionNames field's value.
func (s *DescribeScheduledActionsInput) SetScheduledActionNames(v []*string) *DescribeScheduledActionsInput {
	s.ScheduledActionNames = v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DescribeScheduledActionsInput) SetServiceNamespace(v string) *DescribeScheduledActionsInput {
	s.ServiceNamespace = &v
	return s
}

type DescribeScheduledActionsOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the scheduled actions.
	ScheduledActions []*ScheduledAction `type:"list"`
}

// String returns the string representation
func (s DescribeScheduledActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledActionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduledActionsOutput) SetNextToken(v string) *DescribeScheduledActionsOutput {
	s.NextToken = &v
	return s
}

// SetScheduledActions sets the ScheduledActions field's value.
func (s *DescribeScheduledActionsOutput) SetScheduledActions(v []*ScheduledAction) *DescribeScheduledActionsOutput {
	s.ScheduledActions = v
	return s
}

// Describes the dimension names and values associated with a metric.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MetricDimension) SetName(v string) *MetricDimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDimension) SetValue(v string) *MetricDimension {
	s.Value = &v
	return s
}

// Represents a predefined metric for a target tracking scaling policy to use
// with Application Auto Scaling.
type PredefinedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The metric type. The ALBRequestCountPerTarget metric type applies only to
	// Spot fleet requests and ECS services.
	//
	// PredefinedMetricType is a required field
	PredefinedMetricType *string `type:"string" required:"true" enum:"MetricType"`

	// Identifies the resource associated with the metric type. You can't specify
	// a resource label unless the metric type is ALBRequestCountPerTarget and there
	// is a target group attached to the Spot fleet request or ECS service.
	//
	// The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
	// where:
	//
	//    * app/<load-balancer-name>/<load-balancer-id> is the final portion of
	//    the load balancer ARN
	//
	//    * targetgroup/<target-group-name>/<target-group-id> is the final portion
	//    of the target group ARN.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PredefinedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredefinedMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredefinedMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredefinedMetricSpecification"}
	if s.PredefinedMetricType == nil {
		invalidParams.Add(request.NewErrParamRequired("PredefinedMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefinedMetricType sets the PredefinedMetricType field's value.
func (s *PredefinedMetricSpecification) SetPredefinedMetricType(v string) *PredefinedMetricSpecification {
	s.PredefinedMetricType = &v
	return s
}

// SetResourceLabel sets the ResourceLabel field's value.
func (s *PredefinedMetricSpecification) SetResourceLabel(v string) *PredefinedMetricSpecification {
	s.ResourceLabel = &v
	return s
}

type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The policy type. This parameter is required if you are creating a scaling
	// policy.
	//
	// For information on which services do not support StepScaling or TargetTrackingScaling,
	// see Step Scaling Policies for Application Auto Scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
	// and Target Tracking Scaling Policies for Application Auto Scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
	// in the Application Auto Scaling User Guide.
	PolicyType *string `type:"string" enum:"PolicyType"`

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// A step scaling policy.
	//
	// This parameter is required if you are creating a policy and the policy type
	// is StepScaling.
	StepScalingPolicyConfiguration *StepScalingPolicyConfiguration `type:"structure"`

	// A target tracking scaling policy. Includes support for predefined or customized
	// metrics.
	//
	// This parameter is required if you are creating a policy and the policy type
	// is TargetTrackingScaling.
	TargetTrackingScalingPolicyConfiguration *TargetTrackingScalingPolicyConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScalingPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}
	if s.StepScalingPolicyConfiguration != nil {
		if err := s.StepScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StepScalingPolicyConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetTrackingScalingPolicyConfiguration != nil {
		if err := s.TargetTrackingScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetTrackingScalingPolicyConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *PutScalingPolicyInput) SetPolicyName(v string) *PutScalingPolicyInput {
	s.PolicyName = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *PutScalingPolicyInput) SetPolicyType(v string) *PutScalingPolicyInput {
	s.PolicyType = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutScalingPolicyInput) SetResourceId(v string) *PutScalingPolicyInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *PutScalingPolicyInput) SetScalableDimension(v string) *PutScalingPolicyInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *PutScalingPolicyInput) SetServiceNamespace(v string) *PutScalingPolicyInput {
	s.ServiceNamespace = &v
	return s
}

// SetStepScalingPolicyConfiguration sets the StepScalingPolicyConfiguration field's value.
func (s *PutScalingPolicyInput) SetStepScalingPolicyConfiguration(v *StepScalingPolicyConfiguration) *PutScalingPolicyInput {
	s.StepScalingPolicyConfiguration = v
	return s
}

// SetTargetTrackingScalingPolicyConfiguration sets the TargetTrackingScalingPolicyConfiguration field's value.
func (s *PutScalingPolicyInput) SetTargetTrackingScalingPolicyConfiguration(v *TargetTrackingScalingPolicyConfiguration) *PutScalingPolicyInput {
	s.TargetTrackingScalingPolicyConfiguration = v
	return s
}

type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarms created for the target tracking scaling policy.
	Alarms []*Alarm `type:"list"`

	// The Amazon Resource Name (ARN) of the resulting scaling policy.
	//
	// PolicyARN is a required field
	PolicyARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyOutput) GoString() string {
	return s.String()
}

// SetAlarms sets the Alarms field's value.
func (s *PutScalingPolicyOutput) SetAlarms(v []*Alarm) *PutScalingPolicyOutput {
	s.Alarms = v
	return s
}

// SetPolicyARN sets the PolicyARN field's value.
func (s *PutScalingPolicyOutput) SetPolicyARN(v string) *PutScalingPolicyOutput {
	s.PolicyARN = &v
	return s
}

type PutScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The date and time for the scheduled action to end.
	EndTime *time.Time `type:"timestamp"`

	// The identifier of the resource associated with the scheduled action. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The new minimum and maximum capacity. You can set both values or just one.
	// During the scheduled time, if the current capacity is below the minimum capacity,
	// Application Auto Scaling scales out to the minimum capacity. If the current
	// capacity is above the maximum capacity, Application Auto Scaling scales in
	// to the maximum capacity.
	ScalableTargetAction *ScalableTargetAction `type:"structure"`

	// The schedule for this action. The following formats are supported:
	//
	//    * At expressions - "at(yyyy-mm-ddThh:mm:ss)"
	//
	//    * Rate expressions - "rate(valueunit)"
	//
	//    * Cron expressions - "cron(fields)"
	//
	// At expressions are useful for one-time schedules. Specify the time, in UTC.
	//
	// For rate expressions, value is a positive integer and unit is minute | minutes
	// | hour | hours | day | days.
	//
	// For more information about cron expressions, see Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Schedule *string `min:"1" type:"string"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The date and time for the scheduled action to start.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s PutScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScheduledActionInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.Schedule != nil && len(*s.Schedule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schedule", 1))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *PutScheduledActionInput) SetEndTime(v time.Time) *PutScheduledActionInput {
	s.EndTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutScheduledActionInput) SetResourceId(v string) *PutScheduledActionInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *PutScheduledActionInput) SetScalableDimension(v string) *PutScheduledActionInput {
	s.ScalableDimension = &v
	return s
}

// SetScalableTargetAction sets the ScalableTargetAction field's value.
func (s *PutScheduledActionInput) SetScalableTargetAction(v *ScalableTargetAction) *PutScheduledActionInput {
	s.ScalableTargetAction = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *PutScheduledActionInput) SetSchedule(v string) *PutScheduledActionInput {
	s.Schedule = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *PutScheduledActionInput) SetScheduledActionName(v string) *PutScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *PutScheduledActionInput) SetServiceNamespace(v string) *PutScheduledActionInput {
	s.ServiceNamespace = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PutScheduledActionInput) SetStartTime(v time.Time) *PutScheduledActionInput {
	s.StartTime = &v
	return s
}

type PutScheduledActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScheduledActionOutput) GoString() string {
	return s.String()
}

type RegisterScalableTargetInput struct {
	_ struct{} `type:"structure"`

	// The maximum value to scale to in response to a scale-out event. This parameter
	// is required to register a scalable target.
	MaxCapacity *int64 `type:"integer"`

	// The minimum value to scale to in response to a scale-in event. This parameter
	// is required to register a scalable target.
	MinCapacity *int64 `type:"integer"`

	// The identifier of the resource associated with the scalable target. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// Application Auto Scaling creates a service-linked role that grants it permissions
	// to modify the scalable target on your behalf. For more information, see Service-Linked
	// Roles for Application Auto Scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-service-linked-roles.html).
	//
	// For resources that are not supported using a service-linked role, this parameter
	// is required and must specify the ARN of an IAM role that allows Application
	// Auto Scaling to modify the scalable target on your behalf.
	RoleARN *string `min:"1" type:"string"`

	// The scalable dimension associated with the scalable target. This string consists
	// of the service namespace, resource type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s RegisterScalableTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterScalableTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterScalableTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterScalableTargetInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *RegisterScalableTargetInput) SetMaxCapacity(v int64) *RegisterScalableTargetInput {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *RegisterScalableTargetInput) SetMinCapacity(v int64) *RegisterScalableTargetInput {
	s.MinCapacity = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *RegisterScalableTargetInput) SetResourceId(v string) *RegisterScalableTargetInput {
	s.ResourceId = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *RegisterScalableTargetInput) SetRoleARN(v string) *RegisterScalableTargetInput {
	s.RoleARN = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *RegisterScalableTargetInput) SetScalableDimension(v string) *RegisterScalableTargetInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *RegisterScalableTargetInput) SetServiceNamespace(v string) *RegisterScalableTargetInput {
	s.ServiceNamespace = &v
	return s
}

type RegisterScalableTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterScalableTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterScalableTargetOutput) GoString() string {
	return s.String()
}

// Represents a scalable target.
type ScalableTarget struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for when the scalable target was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The maximum value to scale to in response to a scale-out event.
	//
	// MaxCapacity is a required field
	MaxCapacity *int64 `type:"integer" required:"true"`

	// The minimum value to scale to in response to a scale-in event.
	//
	// MinCapacity is a required field
	MinCapacity *int64 `type:"integer" required:"true"`

	// The identifier of the resource associated with the scalable target. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The ARN of an IAM role that allows Application Auto Scaling to modify the
	// scalable target on your behalf.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the scalable target. This string consists
	// of the service namespace, resource type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s ScalableTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalableTarget) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScalableTarget) SetCreationTime(v time.Time) *ScalableTarget {
	s.CreationTime = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *ScalableTarget) SetMaxCapacity(v int64) *ScalableTarget {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *ScalableTarget) SetMinCapacity(v int64) *ScalableTarget {
	s.MinCapacity = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalableTarget) SetResourceId(v string) *ScalableTarget {
	s.ResourceId = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ScalableTarget) SetRoleARN(v string) *ScalableTarget {
	s.RoleARN = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalableTarget) SetScalableDimension(v string) *ScalableTarget {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalableTarget) SetServiceNamespace(v string) *ScalableTarget {
	s.ServiceNamespace = &v
	return s
}

// Represents the minimum and maximum capacity for a scheduled action.
type ScalableTargetAction struct {
	_ struct{} `type:"structure"`

	// The maximum capacity.
	MaxCapacity *int64 `type:"integer"`

	// The minimum capacity.
	MinCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s ScalableTargetAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalableTargetAction) GoString() string {
	return s.String()
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *ScalableTargetAction) SetMaxCapacity(v int64) *ScalableTargetAction {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *ScalableTargetAction) SetMinCapacity(v int64) *ScalableTargetAction {
	s.MinCapacity = &v
	return s
}

// Represents a scaling activity.
type ScalingActivity struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the scaling activity.
	//
	// ActivityId is a required field
	ActivityId *string `type:"string" required:"true"`

	// A simple description of what caused the scaling activity to happen.
	//
	// Cause is a required field
	Cause *string `type:"string" required:"true"`

	// A simple description of what action the scaling activity intends to accomplish.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The details about the scaling activity.
	Details *string `type:"string"`

	// The Unix timestamp for when the scaling activity ended.
	EndTime *time.Time `type:"timestamp"`

	// The identifier of the resource associated with the scaling activity. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The Unix timestamp for when the scaling activity began.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// Indicates the status of the scaling activity.
	//
	// StatusCode is a required field
	StatusCode *string `type:"string" required:"true" enum:"ScalingActivityStatusCode"`

	// A simple message about the current status of the scaling activity.
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s ScalingActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingActivity) GoString() string {
	return s.String()
}

// SetActivityId sets the ActivityId field's value.
func (s *ScalingActivity) SetActivityId(v string) *ScalingActivity {
	s.ActivityId = &v
	return s
}

// SetCause sets the Cause field's value.
func (s *ScalingActivity) SetCause(v string) *ScalingActivity {
	s.Cause = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ScalingActivity) SetDescription(v string) *ScalingActivity {
	s.Description = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ScalingActivity) SetDetails(v string) *ScalingActivity {
	s.Details = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ScalingActivity) SetEndTime(v time.Time) *ScalingActivity {
	s.EndTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalingActivity) SetResourceId(v string) *ScalingActivity {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalingActivity) SetScalableDimension(v string) *ScalingActivity {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalingActivity) SetServiceNamespace(v string) *ScalingActivity {
	s.ServiceNamespace = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScalingActivity) SetStartTime(v time.Time) *ScalingActivity {
	s.StartTime = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ScalingActivity) SetStatusCode(v string) *ScalingActivity {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ScalingActivity) SetStatusMessage(v string) *ScalingActivity {
	s.StatusMessage = &v
	return s
}

// Represents a scaling policy to use with Application Auto Scaling.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarms associated with the scaling policy.
	Alarms []*Alarm `type:"list"`

	// The Unix timestamp for when the scaling policy was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the scaling policy.
	//
	// PolicyARN is a required field
	PolicyARN *string `min:"1" type:"string" required:"true"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The scaling policy type.
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"PolicyType"`

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// A step scaling policy.
	StepScalingPolicyConfiguration *StepScalingPolicyConfiguration `type:"structure"`

	// A target tracking scaling policy.
	TargetTrackingScalingPolicyConfiguration *TargetTrackingScalingPolicyConfiguration `type:"structure"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// SetAlarms sets the Alarms field's value.
func (s *ScalingPolicy) SetAlarms(v []*Alarm) *ScalingPolicy {
	s.Alarms = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScalingPolicy) SetCreationTime(v time.Time) *ScalingPolicy {
	s.CreationTime = &v
	return s
}

// SetPolicyARN sets the PolicyARN field's value.
func (s *ScalingPolicy) SetPolicyARN(v string) *ScalingPolicy {
	s.PolicyARN = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ScalingPolicy) SetPolicyName(v string) *ScalingPolicy {
	s.PolicyName = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *ScalingPolicy) SetPolicyType(v string) *ScalingPolicy {
	s.PolicyType = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalingPolicy) SetResourceId(v string) *ScalingPolicy {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalingPolicy) SetScalableDimension(v string) *ScalingPolicy {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalingPolicy) SetServiceNamespace(v string) *ScalingPolicy {
	s.ServiceNamespace = &v
	return s
}

// SetStepScalingPolicyConfiguration sets the StepScalingPolicyConfiguration field's value.
func (s *ScalingPolicy) SetStepScalingPolicyConfiguration(v *StepScalingPolicyConfiguration) *ScalingPolicy {
	s.StepScalingPolicyConfiguration = v
	return s
}

// SetTargetTrackingScalingPolicyConfiguration sets the TargetTrackingScalingPolicyConfiguration field's value.
func (s *ScalingPolicy) SetTargetTrackingScalingPolicyConfiguration(v *TargetTrackingScalingPolicyConfiguration) *ScalingPolicy {
	s.TargetTrackingScalingPolicyConfiguration = v
	return s
}

// Represents a scheduled action.
type ScheduledAction struct {
	_ struct{} `type:"structure"`

	// The date and time that the scheduled action was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The date and time that the action is scheduled to end.
	EndTime *time.Time `type:"timestamp"`

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variants - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The new minimum and maximum capacity. You can set both values or just one.
	// During the scheduled time, if the current capacity is below the minimum capacity,
	// Application Auto Scaling scales out to the minimum capacity. If the current
	// capacity is above the maximum capacity, Application Auto Scaling scales in
	// to the maximum capacity.
	ScalableTargetAction *ScalableTargetAction `type:"structure"`

	// The schedule for this action. The following formats are supported:
	//
	//    * At expressions - "at(yyyy-mm-ddThh:mm:ss)"
	//
	//    * Rate expressions - "rate(valueunit)"
	//
	//    * Cron expressions - "cron(fields)"
	//
	// At expressions are useful for one-time schedules. Specify the time, in UTC.
	//
	// For rate expressions, value is a positive integer and unit is minute | minutes
	// | hour | hours | day | days.
	//
	// For more information about cron expressions, see Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	//
	// Schedule is a required field
	Schedule *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the scheduled action.
	//
	// ScheduledActionARN is a required field
	ScheduledActionARN *string `min:"1" type:"string" required:"true"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The date and time that the action is scheduled to begin.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ScheduledAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduledAction) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScheduledAction) SetCreationTime(v time.Time) *ScheduledAction {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ScheduledAction) SetEndTime(v time.Time) *ScheduledAction {
	s.EndTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScheduledAction) SetResourceId(v string) *ScheduledAction {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScheduledAction) SetScalableDimension(v string) *ScheduledAction {
	s.ScalableDimension = &v
	return s
}

// SetScalableTargetAction sets the ScalableTargetAction field's value.
func (s *ScheduledAction) SetScalableTargetAction(v *ScalableTargetAction) *ScheduledAction {
	s.ScalableTargetAction = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *ScheduledAction) SetSchedule(v string) *ScheduledAction {
	s.Schedule = &v
	return s
}

// SetScheduledActionARN sets the ScheduledActionARN field's value.
func (s *ScheduledAction) SetScheduledActionARN(v string) *ScheduledAction {
	s.ScheduledActionARN = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *ScheduledAction) SetScheduledActionName(v string) *ScheduledAction {
	s.ScheduledActionName = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScheduledAction) SetServiceNamespace(v string) *ScheduledAction {
	s.ServiceNamespace = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScheduledAction) SetStartTime(v time.Time) *ScheduledAction {
	s.StartTime = &v
	return s
}

// Represents a step adjustment for a StepScalingPolicyConfiguration. Describes
// an adjustment based on the difference between the value of the aggregated
// CloudWatch metric and the breach threshold that you've defined for the alarm.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//    * To trigger the adjustment when the metric is greater than or equal to
//    50 and less than 60, specify a lower bound of 0 and an upper bound of
//    10.
//
//    * To trigger the adjustment when the metric is greater than 40 and less
//    than or equal to 50, specify a lower bound of -10 and an upper bound of
//    0.
//
// There are a few rules for the step adjustments for your step policy:
//
//    * The ranges of your step adjustments can't overlap or have a gap.
//
//    * At most one step adjustment can have a null lower bound. If one step
//    adjustment has a negative lower bound, then there must be a step adjustment
//    with a null lower bound.
//
//    * At most one step adjustment can have a null upper bound. If one step
//    adjustment has a positive upper bound, then there must be a step adjustment
//    with a null upper bound.
//
//    * The upper and lower bound can't be null in the same step adjustment.
type StepAdjustment struct {
	_ struct{} `type:"structure"`

	// The lower bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the lower bound
	// is inclusive (the metric must be greater than or equal to the threshold plus
	// the lower bound). Otherwise, it is exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64 `type:"double"`

	// The upper bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the upper bound
	// is exclusive (the metric must be less than the threshold plus the upper bound).
	// Otherwise, it is inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64 `type:"double"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current scalable dimension while a negative number removes
	// from the current scalable dimension.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StepAdjustment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepAdjustment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepAdjustment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepAdjustment"}
	if s.ScalingAdjustment == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingAdjustment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricIntervalLowerBound sets the MetricIntervalLowerBound field's value.
func (s *StepAdjustment) SetMetricIntervalLowerBound(v float64) *StepAdjustment {
	s.MetricIntervalLowerBound = &v
	return s
}

// SetMetricIntervalUpperBound sets the MetricIntervalUpperBound field's value.
func (s *StepAdjustment) SetMetricIntervalUpperBound(v float64) *StepAdjustment {
	s.MetricIntervalUpperBound = &v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *StepAdjustment) SetScalingAdjustment(v int64) *StepAdjustment {
	s.ScalingAdjustment = &v
	return s
}

// Represents a step scaling policy configuration to use with Application Auto
// Scaling.
type StepScalingPolicyConfiguration struct {
	_ struct{} `type:"structure"`

	// The adjustment type, which specifies how the ScalingAdjustment parameter
	// in a StepAdjustment is interpreted.
	AdjustmentType *string `type:"string" enum:"AdjustmentType"`

	// The amount of time, in seconds, after a scaling activity completes where
	// previous trigger-related scaling activities can influence future scaling
	// events.
	//
	// For scale-out policies, while the cooldown period is in effect, the capacity
	// that has been added by the previous scale-out event that initiated the cooldown
	// is calculated as part of the desired capacity for the next scale out. The
	// intention is to continuously (but not excessively) scale out. For example,
	// an alarm triggers a step scaling policy to scale out an Amazon ECS service
	// by 2 tasks, the scaling activity completes successfully, and a cooldown period
	// of 5 minutes starts. During the cooldown period, if the alarm triggers the
	// same policy again but at a more aggressive step adjustment to scale out the
	// service by 3 tasks, the 2 tasks that were added in the previous scale-out
	// event are considered part of that capacity and only 1 additional task is
	// added to the desired count.
	//
	// For scale-in policies, the cooldown period is used to block subsequent scale-in
	// requests until it has expired. The intention is to scale in conservatively
	// to protect your application's availability. However, if another alarm triggers
	// a scale-out policy during the cooldown period after a scale-in, Application
	// Auto Scaling scales out your scalable target immediately.
	Cooldown *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. Valid values are Minimum,
	// Maximum, and Average. If the aggregation type is null, the value is treated
	// as Average.
	MetricAggregationType *string `type:"string" enum:"MetricAggregationType"`

	// The minimum number to adjust your scalable dimension as a result of a scaling
	// activity. If the adjustment type is PercentChangeInCapacity, the scaling
	// policy changes the scalable dimension of the scalable target by this amount.
	//
	// For example, suppose that you create a step scaling policy to scale out an
	// Amazon ECS service by 25 percent and you specify a MinAdjustmentMagnitude
	// of 2. If the service has 4 tasks and the scaling policy is performed, 25
	// percent of 4 is 1. However, because you specified a MinAdjustmentMagnitude
	// of 2, Application Auto Scaling scales out the service by 2 tasks.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	StepAdjustments []*StepAdjustment `type:"list"`
}

// String returns the string representation
func (s StepScalingPolicyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepScalingPolicyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepScalingPolicyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepScalingPolicyConfiguration"}
	if s.StepAdjustments != nil {
		for i, v := range s.StepAdjustments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StepAdjustments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdjustmentType sets the AdjustmentType field's value.
func (s *StepScalingPolicyConfiguration) SetAdjustmentType(v string) *StepScalingPolicyConfiguration {
	s.AdjustmentType = &v
	return s
}

// SetCooldown sets the Cooldown field's value.
func (s *StepScalingPolicyConfiguration) SetCooldown(v int64) *StepScalingPolicyConfiguration {
	s.Cooldown = &v
	return s
}

// SetMetricAggregationType sets the MetricAggregationType field's value.
func (s *StepScalingPolicyConfiguration) SetMetricAggregationType(v string) *StepScalingPolicyConfiguration {
	s.MetricAggregationType = &v
	return s
}

// SetMinAdjustmentMagnitude sets the MinAdjustmentMagnitude field's value.
func (s *StepScalingPolicyConfiguration) SetMinAdjustmentMagnitude(v int64) *StepScalingPolicyConfiguration {
	s.MinAdjustmentMagnitude = &v
	return s
}

// SetStepAdjustments sets the StepAdjustments field's value.
func (s *StepScalingPolicyConfiguration) SetStepAdjustments(v []*StepAdjustment) *StepScalingPolicyConfiguration {
	s.StepAdjustments = v
	return s
}

// Represents a target tracking scaling policy configuration to use with Application
// Auto Scaling.
type TargetTrackingScalingPolicyConfiguration struct {
	_ struct{} `type:"structure"`

	// A customized metric. You can specify either a predefined metric or a customized
	// metric.
	CustomizedMetricSpecification *CustomizedMetricSpecification `type:"structure"`

	// Indicates whether scale in by the target tracking scaling policy is disabled.
	// If the value is true, scale in is disabled and the target tracking scaling
	// policy won't remove capacity from the scalable resource. Otherwise, scale
	// in is enabled and the target tracking scaling policy can remove capacity
	// from the scalable resource. The default value is false.
	DisableScaleIn *bool `type:"boolean"`

	// A predefined metric. You can specify either a predefined metric or a customized
	// metric.
	PredefinedMetricSpecification *PredefinedMetricSpecification `type:"structure"`

	// The amount of time, in seconds, after a scale-in activity completes before
	// another scale in activity can start.
	//
	// The cooldown period is used to block subsequent scale-in requests until it
	// has expired. The intention is to scale in conservatively to protect your
	// application's availability. However, if another alarm triggers a scale-out
	// policy during the cooldown period after a scale-in, Application Auto Scaling
	// scales out your scalable target immediately.
	ScaleInCooldown *int64 `type:"integer"`

	// The amount of time, in seconds, after a scale-out activity completes before
	// another scale-out activity can start.
	//
	// While the cooldown period is in effect, the capacity that has been added
	// by the previous scale-out event that initiated the cooldown is calculated
	// as part of the desired capacity for the next scale out. The intention is
	// to continuously (but not excessively) scale out.
	ScaleOutCooldown *int64 `type:"integer"`

	// The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
	// (Base 10) or 2e-360 to 2e360 (Base 2).
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s TargetTrackingScalingPolicyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetTrackingScalingPolicyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingScalingPolicyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetTrackingScalingPolicyConfiguration"}
	if s.TargetValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetValue"))
	}
	if s.CustomizedMetricSpecification != nil {
		if err := s.CustomizedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedMetricSpecification != nil {
		if err := s.PredefinedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedMetricSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomizedMetricSpecification sets the CustomizedMetricSpecification field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetCustomizedMetricSpecification(v *CustomizedMetricSpecification) *TargetTrackingScalingPolicyConfiguration {
	s.CustomizedMetricSpecification = v
	return s
}

// SetDisableScaleIn sets the DisableScaleIn field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetDisableScaleIn(v bool) *TargetTrackingScalingPolicyConfiguration {
	s.DisableScaleIn = &v
	return s
}

// SetPredefinedMetricSpecification sets the PredefinedMetricSpecification field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetPredefinedMetricSpecification(v *PredefinedMetricSpecification) *TargetTrackingScalingPolicyConfiguration {
	s.PredefinedMetricSpecification = v
	return s
}

// SetScaleInCooldown sets the ScaleInCooldown field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetScaleInCooldown(v int64) *TargetTrackingScalingPolicyConfiguration {
	s.ScaleInCooldown = &v
	return s
}

// SetScaleOutCooldown sets the ScaleOutCooldown field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetScaleOutCooldown(v int64) *TargetTrackingScalingPolicyConfiguration {
	s.ScaleOutCooldown = &v
	return s
}

// SetTargetValue sets the TargetValue field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetTargetValue(v float64) *TargetTrackingScalingPolicyConfiguration {
	s.TargetValue = &v
	return s
}

const (
	// AdjustmentTypeChangeInCapacity is a AdjustmentType enum value
	AdjustmentTypeChangeInCapacity = "ChangeInCapacity"

	// AdjustmentTypePercentChangeInCapacity is a AdjustmentType enum value
	AdjustmentTypePercentChangeInCapacity = "PercentChangeInCapacity"

	// AdjustmentTypeExactCapacity is a AdjustmentType enum value
	AdjustmentTypeExactCapacity = "ExactCapacity"
)

const (
	// MetricAggregationTypeAverage is a MetricAggregationType enum value
	MetricAggregationTypeAverage = "Average"

	// MetricAggregationTypeMinimum is a MetricAggregationType enum value
	MetricAggregationTypeMinimum = "Minimum"

	// MetricAggregationTypeMaximum is a MetricAggregationType enum value
	MetricAggregationTypeMaximum = "Maximum"
)

const (
	// MetricStatisticAverage is a MetricStatistic enum value
	MetricStatisticAverage = "Average"

	// MetricStatisticMinimum is a MetricStatistic enum value
	MetricStatisticMinimum = "Minimum"

	// MetricStatisticMaximum is a MetricStatistic enum value
	MetricStatisticMaximum = "Maximum"

	// MetricStatisticSampleCount is a MetricStatistic enum value
	MetricStatisticSampleCount = "SampleCount"

	// MetricStatisticSum is a MetricStatistic enum value
	MetricStatisticSum = "Sum"
)

const (
	// MetricTypeDynamoDbreadCapacityUtilization is a MetricType enum value
	MetricTypeDynamoDbreadCapacityUtilization = "DynamoDBReadCapacityUtilization"

	// MetricTypeDynamoDbwriteCapacityUtilization is a MetricType enum value
	MetricTypeDynamoDbwriteCapacityUtilization = "DynamoDBWriteCapacityUtilization"

	// MetricTypeAlbrequestCountPerTarget is a MetricType enum value
	MetricTypeAlbrequestCountPerTarget = "ALBRequestCountPerTarget"

	// MetricTypeRdsreaderAverageCpuutilization is a MetricType enum value
	MetricTypeRdsreaderAverageCpuutilization = "RDSReaderAverageCPUUtilization"

	// MetricTypeRdsreaderAverageDatabaseConnections is a MetricType enum value
	MetricTypeRdsreaderAverageDatabaseConnections = "RDSReaderAverageDatabaseConnections"

	// MetricTypeEc2spotFleetRequestAverageCpuutilization is a MetricType enum value
	MetricTypeEc2spotFleetRequestAverageCpuutilization = "EC2SpotFleetRequestAverageCPUUtilization"

	// MetricTypeEc2spotFleetRequestAverageNetworkIn is a MetricType enum value
	MetricTypeEc2spotFleetRequestAverageNetworkIn = "EC2SpotFleetRequestAverageNetworkIn"

	// MetricTypeEc2spotFleetRequestAverageNetworkOut is a MetricType enum value
	MetricTypeEc2spotFleetRequestAverageNetworkOut = "EC2SpotFleetRequestAverageNetworkOut"

	// MetricTypeSageMakerVariantInvocationsPerInstance is a MetricType enum value
	MetricTypeSageMakerVariantInvocationsPerInstance = "SageMakerVariantInvocationsPerInstance"

	// MetricTypeEcsserviceAverageCpuutilization is a MetricType enum value
	MetricTypeEcsserviceAverageCpuutilization = "ECSServiceAverageCPUUtilization"

	// MetricTypeEcsserviceAverageMemoryUtilization is a MetricType enum value
	MetricTypeEcsserviceAverageMemoryUtilization = "ECSServiceAverageMemoryUtilization"
)

const (
	// PolicyTypeStepScaling is a PolicyType enum value
	PolicyTypeStepScaling = "StepScaling"

	// PolicyTypeTargetTrackingScaling is a PolicyType enum value
	PolicyTypeTargetTrackingScaling = "TargetTrackingScaling"
)

const (
	// ScalableDimensionEcsServiceDesiredCount is a ScalableDimension enum value
	ScalableDimensionEcsServiceDesiredCount = "ecs:service:DesiredCount"

	// ScalableDimensionEc2SpotFleetRequestTargetCapacity is a ScalableDimension enum value
	ScalableDimensionEc2SpotFleetRequestTargetCapacity = "ec2:spot-fleet-request:TargetCapacity"

	// ScalableDimensionElasticmapreduceInstancegroupInstanceCount is a ScalableDimension enum value
	ScalableDimensionElasticmapreduceInstancegroupInstanceCount = "elasticmapreduce:instancegroup:InstanceCount"

	// ScalableDimensionAppstreamFleetDesiredCapacity is a ScalableDimension enum value
	ScalableDimensionAppstreamFleetDesiredCapacity = "appstream:fleet:DesiredCapacity"

	// ScalableDimensionDynamodbTableReadCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbTableReadCapacityUnits = "dynamodb:table:ReadCapacityUnits"

	// ScalableDimensionDynamodbTableWriteCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbTableWriteCapacityUnits = "dynamodb:table:WriteCapacityUnits"

	// ScalableDimensionDynamodbIndexReadCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbIndexReadCapacityUnits = "dynamodb:index:ReadCapacityUnits"

	// ScalableDimensionDynamodbIndexWriteCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbIndexWriteCapacityUnits = "dynamodb:index:WriteCapacityUnits"

	// ScalableDimensionRdsClusterReadReplicaCount is a ScalableDimension enum value
	ScalableDimensionRdsClusterReadReplicaCount = "rds:cluster:ReadReplicaCount"

	// ScalableDimensionSagemakerVariantDesiredInstanceCount is a ScalableDimension enum value
	ScalableDimensionSagemakerVariantDesiredInstanceCount = "sagemaker:variant:DesiredInstanceCount"

	// ScalableDimensionCustomResourceResourceTypeProperty is a ScalableDimension enum value
	ScalableDimensionCustomResourceResourceTypeProperty = "custom-resource:ResourceType:Property"
)

const (
	// ScalingActivityStatusCodePending is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodePending = "Pending"

	// ScalingActivityStatusCodeInProgress is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeInProgress = "InProgress"

	// ScalingActivityStatusCodeSuccessful is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeSuccessful = "Successful"

	// ScalingActivityStatusCodeOverridden is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeOverridden = "Overridden"

	// ScalingActivityStatusCodeUnfulfilled is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeUnfulfilled = "Unfulfilled"

	// ScalingActivityStatusCodeFailed is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeFailed = "Failed"
)

const (
	// ServiceNamespaceEcs is a ServiceNamespace enum value
	ServiceNamespaceEcs = "ecs"

	// ServiceNamespaceElasticmapreduce is a ServiceNamespace enum value
	ServiceNamespaceElasticmapreduce = "elasticmapreduce"

	// ServiceNamespaceEc2 is a ServiceNamespace enum value
	ServiceNamespaceEc2 = "ec2"

	// ServiceNamespaceAppstream is a ServiceNamespace enum value
	ServiceNamespaceAppstream = "appstream"

	// ServiceNamespaceDynamodb is a ServiceNamespace enum value
	ServiceNamespaceDynamodb = "dynamodb"

	// ServiceNamespaceRds is a ServiceNamespace enum value
	ServiceNamespaceRds = "rds"

	// ServiceNamespaceSagemaker is a ServiceNamespace enum value
	ServiceNamespaceSagemaker = "sagemaker"

	// ServiceNamespaceCustomResource is a ServiceNamespace enum value
	ServiceNamespaceCustomResource = "custom-resource"
)
