package vm

import (
	"testing"

	"gotest.tools/assert"
)

func TestAddHostNameToUserData(t *testing.T) {
	userData := "{\"ignition\":{\"config\":{\"merge\":[{\"source\":\"https://192.168.123.15:22623/config/worker\"}]},\"security\":{\"tls\":{\"certificateAuthorities\":[{\"source\":\"data:text/plain;charset=utf-8;base64,LS0tLS1CRUdJTiBDRVJUSUZJQ0FURS0tLS0tCk1JSURFRENDQWZpZ0F3SUJBZ0lJS01BN3hKRW5lWXd3RFFZSktvWklodmNOQVFFTEJRQXdKakVTTUJBR0ExVUUKQ3hNSmIzQmxibk5vYVdaME1SQXdEZ1lEVlFRREV3ZHliMjkwTFdOaE1CNFhEVEl3TVRBeU5URXpNRGt4TVZvWApEVE13TVRBeU16RXpNRGt4TVZvd0pqRVNNQkFHQTFVRUN4TUpiM0JsYm5Ob2FXWjBNUkF3RGdZRFZRUURFd2R5CmIyOTBMV05oTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUFyTnhDRFR5bWUzVlgKQWJkK1JIUnhPQnp4SkNiclZlVmJ4SVptVXl5Mk5KdmR6cXdHUWtEdU9weEdHaGNTS09KVFdvNTZwcG9xci9JTgpTVmlxamovME9uU1Z1aVJiS1c4dkRnSCswNmxjMHlzMFdQRnZTUS9RQURjVlMya3BoZlA5ZEgybTl0YmJDckJ6CnMva0Q0aFdtWGptTHhWMlZCakp3NnFMQjA2d0NVcVJkOUM5Tzd5T1VxaEV1UWpCZ0xzK1dlcWV2WGtlZnd1ZlkKUmR6OE5XYkpVOVY0endkUTUxc3pCdGRxTmcrallzVVFvSUZDbWZiOERLVGV2N1NTTitwUXFkVlgrOUNDcWtZMwpia0ZhbHlVa0YzN2RYRjNmdXdWeHFqTWVpTDY5c3dMRE5vQjZCUjRXamVhd0V3b1JwS2VyVm5sT1FZQzYxalVqCjdJdVRiUHplbXdJREFRQUJvMEl3UURBT0JnTlZIUThCQWY4RUJBTUNBcVF3RHdZRFZSMFRBUUgvQkFVd0F3RUIKL3pBZEJnTlZIUTRFRmdRVXNncW05VVNlNXdDcHg2TzRzZFV3VFVmZTdxRXdEUVlKS29aSWh2Y05BUUVMQlFBRApnZ0VCQUFYRnFZblBmK2VrTmlaOFJHbEpjckJldHV4Mkgwc1FPb001Rkt4dVhZSC9iNEYzYWw0bUhjdDJMYk5VCittVGxoZk4yNlFOQ3FsZkF4MWhIaWJueFZFeTlxUWJtSnFoUU1kcm5vYi83bmFPeFRsZEUxdVNWSmFpUEt1S0sKZWhtQjlRL1l1WGJMeG84SjBBMndOWHBJL1NwTUVRbEgzSmZVTHdqRTNqaVVIR25GdkMvcy8vNHhRU2c4M3Y0NQpLZnBOVlhsRVAvaVdRYWo0UXhXbGxTUVkwbnc2RmdpbUxwa3huLzJ2aUlTeVcvT0N2YTRzdzFFS2IzM1BhTnhOCjhnd3ZLNnhFUlNDVGNPTEJxbnJseUErTmVINjY2YXFCclY0TEFZclZsUXhKOWd0YzdsbEFyRjdwNEhsR1hMdXoKSVR6VUVOejhHWXB1K1NpZU1DdUhkZWs0VHEwPQotLS0tLUVORCBDRVJUSUZJQ0FURS0tLS0tCg==\"}]}},\"version\":\"3.1.0\"}}"

	expected := "{\"ignition\":{\"config\":{\"merge\":[{\"source\":\"https://192.168.123.15:22623/config/worker\"}]},\"security\":{\"tls\":{\"certificateAuthorities\":[{\"source\":\"data:text/plain;charset=utf-8;base64,LS0tLS1CRUdJTiBDRVJUSUZJQ0FURS0tLS0tCk1JSURFRENDQWZpZ0F3SUJBZ0lJS01BN3hKRW5lWXd3RFFZSktvWklodmNOQVFFTEJRQXdKakVTTUJBR0ExVUUKQ3hNSmIzQmxibk5vYVdaME1SQXdEZ1lEVlFRREV3ZHliMjkwTFdOaE1CNFhEVEl3TVRBeU5URXpNRGt4TVZvWApEVE13TVRBeU16RXpNRGt4TVZvd0pqRVNNQkFHQTFVRUN4TUpiM0JsYm5Ob2FXWjBNUkF3RGdZRFZRUURFd2R5CmIyOTBMV05oTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUFyTnhDRFR5bWUzVlgKQWJkK1JIUnhPQnp4SkNiclZlVmJ4SVptVXl5Mk5KdmR6cXdHUWtEdU9weEdHaGNTS09KVFdvNTZwcG9xci9JTgpTVmlxamovME9uU1Z1aVJiS1c4dkRnSCswNmxjMHlzMFdQRnZTUS9RQURjVlMya3BoZlA5ZEgybTl0YmJDckJ6CnMva0Q0aFdtWGptTHhWMlZCakp3NnFMQjA2d0NVcVJkOUM5Tzd5T1VxaEV1UWpCZ0xzK1dlcWV2WGtlZnd1ZlkKUmR6OE5XYkpVOVY0endkUTUxc3pCdGRxTmcrallzVVFvSUZDbWZiOERLVGV2N1NTTitwUXFkVlgrOUNDcWtZMwpia0ZhbHlVa0YzN2RYRjNmdXdWeHFqTWVpTDY5c3dMRE5vQjZCUjRXamVhd0V3b1JwS2VyVm5sT1FZQzYxalVqCjdJdVRiUHplbXdJREFRQUJvMEl3UURBT0JnTlZIUThCQWY4RUJBTUNBcVF3RHdZRFZSMFRBUUgvQkFVd0F3RUIKL3pBZEJnTlZIUTRFRmdRVXNncW05VVNlNXdDcHg2TzRzZFV3VFVmZTdxRXdEUVlKS29aSWh2Y05BUUVMQlFBRApnZ0VCQUFYRnFZblBmK2VrTmlaOFJHbEpjckJldHV4Mkgwc1FPb001Rkt4dVhZSC9iNEYzYWw0bUhjdDJMYk5VCittVGxoZk4yNlFOQ3FsZkF4MWhIaWJueFZFeTlxUWJtSnFoUU1kcm5vYi83bmFPeFRsZEUxdVNWSmFpUEt1S0sKZWhtQjlRL1l1WGJMeG84SjBBMndOWHBJL1NwTUVRbEgzSmZVTHdqRTNqaVVIR25GdkMvcy8vNHhRU2c4M3Y0NQpLZnBOVlhsRVAvaVdRYWo0UXhXbGxTUVkwbnc2RmdpbUxwa3huLzJ2aUlTeVcvT0N2YTRzdzFFS2IzM1BhTnhOCjhnd3ZLNnhFUlNDVGNPTEJxbnJseUErTmVINjY2YXFCclY0TEFZclZsUXhKOWd0YzdsbEFyRjdwNEhsR1hMdXoKSVR6VUVOejhHWXB1K1NpZU1DdUhkZWs0VHEwPQotLS0tLUVORCBDRVJUSUZJQ0FURS0tLS0tCg==\"}]}},\"version\":\"3.1.0\"},\"storage\":{\"files\":[{\"contents\":{\"source\":\"data:,testHostName\"},\"filesystem\":\"root\",\"mode\":420,\"path\":\"/etc/hostname\"}]}}"

	result, _ := addHostnameToUserData([]byte(userData), "testHostName")
	assert.Equal(t, string(result), expected)

}
