---
layout: "docs"
page_title: "Upgrading to Vault 1.1.1 - Guides"
sidebar_title: "Upgrade to 1.1.1"
sidebar_current: "docs-upgrading-to-1.1.1"
description: |-
  This page contains the list of deprecations and important or breaking changes
  for Vault 1.1.1. Please read it carefully.
---

# Overview

This page contains the list of deprecations and important or breaking changes
for Vault 1.1.0 compared to 1.1.1. Please read it carefully.

## Known Issues

### Issue with some KVv2 mounts

There is a known issue that could cause the upgrade to 1.1.1 to fail under
certain circumstances. This issue occurs when a KV version 2 mount exists but
contains no data. This will be fixed in 1.1.2. Additionally a work around does
exist: prior to upgrading ensure all KV v2 mounts have at least one key written
to it.

### Change in LDAP Group CN handling

A bug fix to allow group CNs to be found from an LDAP server in lowercase `cn`
as well as uppercase `CN` had an unintended consequence. If prior to that a
group used `cn`, as in `cn=foo,ou=bar` then the group that would need to be put
into place in the LDAP plugin to match against policies is `cn=foo,ou=bar`
since the CN would not be correctly found. After the change, the CN was
correctly found, but this would result in the group name being parsed as `foo`
and would not match groups using the full DN. In 1.1.5+, there is a boolean
config setting `use_pre111_group_cn_behavior` to allow reverting to the old
matching behavior; we also attempt to upgrade exiting configs to have that
defaulted to true.


### Long WAL replay

-> **NOTE:** This is a known issue applicable to _Vault Enterprise_.

During upgrades to 1.1.0, 1.1.1 or 1.1.2, Vault replication secondaries may
require an automatically-triggered reindex, either if upgrading from a pre-0.8
version of Vault or if a previously-issued reindex operation has failed in the
past. In these reindex scenarios, the secondary cluster will perform a complete
WAL replay, which can take a long time and is a partially blocking operation.

This is fixed in [Vault
1.1.3](https://github.com/hashicorp/vault/blob/master/CHANGELOG.md#113-june-5th-2019),
and we recommend upgrading to Vault 1.1.3+ rather than any prior 1.1.x version.
We also strongly recommend upgrading your Vault cluster to 1.1.3 if you are
running Vault Enterprise 1.1.0, 1.1.1 or 1.1.2.


## JWT/OIDC Plugin

Logins of role_type "oidc" via the /login path are no longer allowed.

## ACL Wildcards

New ordering defines which policy wins when there are multiple inexact matches
and at least one path contains `+`. `+*` is now illegal in policy paths. The
previous behavior simply selected any matching segment-wildcard path that
matched.

## Replication

Due to technical limitations, mounting and unmounting was not previously
possible from a performance secondary. These have been resolved, and these
operations may now be run from a performance secondary.
