package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnRefreshTasks invokes the dcdn.DescribeDcdnRefreshTasks API synchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdnrefreshtasks.html
func (client *Client) DescribeDcdnRefreshTasks(request *DescribeDcdnRefreshTasksRequest) (response *DescribeDcdnRefreshTasksResponse, err error) {
	response = CreateDescribeDcdnRefreshTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnRefreshTasksWithChan invokes the dcdn.DescribeDcdnRefreshTasks API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdnrefreshtasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnRefreshTasksWithChan(request *DescribeDcdnRefreshTasksRequest) (<-chan *DescribeDcdnRefreshTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnRefreshTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnRefreshTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnRefreshTasksWithCallback invokes the dcdn.DescribeDcdnRefreshTasks API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdnrefreshtasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnRefreshTasksWithCallback(request *DescribeDcdnRefreshTasksRequest, callback func(response *DescribeDcdnRefreshTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnRefreshTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnRefreshTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnRefreshTasksRequest is the request struct for api DescribeDcdnRefreshTasks
type DescribeDcdnRefreshTasksRequest struct {
	*requests.RpcRequest
	ObjectPath      string           `position:"Query" name:"ObjectPath"`
	DomainName      string           `position:"Query" name:"DomainName"`
	EndTime         string           `position:"Query" name:"EndTime"`
	StartTime       string           `position:"Query" name:"StartTime"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken   string           `position:"Query" name:"SecurityToken"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ObjectType      string           `position:"Query" name:"ObjectType"`
	TaskId          string           `position:"Query" name:"TaskId"`
	Status          string           `position:"Query" name:"Status"`
}

// DescribeDcdnRefreshTasksResponse is the response struct for api DescribeDcdnRefreshTasks
type DescribeDcdnRefreshTasksResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	Tasks      Tasks  `json:"Tasks" xml:"Tasks"`
}

// CreateDescribeDcdnRefreshTasksRequest creates a request to invoke DescribeDcdnRefreshTasks API
func CreateDescribeDcdnRefreshTasksRequest() (request *DescribeDcdnRefreshTasksRequest) {
	request = &DescribeDcdnRefreshTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnRefreshTasks", "", "")
	return
}

// CreateDescribeDcdnRefreshTasksResponse creates a response to parse from DescribeDcdnRefreshTasks response
func CreateDescribeDcdnRefreshTasksResponse() (response *DescribeDcdnRefreshTasksResponse) {
	response = &DescribeDcdnRefreshTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
