package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeETLJobStageOutputSchema invokes the emr.DescribeETLJobStageOutputSchema API synchronously
// api document: https://help.aliyun.com/api/emr/describeetljobstageoutputschema.html
func (client *Client) DescribeETLJobStageOutputSchema(request *DescribeETLJobStageOutputSchemaRequest) (response *DescribeETLJobStageOutputSchemaResponse, err error) {
	response = CreateDescribeETLJobStageOutputSchemaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeETLJobStageOutputSchemaWithChan invokes the emr.DescribeETLJobStageOutputSchema API asynchronously
// api document: https://help.aliyun.com/api/emr/describeetljobstageoutputschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeETLJobStageOutputSchemaWithChan(request *DescribeETLJobStageOutputSchemaRequest) (<-chan *DescribeETLJobStageOutputSchemaResponse, <-chan error) {
	responseChan := make(chan *DescribeETLJobStageOutputSchemaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeETLJobStageOutputSchema(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeETLJobStageOutputSchemaWithCallback invokes the emr.DescribeETLJobStageOutputSchema API asynchronously
// api document: https://help.aliyun.com/api/emr/describeetljobstageoutputschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeETLJobStageOutputSchemaWithCallback(request *DescribeETLJobStageOutputSchemaRequest, callback func(response *DescribeETLJobStageOutputSchemaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeETLJobStageOutputSchemaResponse
		var err error
		defer close(result)
		response, err = client.DescribeETLJobStageOutputSchema(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeETLJobStageOutputSchemaRequest is the request struct for api DescribeETLJobStageOutputSchema
type DescribeETLJobStageOutputSchemaRequest struct {
	*requests.RpcRequest
	StageName       string           `position:"Query" name:"StageName"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EtlJobId        string           `position:"Query" name:"EtlJobId"`
}

// DescribeETLJobStageOutputSchemaResponse is the response struct for api DescribeETLJobStageOutputSchema
type DescribeETLJobStageOutputSchemaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Schema    Schema `json:"Schema" xml:"Schema"`
}

// CreateDescribeETLJobStageOutputSchemaRequest creates a request to invoke DescribeETLJobStageOutputSchema API
func CreateDescribeETLJobStageOutputSchemaRequest() (request *DescribeETLJobStageOutputSchemaRequest) {
	request = &DescribeETLJobStageOutputSchemaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeETLJobStageOutputSchema", "emr", "openAPI")
	return
}

// CreateDescribeETLJobStageOutputSchemaResponse creates a response to parse from DescribeETLJobStageOutputSchema response
func CreateDescribeETLJobStageOutputSchemaResponse() (response *DescribeETLJobStageOutputSchemaResponse) {
	response = &DescribeETLJobStageOutputSchemaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
