package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTempInstance invokes the r_kvstore.DescribeTempInstance API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/describetempinstance.html
func (client *Client) DescribeTempInstance(request *DescribeTempInstanceRequest) (response *DescribeTempInstanceResponse, err error) {
	response = CreateDescribeTempInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTempInstanceWithChan invokes the r_kvstore.DescribeTempInstance API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describetempinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTempInstanceWithChan(request *DescribeTempInstanceRequest) (<-chan *DescribeTempInstanceResponse, <-chan error) {
	responseChan := make(chan *DescribeTempInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTempInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTempInstanceWithCallback invokes the r_kvstore.DescribeTempInstance API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describetempinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTempInstanceWithCallback(request *DescribeTempInstanceRequest, callback func(response *DescribeTempInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTempInstanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeTempInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTempInstanceRequest is the request struct for api DescribeTempInstance
type DescribeTempInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeTempInstanceResponse is the response struct for api DescribeTempInstance
type DescribeTempInstanceResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	TempInstances TempInstances `json:"TempInstances" xml:"TempInstances"`
}

// CreateDescribeTempInstanceRequest creates a request to invoke DescribeTempInstance API
func CreateDescribeTempInstanceRequest() (request *DescribeTempInstanceRequest) {
	request = &DescribeTempInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeTempInstance", "redisa", "openAPI")
	return
}

// CreateDescribeTempInstanceResponse creates a response to parse from DescribeTempInstance response
func CreateDescribeTempInstanceResponse() (response *DescribeTempInstanceResponse) {
	response = &DescribeTempInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
