package migrate

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/migrate/mgmt/2018-02-02/migrate"

// AssessedDisk a disk assessed for an assessment.
type AssessedDisk struct {
	// Name - READ-ONLY; Name of the assessed disk.
	Name *string `json:"name,omitempty"`
	// GigabytesProvisioned - READ-ONLY; Gigabytes of storage provisioned for this disk.
	GigabytesProvisioned *float64 `json:"gigabytesProvisioned,omitempty"`
	// GigabytesConsumed - READ-ONLY; Gigabytes of storage consumed by this disk.
	GigabytesConsumed *float64 `json:"gigabytesConsumed,omitempty"`
	// MegabytesPerSecondOfRead - READ-ONLY; Disk throughput in MegaBytes per second.
	MegabytesPerSecondOfRead *float64 `json:"megabytesPerSecondOfRead,omitempty"`
	// MegabytesPerSecondOfReadDataPointsExpected - READ-ONLY; Expected data points for MegaBytes per second of read.
	MegabytesPerSecondOfReadDataPointsExpected *int32 `json:"megabytesPerSecondOfReadDataPointsExpected,omitempty"`
	// MegabytesPerSecondOfReadDataPointsReceived - READ-ONLY; Received data points for MegaBytes per second of read.
	MegabytesPerSecondOfReadDataPointsReceived *int32 `json:"megabytesPerSecondOfReadDataPointsReceived,omitempty"`
	// MegabytesPerSecondOfWrite - READ-ONLY; Disk throughput in MegaBytes per second.
	MegabytesPerSecondOfWrite *float64 `json:"megabytesPerSecondOfWrite,omitempty"`
	// MegabytesPerSecondOfWriteDataPointsExpected - READ-ONLY; Expected data points for MegaBytes per second of write.
	MegabytesPerSecondOfWriteDataPointsExpected *int32 `json:"megabytesPerSecondOfWriteDataPointsExpected,omitempty"`
	// MegabytesPerSecondOfWriteDataPointsReceived - READ-ONLY; Received data points for MegaBytes per second of write.
	MegabytesPerSecondOfWriteDataPointsReceived *int32 `json:"megabytesPerSecondOfWriteDataPointsReceived,omitempty"`
	// NumberOfReadOperationsPerSecond - READ-ONLY; Number of read operations per second for the disk.
	NumberOfReadOperationsPerSecond *float64 `json:"numberOfReadOperationsPerSecond,omitempty"`
	// NumberOfReadOperationsPerSecondDataPointsExpected - READ-ONLY; Expected number of data points for read operations per second.
	NumberOfReadOperationsPerSecondDataPointsExpected *int32 `json:"numberOfReadOperationsPerSecondDataPointsExpected,omitempty"`
	// NumberOfReadOperationsPerSecondDataPointsReceived - READ-ONLY; Received number of data points for read operations per second.
	NumberOfReadOperationsPerSecondDataPointsReceived *int32 `json:"numberOfReadOperationsPerSecondDataPointsReceived,omitempty"`
	// NumberOfWriteOperationsPerSecond - READ-ONLY; Number of read and write operations per second for the disk.
	NumberOfWriteOperationsPerSecond *float64 `json:"numberOfWriteOperationsPerSecond,omitempty"`
	// NumberOfWriteOperationsPerSecondDataPointsExpected - READ-ONLY; Expected number of data points for write operations per second.
	NumberOfWriteOperationsPerSecondDataPointsExpected *int32 `json:"numberOfWriteOperationsPerSecondDataPointsExpected,omitempty"`
	// NumberOfWriteOperationsPerSecondDataPointsReceived - READ-ONLY; Received number of data points for write operations per second.
	NumberOfWriteOperationsPerSecondDataPointsReceived *int32 `json:"numberOfWriteOperationsPerSecondDataPointsReceived,omitempty"`
	// MonthlyStorageCost - READ-ONLY; Estimated aggregate storage cost for a 31-day month for this disk.
	MonthlyStorageCost *float64 `json:"monthlyStorageCost,omitempty"`
	// RecommendedDiskType - READ-ONLY; Storage type selected for this disk. Possible values include: 'AzureDiskTypeUnknown', 'AzureDiskTypeStandard', 'AzureDiskTypePremium'
	RecommendedDiskType AzureDiskType `json:"recommendedDiskType,omitempty"`
	// RecommendedDiskSize - READ-ONLY; Recommended Azure size for the disk, given utilization data and preferences set on Assessment. Possible values include: 'Unknown', 'StandardS4', 'StandardS6', 'StandardS10', 'StandardS20', 'StandardS30', 'StandardS40', 'StandardS50', 'PremiumP4', 'PremiumP6', 'PremiumP10', 'PremiumP20', 'PremiumP30', 'PremiumP40', 'PremiumP50'
	RecommendedDiskSize AzureDiskSize `json:"recommendedDiskSize,omitempty"`
	// GigabytesForRecommendedDiskSize - READ-ONLY; Gigabytes of storage provided by the recommended Azure disk size.
	GigabytesForRecommendedDiskSize *int32 `json:"gigabytesForRecommendedDiskSize,omitempty"`
	// Suitability - READ-ONLY; Whether this disk is suitable for Azure. Possible values include: 'CloudSuitabilityUnknown', 'CloudSuitabilityNotSuitable', 'CloudSuitabilitySuitable', 'CloudSuitabilityConditionallySuitable', 'CloudSuitabilityReadinessUnknown'
	Suitability CloudSuitability `json:"suitability,omitempty"`
	// SuitabilityExplanation - READ-ONLY; If disk is suitable, this explains the reasons and mitigation steps. Possible values include: 'AzureDiskSuitabilityExplanationUnknown', 'AzureDiskSuitabilityExplanationNotApplicable', 'AzureDiskSuitabilityExplanationDiskSizeGreaterThanSupported', 'AzureDiskSuitabilityExplanationNoSuitableDiskSizeForIops', 'AzureDiskSuitabilityExplanationNoSuitableDiskSizeForThroughput', 'AzureDiskSuitabilityExplanationNoDiskSizeFoundInSelectedLocation', 'AzureDiskSuitabilityExplanationNoDiskSizeFoundForSelectedRedundancy', 'AzureDiskSuitabilityExplanationInternalErrorOccurredForDiskEvaluation'
	SuitabilityExplanation AzureDiskSuitabilityExplanation `json:"suitabilityExplanation,omitempty"`
}

// AssessedMachine a machine evaluated as part of an assessment.
type AssessedMachine struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Path reference to this assessed machine. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessments/{assessmentName}/assessedMachines/{assessedMachineName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the machine.
	Name *string `json:"name,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Type - READ-ONLY; Type of the object = [Microsoft.Migrate/projects/groups/assessments/assessedMachines].
	Type *string `json:"type,omitempty"`
	// AssessedMachineProperties - Properties of an assessed machine.
	*AssessedMachineProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessedMachine.
func (am AssessedMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if am.ETag != nil {
		objectMap["eTag"] = am.ETag
	}
	if am.AssessedMachineProperties != nil {
		objectMap["properties"] = am.AssessedMachineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessedMachine struct.
func (am *AssessedMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				am.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				am.Name = &name
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				am.ETag = &eTag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				am.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var assessedMachineProperties AssessedMachineProperties
				err = json.Unmarshal(*v, &assessedMachineProperties)
				if err != nil {
					return err
				}
				am.AssessedMachineProperties = &assessedMachineProperties
			}
		}
	}

	return nil
}

// AssessedMachineProperties properties of an assessed machine.
type AssessedMachineProperties struct {
	// Groups - READ-ONLY; List of references to the groups that the machine is member of.
	Groups *[]string `json:"groups,omitempty"`
	// DiscoveredTimestamp - READ-ONLY; Time when this machine was discovered by Azure Migrate agent. Date-Time represented in ISO-8601 format.
	DiscoveredTimestamp *date.Time `json:"discoveredTimestamp,omitempty"`
	// BootType - READ-ONLY; Boot type of the machine. Possible values include: 'MachineBootTypeUnknown', 'MachineBootTypeEFI', 'MachineBootTypeBIOS'
	BootType MachineBootType `json:"bootType,omitempty"`
	// DatacenterContainer - READ-ONLY; Container defined in the management solution that this machine is part of in the datacenter.
	DatacenterContainer *string `json:"datacenterContainer,omitempty"`
	// DatacenterManagementServer - READ-ONLY; Name of the server hosting the datacenter management solution.
	DatacenterManagementServer *string `json:"datacenterManagementServer,omitempty"`
	// DatacenterMachineID - READ-ONLY; ID of the machine as tracked by the datacenter management solution.
	DatacenterMachineID *string `json:"datacenterMachineId,omitempty"`
	// DatacenterManagementServerID - READ-ONLY; ID of the server hosting the datacenter management solution.
	DatacenterManagementServerID *string `json:"datacenterManagementServerId,omitempty"`
	// Description - READ-ONLY; Description of the machine
	Description *string `json:"description,omitempty"`
	// DisplayName - READ-ONLY; User readable name of the machine as defined by the user in their private datacenter.
	DisplayName *string `json:"displayName,omitempty"`
	// MegabytesOfMemory - READ-ONLY; Memory in Megabytes.
	MegabytesOfMemory *float64 `json:"megabytesOfMemory,omitempty"`
	// NumberOfCores - READ-ONLY; Processor count.
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`
	// OperatingSystem - READ-ONLY; Operating System of the machine.
	OperatingSystem *string `json:"operatingSystem,omitempty"`
	// MonthlyBandwidthCost - READ-ONLY; Monthly network cost estimate for the network adapters that are attached to this machine as a group, for a 31-day month.
	MonthlyBandwidthCost *float64 `json:"monthlyBandwidthCost,omitempty"`
	// MonthlyStorageCost - READ-ONLY; Monthly storage cost estimate for the disks that are attached to this machine as a group, for a 31-day month.
	MonthlyStorageCost *float64 `json:"monthlyStorageCost,omitempty"`
	// Disks - READ-ONLY; Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object.
	Disks map[string]*AssessedDisk `json:"disks"`
	// NetworkAdapters - READ-ONLY; Dictionary of network adapters attached to the machine. Key is name of the adapter. Value is a network adapter object.
	NetworkAdapters map[string]*AssessedNetworkAdapter `json:"networkAdapters"`
	// RecommendedSize - READ-ONLY; Recommended Azure size for this machine. Possible values include: 'AzureVMSizeUnknown', 'AzureVMSizeBasicA0', 'AzureVMSizeBasicA1', 'AzureVMSizeBasicA2', 'AzureVMSizeBasicA3', 'AzureVMSizeBasicA4', 'AzureVMSizeStandardA0', 'AzureVMSizeStandardA1', 'AzureVMSizeStandardA2', 'AzureVMSizeStandardA3', 'AzureVMSizeStandardA4', 'AzureVMSizeStandardA5', 'AzureVMSizeStandardA6', 'AzureVMSizeStandardA7', 'AzureVMSizeStandardA8', 'AzureVMSizeStandardA9', 'AzureVMSizeStandardA10', 'AzureVMSizeStandardA11', 'AzureVMSizeStandardA1V2', 'AzureVMSizeStandardA2V2', 'AzureVMSizeStandardA4V2', 'AzureVMSizeStandardA8V2', 'AzureVMSizeStandardA2mV2', 'AzureVMSizeStandardA4mV2', 'AzureVMSizeStandardA8mV2', 'AzureVMSizeStandardD1', 'AzureVMSizeStandardD2', 'AzureVMSizeStandardD3', 'AzureVMSizeStandardD4', 'AzureVMSizeStandardD11', 'AzureVMSizeStandardD12', 'AzureVMSizeStandardD13', 'AzureVMSizeStandardD14', 'AzureVMSizeStandardD1V2', 'AzureVMSizeStandardD2V2', 'AzureVMSizeStandardD3V2', 'AzureVMSizeStandardD4V2', 'AzureVMSizeStandardD5V2', 'AzureVMSizeStandardD11V2', 'AzureVMSizeStandardD12V2', 'AzureVMSizeStandardD13V2', 'AzureVMSizeStandardD14V2', 'AzureVMSizeStandardD15V2', 'AzureVMSizeStandardDS1', 'AzureVMSizeStandardDS2', 'AzureVMSizeStandardDS3', 'AzureVMSizeStandardDS4', 'AzureVMSizeStandardDS11', 'AzureVMSizeStandardDS12', 'AzureVMSizeStandardDS13', 'AzureVMSizeStandardDS14', 'AzureVMSizeStandardDS1V2', 'AzureVMSizeStandardDS2V2', 'AzureVMSizeStandardDS3V2', 'AzureVMSizeStandardDS4V2', 'AzureVMSizeStandardDS5V2', 'AzureVMSizeStandardDS11V2', 'AzureVMSizeStandardDS12V2', 'AzureVMSizeStandardDS13V2', 'AzureVMSizeStandardDS14V2', 'AzureVMSizeStandardDS15V2', 'AzureVMSizeStandardF1', 'AzureVMSizeStandardF2', 'AzureVMSizeStandardF4', 'AzureVMSizeStandardF8', 'AzureVMSizeStandardF16', 'AzureVMSizeStandardF1s', 'AzureVMSizeStandardF2s', 'AzureVMSizeStandardF4s', 'AzureVMSizeStandardF8s', 'AzureVMSizeStandardF16s', 'AzureVMSizeStandardG1', 'AzureVMSizeStandardG2', 'AzureVMSizeStandardG3', 'AzureVMSizeStandardG4', 'AzureVMSizeStandardG5', 'AzureVMSizeStandardGS1', 'AzureVMSizeStandardGS2', 'AzureVMSizeStandardGS3', 'AzureVMSizeStandardGS4', 'AzureVMSizeStandardGS5', 'AzureVMSizeStandardH8', 'AzureVMSizeStandardH16', 'AzureVMSizeStandardH8m', 'AzureVMSizeStandardH16m', 'AzureVMSizeStandardH16r', 'AzureVMSizeStandardH16mr', 'AzureVMSizeStandardL4s', 'AzureVMSizeStandardL8s', 'AzureVMSizeStandardL16s', 'AzureVMSizeStandardL32s'
	RecommendedSize AzureVMSize `json:"recommendedSize,omitempty"`
	// NumberOfCoresForRecommendedSize - READ-ONLY; Number of CPU cores in the Recommended Azure VM Size.
	NumberOfCoresForRecommendedSize *int32 `json:"numberOfCoresForRecommendedSize,omitempty"`
	// MegabytesOfMemoryForRecommendedSize - READ-ONLY; Megabytes of memory in the Recommended Azure VM Size.
	MegabytesOfMemoryForRecommendedSize *float64 `json:"megabytesOfMemoryForRecommendedSize,omitempty"`
	// MonthlyComputeCostForRecommendedSize - READ-ONLY; Compute Cost for a 31-day month, if the machine is migrated to Azure with the Recommended Size.
	MonthlyComputeCostForRecommendedSize *float64 `json:"monthlyComputeCostForRecommendedSize,omitempty"`
	// PercentageCoresUtilization - READ-ONLY; Utilization percentage of the processor core as observed in the private data center, in the Time Range selected on Assessment, reported as the Percentile value based on the percentile number selected in assessment.
	PercentageCoresUtilization *float64 `json:"percentageCoresUtilization,omitempty"`
	// PercentageMemoryUtilization - READ-ONLY; Utilization percentage of the memory as observed in the private data center, in the Time Range selected on Assessment, reported as the Percentile value based on the percentile number selected in assessment.
	PercentageMemoryUtilization *float64 `json:"percentageMemoryUtilization,omitempty"`
	// PercentageCoresUtilizationDataPointsExpected - READ-ONLY; Expected data points for percentage of cores utilization.
	PercentageCoresUtilizationDataPointsExpected *int32 `json:"percentageCoresUtilizationDataPointsExpected,omitempty"`
	// PercentageCoresUtilizationDataPointsReceived - READ-ONLY; Received data points for percentage of cores utilization.
	PercentageCoresUtilizationDataPointsReceived *int32 `json:"percentageCoresUtilizationDataPointsReceived,omitempty"`
	// PercentageMemoryUtilizationDataPointsExpected - READ-ONLY; Expected data points for percentage of memory utilization.
	PercentageMemoryUtilizationDataPointsExpected *int32 `json:"percentageMemoryUtilizationDataPointsExpected,omitempty"`
	// PercentageMemoryUtilizationDataPointsReceived - READ-ONLY; Received data points for percentage of memory utilization.
	PercentageMemoryUtilizationDataPointsReceived *int32 `json:"percentageMemoryUtilizationDataPointsReceived,omitempty"`
	// Suitability - READ-ONLY; Whether machine is suitable for migration to Azure. Possible values include: 'CloudSuitabilityUnknown', 'CloudSuitabilityNotSuitable', 'CloudSuitabilitySuitable', 'CloudSuitabilityConditionallySuitable', 'CloudSuitabilityReadinessUnknown'
	Suitability CloudSuitability `json:"suitability,omitempty"`
	// SuitabilityExplanation - READ-ONLY; If machine is not ready to be migrated, this explains the reasons and mitigation steps. Possible values include: 'AzureVMSuitabilityExplanationUnknown', 'AzureVMSuitabilityExplanationNotApplicable', 'AzureVMSuitabilityExplanationGuestOperatingSystemArchitectureNotSupported', 'AzureVMSuitabilityExplanationGuestOperatingSystemNotSupported', 'AzureVMSuitabilityExplanationBootTypeNotSupported', 'AzureVMSuitabilityExplanationMoreDisksThanSupported', 'AzureVMSuitabilityExplanationNoSuitableVMSizeFound', 'AzureVMSuitabilityExplanationOneOrMoreDisksNotSuitable', 'AzureVMSuitabilityExplanationOneOrMoreAdaptersNotSuitable', 'AzureVMSuitabilityExplanationInternalErrorOccuredDuringComputeEvaluation', 'AzureVMSuitabilityExplanationInternalErrorOccuredDuringStorageEvaluation', 'AzureVMSuitabilityExplanationInternalErrorOccuredDuringNetworkEvaluation', 'AzureVMSuitabilityExplanationNoVMSizeSupportsStoragePerformance', 'AzureVMSuitabilityExplanationNoVMSizeSupportsNetworkPerformance', 'AzureVMSuitabilityExplanationNoVMSizeForSelectedPricingTier', 'AzureVMSuitabilityExplanationNoVMSizeForSelectedAzureLocation', 'AzureVMSuitabilityExplanationCheckRedHatLinuxVersion', 'AzureVMSuitabilityExplanationCheckOpenSuseLinuxVersion', 'AzureVMSuitabilityExplanationCheckWindowsServer2008R2Version', 'AzureVMSuitabilityExplanationCheckCentOsVersion', 'AzureVMSuitabilityExplanationCheckDebianLinuxVersion', 'AzureVMSuitabilityExplanationCheckSuseLinuxVersion', 'AzureVMSuitabilityExplanationCheckOracleLinuxVersion', 'AzureVMSuitabilityExplanationCheckUbuntuLinuxVersion', 'AzureVMSuitabilityExplanationCheckCoreOsLinuxVersion', 'AzureVMSuitabilityExplanationWindowsServerVersionConditionallySupported', 'AzureVMSuitabilityExplanationNoGuestOperatingSystemConditionallySupported', 'AzureVMSuitabilityExplanationWindowsClientVersionsConditionallySupported', 'AzureVMSuitabilityExplanationBootTypeUnknown', 'AzureVMSuitabilityExplanationGuestOperatingSystemUnknown', 'AzureVMSuitabilityExplanationWindowsServerVersionsSupportedWithCaveat', 'AzureVMSuitabilityExplanationWindowsOSNoLongerUnderMSSupport', 'AzureVMSuitabilityExplanationEndorsedWithConditionsLinuxDistributions', 'AzureVMSuitabilityExplanationUnendorsedLinuxDistributions', 'AzureVMSuitabilityExplanationNoVMSizeForStandardPricingTier', 'AzureVMSuitabilityExplanationNoVMSizeForBasicPricingTier'
	SuitabilityExplanation AzureVMSuitabilityExplanation `json:"suitabilityExplanation,omitempty"`
	// CreatedTimestamp - READ-ONLY; Time when this machine was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Time when this machine was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessedMachineProperties.
func (amp AssessedMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AssessedMachineResultList list of assessed machines.
type AssessedMachineResultList struct {
	autorest.Response `json:"-"`
	// Value - List of assessed machines.
	Value *[]AssessedMachine `json:"value,omitempty"`
}

// AssessedNetworkAdapter a network adapter assessed for an assessment.
type AssessedNetworkAdapter struct {
	// MacAddress - READ-ONLY; MAC Address of the network adapter.
	MacAddress *string `json:"macAddress,omitempty"`
	// IPAddresses - READ-ONLY; List of IP Addresses on the network adapter.
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
	// MonthlyBandwidthCosts - READ-ONLY; Monthly cost estimate for network bandwidth used by this network adapter.
	MonthlyBandwidthCosts *float64 `json:"monthlyBandwidthCosts,omitempty"`
	// MegabytesPerSecondReceived - READ-ONLY; Adapter throughput for incoming traffic in MegaBytes per second.
	MegabytesPerSecondReceived *float64 `json:"megabytesPerSecondReceived,omitempty"`
	// MegabytesPerSecondReceivedDataPointsExpected - READ-ONLY; Expected data points for incoming traffic in MegaBytes per second.
	MegabytesPerSecondReceivedDataPointsExpected *int32 `json:"megabytesPerSecondReceivedDataPointsExpected,omitempty"`
	// MegabytesPerSecondOfReadDataPointsReceived - READ-ONLY; Received data points for incoming traffic in MegaBytes per second.
	MegabytesPerSecondOfReadDataPointsReceived *int32 `json:"megabytesPerSecondOfReadDataPointsReceived,omitempty"`
	// MegabytesPerSecondTransmitted - READ-ONLY; Adapter throughput for outgoing traffic in MegaBytes per second.
	MegabytesPerSecondTransmitted *float64 `json:"megabytesPerSecondTransmitted,omitempty"`
	// MegabytesPerSecondTransmittedDataPointsExpected - READ-ONLY; Expected data points for outgoing traffic in MegaBytes per second.
	MegabytesPerSecondTransmittedDataPointsExpected *int32 `json:"megabytesPerSecondTransmittedDataPointsExpected,omitempty"`
	// MegabytesPerSecondTransmittedDataPointsReceived - READ-ONLY; Received data points for outgoing traffic in MegaBytes per second.
	MegabytesPerSecondTransmittedDataPointsReceived *int32 `json:"megabytesPerSecondTransmittedDataPointsReceived,omitempty"`
	// NetGigabytesTransmittedPerMonth - Gigabytes transmitted through this adapter each month.
	NetGigabytesTransmittedPerMonth *float64 `json:"netGigabytesTransmittedPerMonth,omitempty"`
	// Suitability - READ-ONLY; Whether this adapter is suitable for Azure. Possible values include: 'CloudSuitabilityUnknown', 'CloudSuitabilityNotSuitable', 'CloudSuitabilitySuitable', 'CloudSuitabilityConditionallySuitable', 'CloudSuitabilityReadinessUnknown'
	Suitability CloudSuitability `json:"suitability,omitempty"`
	// SuitabilityExplanation - READ-ONLY; If network adapter is suitable, this explains the reasons and mitigation steps. Possible values include: 'AzureNetworkAdapterSuitabilityExplanationUnknown', 'AzureNetworkAdapterSuitabilityExplanationNotApplicable', 'AzureNetworkAdapterSuitabilityExplanationInternalErrorOccured'
	SuitabilityExplanation AzureNetworkAdapterSuitabilityExplanation `json:"suitabilityExplanation,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessedNetworkAdapter.
func (ana AssessedNetworkAdapter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ana.NetGigabytesTransmittedPerMonth != nil {
		objectMap["netGigabytesTransmittedPerMonth"] = ana.NetGigabytesTransmittedPerMonth
	}
	return json.Marshal(objectMap)
}

// Assessment an assessment created for a group in the Migration project.
type Assessment struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Path reference to this assessment. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessment/{assessmentName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Unique name of an assessment.
	Name *string `json:"name,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Type - READ-ONLY; Type of the object = [Microsoft.Migrate/projects/groups/assessments].
	Type *string `json:"type,omitempty"`
	// AssessmentProperties - Properties of the assessment.
	*AssessmentProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Assessment.
func (a Assessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ETag != nil {
		objectMap["eTag"] = a.ETag
	}
	if a.AssessmentProperties != nil {
		objectMap["properties"] = a.AssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Assessment struct.
func (a *Assessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				a.ETag = &eTag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var assessmentProperties AssessmentProperties
				err = json.Unmarshal(*v, &assessmentProperties)
				if err != nil {
					return err
				}
				a.AssessmentProperties = &assessmentProperties
			}
		}
	}

	return nil
}

// AssessmentOptionsResultList list of assessment options.
type AssessmentOptionsResultList struct {
	autorest.Response `json:"-"`
	// VMFamilies - READ-ONLY; Dictionary of VM families grouped by vm family name describing the targeted azure locations of VM family and the category of the family.
	VMFamilies *[]VMFamily `json:"vmFamilies,omitempty"`
	// ReservedInstanceVMFamilies - READ-ONLY; List of supported VM Families.
	ReservedInstanceVMFamilies *[]string `json:"reservedInstanceVmFamilies,omitempty"`
}

// AssessmentProperties properties of an assessment.
type AssessmentProperties struct {
	// AzureLocation - Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API. Possible values include: 'AzureLocationUnknown', 'AzureLocationEastAsia', 'AzureLocationSoutheastAsia', 'AzureLocationAustraliaEast', 'AzureLocationAustraliaSoutheast', 'AzureLocationBrazilSouth', 'AzureLocationCanadaCentral', 'AzureLocationCanadaEast', 'AzureLocationWestEurope', 'AzureLocationNorthEurope', 'AzureLocationCentralIndia', 'AzureLocationSouthIndia', 'AzureLocationWestIndia', 'AzureLocationJapanEast', 'AzureLocationJapanWest', 'AzureLocationKoreaCentral', 'AzureLocationKoreaSouth', 'AzureLocationUkWest', 'AzureLocationUkSouth', 'AzureLocationNorthCentralUs', 'AzureLocationEastUs', 'AzureLocationWestUs2', 'AzureLocationSouthCentralUs', 'AzureLocationCentralUs', 'AzureLocationEastUs2', 'AzureLocationWestUs', 'AzureLocationWestCentralUs', 'AzureLocationGermanyCentral', 'AzureLocationGermanyNortheast', 'AzureLocationChinaNorth', 'AzureLocationChinaEast'
	AzureLocation AzureLocation `json:"azureLocation,omitempty"`
	// AzureOfferCode - Offer code according to which cost estimation is done. Possible values include: 'AzureOfferCodeUnknown', 'AzureOfferCodeMSAZR0003P', 'AzureOfferCodeMSAZR0044P', 'AzureOfferCodeMSAZR0059P', 'AzureOfferCodeMSAZR0060P', 'AzureOfferCodeMSAZR0062P', 'AzureOfferCodeMSAZR0063P', 'AzureOfferCodeMSAZR0064P', 'AzureOfferCodeMSAZR0029P', 'AzureOfferCodeMSAZR0022P', 'AzureOfferCodeMSAZR0023P', 'AzureOfferCodeMSAZR0148P', 'AzureOfferCodeMSAZR0025P', 'AzureOfferCodeMSAZR0036P', 'AzureOfferCodeMSAZR0120P', 'AzureOfferCodeMSAZR0121P', 'AzureOfferCodeMSAZR0122P', 'AzureOfferCodeMSAZR0123P', 'AzureOfferCodeMSAZR0124P', 'AzureOfferCodeMSAZR0125P', 'AzureOfferCodeMSAZR0126P', 'AzureOfferCodeMSAZR0127P', 'AzureOfferCodeMSAZR0128P', 'AzureOfferCodeMSAZR0129P', 'AzureOfferCodeMSAZR0130P', 'AzureOfferCodeMSAZR0111P', 'AzureOfferCodeMSAZR0144P', 'AzureOfferCodeMSAZR0149P', 'AzureOfferCodeMSMCAZR0044P', 'AzureOfferCodeMSMCAZR0059P', 'AzureOfferCodeMSMCAZR0060P', 'AzureOfferCodeMSMCAZR0063P', 'AzureOfferCodeMSMCAZR0120P', 'AzureOfferCodeMSMCAZR0121P', 'AzureOfferCodeMSMCAZR0125P', 'AzureOfferCodeMSMCAZR0128P', 'AzureOfferCodeMSAZRDE0003P', 'AzureOfferCodeMSAZRDE0044P'
	AzureOfferCode AzureOfferCode `json:"azureOfferCode,omitempty"`
	// AzurePricingTier - Pricing tier for Size evaluation. Possible values include: 'Standard', 'Basic'
	AzurePricingTier AzurePricingTier `json:"azurePricingTier,omitempty"`
	// AzureStorageRedundancy - Storage Redundancy type offered by Azure. Possible values include: 'AzureStorageRedundancyUnknown', 'AzureStorageRedundancyLocallyRedundant', 'AzureStorageRedundancyZoneRedundant', 'AzureStorageRedundancyGeoRedundant', 'AzureStorageRedundancyReadAccessGeoRedundant'
	AzureStorageRedundancy AzureStorageRedundancy `json:"azureStorageRedundancy,omitempty"`
	// ScalingFactor - Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3.
	ScalingFactor *float64 `json:"scalingFactor,omitempty"`
	// Percentile - Percentile of performance data used to recommend Azure size. Possible values include: 'Percentile50', 'Percentile90', 'Percentile95', 'Percentile99'
	Percentile Percentile `json:"percentile,omitempty"`
	// TimeRange - Time range of performance data used to recommend a size. Possible values include: 'Day', 'Week', 'Month'
	TimeRange TimeRange `json:"timeRange,omitempty"`
	// Stage - User configurable setting that describes the status of the assessment. Possible values include: 'InProgress', 'UnderReview', 'Approved'
	Stage AssessmentStage `json:"stage,omitempty"`
	// Currency - Currency to report prices in. Possible values include: 'CurrencyUnknown', 'CurrencyUSD', 'CurrencyDKK', 'CurrencyCAD', 'CurrencyIDR', 'CurrencyJPY', 'CurrencyKRW', 'CurrencyNZD', 'CurrencyNOK', 'CurrencyRUB', 'CurrencySAR', 'CurrencyZAR', 'CurrencySEK', 'CurrencyTRY', 'CurrencyGBP', 'CurrencyMXN', 'CurrencyMYR', 'CurrencyINR', 'CurrencyHKD', 'CurrencyBRL', 'CurrencyTWD', 'CurrencyEUR', 'CurrencyCHF', 'CurrencyARS', 'CurrencyAUD', 'CurrencyCNY'
	Currency Currency `json:"currency,omitempty"`
	// AzureHybridUseBenefit - AHUB discount on windows virtual machines. Possible values include: 'AzureHybridUseBenefitUnknown', 'AzureHybridUseBenefitYes', 'AzureHybridUseBenefitNo'
	AzureHybridUseBenefit AzureHybridUseBenefit `json:"azureHybridUseBenefit,omitempty"`
	// DiscountPercentage - Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
	DiscountPercentage *float64 `json:"discountPercentage,omitempty"`
	// ConfidenceRatingInPercentage - READ-ONLY; Confidence rating percentage for assessment. Can be in the range [0, 100].
	ConfidenceRatingInPercentage *float64 `json:"confidenceRatingInPercentage,omitempty"`
	// SizingCriterion - Assessment sizing criterion. Possible values include: 'PerformanceBased', 'AsOnPremises'
	SizingCriterion AssessmentSizingCriterion `json:"sizingCriterion,omitempty"`
	// PricesTimestamp - READ-ONLY; Time when the Azure Prices were queried. Date-Time represented in ISO-8601 format.
	PricesTimestamp *date.Time `json:"pricesTimestamp,omitempty"`
	// CreatedTimestamp - READ-ONLY; Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
	// MonthlyComputeCost - READ-ONLY; Monthly compute cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyComputeCost *float64 `json:"monthlyComputeCost,omitempty"`
	// MonthlyBandwidthCost - READ-ONLY; Monthly network cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyBandwidthCost *float64 `json:"monthlyBandwidthCost,omitempty"`
	// MonthlyStorageCost - READ-ONLY; Monthly storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyStorageCost *float64 `json:"monthlyStorageCost,omitempty"`
	// Status - READ-ONLY; Whether the assessment has been created and is valid. Possible values include: 'Created', 'Updated', 'Running', 'Completed', 'Invalid'
	Status AssessmentStatus `json:"status,omitempty"`
	// NumberOfMachines - READ-ONLY; Number of assessed machines part of this assessment.
	NumberOfMachines *int32 `json:"numberOfMachines,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentProperties.
func (ap AssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AzureLocation != "" {
		objectMap["azureLocation"] = ap.AzureLocation
	}
	if ap.AzureOfferCode != "" {
		objectMap["azureOfferCode"] = ap.AzureOfferCode
	}
	if ap.AzurePricingTier != "" {
		objectMap["azurePricingTier"] = ap.AzurePricingTier
	}
	if ap.AzureStorageRedundancy != "" {
		objectMap["azureStorageRedundancy"] = ap.AzureStorageRedundancy
	}
	if ap.ScalingFactor != nil {
		objectMap["scalingFactor"] = ap.ScalingFactor
	}
	if ap.Percentile != "" {
		objectMap["percentile"] = ap.Percentile
	}
	if ap.TimeRange != "" {
		objectMap["timeRange"] = ap.TimeRange
	}
	if ap.Stage != "" {
		objectMap["stage"] = ap.Stage
	}
	if ap.Currency != "" {
		objectMap["currency"] = ap.Currency
	}
	if ap.AzureHybridUseBenefit != "" {
		objectMap["azureHybridUseBenefit"] = ap.AzureHybridUseBenefit
	}
	if ap.DiscountPercentage != nil {
		objectMap["discountPercentage"] = ap.DiscountPercentage
	}
	if ap.SizingCriterion != "" {
		objectMap["sizingCriterion"] = ap.SizingCriterion
	}
	return json.Marshal(objectMap)
}

// AssessmentResultList list of assessments.
type AssessmentResultList struct {
	autorest.Response `json:"-"`
	// Value - List of assessments.
	Value *[]Assessment `json:"value,omitempty"`
}

// CheckNameAvailabilityParameters parameters for a check name availability request.
type CheckNameAvailabilityParameters struct {
	// Name - The name to check for availability
	Name *string `json:"name,omitempty"`
	// Type - The resource type. Must be set to Microsoft.Migrate/projects
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; Gets the reason that a project name could not be used. The Reason element is only returned if NameAvailable is false. Possible values include: 'NameAvailabilityReasonAvailable', 'NameAvailabilityReasonInvalid', 'NameAvailabilityReasonAlreadyExists'
	Reason NameAvailabilityReason `json:"reason,omitempty"`
	// Message - READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// CloudError an error response from the Azure Migrate service.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Azure Migrate service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// Disk a disk discovered on a machine.
type Disk struct {
	// GigabytesAllocated - READ-ONLY; Gigabytes of storage provisioned for this disk.
	GigabytesAllocated *float64 `json:"gigabytesAllocated,omitempty"`
	// GigabytesConsumed - READ-ONLY; Gigabytes of storage consumed by this disk.
	GigabytesConsumed *float64 `json:"gigabytesConsumed,omitempty"`
}

// DownloadURL download URL for assessment report.
type DownloadURL struct {
	autorest.Response `json:"-"`
	// AssessmentReportURL - READ-ONLY; Hyperlink to download report.
	AssessmentReportURL *string `json:"assessmentReportUrl,omitempty"`
	// ExpirationTime - READ-ONLY; Expiry date of download url.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
}

// Group a group created in a Migration project.
type Group struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Path reference to this group. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the group.
	Name *string `json:"name,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Type - READ-ONLY; Type of the object = [Microsoft.Migrate/projects/groups].
	Type *string `json:"type,omitempty"`
	// GroupProperties - Properties of the group.
	*GroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.ETag != nil {
		objectMap["eTag"] = g.ETag
	}
	if g.GroupProperties != nil {
		objectMap["properties"] = g.GroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Group struct.
func (g *Group) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				g.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				g.Name = &name
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				g.ETag = &eTag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				g.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var groupProperties GroupProperties
				err = json.Unmarshal(*v, &groupProperties)
				if err != nil {
					return err
				}
				g.GroupProperties = &groupProperties
			}
		}
	}

	return nil
}

// GroupProperties properties of group resource.
type GroupProperties struct {
	// Machines - List of machine names that are part of this group.
	Machines *[]string `json:"machines,omitempty"`
	// Assessments - READ-ONLY; List of References to Assessments created on this group.
	Assessments *[]string `json:"assessments,omitempty"`
	// CreatedTimestamp - READ-ONLY; Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupProperties.
func (gp GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.Machines != nil {
		objectMap["machines"] = gp.Machines
	}
	return json.Marshal(objectMap)
}

// GroupResultList list of groups.
type GroupResultList struct {
	autorest.Response `json:"-"`
	// Value - List of groups.
	Value *[]Group `json:"value,omitempty"`
}

// Machine a machine in a migration project.
type Machine struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Path reference to this machine. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/machines/{machineName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the machine. It is a GUID which is unique identifier of machine in private data center. For user-readable name, we have a displayName property on this machine.
	Name *string `json:"name,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Type - READ-ONLY; Type of the object = [Microsoft.Migrate/projects/machines].
	Type *string `json:"type,omitempty"`
	// MachineProperties - Properties of the machine.
	*MachineProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Machine.
func (mVar Machine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.ETag != nil {
		objectMap["eTag"] = mVar.ETag
	}
	if mVar.MachineProperties != nil {
		objectMap["properties"] = mVar.MachineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Machine struct.
func (mVar *Machine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				mVar.ETag = &eTag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var machineProperties MachineProperties
				err = json.Unmarshal(*v, &machineProperties)
				if err != nil {
					return err
				}
				mVar.MachineProperties = &machineProperties
			}
		}
	}

	return nil
}

// MachineProperties properties of a machine.
type MachineProperties struct {
	// BootType - READ-ONLY; Boot type of the machine. Possible values include: 'MachineBootTypeUnknown', 'MachineBootTypeEFI', 'MachineBootTypeBIOS'
	BootType MachineBootType `json:"bootType,omitempty"`
	// DatacenterContainer - READ-ONLY; Container defined in the management solution that this machine is part of in the datacenter.
	DatacenterContainer *string `json:"datacenterContainer,omitempty"`
	// DatacenterManagementServer - READ-ONLY; Name of the server hosting the datacenter management solution.
	DatacenterManagementServer *string `json:"datacenterManagementServer,omitempty"`
	// DatacenterMachineID - READ-ONLY; ID of the machine as tracked by the datacenter management solution.
	DatacenterMachineID *string `json:"datacenterMachineId,omitempty"`
	// DatacenterManagementServerID - READ-ONLY; ID of the server hosting the datacenter management solution.
	DatacenterManagementServerID *string `json:"datacenterManagementServerId,omitempty"`
	// Description - READ-ONLY; Description of the machine
	Description *string `json:"description,omitempty"`
	// DisplayName - READ-ONLY; User readable name of the machine as defined by the user in their private datacenter.
	DisplayName *string `json:"displayName,omitempty"`
	// MegabytesOfMemory - READ-ONLY; Memory in Megabytes.
	MegabytesOfMemory *float64 `json:"megabytesOfMemory,omitempty"`
	// NumberOfCores - READ-ONLY; Processor count.
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`
	// OperatingSystem - READ-ONLY; Operating System of the machine.
	OperatingSystem *string `json:"operatingSystem,omitempty"`
	// Groups - READ-ONLY; List of references to the groups that the machine is member of.
	Groups *[]string `json:"groups,omitempty"`
	// CreatedTimestamp - READ-ONLY; Time when this machine was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Time when this machine was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
	// DiscoveredTimestamp - READ-ONLY; Time when this machine was discovered by Azure Migrate agent. Date-Time represented in ISO-8601 format.
	DiscoveredTimestamp *date.Time `json:"discoveredTimestamp,omitempty"`
	// Disks - READ-ONLY; Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object
	Disks map[string]*Disk `json:"disks"`
	// NetworkAdapters - READ-ONLY; Dictionary of network adapters attached to the machine. Key is ID of network adapter. Value is a network adapter object
	NetworkAdapters map[string]*NetworkAdapter `json:"networkAdapters"`
}

// MarshalJSON is the custom marshaler for MachineProperties.
func (mp MachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MachineResultList list of machines.
type MachineResultList struct {
	autorest.Response `json:"-"`
	// Value - List of machines.
	Value *[]Machine `json:"value,omitempty"`
}

// NetworkAdapter a network adapter discovered on a machine.
type NetworkAdapter struct {
	// MacAddress - READ-ONLY; MAC Address of the network adapter.
	MacAddress *string `json:"macAddress,omitempty"`
	// IPAddresses - READ-ONLY; List of IP Addresses on the network adapter.
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
}

// Operation a REST API operation supported by the provider.
type Operation struct {
	// Name - READ-ONLY; Name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - Displayable properties of the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; Origin of the operation.
	Origin *string `json:"origin,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay displayable properties of the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Provider of the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource operated on by the operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation Type.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationResultList list of API operations.
type OperationResultList struct {
	autorest.Response `json:"-"`
	// Value - List of operations.
	Value *[]Operation `json:"value,omitempty"`
}

// Project azure Migrate Project.
type Project struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Path reference to this project /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the project.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the object = [Microsoft.Migrate/projects].
	Type *string `json:"type,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Location - Azure location in which project is created.
	Location *string `json:"location,omitempty"`
	// Tags - Tags provided by Azure Tagging service.
	Tags interface{} `json:"tags,omitempty"`
	// ProjectProperties - Properties of the project.
	*ProjectProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Project.
func (p Project) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ETag != nil {
		objectMap["eTag"] = p.ETag
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	if p.ProjectProperties != nil {
		objectMap["properties"] = p.ProjectProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Project struct.
func (p *Project) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				p.ETag = &eTag
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "properties":
			if v != nil {
				var projectProperties ProjectProperties
				err = json.Unmarshal(*v, &projectProperties)
				if err != nil {
					return err
				}
				p.ProjectProperties = &projectProperties
			}
		}
	}

	return nil
}

// ProjectKey ID and Key for Migration Project.
type ProjectKey struct {
	autorest.Response `json:"-"`
	// WorkspaceID - READ-ONLY; ID of Migration Project.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// WorkspaceKey - READ-ONLY; Key of Migration Project.
	WorkspaceKey *string `json:"workspaceKey,omitempty"`
}

// ProjectProperties properties of a project.
type ProjectProperties struct {
	// CreatedTimestamp - READ-ONLY; Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - READ-ONLY; Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
	// DiscoveryStatus - READ-ONLY; Reports whether project is under discovery. Possible values include: 'DiscoveryStatusUnknown', 'DiscoveryStatusNotStarted', 'DiscoveryStatusInProgress', 'DiscoveryStatusCompleted'
	DiscoveryStatus DiscoveryStatus `json:"discoveryStatus,omitempty"`
	// CustomerWorkspaceID - ARM ID of the Service Map workspace created by user.
	CustomerWorkspaceID *string `json:"customerWorkspaceId,omitempty"`
	// CustomerWorkspaceLocation - Location of the Service Map workspace created by user.
	CustomerWorkspaceLocation *string `json:"customerWorkspaceLocation,omitempty"`
	// LastDiscoveryTimestamp - READ-ONLY; Time when this project was created. Date-Time represented in ISO-8601 format. This value will be null until discovery is complete.
	LastDiscoveryTimestamp *date.Time `json:"lastDiscoveryTimestamp,omitempty"`
	// LastDiscoverySessionID - READ-ONLY; Session id of the last discovery.
	LastDiscoverySessionID *string `json:"lastDiscoverySessionId,omitempty"`
	// NumberOfGroups - READ-ONLY; Number of groups created in the project.
	NumberOfGroups *int32 `json:"numberOfGroups,omitempty"`
	// NumberOfMachines - READ-ONLY; Number of machines in the project.
	NumberOfMachines *int32 `json:"numberOfMachines,omitempty"`
	// NumberOfAssessments - READ-ONLY; Number of assessments created in the project.
	NumberOfAssessments *int32 `json:"numberOfAssessments,omitempty"`
	// LastAssessmentTimestamp - READ-ONLY; Time when last assessment was created. Date-Time represented in ISO-8601 format. This value will be null until assessment is created.
	LastAssessmentTimestamp *date.Time `json:"lastAssessmentTimestamp,omitempty"`
	// ProvisioningState - Provisioning state of the project. Possible values include: 'Accepted', 'Creating', 'Deleting', 'Failed', 'Moving', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ProjectProperties.
func (pp ProjectProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.CustomerWorkspaceID != nil {
		objectMap["customerWorkspaceId"] = pp.CustomerWorkspaceID
	}
	if pp.CustomerWorkspaceLocation != nil {
		objectMap["customerWorkspaceLocation"] = pp.CustomerWorkspaceLocation
	}
	if pp.ProvisioningState != "" {
		objectMap["provisioningState"] = pp.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// ProjectResultList list of projects.
type ProjectResultList struct {
	autorest.Response `json:"-"`
	// Value - List of projects.
	Value *[]Project `json:"value,omitempty"`
}

// VMFamily VM family name, the list of targeted azure locations and the category of the family.
type VMFamily struct {
	// FamilyName - READ-ONLY; Name of the VM family.
	FamilyName *string `json:"familyName,omitempty"`
	// TargetLocations - READ-ONLY; List of Azure regions.
	TargetLocations *[]string `json:"targetLocations,omitempty"`
	// Category - READ-ONLY; Category of the VM family.
	Category *[]string `json:"category,omitempty"`
}
