// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/helper/schema"
	"github.com/hashicorp/terraform-plugin-sdk/helper/validation"
)

func resourceAccessContextManagerAccessLevels() *schema.Resource {
	return &schema.Resource{
		Create: resourceAccessContextManagerAccessLevelsCreate,
		Read:   resourceAccessContextManagerAccessLevelsRead,
		Update: resourceAccessContextManagerAccessLevelsUpdate,
		Delete: resourceAccessContextManagerAccessLevelsDelete,

		Importer: &schema.ResourceImporter{
			State: resourceAccessContextManagerAccessLevelsImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(6 * time.Minute),
			Update: schema.DefaultTimeout(6 * time.Minute),
			Delete: schema.DefaultTimeout(6 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"parent": {
				Type:     schema.TypeString,
				Required: true,
				ForceNew: true,
				Description: `The AccessPolicy this AccessLevel lives in.
Format: accessPolicies/{policy_id}`,
			},
			"access_levels": {
				Type:        schema.TypeSet,
				Optional:    true,
				Description: `The desired Access Levels that should replace all existing Access Levels in the Access Policy.`,
				Elem:        accesscontextmanagerAccessLevelsAccessLevelsSchema(),
				// Default schema.HashSchema is used.
			},
		},
	}
}

func accesscontextmanagerAccessLevelsAccessLevelsSchema() *schema.Resource {
	return &schema.Resource{
		Schema: map[string]*schema.Schema{
			"name": {
				Type:     schema.TypeString,
				Required: true,
				ForceNew: true,
				Description: `Resource name for the Access Level. The short_name component must begin
with a letter and only include alphanumeric and '_'.
Format: accessPolicies/{policy_id}/accessLevels/{short_name}`,
			},
			"title": {
				Type:        schema.TypeString,
				Required:    true,
				Description: `Human readable title. Must be unique within the Policy.`,
			},
			"basic": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `A set of predefined conditions for the access level and a combining function.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"conditions": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `A set of requirements for the AccessLevel to be granted.`,
							MinItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"device_policy": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `Device specific restrictions, all restrictions must hold for
the Condition to be true. If not specified, all devices are
allowed.`,
										MaxItems: 1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"allowed_device_management_levels": {
													Type:     schema.TypeList,
													Optional: true,
													Description: `A list of allowed device management levels.
An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"]`,
													Elem: &schema.Schema{
														Type:         schema.TypeString,
														ValidateFunc: validation.StringInSlice([]string{"MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"}, false),
													},
												},
												"allowed_encryption_statuses": {
													Type:     schema.TypeList,
													Optional: true,
													Description: `A list of allowed encryptions statuses.
An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"]`,
													Elem: &schema.Schema{
														Type:         schema.TypeString,
														ValidateFunc: validation.StringInSlice([]string{"ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"}, false),
													},
												},
												"os_constraints": {
													Type:     schema.TypeList,
													Optional: true,
													Description: `A list of allowed OS versions.
An empty list allows all types and all versions.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"os_type": {
																Type:         schema.TypeString,
																Required:     true,
																ValidateFunc: validation.StringInSlice([]string{"OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS"}, false),
																Description:  `The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS"]`,
															},
															"minimum_version": {
																Type:     schema.TypeString,
																Optional: true,
																Description: `The minimum allowed OS version. If not set, any version
of this OS satisfies the constraint.
Format: "major.minor.patch" such as "10.5.301", "9.2.1".`,
															},
														},
													},
												},
												"require_admin_approval": {
													Type:        schema.TypeBool,
													Optional:    true,
													Description: `Whether the device needs to be approved by the customer admin.`,
												},
												"require_corp_owned": {
													Type:        schema.TypeBool,
													Optional:    true,
													Description: `Whether the device needs to be corp owned.`,
												},
												"require_screen_lock": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `Whether or not screenlock is required for the DevicePolicy
to be true. Defaults to false.`,
												},
											},
										},
									},
									"ip_subnetworks": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of CIDR block IP subnetwork specification. May be IPv4
or IPv6.
Note that for a CIDR IP address block, the specified IP address
portion must be properly truncated (i.e. all the host bits must
be zero) or the input is considered malformed. For example,
"192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
is not. The originating IP of a request must be in one of the
listed subnets in order for this Condition to be true.
If empty, all IP addresses are allowed.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"members": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `An allowed list of members (users, service accounts).
Using groups is not supported yet.

The signed-in user originating the request must be a part of one
of the provided members. If not specified, a request may come
from any user (logged in/not logged in, not present in any
groups, etc.).
Formats: 'user:{emailid}', 'serviceAccount:{emailid}'`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"negate": {
										Type:     schema.TypeBool,
										Optional: true,
										Description: `Whether to negate the Condition. If true, the Condition becomes
a NAND over its non-empty fields, each field must be false for
the Condition overall to be satisfied. Defaults to false.`,
									},
									"regions": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `The request must originate from one of the provided
countries/regions.
Format: A valid ISO 3166-1 alpha-2 code.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"required_access_levels": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of other access levels defined in the same Policy,
referenced by resource name. Referencing an AccessLevel which
does not exist is an error. All access levels listed must be
granted for the Condition to be true.
Format: accessPolicies/{policy_id}/accessLevels/{short_name}`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
								},
							},
						},
						"combining_function": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validation.StringInSlice([]string{"AND", "OR", ""}, false),
							Description: `How the conditions list should be combined to determine if a request
is granted this AccessLevel. If AND is used, each Condition in
conditions must be satisfied for the AccessLevel to be applied. If
OR is used, at least one Condition in conditions must be satisfied
for the AccessLevel to be applied. Default value: "AND" Possible values: ["AND", "OR"]`,
							Default: "AND",
						},
					},
				},
			},
			"custom": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `Custom access level conditions are set using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request. 
See CEL spec at: https://github.com/google/cel-spec.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"expr": {
							Type:     schema.TypeList,
							Required: true,
							Description: `Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language.
This page details the objects and attributes that are used to the build the CEL expressions for 
custom access levels - https://cloud.google.com/access-context-manager/docs/custom-access-level-spec.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"expression": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Textual representation of an expression in Common Expression Language syntax.`,
									},
									"description": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `Description of the expression`,
									},
									"location": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `String indicating the location of the expression for error reporting, e.g. a file name and a position in the file`,
									},
									"title": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `Title for the expression, i.e. a short string describing its purpose.`,
									},
								},
							},
						},
					},
				},
			},
			"description": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `Description of the AccessLevel and its use. Does not affect behavior.`,
			},
		},
	}
}

func resourceAccessContextManagerAccessLevelsCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	obj := make(map[string]interface{})
	accessLevelsProp, err := expandAccessContextManagerAccessLevelsAccessLevels(d.Get("access_levels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("access_levels"); !isEmptyValue(reflect.ValueOf(accessLevelsProp)) && (ok || !reflect.DeepEqual(v, accessLevelsProp)) {
		obj["accessLevels"] = accessLevelsProp
	}

	url, err := replaceVars(d, config, "{{AccessContextManagerBasePath}}{{parent}}/accessLevels:replaceAll")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new AccessLevels: %#v", obj)
	res, err := sendRequestWithTimeout(config, "POST", "", url, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating AccessLevels: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "{{parent}}/accessLevels")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	err = accessContextManagerOperationWaitTime(
		config, res, "Creating AccessLevels",
		d.Timeout(schema.TimeoutCreate))

	if err != nil {
		// The resource didn't actually create
		d.SetId("")
		return fmt.Errorf("Error waiting to create AccessLevels: %s", err)
	}

	log.Printf("[DEBUG] Finished creating AccessLevels %q: %#v", d.Id(), res)

	return resourceAccessContextManagerAccessLevelsRead(d, meta)
}

func resourceAccessContextManagerAccessLevelsRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	url, err := replaceVars(d, config, "{{AccessContextManagerBasePath}}{{parent}}/accessLevels")
	if err != nil {
		return err
	}

	res, err := sendRequest(config, "GET", "", url, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("AccessContextManagerAccessLevels %q", d.Id()))
	}

	if err := d.Set("access_levels", flattenAccessContextManagerAccessLevelsAccessLevels(res["accessLevels"], d, config)); err != nil {
		return fmt.Errorf("Error reading AccessLevels: %s", err)
	}

	return nil
}

func resourceAccessContextManagerAccessLevelsUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	obj := make(map[string]interface{})
	accessLevelsProp, err := expandAccessContextManagerAccessLevelsAccessLevels(d.Get("access_levels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("access_levels"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, accessLevelsProp)) {
		obj["accessLevels"] = accessLevelsProp
	}

	url, err := replaceVars(d, config, "{{AccessContextManagerBasePath}}{{parent}}/accessLevels:replaceAll")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating AccessLevels %q: %#v", d.Id(), obj)
	res, err := sendRequestWithTimeout(config, "POST", "", url, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating AccessLevels %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating AccessLevels %q: %#v", d.Id(), res)
	}

	err = accessContextManagerOperationWaitTime(
		config, res, "Updating AccessLevels",
		d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return err
	}

	return resourceAccessContextManagerAccessLevelsRead(d, meta)
}

func resourceAccessContextManagerAccessLevelsDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	obj := make(map[string]interface{})
	obj["accessLevels"] = []string{}

	url, err := replaceVars(d, config, "{{AccessContextManagerBasePath}}{{parent}}/accessLevels:replaceAll")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Deleting AccessLevels %q: %#v", d.Id(), obj)
	res, err := sendRequestWithTimeout(config, "POST", "", url, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error deleting AccessLevels %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished deleting AccessLevels %q: %#v", d.Id(), res)
	}

	err = accessContextManagerOperationWaitTime(
		config, res, "Updating AccessLevels",
		d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return err
	}

	return nil
}

func resourceAccessContextManagerAccessLevelsImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)

	// current import_formats can't import fields with forward slashes in their value
	parts, err := getImportIdQualifiers([]string{"accessPolicies/(?P<accessPolicy>[^/]+)/(.+)"}, d, config, d.Id())
	if err != nil {
		return nil, err
	}

	d.Set("parent", fmt.Sprintf("accessPolicies/%s", parts["accessPolicy"]))
	return []*schema.ResourceData{d}, nil
}

func flattenAccessContextManagerAccessLevelsAccessLevels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := schema.NewSet(schema.HashResource(accesscontextmanagerAccessLevelsAccessLevelsSchema()), []interface{}{})
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed.Add(map[string]interface{}{
			"name":        flattenAccessContextManagerAccessLevelsAccessLevelsName(original["name"], d, config),
			"title":       flattenAccessContextManagerAccessLevelsAccessLevelsTitle(original["title"], d, config),
			"description": flattenAccessContextManagerAccessLevelsAccessLevelsDescription(original["description"], d, config),
			"basic":       flattenAccessContextManagerAccessLevelsAccessLevelsBasic(original["basic"], d, config),
			"custom":      flattenAccessContextManagerAccessLevelsAccessLevelsCustom(original["custom"], d, config),
		})
	}
	return transformed
}
func flattenAccessContextManagerAccessLevelsAccessLevelsName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsTitle(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasic(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["combining_function"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsBasicCombiningFunction(original["combiningFunction"], d, config)
	transformed["conditions"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditions(original["conditions"], d, config)
	return []interface{}{transformed}
}
func flattenAccessContextManagerAccessLevelsAccessLevelsBasicCombiningFunction(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil || isEmptyValue(reflect.ValueOf(v)) {
		return "AND"
	}

	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"ip_subnetworks":         flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsIpSubnetworks(original["ipSubnetworks"], d, config),
			"required_access_levels": flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsRequiredAccessLevels(original["requiredAccessLevels"], d, config),
			"members":                flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsMembers(original["members"], d, config),
			"negate":                 flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsNegate(original["negate"], d, config),
			"device_policy":          flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy(original["devicePolicy"], d, config),
			"regions":                flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsRegions(original["regions"], d, config),
		})
	}
	return transformed
}
func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsIpSubnetworks(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsRequiredAccessLevels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsMembers(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsNegate(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["require_screen_lock"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireScreenLock(original["requireScreenlock"], d, config)
	transformed["allowed_encryption_statuses"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyAllowedEncryptionStatuses(original["allowedEncryptionStatuses"], d, config)
	transformed["allowed_device_management_levels"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyAllowedDeviceManagementLevels(original["allowedDeviceManagementLevels"], d, config)
	transformed["os_constraints"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints(original["osConstraints"], d, config)
	transformed["require_admin_approval"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireAdminApproval(original["requireAdminApproval"], d, config)
	transformed["require_corp_owned"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireCorpOwned(original["requireCorpOwned"], d, config)
	return []interface{}{transformed}
}
func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireScreenLock(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyAllowedEncryptionStatuses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyAllowedDeviceManagementLevels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"minimum_version": flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsMinimumVersion(original["minimumVersion"], d, config),
			"os_type":         flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsOsType(original["osType"], d, config),
		})
	}
	return transformed
}
func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsMinimumVersion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsOsType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireAdminApproval(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireCorpOwned(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsBasicConditionsRegions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsCustom(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["expr"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsCustomExpr(original["expr"], d, config)
	return []interface{}{transformed}
}
func flattenAccessContextManagerAccessLevelsAccessLevelsCustomExpr(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["expression"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsCustomExprExpression(original["expression"], d, config)
	transformed["title"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsCustomExprTitle(original["title"], d, config)
	transformed["description"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsCustomExprDescription(original["description"], d, config)
	transformed["location"] =
		flattenAccessContextManagerAccessLevelsAccessLevelsCustomExprLocation(original["location"], d, config)
	return []interface{}{transformed}
}
func flattenAccessContextManagerAccessLevelsAccessLevelsCustomExprExpression(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsCustomExprTitle(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsCustomExprDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessLevelsAccessLevelsCustomExprLocation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandAccessContextManagerAccessLevelsAccessLevels(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	v = v.(*schema.Set).List()
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedName, err := expandAccessContextManagerAccessLevelsAccessLevelsName(original["name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
			transformed["name"] = transformedName
		}

		transformedTitle, err := expandAccessContextManagerAccessLevelsAccessLevelsTitle(original["title"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTitle); val.IsValid() && !isEmptyValue(val) {
			transformed["title"] = transformedTitle
		}

		transformedDescription, err := expandAccessContextManagerAccessLevelsAccessLevelsDescription(original["description"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDescription); val.IsValid() && !isEmptyValue(val) {
			transformed["description"] = transformedDescription
		}

		transformedBasic, err := expandAccessContextManagerAccessLevelsAccessLevelsBasic(original["basic"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedBasic); val.IsValid() && !isEmptyValue(val) {
			transformed["basic"] = transformedBasic
		}

		transformedCustom, err := expandAccessContextManagerAccessLevelsAccessLevelsCustom(original["custom"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedCustom); val.IsValid() && !isEmptyValue(val) {
			transformed["custom"] = transformedCustom
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsTitle(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasic(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedCombiningFunction, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicCombiningFunction(original["combining_function"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCombiningFunction); val.IsValid() && !isEmptyValue(val) {
		transformed["combiningFunction"] = transformedCombiningFunction
	}

	transformedConditions, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditions(original["conditions"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedConditions); val.IsValid() && !isEmptyValue(val) {
		transformed["conditions"] = transformedConditions
	}

	return transformed, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicCombiningFunction(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedIpSubnetworks, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsIpSubnetworks(original["ip_subnetworks"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedIpSubnetworks); val.IsValid() && !isEmptyValue(val) {
			transformed["ipSubnetworks"] = transformedIpSubnetworks
		}

		transformedRequiredAccessLevels, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsRequiredAccessLevels(original["required_access_levels"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRequiredAccessLevels); val.IsValid() && !isEmptyValue(val) {
			transformed["requiredAccessLevels"] = transformedRequiredAccessLevels
		}

		transformedMembers, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsMembers(original["members"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedMembers); val.IsValid() && !isEmptyValue(val) {
			transformed["members"] = transformedMembers
		}

		transformedNegate, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsNegate(original["negate"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedNegate); val.IsValid() && !isEmptyValue(val) {
			transformed["negate"] = transformedNegate
		}

		transformedDevicePolicy, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy(original["device_policy"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDevicePolicy); val.IsValid() && !isEmptyValue(val) {
			transformed["devicePolicy"] = transformedDevicePolicy
		}

		transformedRegions, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsRegions(original["regions"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRegions); val.IsValid() && !isEmptyValue(val) {
			transformed["regions"] = transformedRegions
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsIpSubnetworks(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsRequiredAccessLevels(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsMembers(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsNegate(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedRequireScreenLock, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireScreenLock(original["require_screen_lock"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRequireScreenLock); val.IsValid() && !isEmptyValue(val) {
		transformed["requireScreenlock"] = transformedRequireScreenLock
	}

	transformedAllowedEncryptionStatuses, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyAllowedEncryptionStatuses(original["allowed_encryption_statuses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedEncryptionStatuses); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedEncryptionStatuses"] = transformedAllowedEncryptionStatuses
	}

	transformedAllowedDeviceManagementLevels, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyAllowedDeviceManagementLevels(original["allowed_device_management_levels"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedDeviceManagementLevels); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedDeviceManagementLevels"] = transformedAllowedDeviceManagementLevels
	}

	transformedOsConstraints, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints(original["os_constraints"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOsConstraints); val.IsValid() && !isEmptyValue(val) {
		transformed["osConstraints"] = transformedOsConstraints
	}

	transformedRequireAdminApproval, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireAdminApproval(original["require_admin_approval"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRequireAdminApproval); val.IsValid() && !isEmptyValue(val) {
		transformed["requireAdminApproval"] = transformedRequireAdminApproval
	}

	transformedRequireCorpOwned, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireCorpOwned(original["require_corp_owned"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRequireCorpOwned); val.IsValid() && !isEmptyValue(val) {
		transformed["requireCorpOwned"] = transformedRequireCorpOwned
	}

	return transformed, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireScreenLock(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyAllowedEncryptionStatuses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyAllowedDeviceManagementLevels(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedMinimumVersion, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsMinimumVersion(original["minimum_version"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedMinimumVersion); val.IsValid() && !isEmptyValue(val) {
			transformed["minimumVersion"] = transformedMinimumVersion
		}

		transformedOsType, err := expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsOsType(original["os_type"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedOsType); val.IsValid() && !isEmptyValue(val) {
			transformed["osType"] = transformedOsType
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsMinimumVersion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsOsType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireAdminApproval(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyRequireCorpOwned(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsBasicConditionsRegions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsCustom(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedExpr, err := expandAccessContextManagerAccessLevelsAccessLevelsCustomExpr(original["expr"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExpr); val.IsValid() && !isEmptyValue(val) {
		transformed["expr"] = transformedExpr
	}

	return transformed, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsCustomExpr(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedExpression, err := expandAccessContextManagerAccessLevelsAccessLevelsCustomExprExpression(original["expression"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExpression); val.IsValid() && !isEmptyValue(val) {
		transformed["expression"] = transformedExpression
	}

	transformedTitle, err := expandAccessContextManagerAccessLevelsAccessLevelsCustomExprTitle(original["title"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTitle); val.IsValid() && !isEmptyValue(val) {
		transformed["title"] = transformedTitle
	}

	transformedDescription, err := expandAccessContextManagerAccessLevelsAccessLevelsCustomExprDescription(original["description"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDescription); val.IsValid() && !isEmptyValue(val) {
		transformed["description"] = transformedDescription
	}

	transformedLocation, err := expandAccessContextManagerAccessLevelsAccessLevelsCustomExprLocation(original["location"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocation); val.IsValid() && !isEmptyValue(val) {
		transformed["location"] = transformedLocation
	}

	return transformed, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsCustomExprExpression(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsCustomExprTitle(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsCustomExprDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessLevelsAccessLevelsCustomExprLocation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}
