# Summary

[Introduction](./introduction.md)
[Quick Start](./user/quick-start.md)
[Concepts](./user/concepts.md)
[Personas](./user/personas.md)
- [Tasks](./tasks/index.md)
    - [Certificate Management](./tasks/certs/index.md)
        - [Using Custom Certificates](./tasks/certs/using-custom-certificates.md)
        - [Generating a Kubeconfig](./tasks/certs/generate-kubeconfig.md)
    - [Upgrade](./tasks/upgrade.md)
    - [Configure a MachineHealthCheck](./tasks/healthcheck.md)
    - [Kubeadm based control plane management](./tasks/kubeadm-control-plane.md)
- [clusterctl CLI](./clusterctl/overview.md)
    - [clusterctl Commands](clusterctl/commands/commands.md)
        - [init](clusterctl/commands/init.md)
        - [config cluster](clusterctl/commands/config-cluster.md)
        - [move](./clusterctl/commands/move.md)
        - [upgrade](clusterctl/commands/upgrade.md)
        - [delete](clusterctl/commands/delete.md)
    - [clusterctl Configuration](clusterctl/configuration.md)
    - [clusterctl Provider Contract](clusterctl/provider-contract.md)
    - [clusterctl for Developers](clusterctl/developers.md)
- [Developer Guide](./developer/guide.md)
    - [Repository Layout](./developer/repository-layout.md)
    - [Rapid iterative development with Tilt](./developer/tilt.md)
    - [Testing](./developer/testing.md)
    - [Controllers](./developer/architecture/controllers.md)
        - [Bootstrap](./developer/architecture/controllers/bootstrap.md)
        - [Cluster](./developer/architecture/controllers/cluster.md)
        - [Machine](./developer/architecture/controllers/machine.md)
        - [MachineSet](./developer/architecture/controllers/machine-set.md)
        - [MachineDeployment](./developer/architecture/controllers/machine-deployment.md)
        - [MachineHealthCheck](./developer/architecture/controllers/machine-health-check.md)
        - [Control Plane](./developer/architecture/controllers/control-plane.md)
    - [Provider Implementers](./developer/providers/implementers.md)
        - [v1alpha1 to v1alpha2](./developer/providers/v1alpha1-to-v1alpha2.md)
        - [v1alpha2 to v1alpha3](./developer/providers/v1alpha2-to-v1alpha3.md)
        - [Cluster Infrastructure](./developer/providers/cluster-infrastructure.md)
        - [Machine Infrastructure](./developer/providers/machine-infrastructure.md)
        - [Bootstrap](./developer/providers/bootstrap.md)
        - [Implementer's Guide](./developer/providers/implementers-guide/overview.md)
          - [Naming](./developer/providers/implementers-guide/naming.md)
          - [Create Repo and Generate CRDs](./developer/providers/implementers-guide/generate_crds.md)
          - [Create API](./developer/providers/implementers-guide/create_api.md)
          - [Controllers and Reconciliation](./developer/providers/implementers-guide/controllers_and_reconciliation.md)
          - [Building, Running, Testing](./developer/providers/implementers-guide/building_running_and_testing.md)
- [Troubleshooting](./user/troubleshooting.md)
- [Reference](./reference/reference.md)
    - [Glossary](./reference/glossary.md)
    - [Provider List](./reference/providers.md)
    - [Ports](./reference/ports.md)
    - [Code of Conduct](./code-of-conduct.md)
    - [Contributing](./CONTRIBUTING.md)
    - [Roadmap](./roadmap.md)
