// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha2

import (
	time "time"
	unsafe "unsafe"

	v1 "k8s.io/api/core/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	v1alpha3 "sigs.k8s.io/cluster-api-provider-azure/api/v1alpha3"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*AvailabilityZone)(nil), (*v1alpha3.AvailabilityZone)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AvailabilityZone_To_v1alpha3_AvailabilityZone(a.(*AvailabilityZone), b.(*v1alpha3.AvailabilityZone), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AvailabilityZone)(nil), (*AvailabilityZone)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AvailabilityZone_To_v1alpha2_AvailabilityZone(a.(*v1alpha3.AvailabilityZone), b.(*AvailabilityZone), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureCluster)(nil), (*v1alpha3.AzureCluster)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureCluster_To_v1alpha3_AzureCluster(a.(*AzureCluster), b.(*v1alpha3.AzureCluster), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureCluster)(nil), (*AzureCluster)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureCluster_To_v1alpha2_AzureCluster(a.(*v1alpha3.AzureCluster), b.(*AzureCluster), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureClusterList)(nil), (*v1alpha3.AzureClusterList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureClusterList_To_v1alpha3_AzureClusterList(a.(*AzureClusterList), b.(*v1alpha3.AzureClusterList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureClusterList)(nil), (*AzureClusterList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureClusterList_To_v1alpha2_AzureClusterList(a.(*v1alpha3.AzureClusterList), b.(*AzureClusterList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureMachine)(nil), (*v1alpha3.AzureMachine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureMachine_To_v1alpha3_AzureMachine(a.(*AzureMachine), b.(*v1alpha3.AzureMachine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureMachine)(nil), (*AzureMachine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureMachine_To_v1alpha2_AzureMachine(a.(*v1alpha3.AzureMachine), b.(*AzureMachine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureMachineList)(nil), (*v1alpha3.AzureMachineList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureMachineList_To_v1alpha3_AzureMachineList(a.(*AzureMachineList), b.(*v1alpha3.AzureMachineList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureMachineList)(nil), (*AzureMachineList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureMachineList_To_v1alpha2_AzureMachineList(a.(*v1alpha3.AzureMachineList), b.(*AzureMachineList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureMachineProviderCondition)(nil), (*v1alpha3.AzureMachineProviderCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureMachineProviderCondition_To_v1alpha3_AzureMachineProviderCondition(a.(*AzureMachineProviderCondition), b.(*v1alpha3.AzureMachineProviderCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureMachineProviderCondition)(nil), (*AzureMachineProviderCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureMachineProviderCondition_To_v1alpha2_AzureMachineProviderCondition(a.(*v1alpha3.AzureMachineProviderCondition), b.(*AzureMachineProviderCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureMachineTemplate)(nil), (*v1alpha3.AzureMachineTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureMachineTemplate_To_v1alpha3_AzureMachineTemplate(a.(*AzureMachineTemplate), b.(*v1alpha3.AzureMachineTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureMachineTemplate)(nil), (*AzureMachineTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureMachineTemplate_To_v1alpha2_AzureMachineTemplate(a.(*v1alpha3.AzureMachineTemplate), b.(*AzureMachineTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureMachineTemplateList)(nil), (*v1alpha3.AzureMachineTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureMachineTemplateList_To_v1alpha3_AzureMachineTemplateList(a.(*AzureMachineTemplateList), b.(*v1alpha3.AzureMachineTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureMachineTemplateList)(nil), (*AzureMachineTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureMachineTemplateList_To_v1alpha2_AzureMachineTemplateList(a.(*v1alpha3.AzureMachineTemplateList), b.(*AzureMachineTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureMachineTemplateResource)(nil), (*v1alpha3.AzureMachineTemplateResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureMachineTemplateResource_To_v1alpha3_AzureMachineTemplateResource(a.(*AzureMachineTemplateResource), b.(*v1alpha3.AzureMachineTemplateResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureMachineTemplateResource)(nil), (*AzureMachineTemplateResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureMachineTemplateResource_To_v1alpha2_AzureMachineTemplateResource(a.(*v1alpha3.AzureMachineTemplateResource), b.(*AzureMachineTemplateResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureMachineTemplateSpec)(nil), (*v1alpha3.AzureMachineTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureMachineTemplateSpec_To_v1alpha3_AzureMachineTemplateSpec(a.(*AzureMachineTemplateSpec), b.(*v1alpha3.AzureMachineTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureMachineTemplateSpec)(nil), (*AzureMachineTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureMachineTemplateSpec_To_v1alpha2_AzureMachineTemplateSpec(a.(*v1alpha3.AzureMachineTemplateSpec), b.(*AzureMachineTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AzureResourceReference)(nil), (*v1alpha3.AzureResourceReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureResourceReference_To_v1alpha3_AzureResourceReference(a.(*AzureResourceReference), b.(*v1alpha3.AzureResourceReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.AzureResourceReference)(nil), (*AzureResourceReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureResourceReference_To_v1alpha2_AzureResourceReference(a.(*v1alpha3.AzureResourceReference), b.(*AzureResourceReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BackendPool)(nil), (*v1alpha3.BackendPool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_BackendPool_To_v1alpha3_BackendPool(a.(*BackendPool), b.(*v1alpha3.BackendPool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.BackendPool)(nil), (*BackendPool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_BackendPool_To_v1alpha2_BackendPool(a.(*v1alpha3.BackendPool), b.(*BackendPool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BuildParams)(nil), (*v1alpha3.BuildParams)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_BuildParams_To_v1alpha3_BuildParams(a.(*BuildParams), b.(*v1alpha3.BuildParams), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.BuildParams)(nil), (*BuildParams)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_BuildParams_To_v1alpha2_BuildParams(a.(*v1alpha3.BuildParams), b.(*BuildParams), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FrontendIPConfig)(nil), (*v1alpha3.FrontendIPConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_FrontendIPConfig_To_v1alpha3_FrontendIPConfig(a.(*FrontendIPConfig), b.(*v1alpha3.FrontendIPConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.FrontendIPConfig)(nil), (*FrontendIPConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_FrontendIPConfig_To_v1alpha2_FrontendIPConfig(a.(*v1alpha3.FrontendIPConfig), b.(*FrontendIPConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*IngressRule)(nil), (*v1alpha3.IngressRule)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_IngressRule_To_v1alpha3_IngressRule(a.(*IngressRule), b.(*v1alpha3.IngressRule), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.IngressRule)(nil), (*IngressRule)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IngressRule_To_v1alpha2_IngressRule(a.(*v1alpha3.IngressRule), b.(*IngressRule), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LoadBalancer)(nil), (*v1alpha3.LoadBalancer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_LoadBalancer_To_v1alpha3_LoadBalancer(a.(*LoadBalancer), b.(*v1alpha3.LoadBalancer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.LoadBalancer)(nil), (*LoadBalancer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_LoadBalancer_To_v1alpha2_LoadBalancer(a.(*v1alpha3.LoadBalancer), b.(*LoadBalancer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LoadBalancerHealthCheck)(nil), (*v1alpha3.LoadBalancerHealthCheck)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_LoadBalancerHealthCheck_To_v1alpha3_LoadBalancerHealthCheck(a.(*LoadBalancerHealthCheck), b.(*v1alpha3.LoadBalancerHealthCheck), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.LoadBalancerHealthCheck)(nil), (*LoadBalancerHealthCheck)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_LoadBalancerHealthCheck_To_v1alpha2_LoadBalancerHealthCheck(a.(*v1alpha3.LoadBalancerHealthCheck), b.(*LoadBalancerHealthCheck), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LoadBalancerListener)(nil), (*v1alpha3.LoadBalancerListener)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_LoadBalancerListener_To_v1alpha3_LoadBalancerListener(a.(*LoadBalancerListener), b.(*v1alpha3.LoadBalancerListener), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.LoadBalancerListener)(nil), (*LoadBalancerListener)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_LoadBalancerListener_To_v1alpha2_LoadBalancerListener(a.(*v1alpha3.LoadBalancerListener), b.(*LoadBalancerListener), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ManagedDisk)(nil), (*v1alpha3.ManagedDisk)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ManagedDisk_To_v1alpha3_ManagedDisk(a.(*ManagedDisk), b.(*v1alpha3.ManagedDisk), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.ManagedDisk)(nil), (*ManagedDisk)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ManagedDisk_To_v1alpha2_ManagedDisk(a.(*v1alpha3.ManagedDisk), b.(*ManagedDisk), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Network)(nil), (*v1alpha3.Network)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_Network_To_v1alpha3_Network(a.(*Network), b.(*v1alpha3.Network), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.Network)(nil), (*Network)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Network_To_v1alpha2_Network(a.(*v1alpha3.Network), b.(*Network), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NetworkSpec)(nil), (*v1alpha3.NetworkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_NetworkSpec_To_v1alpha3_NetworkSpec(a.(*NetworkSpec), b.(*v1alpha3.NetworkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.NetworkSpec)(nil), (*NetworkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_NetworkSpec_To_v1alpha2_NetworkSpec(a.(*v1alpha3.NetworkSpec), b.(*NetworkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OSDisk)(nil), (*v1alpha3.OSDisk)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_OSDisk_To_v1alpha3_OSDisk(a.(*OSDisk), b.(*v1alpha3.OSDisk), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.OSDisk)(nil), (*OSDisk)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OSDisk_To_v1alpha2_OSDisk(a.(*v1alpha3.OSDisk), b.(*OSDisk), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PublicIP)(nil), (*v1alpha3.PublicIP)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PublicIP_To_v1alpha3_PublicIP(a.(*PublicIP), b.(*v1alpha3.PublicIP), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.PublicIP)(nil), (*PublicIP)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_PublicIP_To_v1alpha2_PublicIP(a.(*v1alpha3.PublicIP), b.(*PublicIP), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SecurityGroup)(nil), (*v1alpha3.SecurityGroup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_SecurityGroup_To_v1alpha3_SecurityGroup(a.(*SecurityGroup), b.(*v1alpha3.SecurityGroup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.SecurityGroup)(nil), (*SecurityGroup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SecurityGroup_To_v1alpha2_SecurityGroup(a.(*v1alpha3.SecurityGroup), b.(*SecurityGroup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SubnetSpec)(nil), (*v1alpha3.SubnetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_SubnetSpec_To_v1alpha3_SubnetSpec(a.(*SubnetSpec), b.(*v1alpha3.SubnetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.SubnetSpec)(nil), (*SubnetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SubnetSpec_To_v1alpha2_SubnetSpec(a.(*v1alpha3.SubnetSpec), b.(*SubnetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VM)(nil), (*v1alpha3.VM)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VM_To_v1alpha3_VM(a.(*VM), b.(*v1alpha3.VM), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.VM)(nil), (*VM)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VM_To_v1alpha2_VM(a.(*v1alpha3.VM), b.(*VM), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VnetSpec)(nil), (*v1alpha3.VnetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VnetSpec_To_v1alpha3_VnetSpec(a.(*VnetSpec), b.(*v1alpha3.VnetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.VnetSpec)(nil), (*VnetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VnetSpec_To_v1alpha2_VnetSpec(a.(*v1alpha3.VnetSpec), b.(*VnetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*AzureClusterSpec)(nil), (*v1alpha3.AzureClusterSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureClusterSpec_To_v1alpha3_AzureClusterSpec(a.(*AzureClusterSpec), b.(*v1alpha3.AzureClusterSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*AzureClusterStatus)(nil), (*v1alpha3.AzureClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureClusterStatus_To_v1alpha3_AzureClusterStatus(a.(*AzureClusterStatus), b.(*v1alpha3.AzureClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*AzureMachineSpec)(nil), (*v1alpha3.AzureMachineSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureMachineSpec_To_v1alpha3_AzureMachineSpec(a.(*AzureMachineSpec), b.(*v1alpha3.AzureMachineSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*AzureMachineStatus)(nil), (*v1alpha3.AzureMachineStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AzureMachineStatus_To_v1alpha3_AzureMachineStatus(a.(*AzureMachineStatus), b.(*v1alpha3.AzureMachineStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*Image)(nil), (*v1alpha3.Image)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_Image_To_v1alpha3_Image(a.(*Image), b.(*v1alpha3.Image), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha3.AzureClusterSpec)(nil), (*AzureClusterSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureClusterSpec_To_v1alpha2_AzureClusterSpec(a.(*v1alpha3.AzureClusterSpec), b.(*AzureClusterSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha3.AzureClusterStatus)(nil), (*AzureClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureClusterStatus_To_v1alpha2_AzureClusterStatus(a.(*v1alpha3.AzureClusterStatus), b.(*AzureClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha3.AzureMachineSpec)(nil), (*AzureMachineSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureMachineSpec_To_v1alpha2_AzureMachineSpec(a.(*v1alpha3.AzureMachineSpec), b.(*AzureMachineSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha3.AzureMachineStatus)(nil), (*AzureMachineStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AzureMachineStatus_To_v1alpha2_AzureMachineStatus(a.(*v1alpha3.AzureMachineStatus), b.(*AzureMachineStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha3.Image)(nil), (*Image)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Image_To_v1alpha2_Image(a.(*v1alpha3.Image), b.(*Image), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha2_AvailabilityZone_To_v1alpha3_AvailabilityZone(in *AvailabilityZone, out *v1alpha3.AvailabilityZone, s conversion.Scope) error {
	out.ID = (*string)(unsafe.Pointer(in.ID))
	out.Enabled = (*bool)(unsafe.Pointer(in.Enabled))
	return nil
}

// Convert_v1alpha2_AvailabilityZone_To_v1alpha3_AvailabilityZone is an autogenerated conversion function.
func Convert_v1alpha2_AvailabilityZone_To_v1alpha3_AvailabilityZone(in *AvailabilityZone, out *v1alpha3.AvailabilityZone, s conversion.Scope) error {
	return autoConvert_v1alpha2_AvailabilityZone_To_v1alpha3_AvailabilityZone(in, out, s)
}

func autoConvert_v1alpha3_AvailabilityZone_To_v1alpha2_AvailabilityZone(in *v1alpha3.AvailabilityZone, out *AvailabilityZone, s conversion.Scope) error {
	out.ID = (*string)(unsafe.Pointer(in.ID))
	out.Enabled = (*bool)(unsafe.Pointer(in.Enabled))
	return nil
}

// Convert_v1alpha3_AvailabilityZone_To_v1alpha2_AvailabilityZone is an autogenerated conversion function.
func Convert_v1alpha3_AvailabilityZone_To_v1alpha2_AvailabilityZone(in *v1alpha3.AvailabilityZone, out *AvailabilityZone, s conversion.Scope) error {
	return autoConvert_v1alpha3_AvailabilityZone_To_v1alpha2_AvailabilityZone(in, out, s)
}

func autoConvert_v1alpha2_AzureCluster_To_v1alpha3_AzureCluster(in *AzureCluster, out *v1alpha3.AzureCluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_AzureClusterSpec_To_v1alpha3_AzureClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_AzureClusterStatus_To_v1alpha3_AzureClusterStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_AzureCluster_To_v1alpha3_AzureCluster is an autogenerated conversion function.
func Convert_v1alpha2_AzureCluster_To_v1alpha3_AzureCluster(in *AzureCluster, out *v1alpha3.AzureCluster, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureCluster_To_v1alpha3_AzureCluster(in, out, s)
}

func autoConvert_v1alpha3_AzureCluster_To_v1alpha2_AzureCluster(in *v1alpha3.AzureCluster, out *AzureCluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_AzureClusterSpec_To_v1alpha2_AzureClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_AzureClusterStatus_To_v1alpha2_AzureClusterStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_AzureCluster_To_v1alpha2_AzureCluster is an autogenerated conversion function.
func Convert_v1alpha3_AzureCluster_To_v1alpha2_AzureCluster(in *v1alpha3.AzureCluster, out *AzureCluster, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureCluster_To_v1alpha2_AzureCluster(in, out, s)
}

func autoConvert_v1alpha2_AzureClusterList_To_v1alpha3_AzureClusterList(in *AzureClusterList, out *v1alpha3.AzureClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha3.AzureCluster, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_AzureCluster_To_v1alpha3_AzureCluster(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_AzureClusterList_To_v1alpha3_AzureClusterList is an autogenerated conversion function.
func Convert_v1alpha2_AzureClusterList_To_v1alpha3_AzureClusterList(in *AzureClusterList, out *v1alpha3.AzureClusterList, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureClusterList_To_v1alpha3_AzureClusterList(in, out, s)
}

func autoConvert_v1alpha3_AzureClusterList_To_v1alpha2_AzureClusterList(in *v1alpha3.AzureClusterList, out *AzureClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]AzureCluster, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_AzureCluster_To_v1alpha2_AzureCluster(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_AzureClusterList_To_v1alpha2_AzureClusterList is an autogenerated conversion function.
func Convert_v1alpha3_AzureClusterList_To_v1alpha2_AzureClusterList(in *v1alpha3.AzureClusterList, out *AzureClusterList, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureClusterList_To_v1alpha2_AzureClusterList(in, out, s)
}

func autoConvert_v1alpha2_AzureClusterSpec_To_v1alpha3_AzureClusterSpec(in *AzureClusterSpec, out *v1alpha3.AzureClusterSpec, s conversion.Scope) error {
	if err := Convert_v1alpha2_NetworkSpec_To_v1alpha3_NetworkSpec(&in.NetworkSpec, &out.NetworkSpec, s); err != nil {
		return err
	}
	out.ResourceGroup = in.ResourceGroup
	out.Location = in.Location
	out.AdditionalTags = *(*v1alpha3.Tags)(unsafe.Pointer(&in.AdditionalTags))
	return nil
}

func autoConvert_v1alpha3_AzureClusterSpec_To_v1alpha2_AzureClusterSpec(in *v1alpha3.AzureClusterSpec, out *AzureClusterSpec, s conversion.Scope) error {
	if err := Convert_v1alpha3_NetworkSpec_To_v1alpha2_NetworkSpec(&in.NetworkSpec, &out.NetworkSpec, s); err != nil {
		return err
	}
	out.ResourceGroup = in.ResourceGroup
	out.Location = in.Location
	// WARNING: in.ControlPlaneEndpoint requires manual conversion: does not exist in peer-type
	out.AdditionalTags = *(*Tags)(unsafe.Pointer(&in.AdditionalTags))
	return nil
}

func autoConvert_v1alpha2_AzureClusterStatus_To_v1alpha3_AzureClusterStatus(in *AzureClusterStatus, out *v1alpha3.AzureClusterStatus, s conversion.Scope) error {
	if err := Convert_v1alpha2_Network_To_v1alpha3_Network(&in.Network, &out.Network, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_VM_To_v1alpha3_VM(&in.Bastion, &out.Bastion, s); err != nil {
		return err
	}
	out.Ready = in.Ready
	// WARNING: in.APIEndpoints requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_AzureClusterStatus_To_v1alpha2_AzureClusterStatus(in *v1alpha3.AzureClusterStatus, out *AzureClusterStatus, s conversion.Scope) error {
	if err := Convert_v1alpha3_Network_To_v1alpha2_Network(&in.Network, &out.Network, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_VM_To_v1alpha2_VM(&in.Bastion, &out.Bastion, s); err != nil {
		return err
	}
	out.Ready = in.Ready
	return nil
}

func autoConvert_v1alpha2_AzureMachine_To_v1alpha3_AzureMachine(in *AzureMachine, out *v1alpha3.AzureMachine, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_AzureMachineSpec_To_v1alpha3_AzureMachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_AzureMachineStatus_To_v1alpha3_AzureMachineStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_AzureMachine_To_v1alpha3_AzureMachine is an autogenerated conversion function.
func Convert_v1alpha2_AzureMachine_To_v1alpha3_AzureMachine(in *AzureMachine, out *v1alpha3.AzureMachine, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureMachine_To_v1alpha3_AzureMachine(in, out, s)
}

func autoConvert_v1alpha3_AzureMachine_To_v1alpha2_AzureMachine(in *v1alpha3.AzureMachine, out *AzureMachine, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_AzureMachineSpec_To_v1alpha2_AzureMachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_AzureMachineStatus_To_v1alpha2_AzureMachineStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_AzureMachine_To_v1alpha2_AzureMachine is an autogenerated conversion function.
func Convert_v1alpha3_AzureMachine_To_v1alpha2_AzureMachine(in *v1alpha3.AzureMachine, out *AzureMachine, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureMachine_To_v1alpha2_AzureMachine(in, out, s)
}

func autoConvert_v1alpha2_AzureMachineList_To_v1alpha3_AzureMachineList(in *AzureMachineList, out *v1alpha3.AzureMachineList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha3.AzureMachine, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_AzureMachine_To_v1alpha3_AzureMachine(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_AzureMachineList_To_v1alpha3_AzureMachineList is an autogenerated conversion function.
func Convert_v1alpha2_AzureMachineList_To_v1alpha3_AzureMachineList(in *AzureMachineList, out *v1alpha3.AzureMachineList, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureMachineList_To_v1alpha3_AzureMachineList(in, out, s)
}

func autoConvert_v1alpha3_AzureMachineList_To_v1alpha2_AzureMachineList(in *v1alpha3.AzureMachineList, out *AzureMachineList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]AzureMachine, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_AzureMachine_To_v1alpha2_AzureMachine(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_AzureMachineList_To_v1alpha2_AzureMachineList is an autogenerated conversion function.
func Convert_v1alpha3_AzureMachineList_To_v1alpha2_AzureMachineList(in *v1alpha3.AzureMachineList, out *AzureMachineList, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureMachineList_To_v1alpha2_AzureMachineList(in, out, s)
}

func autoConvert_v1alpha2_AzureMachineProviderCondition_To_v1alpha3_AzureMachineProviderCondition(in *AzureMachineProviderCondition, out *v1alpha3.AzureMachineProviderCondition, s conversion.Scope) error {
	out.Type = v1alpha3.AzureMachineProviderConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1alpha2_AzureMachineProviderCondition_To_v1alpha3_AzureMachineProviderCondition is an autogenerated conversion function.
func Convert_v1alpha2_AzureMachineProviderCondition_To_v1alpha3_AzureMachineProviderCondition(in *AzureMachineProviderCondition, out *v1alpha3.AzureMachineProviderCondition, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureMachineProviderCondition_To_v1alpha3_AzureMachineProviderCondition(in, out, s)
}

func autoConvert_v1alpha3_AzureMachineProviderCondition_To_v1alpha2_AzureMachineProviderCondition(in *v1alpha3.AzureMachineProviderCondition, out *AzureMachineProviderCondition, s conversion.Scope) error {
	out.Type = AzureMachineProviderConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1alpha3_AzureMachineProviderCondition_To_v1alpha2_AzureMachineProviderCondition is an autogenerated conversion function.
func Convert_v1alpha3_AzureMachineProviderCondition_To_v1alpha2_AzureMachineProviderCondition(in *v1alpha3.AzureMachineProviderCondition, out *AzureMachineProviderCondition, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureMachineProviderCondition_To_v1alpha2_AzureMachineProviderCondition(in, out, s)
}

func autoConvert_v1alpha2_AzureMachineSpec_To_v1alpha3_AzureMachineSpec(in *AzureMachineSpec, out *v1alpha3.AzureMachineSpec, s conversion.Scope) error {
	out.ProviderID = (*string)(unsafe.Pointer(in.ProviderID))
	out.VMSize = in.VMSize
	if err := Convert_v1alpha2_AvailabilityZone_To_v1alpha3_AvailabilityZone(&in.AvailabilityZone, &out.AvailabilityZone, s); err != nil {
		return err
	}
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(v1alpha3.Image)
		if err := Convert_v1alpha2_Image_To_v1alpha3_Image(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	if err := Convert_v1alpha2_OSDisk_To_v1alpha3_OSDisk(&in.OSDisk, &out.OSDisk, s); err != nil {
		return err
	}
	out.Location = in.Location
	out.SSHPublicKey = in.SSHPublicKey
	out.AdditionalTags = *(*v1alpha3.Tags)(unsafe.Pointer(&in.AdditionalTags))
	out.AllocatePublicIP = in.AllocatePublicIP
	return nil
}

func autoConvert_v1alpha3_AzureMachineSpec_To_v1alpha2_AzureMachineSpec(in *v1alpha3.AzureMachineSpec, out *AzureMachineSpec, s conversion.Scope) error {
	out.ProviderID = (*string)(unsafe.Pointer(in.ProviderID))
	out.VMSize = in.VMSize
	if err := Convert_v1alpha3_AvailabilityZone_To_v1alpha2_AvailabilityZone(&in.AvailabilityZone, &out.AvailabilityZone, s); err != nil {
		return err
	}
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(Image)
		if err := Convert_v1alpha3_Image_To_v1alpha2_Image(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	if err := Convert_v1alpha3_OSDisk_To_v1alpha2_OSDisk(&in.OSDisk, &out.OSDisk, s); err != nil {
		return err
	}
	out.Location = in.Location
	out.SSHPublicKey = in.SSHPublicKey
	out.AdditionalTags = *(*Tags)(unsafe.Pointer(&in.AdditionalTags))
	out.AllocatePublicIP = in.AllocatePublicIP
	return nil
}

func autoConvert_v1alpha2_AzureMachineStatus_To_v1alpha3_AzureMachineStatus(in *AzureMachineStatus, out *v1alpha3.AzureMachineStatus, s conversion.Scope) error {
	out.Ready = in.Ready
	out.Addresses = *(*[]v1.NodeAddress)(unsafe.Pointer(&in.Addresses))
	out.VMState = (*v1alpha3.VMState)(unsafe.Pointer(in.VMState))
	// WARNING: in.ErrorReason requires manual conversion: does not exist in peer-type
	// WARNING: in.ErrorMessage requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_AzureMachineStatus_To_v1alpha2_AzureMachineStatus(in *v1alpha3.AzureMachineStatus, out *AzureMachineStatus, s conversion.Scope) error {
	out.Ready = in.Ready
	out.Addresses = *(*[]v1.NodeAddress)(unsafe.Pointer(&in.Addresses))
	out.VMState = (*VMState)(unsafe.Pointer(in.VMState))
	// WARNING: in.FailureReason requires manual conversion: does not exist in peer-type
	// WARNING: in.FailureMessage requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha2_AzureMachineTemplate_To_v1alpha3_AzureMachineTemplate(in *AzureMachineTemplate, out *v1alpha3.AzureMachineTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_AzureMachineTemplateSpec_To_v1alpha3_AzureMachineTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_AzureMachineTemplate_To_v1alpha3_AzureMachineTemplate is an autogenerated conversion function.
func Convert_v1alpha2_AzureMachineTemplate_To_v1alpha3_AzureMachineTemplate(in *AzureMachineTemplate, out *v1alpha3.AzureMachineTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureMachineTemplate_To_v1alpha3_AzureMachineTemplate(in, out, s)
}

func autoConvert_v1alpha3_AzureMachineTemplate_To_v1alpha2_AzureMachineTemplate(in *v1alpha3.AzureMachineTemplate, out *AzureMachineTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_AzureMachineTemplateSpec_To_v1alpha2_AzureMachineTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_AzureMachineTemplate_To_v1alpha2_AzureMachineTemplate is an autogenerated conversion function.
func Convert_v1alpha3_AzureMachineTemplate_To_v1alpha2_AzureMachineTemplate(in *v1alpha3.AzureMachineTemplate, out *AzureMachineTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureMachineTemplate_To_v1alpha2_AzureMachineTemplate(in, out, s)
}

func autoConvert_v1alpha2_AzureMachineTemplateList_To_v1alpha3_AzureMachineTemplateList(in *AzureMachineTemplateList, out *v1alpha3.AzureMachineTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha3.AzureMachineTemplate, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_AzureMachineTemplate_To_v1alpha3_AzureMachineTemplate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_AzureMachineTemplateList_To_v1alpha3_AzureMachineTemplateList is an autogenerated conversion function.
func Convert_v1alpha2_AzureMachineTemplateList_To_v1alpha3_AzureMachineTemplateList(in *AzureMachineTemplateList, out *v1alpha3.AzureMachineTemplateList, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureMachineTemplateList_To_v1alpha3_AzureMachineTemplateList(in, out, s)
}

func autoConvert_v1alpha3_AzureMachineTemplateList_To_v1alpha2_AzureMachineTemplateList(in *v1alpha3.AzureMachineTemplateList, out *AzureMachineTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]AzureMachineTemplate, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_AzureMachineTemplate_To_v1alpha2_AzureMachineTemplate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_AzureMachineTemplateList_To_v1alpha2_AzureMachineTemplateList is an autogenerated conversion function.
func Convert_v1alpha3_AzureMachineTemplateList_To_v1alpha2_AzureMachineTemplateList(in *v1alpha3.AzureMachineTemplateList, out *AzureMachineTemplateList, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureMachineTemplateList_To_v1alpha2_AzureMachineTemplateList(in, out, s)
}

func autoConvert_v1alpha2_AzureMachineTemplateResource_To_v1alpha3_AzureMachineTemplateResource(in *AzureMachineTemplateResource, out *v1alpha3.AzureMachineTemplateResource, s conversion.Scope) error {
	if err := Convert_v1alpha2_AzureMachineSpec_To_v1alpha3_AzureMachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_AzureMachineTemplateResource_To_v1alpha3_AzureMachineTemplateResource is an autogenerated conversion function.
func Convert_v1alpha2_AzureMachineTemplateResource_To_v1alpha3_AzureMachineTemplateResource(in *AzureMachineTemplateResource, out *v1alpha3.AzureMachineTemplateResource, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureMachineTemplateResource_To_v1alpha3_AzureMachineTemplateResource(in, out, s)
}

func autoConvert_v1alpha3_AzureMachineTemplateResource_To_v1alpha2_AzureMachineTemplateResource(in *v1alpha3.AzureMachineTemplateResource, out *AzureMachineTemplateResource, s conversion.Scope) error {
	if err := Convert_v1alpha3_AzureMachineSpec_To_v1alpha2_AzureMachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_AzureMachineTemplateResource_To_v1alpha2_AzureMachineTemplateResource is an autogenerated conversion function.
func Convert_v1alpha3_AzureMachineTemplateResource_To_v1alpha2_AzureMachineTemplateResource(in *v1alpha3.AzureMachineTemplateResource, out *AzureMachineTemplateResource, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureMachineTemplateResource_To_v1alpha2_AzureMachineTemplateResource(in, out, s)
}

func autoConvert_v1alpha2_AzureMachineTemplateSpec_To_v1alpha3_AzureMachineTemplateSpec(in *AzureMachineTemplateSpec, out *v1alpha3.AzureMachineTemplateSpec, s conversion.Scope) error {
	if err := Convert_v1alpha2_AzureMachineTemplateResource_To_v1alpha3_AzureMachineTemplateResource(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_AzureMachineTemplateSpec_To_v1alpha3_AzureMachineTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha2_AzureMachineTemplateSpec_To_v1alpha3_AzureMachineTemplateSpec(in *AzureMachineTemplateSpec, out *v1alpha3.AzureMachineTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureMachineTemplateSpec_To_v1alpha3_AzureMachineTemplateSpec(in, out, s)
}

func autoConvert_v1alpha3_AzureMachineTemplateSpec_To_v1alpha2_AzureMachineTemplateSpec(in *v1alpha3.AzureMachineTemplateSpec, out *AzureMachineTemplateSpec, s conversion.Scope) error {
	if err := Convert_v1alpha3_AzureMachineTemplateResource_To_v1alpha2_AzureMachineTemplateResource(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_AzureMachineTemplateSpec_To_v1alpha2_AzureMachineTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha3_AzureMachineTemplateSpec_To_v1alpha2_AzureMachineTemplateSpec(in *v1alpha3.AzureMachineTemplateSpec, out *AzureMachineTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureMachineTemplateSpec_To_v1alpha2_AzureMachineTemplateSpec(in, out, s)
}

func autoConvert_v1alpha2_AzureResourceReference_To_v1alpha3_AzureResourceReference(in *AzureResourceReference, out *v1alpha3.AzureResourceReference, s conversion.Scope) error {
	out.ID = (*string)(unsafe.Pointer(in.ID))
	return nil
}

// Convert_v1alpha2_AzureResourceReference_To_v1alpha3_AzureResourceReference is an autogenerated conversion function.
func Convert_v1alpha2_AzureResourceReference_To_v1alpha3_AzureResourceReference(in *AzureResourceReference, out *v1alpha3.AzureResourceReference, s conversion.Scope) error {
	return autoConvert_v1alpha2_AzureResourceReference_To_v1alpha3_AzureResourceReference(in, out, s)
}

func autoConvert_v1alpha3_AzureResourceReference_To_v1alpha2_AzureResourceReference(in *v1alpha3.AzureResourceReference, out *AzureResourceReference, s conversion.Scope) error {
	out.ID = (*string)(unsafe.Pointer(in.ID))
	return nil
}

// Convert_v1alpha3_AzureResourceReference_To_v1alpha2_AzureResourceReference is an autogenerated conversion function.
func Convert_v1alpha3_AzureResourceReference_To_v1alpha2_AzureResourceReference(in *v1alpha3.AzureResourceReference, out *AzureResourceReference, s conversion.Scope) error {
	return autoConvert_v1alpha3_AzureResourceReference_To_v1alpha2_AzureResourceReference(in, out, s)
}

func autoConvert_v1alpha2_BackendPool_To_v1alpha3_BackendPool(in *BackendPool, out *v1alpha3.BackendPool, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	return nil
}

// Convert_v1alpha2_BackendPool_To_v1alpha3_BackendPool is an autogenerated conversion function.
func Convert_v1alpha2_BackendPool_To_v1alpha3_BackendPool(in *BackendPool, out *v1alpha3.BackendPool, s conversion.Scope) error {
	return autoConvert_v1alpha2_BackendPool_To_v1alpha3_BackendPool(in, out, s)
}

func autoConvert_v1alpha3_BackendPool_To_v1alpha2_BackendPool(in *v1alpha3.BackendPool, out *BackendPool, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	return nil
}

// Convert_v1alpha3_BackendPool_To_v1alpha2_BackendPool is an autogenerated conversion function.
func Convert_v1alpha3_BackendPool_To_v1alpha2_BackendPool(in *v1alpha3.BackendPool, out *BackendPool, s conversion.Scope) error {
	return autoConvert_v1alpha3_BackendPool_To_v1alpha2_BackendPool(in, out, s)
}

func autoConvert_v1alpha2_BuildParams_To_v1alpha3_BuildParams(in *BuildParams, out *v1alpha3.BuildParams, s conversion.Scope) error {
	out.Lifecycle = v1alpha3.ResourceLifecycle(in.Lifecycle)
	out.ClusterName = in.ClusterName
	out.ResourceID = in.ResourceID
	out.Name = (*string)(unsafe.Pointer(in.Name))
	out.Role = (*string)(unsafe.Pointer(in.Role))
	out.Additional = *(*v1alpha3.Tags)(unsafe.Pointer(&in.Additional))
	return nil
}

// Convert_v1alpha2_BuildParams_To_v1alpha3_BuildParams is an autogenerated conversion function.
func Convert_v1alpha2_BuildParams_To_v1alpha3_BuildParams(in *BuildParams, out *v1alpha3.BuildParams, s conversion.Scope) error {
	return autoConvert_v1alpha2_BuildParams_To_v1alpha3_BuildParams(in, out, s)
}

func autoConvert_v1alpha3_BuildParams_To_v1alpha2_BuildParams(in *v1alpha3.BuildParams, out *BuildParams, s conversion.Scope) error {
	out.Lifecycle = ResourceLifecycle(in.Lifecycle)
	out.ClusterName = in.ClusterName
	out.ResourceID = in.ResourceID
	out.Name = (*string)(unsafe.Pointer(in.Name))
	out.Role = (*string)(unsafe.Pointer(in.Role))
	out.Additional = *(*Tags)(unsafe.Pointer(&in.Additional))
	return nil
}

// Convert_v1alpha3_BuildParams_To_v1alpha2_BuildParams is an autogenerated conversion function.
func Convert_v1alpha3_BuildParams_To_v1alpha2_BuildParams(in *v1alpha3.BuildParams, out *BuildParams, s conversion.Scope) error {
	return autoConvert_v1alpha3_BuildParams_To_v1alpha2_BuildParams(in, out, s)
}

func autoConvert_v1alpha2_FrontendIPConfig_To_v1alpha3_FrontendIPConfig(in *FrontendIPConfig, out *v1alpha3.FrontendIPConfig, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha2_FrontendIPConfig_To_v1alpha3_FrontendIPConfig is an autogenerated conversion function.
func Convert_v1alpha2_FrontendIPConfig_To_v1alpha3_FrontendIPConfig(in *FrontendIPConfig, out *v1alpha3.FrontendIPConfig, s conversion.Scope) error {
	return autoConvert_v1alpha2_FrontendIPConfig_To_v1alpha3_FrontendIPConfig(in, out, s)
}

func autoConvert_v1alpha3_FrontendIPConfig_To_v1alpha2_FrontendIPConfig(in *v1alpha3.FrontendIPConfig, out *FrontendIPConfig, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha3_FrontendIPConfig_To_v1alpha2_FrontendIPConfig is an autogenerated conversion function.
func Convert_v1alpha3_FrontendIPConfig_To_v1alpha2_FrontendIPConfig(in *v1alpha3.FrontendIPConfig, out *FrontendIPConfig, s conversion.Scope) error {
	return autoConvert_v1alpha3_FrontendIPConfig_To_v1alpha2_FrontendIPConfig(in, out, s)
}

func autoConvert_v1alpha2_Image_To_v1alpha3_Image(in *Image, out *v1alpha3.Image, s conversion.Scope) error {
	// WARNING: in.Publisher requires manual conversion: does not exist in peer-type
	// WARNING: in.Offer requires manual conversion: does not exist in peer-type
	// WARNING: in.SKU requires manual conversion: does not exist in peer-type
	out.ID = (*string)(unsafe.Pointer(in.ID))
	// WARNING: in.SubscriptionID requires manual conversion: does not exist in peer-type
	// WARNING: in.ResourceGroup requires manual conversion: does not exist in peer-type
	// WARNING: in.Gallery requires manual conversion: does not exist in peer-type
	// WARNING: in.Name requires manual conversion: does not exist in peer-type
	// WARNING: in.Version requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_Image_To_v1alpha2_Image(in *v1alpha3.Image, out *Image, s conversion.Scope) error {
	out.ID = (*string)(unsafe.Pointer(in.ID))
	// WARNING: in.SharedGallery requires manual conversion: does not exist in peer-type
	// WARNING: in.Marketplace requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha2_IngressRule_To_v1alpha3_IngressRule(in *IngressRule, out *v1alpha3.IngressRule, s conversion.Scope) error {
	out.Description = in.Description
	out.Protocol = v1alpha3.SecurityGroupProtocol(in.Protocol)
	out.SourcePorts = (*string)(unsafe.Pointer(in.SourcePorts))
	out.DestinationPorts = (*string)(unsafe.Pointer(in.DestinationPorts))
	out.Source = (*string)(unsafe.Pointer(in.Source))
	out.Destination = (*string)(unsafe.Pointer(in.Destination))
	return nil
}

// Convert_v1alpha2_IngressRule_To_v1alpha3_IngressRule is an autogenerated conversion function.
func Convert_v1alpha2_IngressRule_To_v1alpha3_IngressRule(in *IngressRule, out *v1alpha3.IngressRule, s conversion.Scope) error {
	return autoConvert_v1alpha2_IngressRule_To_v1alpha3_IngressRule(in, out, s)
}

func autoConvert_v1alpha3_IngressRule_To_v1alpha2_IngressRule(in *v1alpha3.IngressRule, out *IngressRule, s conversion.Scope) error {
	out.Description = in.Description
	out.Protocol = SecurityGroupProtocol(in.Protocol)
	out.SourcePorts = (*string)(unsafe.Pointer(in.SourcePorts))
	out.DestinationPorts = (*string)(unsafe.Pointer(in.DestinationPorts))
	out.Source = (*string)(unsafe.Pointer(in.Source))
	out.Destination = (*string)(unsafe.Pointer(in.Destination))
	return nil
}

// Convert_v1alpha3_IngressRule_To_v1alpha2_IngressRule is an autogenerated conversion function.
func Convert_v1alpha3_IngressRule_To_v1alpha2_IngressRule(in *v1alpha3.IngressRule, out *IngressRule, s conversion.Scope) error {
	return autoConvert_v1alpha3_IngressRule_To_v1alpha2_IngressRule(in, out, s)
}

func autoConvert_v1alpha2_LoadBalancer_To_v1alpha3_LoadBalancer(in *LoadBalancer, out *v1alpha3.LoadBalancer, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.SKU = v1alpha3.SKU(in.SKU)
	if err := Convert_v1alpha2_FrontendIPConfig_To_v1alpha3_FrontendIPConfig(&in.FrontendIPConfig, &out.FrontendIPConfig, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_BackendPool_To_v1alpha3_BackendPool(&in.BackendPool, &out.BackendPool, s); err != nil {
		return err
	}
	out.Tags = *(*v1alpha3.Tags)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1alpha2_LoadBalancer_To_v1alpha3_LoadBalancer is an autogenerated conversion function.
func Convert_v1alpha2_LoadBalancer_To_v1alpha3_LoadBalancer(in *LoadBalancer, out *v1alpha3.LoadBalancer, s conversion.Scope) error {
	return autoConvert_v1alpha2_LoadBalancer_To_v1alpha3_LoadBalancer(in, out, s)
}

func autoConvert_v1alpha3_LoadBalancer_To_v1alpha2_LoadBalancer(in *v1alpha3.LoadBalancer, out *LoadBalancer, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.SKU = SKU(in.SKU)
	if err := Convert_v1alpha3_FrontendIPConfig_To_v1alpha2_FrontendIPConfig(&in.FrontendIPConfig, &out.FrontendIPConfig, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_BackendPool_To_v1alpha2_BackendPool(&in.BackendPool, &out.BackendPool, s); err != nil {
		return err
	}
	out.Tags = *(*Tags)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1alpha3_LoadBalancer_To_v1alpha2_LoadBalancer is an autogenerated conversion function.
func Convert_v1alpha3_LoadBalancer_To_v1alpha2_LoadBalancer(in *v1alpha3.LoadBalancer, out *LoadBalancer, s conversion.Scope) error {
	return autoConvert_v1alpha3_LoadBalancer_To_v1alpha2_LoadBalancer(in, out, s)
}

func autoConvert_v1alpha2_LoadBalancerHealthCheck_To_v1alpha3_LoadBalancerHealthCheck(in *LoadBalancerHealthCheck, out *v1alpha3.LoadBalancerHealthCheck, s conversion.Scope) error {
	out.Target = in.Target
	out.Interval = time.Duration(in.Interval)
	out.Timeout = time.Duration(in.Timeout)
	out.HealthyThreshold = in.HealthyThreshold
	out.UnhealthyThreshold = in.UnhealthyThreshold
	return nil
}

// Convert_v1alpha2_LoadBalancerHealthCheck_To_v1alpha3_LoadBalancerHealthCheck is an autogenerated conversion function.
func Convert_v1alpha2_LoadBalancerHealthCheck_To_v1alpha3_LoadBalancerHealthCheck(in *LoadBalancerHealthCheck, out *v1alpha3.LoadBalancerHealthCheck, s conversion.Scope) error {
	return autoConvert_v1alpha2_LoadBalancerHealthCheck_To_v1alpha3_LoadBalancerHealthCheck(in, out, s)
}

func autoConvert_v1alpha3_LoadBalancerHealthCheck_To_v1alpha2_LoadBalancerHealthCheck(in *v1alpha3.LoadBalancerHealthCheck, out *LoadBalancerHealthCheck, s conversion.Scope) error {
	out.Target = in.Target
	out.Interval = time.Duration(in.Interval)
	out.Timeout = time.Duration(in.Timeout)
	out.HealthyThreshold = in.HealthyThreshold
	out.UnhealthyThreshold = in.UnhealthyThreshold
	return nil
}

// Convert_v1alpha3_LoadBalancerHealthCheck_To_v1alpha2_LoadBalancerHealthCheck is an autogenerated conversion function.
func Convert_v1alpha3_LoadBalancerHealthCheck_To_v1alpha2_LoadBalancerHealthCheck(in *v1alpha3.LoadBalancerHealthCheck, out *LoadBalancerHealthCheck, s conversion.Scope) error {
	return autoConvert_v1alpha3_LoadBalancerHealthCheck_To_v1alpha2_LoadBalancerHealthCheck(in, out, s)
}

func autoConvert_v1alpha2_LoadBalancerListener_To_v1alpha3_LoadBalancerListener(in *LoadBalancerListener, out *v1alpha3.LoadBalancerListener, s conversion.Scope) error {
	out.Protocol = v1alpha3.LoadBalancerProtocol(in.Protocol)
	out.Port = in.Port
	out.InstanceProtocol = v1alpha3.LoadBalancerProtocol(in.InstanceProtocol)
	out.InstancePort = in.InstancePort
	return nil
}

// Convert_v1alpha2_LoadBalancerListener_To_v1alpha3_LoadBalancerListener is an autogenerated conversion function.
func Convert_v1alpha2_LoadBalancerListener_To_v1alpha3_LoadBalancerListener(in *LoadBalancerListener, out *v1alpha3.LoadBalancerListener, s conversion.Scope) error {
	return autoConvert_v1alpha2_LoadBalancerListener_To_v1alpha3_LoadBalancerListener(in, out, s)
}

func autoConvert_v1alpha3_LoadBalancerListener_To_v1alpha2_LoadBalancerListener(in *v1alpha3.LoadBalancerListener, out *LoadBalancerListener, s conversion.Scope) error {
	out.Protocol = LoadBalancerProtocol(in.Protocol)
	out.Port = in.Port
	out.InstanceProtocol = LoadBalancerProtocol(in.InstanceProtocol)
	out.InstancePort = in.InstancePort
	return nil
}

// Convert_v1alpha3_LoadBalancerListener_To_v1alpha2_LoadBalancerListener is an autogenerated conversion function.
func Convert_v1alpha3_LoadBalancerListener_To_v1alpha2_LoadBalancerListener(in *v1alpha3.LoadBalancerListener, out *LoadBalancerListener, s conversion.Scope) error {
	return autoConvert_v1alpha3_LoadBalancerListener_To_v1alpha2_LoadBalancerListener(in, out, s)
}

func autoConvert_v1alpha2_ManagedDisk_To_v1alpha3_ManagedDisk(in *ManagedDisk, out *v1alpha3.ManagedDisk, s conversion.Scope) error {
	out.StorageAccountType = in.StorageAccountType
	return nil
}

// Convert_v1alpha2_ManagedDisk_To_v1alpha3_ManagedDisk is an autogenerated conversion function.
func Convert_v1alpha2_ManagedDisk_To_v1alpha3_ManagedDisk(in *ManagedDisk, out *v1alpha3.ManagedDisk, s conversion.Scope) error {
	return autoConvert_v1alpha2_ManagedDisk_To_v1alpha3_ManagedDisk(in, out, s)
}

func autoConvert_v1alpha3_ManagedDisk_To_v1alpha2_ManagedDisk(in *v1alpha3.ManagedDisk, out *ManagedDisk, s conversion.Scope) error {
	out.StorageAccountType = in.StorageAccountType
	return nil
}

// Convert_v1alpha3_ManagedDisk_To_v1alpha2_ManagedDisk is an autogenerated conversion function.
func Convert_v1alpha3_ManagedDisk_To_v1alpha2_ManagedDisk(in *v1alpha3.ManagedDisk, out *ManagedDisk, s conversion.Scope) error {
	return autoConvert_v1alpha3_ManagedDisk_To_v1alpha2_ManagedDisk(in, out, s)
}

func autoConvert_v1alpha2_Network_To_v1alpha3_Network(in *Network, out *v1alpha3.Network, s conversion.Scope) error {
	out.SecurityGroups = *(*map[v1alpha3.SecurityGroupRole]v1alpha3.SecurityGroup)(unsafe.Pointer(&in.SecurityGroups))
	if err := Convert_v1alpha2_LoadBalancer_To_v1alpha3_LoadBalancer(&in.APIServerLB, &out.APIServerLB, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_PublicIP_To_v1alpha3_PublicIP(&in.APIServerIP, &out.APIServerIP, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_Network_To_v1alpha3_Network is an autogenerated conversion function.
func Convert_v1alpha2_Network_To_v1alpha3_Network(in *Network, out *v1alpha3.Network, s conversion.Scope) error {
	return autoConvert_v1alpha2_Network_To_v1alpha3_Network(in, out, s)
}

func autoConvert_v1alpha3_Network_To_v1alpha2_Network(in *v1alpha3.Network, out *Network, s conversion.Scope) error {
	out.SecurityGroups = *(*map[SecurityGroupRole]SecurityGroup)(unsafe.Pointer(&in.SecurityGroups))
	if err := Convert_v1alpha3_LoadBalancer_To_v1alpha2_LoadBalancer(&in.APIServerLB, &out.APIServerLB, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_PublicIP_To_v1alpha2_PublicIP(&in.APIServerIP, &out.APIServerIP, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_Network_To_v1alpha2_Network is an autogenerated conversion function.
func Convert_v1alpha3_Network_To_v1alpha2_Network(in *v1alpha3.Network, out *Network, s conversion.Scope) error {
	return autoConvert_v1alpha3_Network_To_v1alpha2_Network(in, out, s)
}

func autoConvert_v1alpha2_NetworkSpec_To_v1alpha3_NetworkSpec(in *NetworkSpec, out *v1alpha3.NetworkSpec, s conversion.Scope) error {
	if err := Convert_v1alpha2_VnetSpec_To_v1alpha3_VnetSpec(&in.Vnet, &out.Vnet, s); err != nil {
		return err
	}
	out.Subnets = *(*v1alpha3.Subnets)(unsafe.Pointer(&in.Subnets))
	return nil
}

// Convert_v1alpha2_NetworkSpec_To_v1alpha3_NetworkSpec is an autogenerated conversion function.
func Convert_v1alpha2_NetworkSpec_To_v1alpha3_NetworkSpec(in *NetworkSpec, out *v1alpha3.NetworkSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_NetworkSpec_To_v1alpha3_NetworkSpec(in, out, s)
}

func autoConvert_v1alpha3_NetworkSpec_To_v1alpha2_NetworkSpec(in *v1alpha3.NetworkSpec, out *NetworkSpec, s conversion.Scope) error {
	if err := Convert_v1alpha3_VnetSpec_To_v1alpha2_VnetSpec(&in.Vnet, &out.Vnet, s); err != nil {
		return err
	}
	out.Subnets = *(*Subnets)(unsafe.Pointer(&in.Subnets))
	return nil
}

// Convert_v1alpha3_NetworkSpec_To_v1alpha2_NetworkSpec is an autogenerated conversion function.
func Convert_v1alpha3_NetworkSpec_To_v1alpha2_NetworkSpec(in *v1alpha3.NetworkSpec, out *NetworkSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_NetworkSpec_To_v1alpha2_NetworkSpec(in, out, s)
}

func autoConvert_v1alpha2_OSDisk_To_v1alpha3_OSDisk(in *OSDisk, out *v1alpha3.OSDisk, s conversion.Scope) error {
	out.OSType = in.OSType
	out.DiskSizeGB = in.DiskSizeGB
	if err := Convert_v1alpha2_ManagedDisk_To_v1alpha3_ManagedDisk(&in.ManagedDisk, &out.ManagedDisk, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_OSDisk_To_v1alpha3_OSDisk is an autogenerated conversion function.
func Convert_v1alpha2_OSDisk_To_v1alpha3_OSDisk(in *OSDisk, out *v1alpha3.OSDisk, s conversion.Scope) error {
	return autoConvert_v1alpha2_OSDisk_To_v1alpha3_OSDisk(in, out, s)
}

func autoConvert_v1alpha3_OSDisk_To_v1alpha2_OSDisk(in *v1alpha3.OSDisk, out *OSDisk, s conversion.Scope) error {
	out.OSType = in.OSType
	out.DiskSizeGB = in.DiskSizeGB
	if err := Convert_v1alpha3_ManagedDisk_To_v1alpha2_ManagedDisk(&in.ManagedDisk, &out.ManagedDisk, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_OSDisk_To_v1alpha2_OSDisk is an autogenerated conversion function.
func Convert_v1alpha3_OSDisk_To_v1alpha2_OSDisk(in *v1alpha3.OSDisk, out *OSDisk, s conversion.Scope) error {
	return autoConvert_v1alpha3_OSDisk_To_v1alpha2_OSDisk(in, out, s)
}

func autoConvert_v1alpha2_PublicIP_To_v1alpha3_PublicIP(in *PublicIP, out *v1alpha3.PublicIP, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.IPAddress = in.IPAddress
	out.DNSName = in.DNSName
	return nil
}

// Convert_v1alpha2_PublicIP_To_v1alpha3_PublicIP is an autogenerated conversion function.
func Convert_v1alpha2_PublicIP_To_v1alpha3_PublicIP(in *PublicIP, out *v1alpha3.PublicIP, s conversion.Scope) error {
	return autoConvert_v1alpha2_PublicIP_To_v1alpha3_PublicIP(in, out, s)
}

func autoConvert_v1alpha3_PublicIP_To_v1alpha2_PublicIP(in *v1alpha3.PublicIP, out *PublicIP, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.IPAddress = in.IPAddress
	out.DNSName = in.DNSName
	return nil
}

// Convert_v1alpha3_PublicIP_To_v1alpha2_PublicIP is an autogenerated conversion function.
func Convert_v1alpha3_PublicIP_To_v1alpha2_PublicIP(in *v1alpha3.PublicIP, out *PublicIP, s conversion.Scope) error {
	return autoConvert_v1alpha3_PublicIP_To_v1alpha2_PublicIP(in, out, s)
}

func autoConvert_v1alpha2_SecurityGroup_To_v1alpha3_SecurityGroup(in *SecurityGroup, out *v1alpha3.SecurityGroup, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.IngressRules = *(*v1alpha3.IngressRules)(unsafe.Pointer(&in.IngressRules))
	out.Tags = *(*v1alpha3.Tags)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1alpha2_SecurityGroup_To_v1alpha3_SecurityGroup is an autogenerated conversion function.
func Convert_v1alpha2_SecurityGroup_To_v1alpha3_SecurityGroup(in *SecurityGroup, out *v1alpha3.SecurityGroup, s conversion.Scope) error {
	return autoConvert_v1alpha2_SecurityGroup_To_v1alpha3_SecurityGroup(in, out, s)
}

func autoConvert_v1alpha3_SecurityGroup_To_v1alpha2_SecurityGroup(in *v1alpha3.SecurityGroup, out *SecurityGroup, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.IngressRules = *(*IngressRules)(unsafe.Pointer(&in.IngressRules))
	out.Tags = *(*Tags)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1alpha3_SecurityGroup_To_v1alpha2_SecurityGroup is an autogenerated conversion function.
func Convert_v1alpha3_SecurityGroup_To_v1alpha2_SecurityGroup(in *v1alpha3.SecurityGroup, out *SecurityGroup, s conversion.Scope) error {
	return autoConvert_v1alpha3_SecurityGroup_To_v1alpha2_SecurityGroup(in, out, s)
}

func autoConvert_v1alpha2_SubnetSpec_To_v1alpha3_SubnetSpec(in *SubnetSpec, out *v1alpha3.SubnetSpec, s conversion.Scope) error {
	out.Role = v1alpha3.SubnetRole(in.Role)
	out.ID = in.ID
	out.Name = in.Name
	out.CidrBlock = in.CidrBlock
	out.InternalLBIPAddress = in.InternalLBIPAddress
	if err := Convert_v1alpha2_SecurityGroup_To_v1alpha3_SecurityGroup(&in.SecurityGroup, &out.SecurityGroup, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_SubnetSpec_To_v1alpha3_SubnetSpec is an autogenerated conversion function.
func Convert_v1alpha2_SubnetSpec_To_v1alpha3_SubnetSpec(in *SubnetSpec, out *v1alpha3.SubnetSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_SubnetSpec_To_v1alpha3_SubnetSpec(in, out, s)
}

func autoConvert_v1alpha3_SubnetSpec_To_v1alpha2_SubnetSpec(in *v1alpha3.SubnetSpec, out *SubnetSpec, s conversion.Scope) error {
	out.Role = SubnetRole(in.Role)
	out.ID = in.ID
	out.Name = in.Name
	out.CidrBlock = in.CidrBlock
	out.InternalLBIPAddress = in.InternalLBIPAddress
	if err := Convert_v1alpha3_SecurityGroup_To_v1alpha2_SecurityGroup(&in.SecurityGroup, &out.SecurityGroup, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_SubnetSpec_To_v1alpha2_SubnetSpec is an autogenerated conversion function.
func Convert_v1alpha3_SubnetSpec_To_v1alpha2_SubnetSpec(in *v1alpha3.SubnetSpec, out *SubnetSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_SubnetSpec_To_v1alpha2_SubnetSpec(in, out, s)
}

func autoConvert_v1alpha2_VM_To_v1alpha3_VM(in *VM, out *v1alpha3.VM, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.AvailabilityZone = in.AvailabilityZone
	out.VMSize = in.VMSize
	if err := Convert_v1alpha2_Image_To_v1alpha3_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_OSDisk_To_v1alpha3_OSDisk(&in.OSDisk, &out.OSDisk, s); err != nil {
		return err
	}
	out.StartupScript = in.StartupScript
	out.State = v1alpha3.VMState(in.State)
	out.Identity = v1alpha3.VMIdentity(in.Identity)
	out.Tags = *(*v1alpha3.Tags)(unsafe.Pointer(&in.Tags))
	out.Addresses = *(*[]v1.NodeAddress)(unsafe.Pointer(&in.Addresses))
	return nil
}

// Convert_v1alpha2_VM_To_v1alpha3_VM is an autogenerated conversion function.
func Convert_v1alpha2_VM_To_v1alpha3_VM(in *VM, out *v1alpha3.VM, s conversion.Scope) error {
	return autoConvert_v1alpha2_VM_To_v1alpha3_VM(in, out, s)
}

func autoConvert_v1alpha3_VM_To_v1alpha2_VM(in *v1alpha3.VM, out *VM, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.AvailabilityZone = in.AvailabilityZone
	out.VMSize = in.VMSize
	if err := Convert_v1alpha3_Image_To_v1alpha2_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_OSDisk_To_v1alpha2_OSDisk(&in.OSDisk, &out.OSDisk, s); err != nil {
		return err
	}
	out.StartupScript = in.StartupScript
	out.State = VMState(in.State)
	out.Identity = VMIdentity(in.Identity)
	out.Tags = *(*Tags)(unsafe.Pointer(&in.Tags))
	out.Addresses = *(*[]v1.NodeAddress)(unsafe.Pointer(&in.Addresses))
	return nil
}

// Convert_v1alpha3_VM_To_v1alpha2_VM is an autogenerated conversion function.
func Convert_v1alpha3_VM_To_v1alpha2_VM(in *v1alpha3.VM, out *VM, s conversion.Scope) error {
	return autoConvert_v1alpha3_VM_To_v1alpha2_VM(in, out, s)
}

func autoConvert_v1alpha2_VnetSpec_To_v1alpha3_VnetSpec(in *VnetSpec, out *v1alpha3.VnetSpec, s conversion.Scope) error {
	out.ResourceGroup = in.ResourceGroup
	out.ID = in.ID
	out.Name = in.Name
	out.CidrBlock = in.CidrBlock
	out.Tags = *(*v1alpha3.Tags)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1alpha2_VnetSpec_To_v1alpha3_VnetSpec is an autogenerated conversion function.
func Convert_v1alpha2_VnetSpec_To_v1alpha3_VnetSpec(in *VnetSpec, out *v1alpha3.VnetSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_VnetSpec_To_v1alpha3_VnetSpec(in, out, s)
}

func autoConvert_v1alpha3_VnetSpec_To_v1alpha2_VnetSpec(in *v1alpha3.VnetSpec, out *VnetSpec, s conversion.Scope) error {
	out.ResourceGroup = in.ResourceGroup
	out.ID = in.ID
	out.Name = in.Name
	out.CidrBlock = in.CidrBlock
	out.Tags = *(*Tags)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1alpha3_VnetSpec_To_v1alpha2_VnetSpec is an autogenerated conversion function.
func Convert_v1alpha3_VnetSpec_To_v1alpha2_VnetSpec(in *v1alpha3.VnetSpec, out *VnetSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_VnetSpec_To_v1alpha2_VnetSpec(in, out, s)
}
