// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteClientVpnRouteInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Client VPN endpoint from which the route is to be deleted.
	//
	// ClientVpnEndpointId is a required field
	ClientVpnEndpointId *string `type:"string" required:"true"`

	// The IPv4 address range, in CIDR notation, of the route to be deleted.
	//
	// DestinationCidrBlock is a required field
	DestinationCidrBlock *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the target subnet used by the route.
	TargetVpcSubnetId *string `type:"string"`
}

// String returns the string representation
func (s DeleteClientVpnRouteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClientVpnRouteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteClientVpnRouteInput"}

	if s.ClientVpnEndpointId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientVpnEndpointId"))
	}

	if s.DestinationCidrBlock == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationCidrBlock"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteClientVpnRouteOutput struct {
	_ struct{} `type:"structure"`

	// The current state of the route.
	Status *VpnRouteStatus `locationName:"status" type:"structure"`
}

// String returns the string representation
func (s DeleteClientVpnRouteOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteClientVpnRoute = "DeleteClientVpnRoute"

// DeleteClientVpnRouteRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes a route from a Client VPN endpoint. You can only delete routes that
// you manually added using the CreateClientVpnRoute action. You cannot delete
// routes that were automatically added when associating a subnet. To remove
// routes that have been automatically added, disassociate the target subnet
// from the Client VPN endpoint.
//
//    // Example sending a request using DeleteClientVpnRouteRequest.
//    req := client.DeleteClientVpnRouteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute
func (c *Client) DeleteClientVpnRouteRequest(input *DeleteClientVpnRouteInput) DeleteClientVpnRouteRequest {
	op := &aws.Operation{
		Name:       opDeleteClientVpnRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClientVpnRouteInput{}
	}

	req := c.newRequest(op, input, &DeleteClientVpnRouteOutput{})
	return DeleteClientVpnRouteRequest{Request: req, Input: input, Copy: c.DeleteClientVpnRouteRequest}
}

// DeleteClientVpnRouteRequest is the request type for the
// DeleteClientVpnRoute API operation.
type DeleteClientVpnRouteRequest struct {
	*aws.Request
	Input *DeleteClientVpnRouteInput
	Copy  func(*DeleteClientVpnRouteInput) DeleteClientVpnRouteRequest
}

// Send marshals and sends the DeleteClientVpnRoute API request.
func (r DeleteClientVpnRouteRequest) Send(ctx context.Context) (*DeleteClientVpnRouteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteClientVpnRouteResponse{
		DeleteClientVpnRouteOutput: r.Request.Data.(*DeleteClientVpnRouteOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteClientVpnRouteResponse is the response type for the
// DeleteClientVpnRoute API operation.
type DeleteClientVpnRouteResponse struct {
	*DeleteClientVpnRouteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteClientVpnRoute request.
func (r *DeleteClientVpnRouteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
